% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_contact_flow_module}
\alias{connect_create_contact_flow_module}
\title{Creates a flow module for the specified Amazon Connect instance}
\usage{
connect_create_contact_flow_module(
  InstanceId,
  Name,
  Description = NULL,
  Content,
  Tags = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{Name}{[required] The name of the flow module.}

\item{Description}{The description of the flow module.}

\item{Content}{[required] The JSON string that represents the content of the flow. For an example,
see \href{https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html}{Example flow in Amazon Connect Flow language}.}

\item{Tags}{The tags used to organize, track, or control access for this resource.
For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Creates a flow module for the specified Amazon Connect instance.

See \url{https://www.paws-r-sdk.com/docs/connect_create_contact_flow_module/} for full documentation.
}
\keyword{internal}
