% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_describe_continuous_backups}
\alias{dynamodb_describe_continuous_backups}
\title{Checks the status of continuous backups and point in time recovery on
the specified table}
\usage{
dynamodb_describe_continuous_backups(TableName)
}
\arguments{
\item{TableName}{[required] Name of the table for which the customer wants to check the continuous
backups and point in time recovery settings.}
}
\description{
Checks the status of continuous backups and point in time recovery on
the specified table. Continuous backups are \code{ENABLED} on all tables at
table creation. If point in time recovery is enabled,
\code{PointInTimeRecoveryStatus} will be set to ENABLED.

After continuous backups and point in time recovery are enabled, you can
restore to any point in time within \code{EarliestRestorableDateTime} and
\code{LatestRestorableDateTime}.

\code{LatestRestorableDateTime} is typically 5 minutes before the current
time. You can restore your table to any point in time during the last 35
days.

You can call \code{DescribeContinuousBackups} at a maximum rate of 10 times
per second.
}
\section{Request syntax}{
\preformatted{svc$describe_continuous_backups(
  TableName = "string"
)
}
}

\keyword{internal}
