% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_create_user}
\alias{elasticache_create_user}
\title{For Redis engine version 6}
\usage{
elasticache_create_user(UserId, UserName, Engine, Passwords,
  AccessString, NoPasswordRequired)
}
\arguments{
\item{UserId}{[required] The ID of the user.}

\item{UserName}{[required] The username of the user.}

\item{Engine}{[required] The current supported value is Redis.}

\item{Passwords}{Passwords used for this user. You can create up to two passwords for
each user.}

\item{AccessString}{[required] Access permissions string used for this user.}

\item{NoPasswordRequired}{Indicates a password is not required for this user.}
}
\description{
For Redis engine version 6.x onwards: Creates a Redis user. For more
information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html}{Using Role Based Access Control (RBAC)}.
}
\section{Request syntax}{
\preformatted{svc$create_user(
  UserId = "string",
  UserName = "string",
  Engine = "string",
  Passwords = list(
    "string"
  ),
  AccessString = "string",
  NoPasswordRequired = TRUE|FALSE
)
}
}

\keyword{internal}
