% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_import_installation_media}
\alias{rds_import_installation_media}
\title{Imports the installation media for a DB engine that requires an
on-premises customer provided license, such as SQL Server}
\usage{
rds_import_installation_media(CustomAvailabilityZoneId, Engine,
  EngineVersion, EngineInstallationMediaPath, OSInstallationMediaPath)
}
\arguments{
\item{CustomAvailabilityZoneId}{[required] The identifier of the custom Availability Zone (AZ) to import the
installation media to.}

\item{Engine}{[required] The name of the database engine to be used for this instance.

The list only includes supported DB engines that require an on-premises
customer provided license.

Valid Values:
\itemize{
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}}

\item{EngineVersion}{[required] The version number of the database engine to use.

For a list of valid engine versions, call DescribeDBEngineVersions.

The following are the database engines and links to information about
the major and minor versions. The list only includes DB engines that
require an on-premises customer provided license.

\strong{Microsoft SQL Server}

See \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport}{Microsoft SQL Server Versions on Amazon RDS}
in the \emph{Amazon RDS User Guide.}}

\item{EngineInstallationMediaPath}{[required] The path to the installation medium for the specified DB engine.

Example:
\code{SQLServerISO/en_sql_server_2016_enterprise_x64_dvd_8701793.iso}}

\item{OSInstallationMediaPath}{[required] The path to the installation medium for the operating system associated
with the specified DB engine.

Example: \code{WindowsISO/en_windows_server_2016_x64_dvd_9327751.iso}}
}
\description{
Imports the installation media for a DB engine that requires an
on-premises customer provided license, such as SQL Server.
}
\section{Request syntax}{
\preformatted{svc$import_installation_media(
  CustomAvailabilityZoneId = "string",
  Engine = "string",
  EngineVersion = "string",
  EngineInstallationMediaPath = "string",
  OSInstallationMediaPath = "string"
)
}
}

\keyword{internal}
