% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_restore_table_from_cluster_snapshot}
\alias{redshift_restore_table_from_cluster_snapshot}
\title{Creates a new table from a table in an Amazon Redshift cluster snapshot}
\usage{
redshift_restore_table_from_cluster_snapshot(ClusterIdentifier,
  SnapshotIdentifier, SourceDatabaseName, SourceSchemaName,
  SourceTableName, TargetDatabaseName, TargetSchemaName, NewTableName)
}
\arguments{
\item{ClusterIdentifier}{[required] The identifier of the Amazon Redshift cluster to restore the table to.}

\item{SnapshotIdentifier}{[required] The identifier of the snapshot to restore the table from. This snapshot
must have been created from the Amazon Redshift cluster specified by the
\code{ClusterIdentifier} parameter.}

\item{SourceDatabaseName}{[required] The name of the source database that contains the table to restore from.}

\item{SourceSchemaName}{The name of the source schema that contains the table to restore from.
If you do not specify a \code{SourceSchemaName} value, the default is
\code{public}.}

\item{SourceTableName}{[required] The name of the source table to restore from.}

\item{TargetDatabaseName}{The name of the database to restore the table to.}

\item{TargetSchemaName}{The name of the schema to restore the table to.}

\item{NewTableName}{[required] The name of the table to create as a result of the current request.}
}
\description{
Creates a new table from a table in an Amazon Redshift cluster snapshot.
You must create the new table within the Amazon Redshift cluster that
the snapshot was taken from.

You cannot use \code{RestoreTableFromClusterSnapshot} to restore a table with
the same name as an existing table in an Amazon Redshift cluster. That
is, you cannot overwrite an existing table in a cluster with a restored
table. If you want to replace your original table with a new, restored
table, then rename or drop your original table before you call
\code{RestoreTableFromClusterSnapshot}. When you have renamed your original
table, then you can pass the original name of the table as the
\code{NewTableName} parameter value in the call to
\code{RestoreTableFromClusterSnapshot}. This way, you can replace the
original table with the table created from the snapshot.
}
\section{Request syntax}{
\preformatted{svc$restore_table_from_cluster_snapshot(
  ClusterIdentifier = "string",
  SnapshotIdentifier = "string",
  SourceDatabaseName = "string",
  SourceSchemaName = "string",
  SourceTableName = "string",
  TargetDatabaseName = "string",
  TargetSchemaName = "string",
  NewTableName = "string"
)
}
}

\keyword{internal}
