% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_copy_db_cluster_snapshot}
\alias{neptune_copy_db_cluster_snapshot}
\title{Copies a snapshot of a DB cluster}
\usage{
neptune_copy_db_cluster_snapshot(SourceDBClusterSnapshotIdentifier,
  TargetDBClusterSnapshotIdentifier, KmsKeyId, PreSignedUrl, CopyTags,
  Tags)
}
\arguments{
\item{SourceDBClusterSnapshotIdentifier}{[required] The identifier of the DB cluster snapshot to copy. This parameter is not
case-sensitive.

You can't copy from one AWS Region to another.

Constraints:
\itemize{
\item Must specify a valid system snapshot in the "available" state.
\item Specify a valid DB snapshot identifier.
}

Example: \code{my-cluster-snapshot1}}

\item{TargetDBClusterSnapshotIdentifier}{[required] The identifier of the new DB cluster snapshot to create from the source
DB cluster snapshot. This parameter is not case-sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster-snapshot2}}

\item{KmsKeyId}{The AWS AWS KMS key ID for an encrypted DB cluster snapshot. The KMS key
ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key
alias for the KMS encryption key.

If you copy an unencrypted DB cluster snapshot and specify a value for
the \code{KmsKeyId} parameter, Amazon Neptune encrypts the target DB cluster
snapshot using the specified KMS encryption key.

If you copy an encrypted DB cluster snapshot from your AWS account, you
can specify a value for \code{KmsKeyId} to encrypt the copy with a new KMS
encryption key. If you don't specify a value for \code{KmsKeyId}, then the
copy of the DB cluster snapshot is encrypted with the same KMS key as
the source DB cluster snapshot.

If you copy an encrypted DB cluster snapshot that is shared from another
AWS account, then you must specify a value for \code{KmsKeyId}.

KMS encryption keys are specific to the AWS Region that they are created
in, and you can't use encryption keys from one AWS Region in another
AWS Region.}

\item{PreSignedUrl}{Not currently supported.}

\item{CopyTags}{True to copy all tags from the source DB cluster snapshot to the target
DB cluster snapshot, and otherwise false. The default is false.}

\item{Tags}{The tags to assign to the new DB cluster snapshot copy.}
}
\description{
Copies a snapshot of a DB cluster.
}
\details{
To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
\code{SourceDBClusterSnapshotIdentifier} must be the Amazon Resource Name
(ARN) of the shared DB cluster snapshot.

You can't copy from one AWS Region to another.
}
\section{Request syntax}{
\preformatted{svc$copy_db_cluster_snapshot(
  SourceDBClusterSnapshotIdentifier = "string",
  TargetDBClusterSnapshotIdentifier = "string",
  KmsKeyId = "string",
  PreSignedUrl = "string",
  CopyTags = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
