% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_copy_db_cluster_snapshot}
\alias{docdb_copy_db_cluster_snapshot}
\title{Copies a snapshot of a DB cluster}
\usage{
docdb_copy_db_cluster_snapshot(SourceDBClusterSnapshotIdentifier,
  TargetDBClusterSnapshotIdentifier, KmsKeyId, PreSignedUrl, CopyTags,
  Tags)
}
\arguments{
\item{SourceDBClusterSnapshotIdentifier}{[required] The identifier of the DB cluster snapshot to copy. This parameter is not
case sensitive.

You can't copy an encrypted, shared DB cluster snapshot from one AWS
Region to another.

Constraints:
\itemize{
\item Must specify a valid system snapshot in the "available" state.
\item If the source snapshot is in the same AWS Region as the copy,
specify a valid DB snapshot identifier.
\item If the source snapshot is in a different AWS Region than the copy,
specify a valid DB cluster snapshot ARN.
}

Example: \code{my-cluster-snapshot1}}

\item{TargetDBClusterSnapshotIdentifier}{[required] The identifier of the new DB cluster snapshot to create from the source
DB cluster snapshot. This parameter is not case sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster-snapshot2}}

\item{KmsKeyId}{The AWS KMS key ID for an encrypted DB cluster snapshot. The AWS KMS key
ID is the Amazon Resource Name (ARN), AWS KMS key identifier, or the AWS
KMS key alias for the AWS KMS encryption key.

If you copy an encrypted DB cluster snapshot from your AWS account, you
can specify a value for \code{KmsKeyId} to encrypt the copy with a new AWS
KMS encryption key. If you don't specify a value for \code{KmsKeyId}, then
the copy of the DB cluster snapshot is encrypted with the same AWS KMS
key as the source DB cluster snapshot.

If you copy an encrypted DB cluster snapshot that is shared from another
AWS account, then you must specify a value for \code{KmsKeyId}.

To copy an encrypted DB cluster snapshot to another AWS Region, set
\code{KmsKeyId} to the AWS KMS key ID that you want to use to encrypt the
copy of the DB cluster snapshot in the destination Region. AWS KMS
encryption keys are specific to the AWS Region that they are created in,
and you can't use encryption keys from one Region in another Region.

If you copy an unencrypted DB cluster snapshot and specify a value for
the \code{KmsKeyId} parameter, an error is returned.}

\item{PreSignedUrl}{The URL that contains a Signature Version 4 signed request for the
\code{CopyDBClusterSnapshot} API action in the AWS Region that contains the
source DB cluster snapshot to copy. You must use the \code{PreSignedUrl}
parameter when copying an encrypted DB cluster snapshot from another AWS
Region.

The presigned URL must be a valid request for the
\code{CopyDBSClusterSnapshot} API action that can be executed in the source
AWS Region that contains the encrypted DB cluster snapshot to be copied.
The presigned URL request must contain the following parameter values:
\itemize{
\item \code{KmsKeyId} - The AWS KMS key identifier for the key to use to
encrypt the copy of the DB cluster snapshot in the destination AWS
Region. This is the same identifier for both the
\code{CopyDBClusterSnapshot} action that is called in the destination AWS
Region, and the action contained in the presigned URL.
\item \code{DestinationRegion} - The name of the AWS Region that the DB cluster
snapshot will be created in.
\item \code{SourceDBClusterSnapshotIdentifier} - The DB cluster snapshot
identifier for the encrypted DB cluster snapshot to be copied. This
identifier must be in the Amazon Resource Name (ARN) format for the
source AWS Region. For example, if you are copying an encrypted DB
cluster snapshot from the us-west-2 AWS Region, then your
\code{SourceDBClusterSnapshotIdentifier} looks like the following
example:
\code{arn:aws:rds:us-west-2:123456789012:cluster-snapshot:my-cluster-snapshot-20161115}.
}}

\item{CopyTags}{Set to \code{true} to copy all tags from the source DB cluster snapshot to
the target DB cluster snapshot, and otherwise \code{false}. The default is
\code{false}.}

\item{Tags}{The tags to be assigned to the DB cluster snapshot.}
}
\description{
Copies a snapshot of a DB cluster.
}
\details{
To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
\code{SourceDBClusterSnapshotIdentifier} must be the Amazon Resource Name
(ARN) of the shared DB cluster snapshot.

To cancel the copy operation after it is in progress, delete the target
DB cluster snapshot identified by \code{TargetDBClusterSnapshotIdentifier}
while that DB cluster snapshot is in the \emph{copying} status.
}
\section{Request syntax}{
\preformatted{svc$copy_db_cluster_snapshot(
  SourceDBClusterSnapshotIdentifier = "string",
  TargetDBClusterSnapshotIdentifier = "string",
  KmsKeyId = "string",
  PreSignedUrl = "string",
  CopyTags = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
