% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_cluster_endpoints}
\alias{rds_describe_db_cluster_endpoints}
\title{Returns information about endpoints for an Amazon Aurora DB cluster}
\usage{
rds_describe_db_cluster_endpoints(DBClusterIdentifier,
  DBClusterEndpointIdentifier, Filters, MaxRecords, Marker)
}
\arguments{
\item{DBClusterIdentifier}{The DB cluster identifier of the DB cluster associated with the
endpoint. This parameter is stored as a lowercase string.}

\item{DBClusterEndpointIdentifier}{The identifier of the endpoint to describe. This parameter is stored as
a lowercase string.}

\item{Filters}{A set of name-value pairs that define which endpoints to include in the
output. The filters are specified as name-value pairs, in the format
\code{Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...}.
\code{Name} can be one of: \code{db-cluster-endpoint-type},
\code{db-cluster-endpoint-custom-type}, \code{db-cluster-endpoint-id},
\code{db-cluster-endpoint-status}. \code{Values} for the
\code{ db-cluster-endpoint-type} filter can be one or more of: \code{reader},
\code{writer}, \code{custom}. \code{Values} for the \code{db-cluster-endpoint-custom-type}
filter can be one or more of: \code{reader}, \code{any}. \code{Values} for the
\code{db-cluster-endpoint-status} filter can be one or more of: \code{available},
\code{creating}, \code{deleting}, \code{modifying}.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{DescribeDBClusterEndpoints} request. If this parameter is specified,
the response includes only records beyond the marker, up to the value
specified by \code{MaxRecords}.}
}
\description{
Returns information about endpoints for an Amazon Aurora DB cluster.
}
\details{
This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$describe_db_cluster_endpoints(
  DBClusterIdentifier = "string",
  DBClusterEndpointIdentifier = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
