% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_failover_db_cluster}
\alias{rds_failover_db_cluster}
\title{Forces a failover for a DB cluster}
\usage{
rds_failover_db_cluster(DBClusterIdentifier, TargetDBInstanceIdentifier)
}
\arguments{
\item{DBClusterIdentifier}{[required] A DB cluster identifier to force a failover for. This parameter is not
case-sensitive.

Constraints:
\itemize{
\item Must match the identifier of an existing DBCluster.
}}

\item{TargetDBInstanceIdentifier}{The name of the instance to promote to the primary instance.

You must specify the instance identifier for an Aurora Replica in the DB
cluster. For example, \code{mydbcluster-replica1}.}
}
\description{
Forces a failover for a DB cluster.
}
\details{
A failover for a DB cluster promotes one of the Aurora Replicas
(read-only instances) in the DB cluster to be the primary instance (the
cluster writer).

Amazon Aurora will automatically fail over to an Aurora Replica, if one
exists, when the primary instance fails. You can force a failover when
you want to simulate a failure of a primary instance for testing.
Because each instance in a DB cluster has its own endpoint address, you
will need to clean up and re-establish any existing connections that use
those endpoint addresses when the failover is complete.

For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$failover_db_cluster(
  DBClusterIdentifier = "string",
  TargetDBInstanceIdentifier = "string"
)
}
}

\keyword{internal}
