% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_create_cluster}
\alias{redshift_create_cluster}
\title{Creates a new cluster}
\usage{
redshift_create_cluster(DBName, ClusterIdentifier, ClusterType,
  NodeType, MasterUsername, MasterUserPassword, ClusterSecurityGroups,
  VpcSecurityGroupIds, ClusterSubnetGroupName, AvailabilityZone,
  PreferredMaintenanceWindow, ClusterParameterGroupName,
  AutomatedSnapshotRetentionPeriod, ManualSnapshotRetentionPeriod, Port,
  ClusterVersion, AllowVersionUpgrade, NumberOfNodes, PubliclyAccessible,
  Encrypted, HsmClientCertificateIdentifier, HsmConfigurationIdentifier,
  ElasticIp, Tags, KmsKeyId, EnhancedVpcRouting, AdditionalInfo, IamRoles,
  MaintenanceTrackName, SnapshotScheduleIdentifier)
}
\arguments{
\item{DBName}{The name of the first database to be created when the cluster is
created.

To create additional databases after the cluster is created, connect to
the cluster with a SQL client and use SQL commands to create a database.
For more information, go to \href{https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html}{Create a Database}
in the Amazon Redshift Database Developer Guide.

Default: \code{dev}

Constraints:
\itemize{
\item Must contain 1 to 64 alphanumeric characters.
\item Must contain only lowercase letters.
\item Cannot be a word that is reserved by the service. A list of reserved
words can be found in \href{https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html}{Reserved Words}
in the Amazon Redshift Database Developer Guide.
}}

\item{ClusterIdentifier}{[required] A unique identifier for the cluster. You use this identifier to refer to
the cluster for any subsequent cluster operations such as deleting or
modifying. The identifier also appears in the Amazon Redshift console.

Constraints:
\itemize{
\item Must contain from 1 to 63 alphanumeric characters or hyphens.
\item Alphabetic characters must be lowercase.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
\item Must be unique for all clusters within an AWS account.
}

Example: \code{myexamplecluster}}

\item{ClusterType}{The type of the cluster. When cluster type is specified as
\itemize{
\item \code{single-node}, the \strong{NumberOfNodes} parameter is not required.
\item \code{multi-node}, the \strong{NumberOfNodes} parameter is required.
}

Valid Values: \code{multi-node} \| \code{single-node}

Default: \code{multi-node}}

\item{NodeType}{[required] The node type to be provisioned for the cluster. For information about
node types, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes}{Working with Clusters}
in the \emph{Amazon Redshift Cluster Management Guide}.

Valid Values: \code{ds2.xlarge} \| \code{ds2.8xlarge} \| \code{ds2.xlarge} \|
\code{ds2.8xlarge} \| \code{dc1.large} \| \code{dc1.8xlarge} \| \code{dc2.large} \|
\code{dc2.8xlarge}}

\item{MasterUsername}{[required] The user name associated with the master user account for the cluster
that is being created.

Constraints:
\itemize{
\item Must be 1 - 128 alphanumeric characters. The user name can't be
\code{PUBLIC}.
\item First character must be a letter.
\item Cannot be a reserved word. A list of reserved words can be found in
\href{https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html}{Reserved Words}
in the Amazon Redshift Database Developer Guide.
}}

\item{MasterUserPassword}{[required] The password associated with the master user account for the cluster
that is being created.

Constraints:
\itemize{
\item Must be between 8 and 64 characters in length.
\item Must contain at least one uppercase letter.
\item Must contain at least one lowercase letter.
\item Must contain one number.
\item Can be any printable ASCII character (ASCII code 33 to 126) except
' (single quote), " (double quote), \, /, @, or space.
}}

\item{ClusterSecurityGroups}{A list of security groups to be associated with this cluster.

Default: The default cluster security group for Amazon Redshift.}

\item{VpcSecurityGroupIds}{A list of Virtual Private Cloud (VPC) security groups to be associated
with the cluster.

Default: The default VPC security group is associated with the cluster.}

\item{ClusterSubnetGroupName}{The name of a cluster subnet group to be associated with this cluster.

If this parameter is not provided the resulting cluster will be deployed
outside virtual private cloud (VPC).}

\item{AvailabilityZone}{The EC2 Availability Zone (AZ) in which you want Amazon Redshift to
provision the cluster. For example, if you have several EC2 instances
running in a specific Availability Zone, then you might want the cluster
to be provisioned in the same zone in order to decrease network latency.

Default: A random, system-chosen Availability Zone in the region that is
specified by the endpoint.

Example: \code{us-east-1d}

Constraint: The specified Availability Zone must be in the same region
as the current endpoint.}

\item{PreferredMaintenanceWindow}{The weekly time range (in UTC) during which automated cluster
maintenance can occur.

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

Default: A 30-minute window selected at random from an 8-hour block of
time per region, occurring on a random day of the week. For more
information about the time blocks for each region, see \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows}{Maintenance Windows}
in Amazon Redshift Cluster Management Guide.

Valid Days: Mon \| Tue \| Wed \| Thu \| Fri \| Sat \| Sun

Constraints: Minimum 30-minute window.}

\item{ClusterParameterGroupName}{The name of the parameter group to be associated with this cluster.

Default: The default Amazon Redshift cluster parameter group. For
information about the default parameter group, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html}{Working with Amazon Redshift Parameter Groups}

Constraints:
\itemize{
\item Must be 1 to 255 alphanumeric characters or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}}

\item{AutomatedSnapshotRetentionPeriod}{The number of days that automated snapshots are retained. If the value
is 0, automated snapshots are disabled. Even if automated snapshots are
disabled, you can still create manual snapshots when you want with
CreateClusterSnapshot.

Default: \code{1}

Constraints: Must be a value from 0 to 35.}

\item{ManualSnapshotRetentionPeriod}{The default number of days to retain a manual snapshot. If the value is
-1, the snapshot is retained indefinitely. This setting doesn't change
the retention period of existing snapshots.

The value must be either -1 or an integer between 1 and 3,653.}

\item{Port}{The port number on which the cluster accepts incoming connections.

The cluster is accessible only via the JDBC and ODBC connection strings.
Part of the connection string requires the port on which the cluster
will listen for incoming connections.

Default: \code{5439}

Valid Values: \code{1150-65535}}

\item{ClusterVersion}{The version of the Amazon Redshift engine software that you want to
deploy on the cluster.

The version selected runs on all the nodes in the cluster.

Constraints: Only version 1.0 is currently available.

Example: \code{1.0}}

\item{AllowVersionUpgrade}{If \code{true}, major version upgrades can be applied during the maintenance
window to the Amazon Redshift engine that is running on the cluster.

When a new major version of the Amazon Redshift engine is released, you
can request that the service automatically apply upgrades during the
maintenance window to the Amazon Redshift engine that is running on your
cluster.

Default: \code{true}}

\item{NumberOfNodes}{The number of compute nodes in the cluster. This parameter is required
when the \strong{ClusterType} parameter is specified as \code{multi-node}.

For information about determining how many nodes you need, go to
\href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes}{Working with Clusters}
in the \emph{Amazon Redshift Cluster Management Guide}.

If you don't specify this parameter, you get a single-node cluster.
When requesting a multi-node cluster, you must specify the number of
nodes that you want in the cluster.

Default: \code{1}

Constraints: Value must be at least 1 and no more than 100.}

\item{PubliclyAccessible}{If \code{true}, the cluster can be accessed from a public network.}

\item{Encrypted}{If \code{true}, the data in the cluster is encrypted at rest.

Default: false}

\item{HsmClientCertificateIdentifier}{Specifies the name of the HSM client certificate the Amazon Redshift
cluster uses to retrieve the data encryption keys stored in an HSM.}

\item{HsmConfigurationIdentifier}{Specifies the name of the HSM configuration that contains the
information the Amazon Redshift cluster can use to retrieve and store
keys in an HSM.}

\item{ElasticIp}{The Elastic IP (EIP) address for the cluster.

Constraints: The cluster must be provisioned in EC2-VPC and
publicly-accessible through an Internet gateway. For more information
about provisioning clusters in EC2-VPC, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms}{Supported Platforms to Launch Your Cluster}
in the Amazon Redshift Cluster Management Guide.}

\item{Tags}{A list of tag instances.}

\item{KmsKeyId}{The AWS Key Management Service (KMS) key ID of the encryption key that
you want to use to encrypt data in the cluster.}

\item{EnhancedVpcRouting}{An option that specifies whether to create the cluster with enhanced VPC
routing enabled. To create a cluster that uses enhanced VPC routing, the
cluster must be in a VPC. For more information, see \href{https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html}{Enhanced VPC Routing}
in the Amazon Redshift Cluster Management Guide.

If this option is \code{true}, enhanced VPC routing is enabled.

Default: false}

\item{AdditionalInfo}{Reserved.}

\item{IamRoles}{A list of AWS Identity and Access Management (IAM) roles that can be
used by the cluster to access other AWS services. You must supply the
IAM roles in their Amazon Resource Name (ARN) format. You can supply up
to 10 IAM roles in a single request.

A cluster can have up to 10 IAM roles associated with it at any time.}

\item{MaintenanceTrackName}{An optional parameter for the name of the maintenance track for the
cluster. If you don't provide a maintenance track name, the cluster is
assigned to the \code{current} track.}

\item{SnapshotScheduleIdentifier}{A unique identifier for the snapshot schedule.}
}
\description{
Creates a new cluster.
}
\details{
To create a cluster in Virtual Private Cloud (VPC), you must provide a
cluster subnet group name. The cluster subnet group identifies the
subnets of your VPC that Amazon Redshift uses when creating the cluster.
For more information about managing clusters, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html}{Amazon Redshift Clusters}
in the \emph{Amazon Redshift Cluster Management Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_cluster(
  DBName = "string",
  ClusterIdentifier = "string",
  ClusterType = "string",
  NodeType = "string",
  MasterUsername = "string",
  MasterUserPassword = "string",
  ClusterSecurityGroups = list(
    "string"
  ),
  VpcSecurityGroupIds = list(
    "string"
  ),
  ClusterSubnetGroupName = "string",
  AvailabilityZone = "string",
  PreferredMaintenanceWindow = "string",
  ClusterParameterGroupName = "string",
  AutomatedSnapshotRetentionPeriod = 123,
  ManualSnapshotRetentionPeriod = 123,
  Port = 123,
  ClusterVersion = "string",
  AllowVersionUpgrade = TRUE|FALSE,
  NumberOfNodes = 123,
  PubliclyAccessible = TRUE|FALSE,
  Encrypted = TRUE|FALSE,
  HsmClientCertificateIdentifier = "string",
  HsmConfigurationIdentifier = "string",
  ElasticIp = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KmsKeyId = "string",
  EnhancedVpcRouting = TRUE|FALSE,
  AdditionalInfo = "string",
  IamRoles = list(
    "string"
  ),
  MaintenanceTrackName = "string",
  SnapshotScheduleIdentifier = "string"
)
}
}

\keyword{internal}
