% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_events}
\alias{rds_describe_events}
\title{Returns events related to DB instances, DB security groups, DB
snapshots, and DB parameter groups for the past 14 days}
\usage{
rds_describe_events(SourceIdentifier, SourceType, StartTime, EndTime,
  Duration, EventCategories, Filters, MaxRecords, Marker)
}
\arguments{
\item{SourceIdentifier}{The identifier of the event source for which events are returned. If not
specified, then all sources are included in the response.

Constraints:
\itemize{
\item If SourceIdentifier is supplied, SourceType must also be provided.
\item If the source type is \code{DBInstance}, then a \code{DBInstanceIdentifier}
must be supplied.
\item If the source type is \code{DBSecurityGroup}, a \code{DBSecurityGroupName}
must be supplied.
\item If the source type is \code{DBParameterGroup}, a \code{DBParameterGroupName}
must be supplied.
\item If the source type is \code{DBSnapshot}, a \code{DBSnapshotIdentifier} must be
supplied.
\item Can\'t end with a hyphen or contain two consecutive hyphens.
}}

\item{SourceType}{The event source to retrieve events for. If no value is specified, all
events are returned.}

\item{StartTime}{The beginning of the time interval to retrieve events for, specified in
ISO 8601 format. For more information about ISO 8601, go to the \href{http://en.wikipedia.org/wiki/ISO_8601}{ISO8601 Wikipedia page.}

Example: 2009-07-08T18:00Z}

\item{EndTime}{The end of the time interval for which to retrieve events, specified in
ISO 8601 format. For more information about ISO 8601, go to the \href{http://en.wikipedia.org/wiki/ISO_8601}{ISO8601 Wikipedia page.}

Example: 2009-07-08T18:00Z}

\item{Duration}{The number of minutes to retrieve events for.

Default: 60}

\item{EventCategories}{A list of event categories that trigger notifications for a event
notification subscription.}

\item{Filters}{This parameter isn\'t currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous DescribeEvents
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Returns events related to DB instances, DB security groups, DB
snapshots, and DB parameter groups for the past 14 days. Events specific
to a particular DB instance, DB security group, database snapshot, or DB
parameter group can be obtained by providing the name as a parameter. By
default, the past hour of events are returned.
}
\section{Request syntax}{
\preformatted{svc$describe_events(
  SourceIdentifier = "string",
  SourceType = "db-instance"|"db-parameter-group"|"db-security-group"|"db-snapshot"|"db-cluster"|"db-cluster-snapshot",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  Duration = 123,
  EventCategories = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
