% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_export_table_to_point_in_time}
\alias{dynamodb_export_table_to_point_in_time}
\title{Exports table data to an S3 bucket}
\usage{
dynamodb_export_table_to_point_in_time(
  TableArn,
  ExportTime = NULL,
  ClientToken = NULL,
  S3Bucket,
  S3BucketOwner = NULL,
  S3Prefix = NULL,
  S3SseAlgorithm = NULL,
  S3SseKmsKeyId = NULL,
  ExportFormat = NULL
)
}
\arguments{
\item{TableArn}{[required] The Amazon Resource Name (ARN) associated with the table to export.}

\item{ExportTime}{Time in the past from which to export table data, counted in seconds
from the start of the Unix epoch. The table export will be a snapshot of
the table's state at this point in time.}

\item{ClientToken}{Providing a \code{ClientToken} makes the call to
\code{ExportTableToPointInTimeInput} idempotent, meaning that multiple
identical calls have the same effect as one single call.

A client token is valid for 8 hours after the first request that uses it
is completed. After 8 hours, any request with the same client token is
treated as a new request. Do not resubmit the same request with the same
client token for more than 8 hours, or the result might not be
idempotent.

If you submit a request with the same client token but a change in other
parameters within the 8-hour idempotency window, DynamoDB returns an
\code{ImportConflictException}.}

\item{S3Bucket}{[required] The name of the Amazon S3 bucket to export the snapshot to.}

\item{S3BucketOwner}{The ID of the Amazon Web Services account that owns the bucket the
export will be stored in.}

\item{S3Prefix}{The Amazon S3 bucket prefix to use as the file name and path of the
exported snapshot.}

\item{S3SseAlgorithm}{Type of encryption used on the bucket where export data will be stored.
Valid values for \code{S3SseAlgorithm} are:
\itemize{
\item \code{AES256} - server-side encryption with Amazon S3 managed keys
\item \code{KMS} - server-side encryption with KMS managed keys
}}

\item{S3SseKmsKeyId}{The ID of the KMS managed key used to encrypt the S3 bucket where export
data will be stored (if applicable).}

\item{ExportFormat}{The format for the exported data. Valid values for \code{ExportFormat} are
\code{DYNAMODB_JSON} or \code{ION}.}
}
\description{
Exports table data to an S3 bucket. The table must have point in time recovery enabled, and you can export data from any time within the point in time recovery window.

See \url{https://www.paws-r-sdk.com/docs/dynamodb_export_table_to_point_in_time/} for full documentation.
}
\keyword{internal}
