% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_authorize_snapshot_access}
\alias{redshift_authorize_snapshot_access}
\title{Authorizes the specified Amazon Web Services account to restore the
specified snapshot}
\usage{
redshift_authorize_snapshot_access(
  SnapshotIdentifier = NULL,
  SnapshotArn = NULL,
  SnapshotClusterIdentifier = NULL,
  AccountWithRestoreAccess
)
}
\arguments{
\item{SnapshotIdentifier}{The identifier of the snapshot the account is authorized to restore.}

\item{SnapshotArn}{The Amazon Resource Name (ARN) of the snapshot to authorize access to.}

\item{SnapshotClusterIdentifier}{The identifier of the cluster the snapshot was created from. This
parameter is required if your IAM user or role has a policy containing a
snapshot resource element that specifies anything other than * for the
cluster name.}

\item{AccountWithRestoreAccess}{[required] The identifier of the Amazon Web Services account authorized to restore
the specified snapshot.

To share a snapshot with Amazon Web Services Support, specify
amazon-redshift-support.}
}
\description{
Authorizes the specified Amazon Web Services account to restore the specified snapshot.

See \url{https://www.paws-r-sdk.com/docs/redshift_authorize_snapshot_access/} for full documentation.
}
\keyword{internal}
