% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftdataapiservice_operations.R
\name{redshiftdataapiservice_get_statement_result}
\alias{redshiftdataapiservice_get_statement_result}
\title{Fetches the temporarily cached result of an SQL statement}
\usage{
redshiftdataapiservice_get_statement_result(Id, NextToken = NULL)
}
\arguments{
\item{Id}{[required] The identifier of the SQL statement whose results are to be fetched.
This value is a universally unique identifier (UUID) generated by Amazon
Redshift Data API. A suffix indicates then number of the SQL statement.
For example, \verb{d9b6c0c9-0747-4bf4-b142-e8883122f766:2} has a suffix of
\verb{:2} that indicates the second SQL statement of a batch query. This
identifier is returned by \code{BatchExecuteStatment}, \code{ExecuteStatment}, and
\code{\link[=redshiftdataapiservice_list_statements]{list_statements}}.}

\item{NextToken}{A value that indicates the starting point for the next set of response
records in a subsequent request. If a value is returned in a response,
you can retrieve the next set of records by providing this returned
NextToken value in the next NextToken parameter and retrying the
command. If the NextToken field is empty, all response records have been
retrieved for the request.}
}
\description{
Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement results.

See \url{https://www.paws-r-sdk.com/docs/redshiftdataapiservice_get_statement_result/} for full documentation.
}
\keyword{internal}
