% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_modify_serverless_cache}
\alias{elasticache_modify_serverless_cache}
\title{This API modifies the attributes of a serverless cache}
\usage{
elasticache_modify_serverless_cache(
  ServerlessCacheName,
  Description = NULL,
  CacheUsageLimits = NULL,
  RemoveUserGroup = NULL,
  UserGroupId = NULL,
  SecurityGroupIds = NULL,
  SnapshotRetentionLimit = NULL,
  DailySnapshotTime = NULL
)
}
\arguments{
\item{ServerlessCacheName}{[required] User-provided identifier for the serverless cache to be modified.}

\item{Description}{User provided description for the serverless cache. Default = NULL, i.e.
the existing description is not removed/modified. The description has a
maximum length of 255 characters.}

\item{CacheUsageLimits}{Modify the cache usage limit for the serverless cache.}

\item{RemoveUserGroup}{The identifier of the UserGroup to be removed from association with the
Redis serverless cache. Available for Redis only. Default is NULL.}

\item{UserGroupId}{The identifier of the UserGroup to be associated with the serverless
cache. Available for Redis only. Default is NULL - the existing
UserGroup is not removed.}

\item{SecurityGroupIds}{The new list of VPC security groups to be associated with the serverless
cache. Populating this list means the current VPC security groups will
be removed. This security group is used to authorize traffic access for
the VPC end-point (private-link). Default = NULL - the existing list of
VPC security groups is not removed.}

\item{SnapshotRetentionLimit}{The number of days for which Elasticache retains automatic snapshots
before deleting them. Available for Redis only. Default = NULL, i.e. the
existing snapshot-retention-limit will not be removed or modified. The
maximum value allowed is 35 days.}

\item{DailySnapshotTime}{The daily time during which Elasticache begins taking a daily snapshot
of the serverless cache. Available for Redis only. The default is NULL,
i.e. the existing snapshot time configured for the cluster is not
removed.}
}
\description{
This API modifies the attributes of a serverless cache.

See \url{https://www.paws-r-sdk.com/docs/elasticache_modify_serverless_cache/} for full documentation.
}
\keyword{internal}
