% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_create_workgroup}
\alias{redshiftserverless_create_workgroup}
\title{Creates an workgroup in Amazon Redshift Serverless}
\usage{
redshiftserverless_create_workgroup(
  baseCapacity = NULL,
  configParameters = NULL,
  enhancedVpcRouting = NULL,
  maxCapacity = NULL,
  namespaceName,
  port = NULL,
  publiclyAccessible = NULL,
  securityGroupIds = NULL,
  subnetIds = NULL,
  tags = NULL,
  workgroupName
)
}
\arguments{
\item{baseCapacity}{The base data warehouse capacity of the workgroup in Redshift Processing
Units (RPUs).}

\item{configParameters}{An array of parameters to set for advanced control over a database. The
options are \code{auto_mv}, \code{datestyle}, \code{enable_case_sensitive_identifier},
\code{enable_user_activity_logging}, \code{query_group}, \code{search_path}, and query
monitoring metrics that let you define performance boundaries. For more
information about query monitoring rules and available metrics, see
\href{https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless}{Query monitoring metrics for Amazon Redshift Serverless}.}

\item{enhancedVpcRouting}{The value that specifies whether to turn on enhanced virtual private
cloud (VPC) routing, which forces Amazon Redshift Serverless to route
traffic through your VPC instead of over the internet.}

\item{maxCapacity}{The maximum data-warehouse capacity Amazon Redshift Serverless uses to
serve queries. The max capacity is specified in RPUs.}

\item{namespaceName}{[required] The name of the namespace to associate with the workgroup.}

\item{port}{The custom port to use when connecting to a workgroup. Valid port ranges
are 5431-5455 and 8191-8215. The default is 5439.}

\item{publiclyAccessible}{A value that specifies whether the workgroup can be accessed from a
public network.}

\item{securityGroupIds}{An array of security group IDs to associate with the workgroup.}

\item{subnetIds}{An array of VPC subnet IDs to associate with the workgroup.}

\item{tags}{A array of tag instances.}

\item{workgroupName}{[required] The name of the created workgroup.}
}
\description{
Creates an workgroup in Amazon Redshift Serverless.

See \url{https://www.paws-r-sdk.com/docs/redshiftserverless_create_workgroup/} for full documentation.
}
\keyword{internal}
