% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_shard_group}
\alias{rds_create_db_shard_group}
\title{Creates a new DB shard group for Aurora Limitless Database}
\usage{
rds_create_db_shard_group(
  DBShardGroupIdentifier,
  DBClusterIdentifier,
  ComputeRedundancy = NULL,
  MaxACU,
  MinACU = NULL,
  PubliclyAccessible = NULL
)
}
\arguments{
\item{DBShardGroupIdentifier}{[required] The name of the DB shard group.}

\item{DBClusterIdentifier}{[required] The name of the primary DB cluster for the DB shard group.}

\item{ComputeRedundancy}{Specifies whether to create standby instances for the DB shard group.
Valid values are the following:
\itemize{
\item 0 - Creates a single, primary DB instance for each physical shard.
This is the default value, and the only one supported for the
preview.
\item 1 - Creates a primary DB instance and a standby instance in a
different Availability Zone (AZ) for each physical shard.
\item 2 - Creates a primary DB instance and two standby instances in
different AZs for each physical shard.
}}

\item{MaxACU}{[required] The maximum capacity of the DB shard group in Aurora capacity units
(ACUs).}

\item{MinACU}{The minimum capacity of the DB shard group in Aurora capacity units
(ACUs).}

\item{PubliclyAccessible}{Specifies whether the DB shard group is publicly accessible.

When the DB shard group is publicly accessible, its Domain Name System
(DNS) endpoint resolves to the private IP address from within the DB
shard group's virtual private cloud (VPC). It resolves to the public IP
address from outside of the DB shard group's VPC. Access to the DB shard
group is ultimately controlled by the security group it uses. That
public access is not permitted if the security group assigned to the DB
shard group doesn't permit it.

When the DB shard group isn't publicly accessible, it is an internal DB
shard group with a DNS name that resolves to a private IP address.

Default: The default behavior varies depending on whether
\code{DBSubnetGroupName} is specified.

If \code{DBSubnetGroupName} isn't specified, and \code{PubliclyAccessible} isn't
specified, the following applies:
\itemize{
\item If the default VPC in the target Region doesn’t have an internet
gateway attached to it, the DB shard group is private.
\item If the default VPC in the target Region has an internet gateway
attached to it, the DB shard group is public.
}

If \code{DBSubnetGroupName} is specified, and \code{PubliclyAccessible} isn't
specified, the following applies:
\itemize{
\item If the subnets are part of a VPC that doesn’t have an internet
gateway attached to it, the DB shard group is private.
\item If the subnets are part of a VPC that has an internet gateway
attached to it, the DB shard group is public.
}}
}
\description{
Creates a new DB shard group for Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.

See \url{https://www.paws-r-sdk.com/docs/rds_create_db_shard_group/} for full documentation.
}
\keyword{internal}
