% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_put_encryption_config}
\alias{xray_put_encryption_config}
\title{Updates the encryption configuration for X-Ray data}
\usage{
xray_put_encryption_config(KeyId, Type)
}
\arguments{
\item{KeyId}{An AWS KMS customer master key (CMK) in one of the following formats:
\itemize{
\item \strong{Alias} - The name of the key. For example, \code{alias/MyKey}.
\item \strong{Key ID} - The KMS key ID of the key. For example,
\verb{ae4aa6d49-a4d8-9df9-a475-4ff6d7898456}. AWS X-Ray does not support
asymmetric CMKs.
\item \strong{ARN} - The full Amazon Resource Name of the key ID or alias. For
example,
\verb{arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456}.
Use this format to specify a key in a different account.
}

Omit this key if you set \code{Type} to \code{NONE}.}

\item{Type}{[required] The type of encryption. Set to \code{KMS} to use your own key for encryption.
Set to \code{NONE} for default encryption.}
}
\value{
A list with the following syntax:\preformatted{list(
  EncryptionConfig = list(
    KeyId = "string",
    Status = "UPDATING"|"ACTIVE",
    Type = "NONE"|"KMS"
  )
)
}
}
\description{
Updates the encryption configuration for X-Ray data.
}
\section{Request syntax}{
\preformatted{svc$put_encryption_config(
  KeyId = "string",
  Type = "NONE"|"KMS"
)
}
}

\keyword{internal}
