% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_describe_package_version}
\alias{codeartifact_describe_package_version}
\title{Returns a PackageVersionDescription object that contains information
about the requested package version}
\usage{
codeartifact_describe_package_version(
  domain,
  domainOwner = NULL,
  repository,
  format,
  namespace = NULL,
  package,
  packageVersion
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the repository that contains the
package version.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository that contains the package version.}

\item{format}{[required] A format that specifies the type of the requested package version.}

\item{namespace}{The namespace of the requested package version. The package version
component that specifies its namespace depends on its type. For example:
\itemize{
\item The namespace of a Maven package version is its \code{groupId}.
\item The namespace of an npm package version is its \code{scope}.
\item Python and NuGet package versions do not contain a corresponding
component, package versions of those formats do not have a
namespace.
}}

\item{package}{[required] The name of the requested package version.}

\item{packageVersion}{[required] A string that contains the package version (for example, \verb{3.5.2}).}
}
\description{
Returns a \href{https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html}{PackageVersionDescription} object that contains information about the requested package version.

See \url{https://paws-r.github.io/docs/codeartifact/describe_package_version.html} for full documentation.
}
\keyword{internal}
