% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_batch_get_deployment_targets}
\alias{codedeploy_batch_get_deployment_targets}
\title{Returns an array of one or more targets associated with a deployment}
\usage{
codedeploy_batch_get_deployment_targets(deploymentId = NULL, targetIds = NULL)
}
\arguments{
\item{deploymentId}{The unique ID of a deployment.}

\item{targetIds}{The unique IDs of the deployment targets. The compute platform of the
deployment determines the type of the targets and their formats. The
maximum number of deployment target IDs you can specify is 25.
\itemize{
\item For deployments that use the EC2/On-premises compute platform, the
target IDs are EC2 or on-premises instances IDs, and their target
type is \code{instanceTarget}.
\item For deployments that use the AWS Lambda compute platform, the target
IDs are the names of Lambda functions, and their target type is
\code{instanceTarget}.
\item For deployments that use the Amazon ECS compute platform, the target
IDs are pairs of Amazon ECS clusters and services specified using
the format \verb{<clustername>:<servicename>}. Their target type is
\code{ecsTarget}.
\item For deployments that are deployed with AWS CloudFormation, the
target IDs are CloudFormation stack IDs. Their target type is
\code{cloudFormationTarget}.
}}
}
\description{
Returns an array of one or more targets associated with a deployment. This method works with all compute types and should be used instead of the deprecated \code{\link[=codedeploy_batch_get_deployment_instances]{batch_get_deployment_instances}}. The maximum number of targets that can be returned is 25.

See \url{https://paws-r.github.io/docs/codedeploy/batch_get_deployment_targets.html} for full documentation.
}
\keyword{internal}
