% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drs_operations.R
\name{drs_disconnect_recovery_instance}
\alias{drs_disconnect_recovery_instance}
\title{Disconnect a Recovery Instance from Elastic Disaster Recovery}
\usage{
drs_disconnect_recovery_instance(recoveryInstanceID)
}
\arguments{
\item{recoveryInstanceID}{[required] The ID of the Recovery Instance to disconnect.}
}
\description{
Disconnect a Recovery Instance from Elastic Disaster Recovery. Data replication is stopped immediately. All AWS resources created by Elastic Disaster Recovery for enabling the replication of the Recovery Instance will be terminated / deleted within 90 minutes. If the agent on the Recovery Instance has not been prevented from communicating with the Elastic Disaster Recovery service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the Recovery Instance will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.

See \url{https://paws-r.github.io/docs/drs/disconnect_recovery_instance.html} for full documentation.
}
\keyword{internal}
