% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_disable_stage_transition}
\alias{codepipeline_disable_stage_transition}
\title{Prevents artifacts in a pipeline from transitioning to the next stage in
the pipeline}
\usage{
codepipeline_disable_stage_transition(
  pipelineName,
  stageName,
  transitionType,
  reason
)
}
\arguments{
\item{pipelineName}{[required] The name of the pipeline in which you want to disable the flow of
artifacts from one stage to another.}

\item{stageName}{[required] The name of the stage where you want to disable the inbound or outbound
transition of artifacts.}

\item{transitionType}{[required] Specifies whether artifacts are prevented from transitioning into the
stage and being processed by the actions in that stage (inbound), or
prevented from transitioning from the stage after they have been
processed by the actions in that stage (outbound).}

\item{reason}{[required] The reason given to the user that a stage is disabled, such as waiting
for manual approval or manual tests. This message is displayed in the
pipeline console UI.}
}
\description{
Prevents artifacts in a pipeline from transitioning to the next stage in the pipeline.

See \url{https://www.paws-r-sdk.com/docs/codepipeline_disable_stage_transition/} for full documentation.
}
\keyword{internal}
