% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worklink_operations.R
\name{worklink_list_website_certificate_authorities}
\alias{worklink_list_website_certificate_authorities}
\title{Retrieves a list of certificate authorities added for the current
account and Region}
\usage{
worklink_list_website_certificate_authorities(FleetArn, MaxResults,
  NextToken)
}
\arguments{
\item{FleetArn}{[required] The ARN of the fleet.}

\item{MaxResults}{The maximum number of results to be included in the next page.}

\item{NextToken}{The pagination token used to retrieve the next page of results for this
operation. If this value is null, it retrieves the first page.}
}
\value{
A list with the following syntax:\preformatted{list(
  WebsiteCertificateAuthorities = list(
    list(
      WebsiteCaId = "string",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      DisplayName = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list of certificate authorities added for the current
account and Region.
}
\section{Request syntax}{
\preformatted{svc$list_website_certificate_authorities(
  FleetArn = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
