% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_describe_workspaces}
\alias{workspaces_describe_workspaces}
\title{Describes the specified WorkSpaces}
\usage{
workspaces_describe_workspaces(WorkspaceIds, DirectoryId, UserName,
  BundleId, Limit, NextToken)
}
\arguments{
\item{WorkspaceIds}{The identifiers of the WorkSpaces. You cannot combine this parameter
with any other filter.

Because the \code{\link[=workspaces_create_workspaces]{create_workspaces}}
operation is asynchronous, the identifier it returns is not immediately
available. If you immediately call
\code{\link[=workspaces_describe_workspaces]{describe_workspaces}} with this
identifier, no information is returned.}

\item{DirectoryId}{The identifier of the directory. In addition, you can optionally specify
a specific directory user (see \code{UserName}). You cannot combine this
parameter with any other filter.}

\item{UserName}{The name of the directory user. You must specify this parameter with
\code{DirectoryId}.}

\item{BundleId}{The identifier of the bundle. All WorkSpaces that are created from this
bundle are retrieved. You cannot combine this parameter with any other
filter.}

\item{Limit}{The maximum number of items to return.}

\item{NextToken}{If you received a \code{NextToken} from a previous call that was paginated,
provide this token to receive the next set of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  Workspaces = list(
    list(
      WorkspaceId = "string",
      DirectoryId = "string",
      UserName = "string",
      IpAddress = "string",
      State = "PENDING"|"AVAILABLE"|"IMPAIRED"|"UNHEALTHY"|"REBOOTING"|"STARTING"|"REBUILDING"|"RESTORING"|"MAINTENANCE"|"ADMIN_MAINTENANCE"|"TERMINATING"|"TERMINATED"|"SUSPENDED"|"UPDATING"|"STOPPING"|"STOPPED"|"ERROR",
      BundleId = "string",
      SubnetId = "string",
      ErrorMessage = "string",
      ErrorCode = "string",
      ComputerName = "string",
      VolumeEncryptionKey = "string",
      UserVolumeEncryptionEnabled = TRUE|FALSE,
      RootVolumeEncryptionEnabled = TRUE|FALSE,
      WorkspaceProperties = list(
        RunningMode = "AUTO_STOP"|"ALWAYS_ON",
        RunningModeAutoStopTimeoutInMinutes = 123,
        RootVolumeSizeGib = 123,
        UserVolumeSizeGib = 123,
        ComputeTypeName = "VALUE"|"STANDARD"|"PERFORMANCE"|"POWER"|"GRAPHICS"|"POWERPRO"|"GRAPHICSPRO"
      ),
      ModificationStates = list(
        list(
          Resource = "ROOT_VOLUME"|"USER_VOLUME"|"COMPUTE_TYPE",
          State = "UPDATE_INITIATED"|"UPDATE_IN_PROGRESS"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the specified WorkSpaces.

You can filter the results by using the bundle identifier, directory
identifier, or owner, but you can specify only one filter at a time.
}
\section{Request syntax}{
\preformatted{svc$describe_workspaces(
  WorkspaceIds = list(
    "string"
  ),
  DirectoryId = "string",
  UserName = "string",
  BundleId = "string",
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
