% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexruntimeservice_operations.R
\name{lexruntimeservice_post_text}
\alias{lexruntimeservice_post_text}
\title{Sends user input (text-only) to Amazon Lex}
\usage{
lexruntimeservice_post_text(botName, botAlias, userId,
  sessionAttributes, requestAttributes, inputText)
}
\arguments{
\item{botName}{[required] The name of the Amazon Lex bot.}

\item{botAlias}{[required] The alias of the Amazon Lex bot.}

\item{userId}{[required] The ID of the client application user. Amazon Lex uses this to identify
a user's conversation with your bot. At runtime, each request must
contain the \code{userID} field.

To decide the user ID to use for your application, consider the
following factors.
\itemize{
\item The \code{userID} field must not contain any personally identifiable
information of the user, for example, name, personal identification
numbers, or other end user personal information.
\item If you want a user to start a conversation on one device and
continue on another device, use a user-specific identifier.
\item If you want the same user to be able to have two independent
conversations on two different devices, choose a device-specific
identifier.
\item A user can't have two independent conversations with two different
versions of the same bot. For example, a user can't have a
conversation with the PROD and BETA versions of the same bot. If you
anticipate that a user will need to have conversation with two
different versions, for example, while testing, include the bot
alias in the user ID to separate the two conversations.
}}

\item{sessionAttributes}{Application-specific information passed between Amazon Lex and a client
application.

For more information, see \href{http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs}{Setting Session Attributes}.}

\item{requestAttributes}{Request-specific information passed between Amazon Lex and a client
application.

The namespace \code{x-amz-lex:} is reserved for special attributes. Don't
create any request attributes with the prefix \code{x-amz-lex:}.

For more information, see \href{http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs}{Setting Request Attributes}.}

\item{inputText}{[required] The text that the user entered (Amazon Lex interprets this text).}
}
\description{
Sends user input (text-only) to Amazon Lex. Client applications can use
this API to send requests to Amazon Lex at runtime. Amazon Lex then
interprets the user input using the machine learning model it built for
the bot.
}
\details{
In response, Amazon Lex returns the next \code{message} to convey to the user
an optional \code{responseCard} to display. Consider the following example
messages:
\itemize{
\item For a user input "I would like a pizza", Amazon Lex might return a
response with a message eliciting slot data (for example,
PizzaSize): "What size pizza would you like?"
\item After the user provides all of the pizza order information, Amazon
Lex might return a response with a message to obtain user
confirmation "Proceed with the pizza order?".
\item After the user replies to a confirmation prompt with a "yes",
Amazon Lex might return a conclusion statement: "Thank you, your
cheese pizza has been ordered.".
}

Not all Amazon Lex messages require a user response. For example, a
conclusion statement does not require a response. Some messages require
only a "yes" or "no" user response. In addition to the \code{message},
Amazon Lex provides additional context about the message in the response
that you might use to enhance client behavior, for example, to display
the appropriate client user interface. These are the \code{slotToElicit},
\code{dialogState}, \code{intentName}, and \code{slots} fields in the response.
Consider the following examples:
\itemize{
\item If the message is to elicit slot data, Amazon Lex returns the
following context information:
\item \code{dialogState} set to ElicitSlot
\item \code{intentName} set to the intent name in the current context
\item \code{slotToElicit} set to the slot name for which the \code{message} is
eliciting information
\item \code{slots} set to a map of slots, configured for the intent, with
currently known values
\item If the message is a confirmation prompt, the \code{dialogState} is set to
ConfirmIntent and \code{SlotToElicit} is set to null.
\item If the message is a clarification prompt (configured for the intent)
that indicates that user intent is not understood, the \code{dialogState}
is set to ElicitIntent and \code{slotToElicit} is set to null.
}

In addition, Amazon Lex also returns your application-specific
\code{sessionAttributes}. For more information, see \href{http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html}{Managing Conversation Context}.
}
\section{Request syntax}{
\preformatted{svc$post_text(
  botName = "string",
  botAlias = "string",
  userId = "string",
  sessionAttributes = list(
    "string"
  ),
  requestAttributes = list(
    "string"
  ),
  inputText = "string"
)
}
}

\keyword{internal}
