% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_search}
\alias{sagemaker_search}
\title{Finds Amazon SageMaker resources that match a search query}
\usage{
sagemaker_search(Resource, SearchExpression, SortBy, SortOrder,
  NextToken, MaxResults)
}
\arguments{
\item{Resource}{[required] The name of the Amazon SageMaker resource to search for.}

\item{SearchExpression}{A Boolean conditional statement. Resources must satisfy this condition
to be included in search results. You must provide at least one
subexpression, filter, or nested filter. The maximum number of recursive
\code{SubExpressions}, \code{NestedFilters}, and \code{Filters} that can be included in
a \code{SearchExpression} object is 50.}

\item{SortBy}{The name of the resource property used to sort the \code{SearchResults}. The
default is \code{LastModifiedTime}.}

\item{SortOrder}{How \code{SearchResults} are ordered. Valid values are \code{Ascending} or
\code{Descending}. The default is \code{Descending}.}

\item{NextToken}{If more than \code{MaxResults} resources match the specified
\code{SearchExpression}, the response includes a \code{NextToken}. The \code{NextToken}
can be passed to the next \code{SearchRequest} to continue retrieving
results.}

\item{MaxResults}{The maximum number of results to return.}
}
\description{
Finds Amazon SageMaker resources that match a search query. Matching
resources are returned as a list of \code{SearchRecord} objects in the
response. You can sort the search results by any resource property in a
ascending or descending order.

You can query against the following value types: numeric, text, Boolean,
and timestamp.
}
\section{Request syntax}{
\preformatted{svc$search(
  Resource = "TrainingJob"|"Experiment"|"ExperimentTrial"|"ExperimentTrialComponent"|"Endpoint"|"ModelPackage"|"ModelPackageGroup"|"Pipeline"|"PipelineExecution"|"FeatureGroup",
  SearchExpression = list(
    Filters = list(
      list(
        Name = "string",
        Operator = "Equals"|"NotEquals"|"GreaterThan"|"GreaterThanOrEqualTo"|"LessThan"|"LessThanOrEqualTo"|"Contains"|"Exists"|"NotExists"|"In",
        Value = "string"
      )
    ),
    NestedFilters = list(
      list(
        NestedPropertyName = "string",
        Filters = list(
          list(
            Name = "string",
            Operator = "Equals"|"NotEquals"|"GreaterThan"|"GreaterThanOrEqualTo"|"LessThan"|"LessThanOrEqualTo"|"Contains"|"Exists"|"NotExists"|"In",
            Value = "string"
          )
        )
      )
    ),
    SubExpressions = list(
      list()
    ),
    Operator = "And"|"Or"
  ),
  SortBy = "string",
  SortOrder = "Ascending"|"Descending",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
