% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_start_sentiment_detection_job}
\alias{comprehend_start_sentiment_detection_job}
\title{Starts an asynchronous sentiment detection job for a collection of
documents}
\usage{
comprehend_start_sentiment_detection_job(InputDataConfig,
  OutputDataConfig, DataAccessRoleArn, JobName, LanguageCode,
  ClientRequestToken, VolumeKmsKeyId, VpcConfig)
}
\arguments{
\item{InputDataConfig}{[required] Specifies the format and location of the input data for the job.}

\item{OutputDataConfig}{[required] Specifies where to send the output files.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the AWS Identity and Access Management
(IAM) role that grants Amazon Comprehend read access to your input data.
For more information, see
\url{https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions}.}

\item{JobName}{The identifier of the job.}

\item{LanguageCode}{[required] The language of the input documents. You can specify any of the primary
languages supported by Amazon Comprehend. All documents must be in the
same language.}

\item{ClientRequestToken}{A unique identifier for the request. If you don't set the client request
token, Amazon Comprehend generates one.}

\item{VolumeKmsKeyId}{ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
uses to encrypt data on the storage volume attached to the ML compute
instance(s) that process the analysis job. The VolumeKmsKeyId can be
either of the following formats:
\itemize{
\item KMS Key ID: \code{"1234abcd-12ab-34cd-56ef-1234567890ab"}
\item Amazon Resource Name (ARN) of a KMS Key:
\code{"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"}
}}

\item{VpcConfig}{Configuration parameters for an optional private Virtual Private Cloud
(VPC) containing the resources you are using for your sentiment
detection job. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html}{Amazon VPC}.}
}
\value{
A list with the following syntax:\preformatted{list(
  JobId = "string",
  JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED"
)
}
}
\description{
Starts an asynchronous sentiment detection job for a collection of
documents. use the operation to track the status of a job.
}
\section{Request syntax}{
\preformatted{svc$start_sentiment_detection_job(
  InputDataConfig = list(
    S3Uri = "string",
    InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
  ),
  OutputDataConfig = list(
    S3Uri = "string",
    KmsKeyId = "string"
  ),
  DataAccessRoleArn = "string",
  JobName = "string",
  LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
  ClientRequestToken = "string",
  VolumeKmsKeyId = "string",
  VpcConfig = list(
    SecurityGroupIds = list(
      "string"
    ),
    Subnets = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
