% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_artifact}
\alias{sagemaker_update_artifact}
\title{Updates an artifact}
\usage{
sagemaker_update_artifact(ArtifactArn, ArtifactName, Properties,
  PropertiesToRemove)
}
\arguments{
\item{ArtifactArn}{[required] The Amazon Resource Name (ARN) of the artifact to update.}

\item{ArtifactName}{The new name for the artifact.}

\item{Properties}{The new list of properties. Overwrites the current property list.}

\item{PropertiesToRemove}{A list of properties to remove.}
}
\value{
A list with the following syntax:\preformatted{list(
  ArtifactArn = "string"
)
}
}
\description{
Updates an artifact.
}
\section{Request syntax}{
\preformatted{svc$update_artifact(
  ArtifactArn = "string",
  ArtifactName = "string",
  Properties = list(
    "string"
  ),
  PropertiesToRemove = list(
    "string"
  )
)
}
}

\keyword{internal}
