# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lexmodelbuildingservice_service.R
NULL

#' Creates a new version of the bot based on the $LATEST version
#'
#' @description
#' Creates a new version of the bot based on the `$LATEST` version. If the
#' `$LATEST` version of this resource hasn't changed since you created the
#' last version, Amazon Lex doesn't create a new version. It returns the
#' last created version.
#' 
#' You can update only the `$LATEST` version of the bot. You can't update
#' the numbered versions that you create with the
#' [`create_bot_version`][lexmodelbuildingservice_create_bot_version]
#' operation.
#' 
#' When you create the first version of a bot, Amazon Lex sets the version
#' to 1. Subsequent versions increment by 1. For more information, see
#' versioning-intro.
#' 
#' This operation requires permission for the `lex:CreateBotVersion`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_create_bot_version(name, checksum)
#'
#' @param name &#91;required&#93; The name of the bot that you want to create a new version of. The name
#' is case sensitive.
#' @param checksum Identifies a specific revision of the `$LATEST` version of the bot. If
#' you specify a checksum and the `$LATEST` version of the bot has a
#' different checksum, a `PreconditionFailedException` exception is
#' returned and Amazon Lex doesn't publish a new version. If you don't
#' specify a checksum, Amazon Lex publishes the `$LATEST` version.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   intents = list(
#'     list(
#'       intentName = "string",
#'       intentVersion = "string"
#'     )
#'   ),
#'   clarificationPrompt = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     maxAttempts = 123,
#'     responseCard = "string"
#'   ),
#'   abortStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   status = "BUILDING"|"READY"|"READY_BASIC_TESTING"|"FAILED"|"NOT_BUILT",
#'   failureReason = "string",
#'   lastUpdatedDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   idleSessionTTLInSeconds = 123,
#'   voiceId = "string",
#'   checksum = "string",
#'   version = "string",
#'   locale = "de-DE"|"en-AU"|"en-GB"|"en-US"|"es-419"|"es-ES"|"es-US"|"fr-FR"|"fr-CA"|"it-IT",
#'   childDirected = TRUE|FALSE,
#'   enableModelImprovements = TRUE|FALSE,
#'   detectSentiment = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_bot_version(
#'   name = "string",
#'   checksum = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_create_bot_version
lexmodelbuildingservice_create_bot_version <- function(name, checksum = NULL) {
  op <- new_operation(
    name = "CreateBotVersion",
    http_method = "POST",
    http_path = "/bots/{name}/versions",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$create_bot_version_input(name = name, checksum = checksum)
  output <- .lexmodelbuildingservice$create_bot_version_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$create_bot_version <- lexmodelbuildingservice_create_bot_version

#' Creates a new version of an intent based on the $LATEST version of the
#' intent
#'
#' @description
#' Creates a new version of an intent based on the `$LATEST` version of the
#' intent. If the `$LATEST` version of this intent hasn't changed since you
#' last updated it, Amazon Lex doesn't create a new version. It returns the
#' last version you created.
#' 
#' You can update only the `$LATEST` version of the intent. You can't
#' update the numbered versions that you create with the
#' [`create_intent_version`][lexmodelbuildingservice_create_intent_version]
#' operation.
#' 
#' When you create a version of an intent, Amazon Lex sets the version to
#' 1. Subsequent versions increment by 1. For more information, see
#' versioning-intro.
#' 
#' This operation requires permissions to perform the
#' `lex:CreateIntentVersion` action.
#'
#' @usage
#' lexmodelbuildingservice_create_intent_version(name, checksum)
#'
#' @param name &#91;required&#93; The name of the intent that you want to create a new version of. The
#' name is case sensitive.
#' @param checksum Checksum of the `$LATEST` version of the intent that should be used to
#' create the new version. If you specify a checksum and the `$LATEST`
#' version of the intent has a different checksum, Amazon Lex returns a
#' `PreconditionFailedException` exception and doesn't publish a new
#' version. If you don't specify a checksum, Amazon Lex publishes the
#' `$LATEST` version.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   slots = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       slotConstraint = "Required"|"Optional",
#'       slotType = "string",
#'       slotTypeVersion = "string",
#'       valueElicitationPrompt = list(
#'         messages = list(
#'           list(
#'             contentType = "PlainText"|"SSML"|"CustomPayload",
#'             content = "string",
#'             groupNumber = 123
#'           )
#'         ),
#'         maxAttempts = 123,
#'         responseCard = "string"
#'       ),
#'       priority = 123,
#'       sampleUtterances = list(
#'         "string"
#'       ),
#'       responseCard = "string",
#'       obfuscationSetting = "NONE"|"DEFAULT_OBFUSCATION",
#'       defaultValueSpec = list(
#'         defaultValueList = list(
#'           list(
#'             defaultValue = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   sampleUtterances = list(
#'     "string"
#'   ),
#'   confirmationPrompt = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     maxAttempts = 123,
#'     responseCard = "string"
#'   ),
#'   rejectionStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   followUpPrompt = list(
#'     prompt = list(
#'       messages = list(
#'         list(
#'           contentType = "PlainText"|"SSML"|"CustomPayload",
#'           content = "string",
#'           groupNumber = 123
#'         )
#'       ),
#'       maxAttempts = 123,
#'       responseCard = "string"
#'     ),
#'     rejectionStatement = list(
#'       messages = list(
#'         list(
#'           contentType = "PlainText"|"SSML"|"CustomPayload",
#'           content = "string",
#'           groupNumber = 123
#'         )
#'       ),
#'       responseCard = "string"
#'     )
#'   ),
#'   conclusionStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   dialogCodeHook = list(
#'     uri = "string",
#'     messageVersion = "string"
#'   ),
#'   fulfillmentActivity = list(
#'     type = "ReturnIntent"|"CodeHook",
#'     codeHook = list(
#'       uri = "string",
#'       messageVersion = "string"
#'     )
#'   ),
#'   parentIntentSignature = "string",
#'   lastUpdatedDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   version = "string",
#'   checksum = "string",
#'   kendraConfiguration = list(
#'     kendraIndex = "string",
#'     queryFilterString = "string",
#'     role = "string"
#'   ),
#'   inputContexts = list(
#'     list(
#'       name = "string"
#'     )
#'   ),
#'   outputContexts = list(
#'     list(
#'       name = "string",
#'       timeToLiveInSeconds = 123,
#'       turnsToLive = 123
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_intent_version(
#'   name = "string",
#'   checksum = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_create_intent_version
lexmodelbuildingservice_create_intent_version <- function(name, checksum = NULL) {
  op <- new_operation(
    name = "CreateIntentVersion",
    http_method = "POST",
    http_path = "/intents/{name}/versions",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$create_intent_version_input(name = name, checksum = checksum)
  output <- .lexmodelbuildingservice$create_intent_version_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$create_intent_version <- lexmodelbuildingservice_create_intent_version

#' Creates a new version of a slot type based on the $LATEST version of the
#' specified slot type
#'
#' @description
#' Creates a new version of a slot type based on the `$LATEST` version of
#' the specified slot type. If the `$LATEST` version of this resource has
#' not changed since the last version that you created, Amazon Lex doesn't
#' create a new version. It returns the last version that you created.
#' 
#' You can update only the `$LATEST` version of a slot type. You can't
#' update the numbered versions that you create with the
#' [`create_slot_type_version`][lexmodelbuildingservice_create_slot_type_version]
#' operation.
#' 
#' When you create a version of a slot type, Amazon Lex sets the version to
#' 1. Subsequent versions increment by 1. For more information, see
#' versioning-intro.
#' 
#' This operation requires permissions for the `lex:CreateSlotTypeVersion`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_create_slot_type_version(name, checksum)
#'
#' @param name &#91;required&#93; The name of the slot type that you want to create a new version for. The
#' name is case sensitive.
#' @param checksum Checksum for the `$LATEST` version of the slot type that you want to
#' publish. If you specify a checksum and the `$LATEST` version of the slot
#' type has a different checksum, Amazon Lex returns a
#' `PreconditionFailedException` exception and doesn't publish the new
#' version. If you don't specify a checksum, Amazon Lex publishes the
#' `$LATEST` version.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   enumerationValues = list(
#'     list(
#'       value = "string",
#'       synonyms = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   lastUpdatedDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   version = "string",
#'   checksum = "string",
#'   valueSelectionStrategy = "ORIGINAL_VALUE"|"TOP_RESOLUTION",
#'   parentSlotTypeSignature = "string",
#'   slotTypeConfigurations = list(
#'     list(
#'       regexConfiguration = list(
#'         pattern = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_slot_type_version(
#'   name = "string",
#'   checksum = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_create_slot_type_version
lexmodelbuildingservice_create_slot_type_version <- function(name, checksum = NULL) {
  op <- new_operation(
    name = "CreateSlotTypeVersion",
    http_method = "POST",
    http_path = "/slottypes/{name}/versions",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$create_slot_type_version_input(name = name, checksum = checksum)
  output <- .lexmodelbuildingservice$create_slot_type_version_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$create_slot_type_version <- lexmodelbuildingservice_create_slot_type_version

#' Deletes all versions of the bot, including the $LATEST version
#'
#' @description
#' Deletes all versions of the bot, including the `$LATEST` version. To
#' delete a specific version of the bot, use the
#' [`delete_bot_version`][lexmodelbuildingservice_delete_bot_version]
#' operation. The [`delete_bot`][lexmodelbuildingservice_delete_bot]
#' operation doesn't immediately remove the bot schema. Instead, it is
#' marked for deletion and removed later.
#' 
#' Amazon Lex stores utterances indefinitely for improving the ability of
#' your bot to respond to user inputs. These utterances are not removed
#' when the bot is deleted. To remove the utterances, use the
#' [`delete_utterances`][lexmodelbuildingservice_delete_utterances]
#' operation.
#' 
#' If a bot has an alias, you can't delete it. Instead, the
#' [`delete_bot`][lexmodelbuildingservice_delete_bot] operation returns a
#' `ResourceInUseException` exception that includes a reference to the
#' alias that refers to the bot. To remove the reference to the bot, delete
#' the alias. If you get the same exception again, delete the referring
#' alias until the [`delete_bot`][lexmodelbuildingservice_delete_bot]
#' operation is successful.
#' 
#' This operation requires permissions for the `lex:DeleteBot` action.
#'
#' @usage
#' lexmodelbuildingservice_delete_bot(name)
#'
#' @param name &#91;required&#93; The name of the bot. The name is case sensitive.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_bot(
#'   name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_delete_bot
lexmodelbuildingservice_delete_bot <- function(name) {
  op <- new_operation(
    name = "DeleteBot",
    http_method = "DELETE",
    http_path = "/bots/{name}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$delete_bot_input(name = name)
  output <- .lexmodelbuildingservice$delete_bot_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$delete_bot <- lexmodelbuildingservice_delete_bot

#' Deletes an alias for the specified bot
#'
#' @description
#' Deletes an alias for the specified bot.
#' 
#' You can't delete an alias that is used in the association between a bot
#' and a messaging channel. If an alias is used in a channel association,
#' the [`delete_bot`][lexmodelbuildingservice_delete_bot] operation returns
#' a `ResourceInUseException` exception that includes a reference to the
#' channel association that refers to the bot. You can remove the reference
#' to the alias by deleting the channel association. If you get the same
#' exception again, delete the referring association until the
#' [`delete_bot_alias`][lexmodelbuildingservice_delete_bot_alias] operation
#' is successful.
#'
#' @usage
#' lexmodelbuildingservice_delete_bot_alias(name, botName)
#'
#' @param name &#91;required&#93; The name of the alias to delete. The name is case sensitive.
#' @param botName &#91;required&#93; The name of the bot that the alias points to.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_bot_alias(
#'   name = "string",
#'   botName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_delete_bot_alias
lexmodelbuildingservice_delete_bot_alias <- function(name, botName) {
  op <- new_operation(
    name = "DeleteBotAlias",
    http_method = "DELETE",
    http_path = "/bots/{botName}/aliases/{name}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$delete_bot_alias_input(name = name, botName = botName)
  output <- .lexmodelbuildingservice$delete_bot_alias_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$delete_bot_alias <- lexmodelbuildingservice_delete_bot_alias

#' Deletes the association between an Amazon Lex bot and a messaging
#' platform
#'
#' @description
#' Deletes the association between an Amazon Lex bot and a messaging
#' platform.
#' 
#' This operation requires permission for the
#' `lex:DeleteBotChannelAssociation` action.
#'
#' @usage
#' lexmodelbuildingservice_delete_bot_channel_association(name, botName,
#'   botAlias)
#'
#' @param name &#91;required&#93; The name of the association. The name is case sensitive.
#' @param botName &#91;required&#93; The name of the Amazon Lex bot.
#' @param botAlias &#91;required&#93; An alias that points to the specific version of the Amazon Lex bot to
#' which this association is being made.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_bot_channel_association(
#'   name = "string",
#'   botName = "string",
#'   botAlias = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_delete_bot_channel_association
lexmodelbuildingservice_delete_bot_channel_association <- function(name, botName, botAlias) {
  op <- new_operation(
    name = "DeleteBotChannelAssociation",
    http_method = "DELETE",
    http_path = "/bots/{botName}/aliases/{aliasName}/channels/{name}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$delete_bot_channel_association_input(name = name, botName = botName, botAlias = botAlias)
  output <- .lexmodelbuildingservice$delete_bot_channel_association_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$delete_bot_channel_association <- lexmodelbuildingservice_delete_bot_channel_association

#' Deletes a specific version of a bot
#'
#' @description
#' Deletes a specific version of a bot. To delete all versions of a bot,
#' use the [`delete_bot`][lexmodelbuildingservice_delete_bot] operation.
#' 
#' This operation requires permissions for the `lex:DeleteBotVersion`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_delete_bot_version(name, version)
#'
#' @param name &#91;required&#93; The name of the bot.
#' @param version &#91;required&#93; The version of the bot to delete. You cannot delete the `$LATEST`
#' version of the bot. To delete the `$LATEST` version, use the
#' [`delete_bot`][lexmodelbuildingservice_delete_bot] operation.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_bot_version(
#'   name = "string",
#'   version = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_delete_bot_version
lexmodelbuildingservice_delete_bot_version <- function(name, version) {
  op <- new_operation(
    name = "DeleteBotVersion",
    http_method = "DELETE",
    http_path = "/bots/{name}/versions/{version}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$delete_bot_version_input(name = name, version = version)
  output <- .lexmodelbuildingservice$delete_bot_version_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$delete_bot_version <- lexmodelbuildingservice_delete_bot_version

#' Deletes all versions of the intent, including the $LATEST version
#'
#' @description
#' Deletes all versions of the intent, including the `$LATEST` version. To
#' delete a specific version of the intent, use the
#' [`delete_intent_version`][lexmodelbuildingservice_delete_intent_version]
#' operation.
#' 
#' You can delete a version of an intent only if it is not referenced. To
#' delete an intent that is referred to in one or more bots (see
#' how-it-works), you must remove those references first.
#' 
#' If you get the `ResourceInUseException` exception, it provides an
#' example reference that shows where the intent is referenced. To remove
#' the reference to the intent, either update the bot or delete it. If you
#' get the same exception when you attempt to delete the intent again,
#' repeat until the intent has no references and the call to
#' [`delete_intent`][lexmodelbuildingservice_delete_intent] is successful.
#' 
#' This operation requires permission for the `lex:DeleteIntent` action.
#'
#' @usage
#' lexmodelbuildingservice_delete_intent(name)
#'
#' @param name &#91;required&#93; The name of the intent. The name is case sensitive.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_intent(
#'   name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_delete_intent
lexmodelbuildingservice_delete_intent <- function(name) {
  op <- new_operation(
    name = "DeleteIntent",
    http_method = "DELETE",
    http_path = "/intents/{name}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$delete_intent_input(name = name)
  output <- .lexmodelbuildingservice$delete_intent_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$delete_intent <- lexmodelbuildingservice_delete_intent

#' Deletes a specific version of an intent
#'
#' @description
#' Deletes a specific version of an intent. To delete all versions of a
#' intent, use the [`delete_intent`][lexmodelbuildingservice_delete_intent]
#' operation.
#' 
#' This operation requires permissions for the `lex:DeleteIntentVersion`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_delete_intent_version(name, version)
#'
#' @param name &#91;required&#93; The name of the intent.
#' @param version &#91;required&#93; The version of the intent to delete. You cannot delete the `$LATEST`
#' version of the intent. To delete the `$LATEST` version, use the
#' [`delete_intent`][lexmodelbuildingservice_delete_intent] operation.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_intent_version(
#'   name = "string",
#'   version = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_delete_intent_version
lexmodelbuildingservice_delete_intent_version <- function(name, version) {
  op <- new_operation(
    name = "DeleteIntentVersion",
    http_method = "DELETE",
    http_path = "/intents/{name}/versions/{version}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$delete_intent_version_input(name = name, version = version)
  output <- .lexmodelbuildingservice$delete_intent_version_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$delete_intent_version <- lexmodelbuildingservice_delete_intent_version

#' Deletes all versions of the slot type, including the $LATEST version
#'
#' @description
#' Deletes all versions of the slot type, including the `$LATEST` version.
#' To delete a specific version of the slot type, use the
#' [`delete_slot_type_version`][lexmodelbuildingservice_delete_slot_type_version]
#' operation.
#' 
#' You can delete a version of a slot type only if it is not referenced. To
#' delete a slot type that is referred to in one or more intents, you must
#' remove those references first.
#' 
#' If you get the `ResourceInUseException` exception, the exception
#' provides an example reference that shows the intent where the slot type
#' is referenced. To remove the reference to the slot type, either update
#' the intent or delete it. If you get the same exception when you attempt
#' to delete the slot type again, repeat until the slot type has no
#' references and the
#' [`delete_slot_type`][lexmodelbuildingservice_delete_slot_type] call is
#' successful.
#' 
#' This operation requires permission for the `lex:DeleteSlotType` action.
#'
#' @usage
#' lexmodelbuildingservice_delete_slot_type(name)
#'
#' @param name &#91;required&#93; The name of the slot type. The name is case sensitive.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_slot_type(
#'   name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_delete_slot_type
lexmodelbuildingservice_delete_slot_type <- function(name) {
  op <- new_operation(
    name = "DeleteSlotType",
    http_method = "DELETE",
    http_path = "/slottypes/{name}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$delete_slot_type_input(name = name)
  output <- .lexmodelbuildingservice$delete_slot_type_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$delete_slot_type <- lexmodelbuildingservice_delete_slot_type

#' Deletes a specific version of a slot type
#'
#' @description
#' Deletes a specific version of a slot type. To delete all versions of a
#' slot type, use the
#' [`delete_slot_type`][lexmodelbuildingservice_delete_slot_type]
#' operation.
#' 
#' This operation requires permissions for the `lex:DeleteSlotTypeVersion`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_delete_slot_type_version(name, version)
#'
#' @param name &#91;required&#93; The name of the slot type.
#' @param version &#91;required&#93; The version of the slot type to delete. You cannot delete the `$LATEST`
#' version of the slot type. To delete the `$LATEST` version, use the
#' [`delete_slot_type`][lexmodelbuildingservice_delete_slot_type]
#' operation.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_slot_type_version(
#'   name = "string",
#'   version = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_delete_slot_type_version
lexmodelbuildingservice_delete_slot_type_version <- function(name, version) {
  op <- new_operation(
    name = "DeleteSlotTypeVersion",
    http_method = "DELETE",
    http_path = "/slottypes/{name}/version/{version}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$delete_slot_type_version_input(name = name, version = version)
  output <- .lexmodelbuildingservice$delete_slot_type_version_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$delete_slot_type_version <- lexmodelbuildingservice_delete_slot_type_version

#' Deletes stored utterances
#'
#' @description
#' Deletes stored utterances.
#' 
#' Amazon Lex stores the utterances that users send to your bot. Utterances
#' are stored for 15 days for use with the
#' [`get_utterances_view`][lexmodelbuildingservice_get_utterances_view]
#' operation, and then stored indefinitely for use in improving the ability
#' of your bot to respond to user input.
#' 
#' Use the [`delete_utterances`][lexmodelbuildingservice_delete_utterances]
#' operation to manually delete stored utterances for a specific user. When
#' you use the
#' [`delete_utterances`][lexmodelbuildingservice_delete_utterances]
#' operation, utterances stored for improving your bot's ability to respond
#' to user input are deleted immediately. Utterances stored for use with
#' the [`get_utterances_view`][lexmodelbuildingservice_get_utterances_view]
#' operation are deleted after 15 days.
#' 
#' This operation requires permissions for the `lex:DeleteUtterances`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_delete_utterances(botName, userId)
#'
#' @param botName &#91;required&#93; The name of the bot that stored the utterances.
#' @param userId &#91;required&#93; The unique identifier for the user that made the utterances. This is the
#' user ID that was sent in the
#' [PostContent](https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html)
#' or
#' [PostText](https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html)
#' operation request that contained the utterance.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_utterances(
#'   botName = "string",
#'   userId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_delete_utterances
lexmodelbuildingservice_delete_utterances <- function(botName, userId) {
  op <- new_operation(
    name = "DeleteUtterances",
    http_method = "DELETE",
    http_path = "/bots/{botName}/utterances/{userId}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$delete_utterances_input(botName = botName, userId = userId)
  output <- .lexmodelbuildingservice$delete_utterances_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$delete_utterances <- lexmodelbuildingservice_delete_utterances

#' Returns metadata information for a specific bot
#'
#' @description
#' Returns metadata information for a specific bot. You must provide the
#' bot name and the bot version or alias.
#' 
#' This operation requires permissions for the `lex:GetBot` action.
#'
#' @usage
#' lexmodelbuildingservice_get_bot(name, versionOrAlias)
#'
#' @param name &#91;required&#93; The name of the bot. The name is case sensitive.
#' @param versionOrAlias &#91;required&#93; The version or alias of the bot.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   intents = list(
#'     list(
#'       intentName = "string",
#'       intentVersion = "string"
#'     )
#'   ),
#'   enableModelImprovements = TRUE|FALSE,
#'   nluIntentConfidenceThreshold = 123.0,
#'   clarificationPrompt = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     maxAttempts = 123,
#'     responseCard = "string"
#'   ),
#'   abortStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   status = "BUILDING"|"READY"|"READY_BASIC_TESTING"|"FAILED"|"NOT_BUILT",
#'   failureReason = "string",
#'   lastUpdatedDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   idleSessionTTLInSeconds = 123,
#'   voiceId = "string",
#'   checksum = "string",
#'   version = "string",
#'   locale = "de-DE"|"en-AU"|"en-GB"|"en-US"|"es-419"|"es-ES"|"es-US"|"fr-FR"|"fr-CA"|"it-IT",
#'   childDirected = TRUE|FALSE,
#'   detectSentiment = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_bot(
#'   name = "string",
#'   versionOrAlias = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example shows how to get configuration information for a bot.
#' svc$get_bot(
#'   name = "DocOrderPizza",
#'   versionOrAlias = "$LATEST"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_bot
lexmodelbuildingservice_get_bot <- function(name, versionOrAlias) {
  op <- new_operation(
    name = "GetBot",
    http_method = "GET",
    http_path = "/bots/{name}/versions/{versionoralias}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_bot_input(name = name, versionOrAlias = versionOrAlias)
  output <- .lexmodelbuildingservice$get_bot_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_bot <- lexmodelbuildingservice_get_bot

#' Returns information about an Amazon Lex bot alias
#'
#' @description
#' Returns information about an Amazon Lex bot alias. For more information
#' about aliases, see versioning-aliases.
#' 
#' This operation requires permissions for the `lex:GetBotAlias` action.
#'
#' @usage
#' lexmodelbuildingservice_get_bot_alias(name, botName)
#'
#' @param name &#91;required&#93; The name of the bot alias. The name is case sensitive.
#' @param botName &#91;required&#93; The name of the bot.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   botVersion = "string",
#'   botName = "string",
#'   lastUpdatedDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   checksum = "string",
#'   conversationLogs = list(
#'     logSettings = list(
#'       list(
#'         logType = "AUDIO"|"TEXT",
#'         destination = "CLOUDWATCH_LOGS"|"S3",
#'         kmsKeyArn = "string",
#'         resourceArn = "string",
#'         resourcePrefix = "string"
#'       )
#'     ),
#'     iamRoleArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_bot_alias(
#'   name = "string",
#'   botName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_bot_alias
lexmodelbuildingservice_get_bot_alias <- function(name, botName) {
  op <- new_operation(
    name = "GetBotAlias",
    http_method = "GET",
    http_path = "/bots/{botName}/aliases/{name}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_bot_alias_input(name = name, botName = botName)
  output <- .lexmodelbuildingservice$get_bot_alias_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_bot_alias <- lexmodelbuildingservice_get_bot_alias

#' Returns a list of aliases for a specified Amazon Lex bot
#'
#' @description
#' Returns a list of aliases for a specified Amazon Lex bot.
#' 
#' This operation requires permissions for the `lex:GetBotAliases` action.
#'
#' @usage
#' lexmodelbuildingservice_get_bot_aliases(botName, nextToken, maxResults,
#'   nameContains)
#'
#' @param botName &#91;required&#93; The name of the bot.
#' @param nextToken A pagination token for fetching the next page of aliases. If the
#' response to this call is truncated, Amazon Lex returns a pagination
#' token in the response. To fetch the next page of aliases, specify the
#' pagination token in the next request.
#' @param maxResults The maximum number of aliases to return in the response. The default is
#' 50. .
#' @param nameContains Substring to match in bot alias names. An alias will be returned if any
#' part of its name matches the substring. For example, "xyz" matches both
#' "xyzabc" and "abcxyz."
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   BotAliases = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       botVersion = "string",
#'       botName = "string",
#'       lastUpdatedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       createdDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       checksum = "string",
#'       conversationLogs = list(
#'         logSettings = list(
#'           list(
#'             logType = "AUDIO"|"TEXT",
#'             destination = "CLOUDWATCH_LOGS"|"S3",
#'             kmsKeyArn = "string",
#'             resourceArn = "string",
#'             resourcePrefix = "string"
#'           )
#'         ),
#'         iamRoleArn = "string"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_bot_aliases(
#'   botName = "string",
#'   nextToken = "string",
#'   maxResults = 123,
#'   nameContains = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_bot_aliases
lexmodelbuildingservice_get_bot_aliases <- function(botName, nextToken = NULL, maxResults = NULL, nameContains = NULL) {
  op <- new_operation(
    name = "GetBotAliases",
    http_method = "GET",
    http_path = "/bots/{botName}/aliases/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_bot_aliases_input(botName = botName, nextToken = nextToken, maxResults = maxResults, nameContains = nameContains)
  output <- .lexmodelbuildingservice$get_bot_aliases_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_bot_aliases <- lexmodelbuildingservice_get_bot_aliases

#' Returns information about the association between an Amazon Lex bot and
#' a messaging platform
#'
#' @description
#' Returns information about the association between an Amazon Lex bot and
#' a messaging platform.
#' 
#' This operation requires permissions for the
#' `lex:GetBotChannelAssociation` action.
#'
#' @usage
#' lexmodelbuildingservice_get_bot_channel_association(name, botName,
#'   botAlias)
#'
#' @param name &#91;required&#93; The name of the association between the bot and the channel. The name is
#' case sensitive.
#' @param botName &#91;required&#93; The name of the Amazon Lex bot.
#' @param botAlias &#91;required&#93; An alias pointing to the specific version of the Amazon Lex bot to which
#' this association is being made.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   botAlias = "string",
#'   botName = "string",
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   type = "Facebook"|"Slack"|"Twilio-Sms"|"Kik",
#'   botConfiguration = list(
#'     "string"
#'   ),
#'   status = "IN_PROGRESS"|"CREATED"|"FAILED",
#'   failureReason = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_bot_channel_association(
#'   name = "string",
#'   botName = "string",
#'   botAlias = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_bot_channel_association
lexmodelbuildingservice_get_bot_channel_association <- function(name, botName, botAlias) {
  op <- new_operation(
    name = "GetBotChannelAssociation",
    http_method = "GET",
    http_path = "/bots/{botName}/aliases/{aliasName}/channels/{name}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_bot_channel_association_input(name = name, botName = botName, botAlias = botAlias)
  output <- .lexmodelbuildingservice$get_bot_channel_association_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_bot_channel_association <- lexmodelbuildingservice_get_bot_channel_association

#' Returns a list of all of the channels associated with the specified bot
#'
#' @description
#' Returns a list of all of the channels associated with the specified bot.
#' 
#' The
#' [`get_bot_channel_associations`][lexmodelbuildingservice_get_bot_channel_associations]
#' operation requires permissions for the `lex:GetBotChannelAssociations`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_get_bot_channel_associations(botName, botAlias,
#'   nextToken, maxResults, nameContains)
#'
#' @param botName &#91;required&#93; The name of the Amazon Lex bot in the association.
#' @param botAlias &#91;required&#93; An alias pointing to the specific version of the Amazon Lex bot to which
#' this association is being made.
#' @param nextToken A pagination token for fetching the next page of associations. If the
#' response to this call is truncated, Amazon Lex returns a pagination
#' token in the response. To fetch the next page of associations, specify
#' the pagination token in the next request.
#' @param maxResults The maximum number of associations to return in the response. The
#' default is 50.
#' @param nameContains Substring to match in channel association names. An association will be
#' returned if any part of its name matches the substring. For example,
#' "xyz" matches both "xyzabc" and "abcxyz." To return all bot channel
#' associations, use a hyphen ("-") as the `nameContains` parameter.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   botChannelAssociations = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       botAlias = "string",
#'       botName = "string",
#'       createdDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       type = "Facebook"|"Slack"|"Twilio-Sms"|"Kik",
#'       botConfiguration = list(
#'         "string"
#'       ),
#'       status = "IN_PROGRESS"|"CREATED"|"FAILED",
#'       failureReason = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_bot_channel_associations(
#'   botName = "string",
#'   botAlias = "string",
#'   nextToken = "string",
#'   maxResults = 123,
#'   nameContains = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_bot_channel_associations
lexmodelbuildingservice_get_bot_channel_associations <- function(botName, botAlias, nextToken = NULL, maxResults = NULL, nameContains = NULL) {
  op <- new_operation(
    name = "GetBotChannelAssociations",
    http_method = "GET",
    http_path = "/bots/{botName}/aliases/{aliasName}/channels/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_bot_channel_associations_input(botName = botName, botAlias = botAlias, nextToken = nextToken, maxResults = maxResults, nameContains = nameContains)
  output <- .lexmodelbuildingservice$get_bot_channel_associations_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_bot_channel_associations <- lexmodelbuildingservice_get_bot_channel_associations

#' Gets information about all of the versions of a bot
#'
#' @description
#' Gets information about all of the versions of a bot.
#' 
#' The [`get_bot_versions`][lexmodelbuildingservice_get_bot_versions]
#' operation returns a `BotMetadata` object for each version of a bot. For
#' example, if a bot has three numbered versions, the
#' [`get_bot_versions`][lexmodelbuildingservice_get_bot_versions] operation
#' returns four `BotMetadata` objects in the response, one for each
#' numbered version and one for the `$LATEST` version.
#' 
#' The [`get_bot_versions`][lexmodelbuildingservice_get_bot_versions]
#' operation always returns at least one version, the `$LATEST` version.
#' 
#' This operation requires permissions for the `lex:GetBotVersions` action.
#'
#' @usage
#' lexmodelbuildingservice_get_bot_versions(name, nextToken, maxResults)
#'
#' @param name &#91;required&#93; The name of the bot for which versions should be returned.
#' @param nextToken A pagination token for fetching the next page of bot versions. If the
#' response to this call is truncated, Amazon Lex returns a pagination
#' token in the response. To fetch the next page of versions, specify the
#' pagination token in the next request.
#' @param maxResults The maximum number of bot versions to return in the response. The
#' default is 10.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   bots = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       status = "BUILDING"|"READY"|"READY_BASIC_TESTING"|"FAILED"|"NOT_BUILT",
#'       lastUpdatedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       createdDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       version = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_bot_versions(
#'   name = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_bot_versions
lexmodelbuildingservice_get_bot_versions <- function(name, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetBotVersions",
    http_method = "GET",
    http_path = "/bots/{name}/versions/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_bot_versions_input(name = name, nextToken = nextToken, maxResults = maxResults)
  output <- .lexmodelbuildingservice$get_bot_versions_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_bot_versions <- lexmodelbuildingservice_get_bot_versions

#' Returns bot information as follows:
#'
#' @description
#' Returns bot information as follows:
#' 
#' -   If you provide the `nameContains` field, the response includes
#'     information for the `$LATEST` version of all bots whose name
#'     contains the specified string.
#' 
#' -   If you don't specify the `nameContains` field, the operation returns
#'     information about the `$LATEST` version of all of your bots.
#' 
#' This operation requires permission for the `lex:GetBots` action.
#'
#' @usage
#' lexmodelbuildingservice_get_bots(nextToken, maxResults, nameContains)
#'
#' @param nextToken A pagination token that fetches the next page of bots. If the response
#' to this call is truncated, Amazon Lex returns a pagination token in the
#' response. To fetch the next page of bots, specify the pagination token
#' in the next request.
#' @param maxResults The maximum number of bots to return in the response that the request
#' will return. The default is 10.
#' @param nameContains Substring to match in bot names. A bot will be returned if any part of
#' its name matches the substring. For example, "xyz" matches both "xyzabc"
#' and "abcxyz."
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   bots = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       status = "BUILDING"|"READY"|"READY_BASIC_TESTING"|"FAILED"|"NOT_BUILT",
#'       lastUpdatedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       createdDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       version = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_bots(
#'   nextToken = "string",
#'   maxResults = 123,
#'   nameContains = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example shows how to get a list of all of the bots in your account.
#' svc$get_bots(
#'   maxResults = 5L,
#'   nextToken = ""
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_bots
lexmodelbuildingservice_get_bots <- function(nextToken = NULL, maxResults = NULL, nameContains = NULL) {
  op <- new_operation(
    name = "GetBots",
    http_method = "GET",
    http_path = "/bots/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_bots_input(nextToken = nextToken, maxResults = maxResults, nameContains = nameContains)
  output <- .lexmodelbuildingservice$get_bots_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_bots <- lexmodelbuildingservice_get_bots

#' Returns information about a built-in intent
#'
#' @description
#' Returns information about a built-in intent.
#' 
#' This operation requires permission for the `lex:GetBuiltinIntent`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_get_builtin_intent(signature)
#'
#' @param signature &#91;required&#93; The unique identifier for a built-in intent. To find the signature for
#' an intent, see [Standard Built-in
#' Intents](https://developer.amazon.com/en-US/docs/alexa/custom-skills/standard-built-in-intents.html)
#' in the *Alexa Skills Kit*.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   signature = "string",
#'   supportedLocales = list(
#'     "de-DE"|"en-AU"|"en-GB"|"en-US"|"es-419"|"es-ES"|"es-US"|"fr-FR"|"fr-CA"|"it-IT"
#'   ),
#'   slots = list(
#'     list(
#'       name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_builtin_intent(
#'   signature = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_builtin_intent
lexmodelbuildingservice_get_builtin_intent <- function(signature) {
  op <- new_operation(
    name = "GetBuiltinIntent",
    http_method = "GET",
    http_path = "/builtins/intents/{signature}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_builtin_intent_input(signature = signature)
  output <- .lexmodelbuildingservice$get_builtin_intent_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_builtin_intent <- lexmodelbuildingservice_get_builtin_intent

#' Gets a list of built-in intents that meet the specified criteria
#'
#' @description
#' Gets a list of built-in intents that meet the specified criteria.
#' 
#' This operation requires permission for the `lex:GetBuiltinIntents`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_get_builtin_intents(locale, signatureContains,
#'   nextToken, maxResults)
#'
#' @param locale A list of locales that the intent supports.
#' @param signatureContains Substring to match in built-in intent signatures. An intent will be
#' returned if any part of its signature matches the substring. For
#' example, "xyz" matches both "xyzabc" and "abcxyz." To find the signature
#' for an intent, see [Standard Built-in
#' Intents](https://developer.amazon.com/en-US/docs/alexa/custom-skills/standard-built-in-intents.html)
#' in the *Alexa Skills Kit*.
#' @param nextToken A pagination token that fetches the next page of intents. If this API
#' call is truncated, Amazon Lex returns a pagination token in the
#' response. To fetch the next page of intents, use the pagination token in
#' the next request.
#' @param maxResults The maximum number of intents to return in the response. The default is
#' 10.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   intents = list(
#'     list(
#'       signature = "string",
#'       supportedLocales = list(
#'         "de-DE"|"en-AU"|"en-GB"|"en-US"|"es-419"|"es-ES"|"es-US"|"fr-FR"|"fr-CA"|"it-IT"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_builtin_intents(
#'   locale = "de-DE"|"en-AU"|"en-GB"|"en-US"|"es-419"|"es-ES"|"es-US"|"fr-FR"|"fr-CA"|"it-IT",
#'   signatureContains = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_builtin_intents
lexmodelbuildingservice_get_builtin_intents <- function(locale = NULL, signatureContains = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetBuiltinIntents",
    http_method = "GET",
    http_path = "/builtins/intents/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_builtin_intents_input(locale = locale, signatureContains = signatureContains, nextToken = nextToken, maxResults = maxResults)
  output <- .lexmodelbuildingservice$get_builtin_intents_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_builtin_intents <- lexmodelbuildingservice_get_builtin_intents

#' Gets a list of built-in slot types that meet the specified criteria
#'
#' @description
#' Gets a list of built-in slot types that meet the specified criteria.
#' 
#' For a list of built-in slot types, see [Slot Type
#' Reference](https://developer.amazon.com/en-US/docs/alexa/custom-skills/slot-type-reference.html)
#' in the *Alexa Skills Kit*.
#' 
#' This operation requires permission for the `lex:GetBuiltInSlotTypes`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_get_builtin_slot_types(locale,
#'   signatureContains, nextToken, maxResults)
#'
#' @param locale A list of locales that the slot type supports.
#' @param signatureContains Substring to match in built-in slot type signatures. A slot type will be
#' returned if any part of its signature matches the substring. For
#' example, "xyz" matches both "xyzabc" and "abcxyz."
#' @param nextToken A pagination token that fetches the next page of slot types. If the
#' response to this API call is truncated, Amazon Lex returns a pagination
#' token in the response. To fetch the next page of slot types, specify the
#' pagination token in the next request.
#' @param maxResults The maximum number of slot types to return in the response. The default
#' is 10.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   slotTypes = list(
#'     list(
#'       signature = "string",
#'       supportedLocales = list(
#'         "de-DE"|"en-AU"|"en-GB"|"en-US"|"es-419"|"es-ES"|"es-US"|"fr-FR"|"fr-CA"|"it-IT"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_builtin_slot_types(
#'   locale = "de-DE"|"en-AU"|"en-GB"|"en-US"|"es-419"|"es-ES"|"es-US"|"fr-FR"|"fr-CA"|"it-IT",
#'   signatureContains = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_builtin_slot_types
lexmodelbuildingservice_get_builtin_slot_types <- function(locale = NULL, signatureContains = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetBuiltinSlotTypes",
    http_method = "GET",
    http_path = "/builtins/slottypes/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_builtin_slot_types_input(locale = locale, signatureContains = signatureContains, nextToken = nextToken, maxResults = maxResults)
  output <- .lexmodelbuildingservice$get_builtin_slot_types_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_builtin_slot_types <- lexmodelbuildingservice_get_builtin_slot_types

#' Exports the contents of a Amazon Lex resource in a specified format
#'
#' @description
#' Exports the contents of a Amazon Lex resource in a specified format.
#'
#' @usage
#' lexmodelbuildingservice_get_export(name, version, resourceType,
#'   exportType)
#'
#' @param name &#91;required&#93; The name of the bot to export.
#' @param version &#91;required&#93; The version of the bot to export.
#' @param resourceType &#91;required&#93; The type of resource to export.
#' @param exportType &#91;required&#93; The format of the exported data.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   version = "string",
#'   resourceType = "BOT"|"INTENT"|"SLOT_TYPE",
#'   exportType = "ALEXA_SKILLS_KIT"|"LEX",
#'   exportStatus = "IN_PROGRESS"|"READY"|"FAILED",
#'   failureReason = "string",
#'   url = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_export(
#'   name = "string",
#'   version = "string",
#'   resourceType = "BOT"|"INTENT"|"SLOT_TYPE",
#'   exportType = "ALEXA_SKILLS_KIT"|"LEX"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_export
lexmodelbuildingservice_get_export <- function(name, version, resourceType, exportType) {
  op <- new_operation(
    name = "GetExport",
    http_method = "GET",
    http_path = "/exports/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_export_input(name = name, version = version, resourceType = resourceType, exportType = exportType)
  output <- .lexmodelbuildingservice$get_export_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_export <- lexmodelbuildingservice_get_export

#' Gets information about an import job started with the StartImport
#' operation
#'
#' @description
#' Gets information about an import job started with the
#' [`start_import`][lexmodelbuildingservice_start_import] operation.
#'
#' @usage
#' lexmodelbuildingservice_get_import(importId)
#'
#' @param importId &#91;required&#93; The identifier of the import job information to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   resourceType = "BOT"|"INTENT"|"SLOT_TYPE",
#'   mergeStrategy = "OVERWRITE_LATEST"|"FAIL_ON_CONFLICT",
#'   importId = "string",
#'   importStatus = "IN_PROGRESS"|"COMPLETE"|"FAILED",
#'   failureReason = list(
#'     "string"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_import(
#'   importId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_import
lexmodelbuildingservice_get_import <- function(importId) {
  op <- new_operation(
    name = "GetImport",
    http_method = "GET",
    http_path = "/imports/{importId}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_import_input(importId = importId)
  output <- .lexmodelbuildingservice$get_import_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_import <- lexmodelbuildingservice_get_import

#' Returns information about an intent
#'
#' @description
#' Returns information about an intent. In addition to the intent name, you
#' must specify the intent version.
#' 
#' This operation requires permissions to perform the `lex:GetIntent`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_get_intent(name, version)
#'
#' @param name &#91;required&#93; The name of the intent. The name is case sensitive.
#' @param version &#91;required&#93; The version of the intent.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   slots = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       slotConstraint = "Required"|"Optional",
#'       slotType = "string",
#'       slotTypeVersion = "string",
#'       valueElicitationPrompt = list(
#'         messages = list(
#'           list(
#'             contentType = "PlainText"|"SSML"|"CustomPayload",
#'             content = "string",
#'             groupNumber = 123
#'           )
#'         ),
#'         maxAttempts = 123,
#'         responseCard = "string"
#'       ),
#'       priority = 123,
#'       sampleUtterances = list(
#'         "string"
#'       ),
#'       responseCard = "string",
#'       obfuscationSetting = "NONE"|"DEFAULT_OBFUSCATION",
#'       defaultValueSpec = list(
#'         defaultValueList = list(
#'           list(
#'             defaultValue = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   sampleUtterances = list(
#'     "string"
#'   ),
#'   confirmationPrompt = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     maxAttempts = 123,
#'     responseCard = "string"
#'   ),
#'   rejectionStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   followUpPrompt = list(
#'     prompt = list(
#'       messages = list(
#'         list(
#'           contentType = "PlainText"|"SSML"|"CustomPayload",
#'           content = "string",
#'           groupNumber = 123
#'         )
#'       ),
#'       maxAttempts = 123,
#'       responseCard = "string"
#'     ),
#'     rejectionStatement = list(
#'       messages = list(
#'         list(
#'           contentType = "PlainText"|"SSML"|"CustomPayload",
#'           content = "string",
#'           groupNumber = 123
#'         )
#'       ),
#'       responseCard = "string"
#'     )
#'   ),
#'   conclusionStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   dialogCodeHook = list(
#'     uri = "string",
#'     messageVersion = "string"
#'   ),
#'   fulfillmentActivity = list(
#'     type = "ReturnIntent"|"CodeHook",
#'     codeHook = list(
#'       uri = "string",
#'       messageVersion = "string"
#'     )
#'   ),
#'   parentIntentSignature = "string",
#'   lastUpdatedDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   version = "string",
#'   checksum = "string",
#'   kendraConfiguration = list(
#'     kendraIndex = "string",
#'     queryFilterString = "string",
#'     role = "string"
#'   ),
#'   inputContexts = list(
#'     list(
#'       name = "string"
#'     )
#'   ),
#'   outputContexts = list(
#'     list(
#'       name = "string",
#'       timeToLiveInSeconds = 123,
#'       turnsToLive = 123
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_intent(
#'   name = "string",
#'   version = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example shows how to get information about an intent.
#' svc$get_intent(
#'   version = "$LATEST",
#'   name = "DocOrderPizza"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_intent
lexmodelbuildingservice_get_intent <- function(name, version) {
  op <- new_operation(
    name = "GetIntent",
    http_method = "GET",
    http_path = "/intents/{name}/versions/{version}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_intent_input(name = name, version = version)
  output <- .lexmodelbuildingservice$get_intent_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_intent <- lexmodelbuildingservice_get_intent

#' Gets information about all of the versions of an intent
#'
#' @description
#' Gets information about all of the versions of an intent.
#' 
#' The [`get_intent_versions`][lexmodelbuildingservice_get_intent_versions]
#' operation returns an `IntentMetadata` object for each version of an
#' intent. For example, if an intent has three numbered versions, the
#' [`get_intent_versions`][lexmodelbuildingservice_get_intent_versions]
#' operation returns four `IntentMetadata` objects in the response, one for
#' each numbered version and one for the `$LATEST` version.
#' 
#' The [`get_intent_versions`][lexmodelbuildingservice_get_intent_versions]
#' operation always returns at least one version, the `$LATEST` version.
#' 
#' This operation requires permissions for the `lex:GetIntentVersions`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_get_intent_versions(name, nextToken, maxResults)
#'
#' @param name &#91;required&#93; The name of the intent for which versions should be returned.
#' @param nextToken A pagination token for fetching the next page of intent versions. If the
#' response to this call is truncated, Amazon Lex returns a pagination
#' token in the response. To fetch the next page of versions, specify the
#' pagination token in the next request.
#' @param maxResults The maximum number of intent versions to return in the response. The
#' default is 10.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   intents = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       lastUpdatedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       createdDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       version = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_intent_versions(
#'   name = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_intent_versions
lexmodelbuildingservice_get_intent_versions <- function(name, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetIntentVersions",
    http_method = "GET",
    http_path = "/intents/{name}/versions/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_intent_versions_input(name = name, nextToken = nextToken, maxResults = maxResults)
  output <- .lexmodelbuildingservice$get_intent_versions_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_intent_versions <- lexmodelbuildingservice_get_intent_versions

#' Returns intent information as follows:
#'
#' @description
#' Returns intent information as follows:
#' 
#' -   If you specify the `nameContains` field, returns the `$LATEST`
#'     version of all intents that contain the specified string.
#' 
#' -   If you don't specify the `nameContains` field, returns information
#'     about the `$LATEST` version of all intents.
#' 
#' The operation requires permission for the `lex:GetIntents` action.
#'
#' @usage
#' lexmodelbuildingservice_get_intents(nextToken, maxResults, nameContains)
#'
#' @param nextToken A pagination token that fetches the next page of intents. If the
#' response to this API call is truncated, Amazon Lex returns a pagination
#' token in the response. To fetch the next page of intents, specify the
#' pagination token in the next request.
#' @param maxResults The maximum number of intents to return in the response. The default is
#' 10.
#' @param nameContains Substring to match in intent names. An intent will be returned if any
#' part of its name matches the substring. For example, "xyz" matches both
#' "xyzabc" and "abcxyz."
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   intents = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       lastUpdatedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       createdDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       version = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_intents(
#'   nextToken = "string",
#'   maxResults = 123,
#'   nameContains = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example shows how to get a list of all of the intents in your
#' # account.
#' svc$get_intents(
#'   maxResults = 10L,
#'   nextToken = ""
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_intents
lexmodelbuildingservice_get_intents <- function(nextToken = NULL, maxResults = NULL, nameContains = NULL) {
  op <- new_operation(
    name = "GetIntents",
    http_method = "GET",
    http_path = "/intents/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_intents_input(nextToken = nextToken, maxResults = maxResults, nameContains = nameContains)
  output <- .lexmodelbuildingservice$get_intents_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_intents <- lexmodelbuildingservice_get_intents

#' Returns information about a specific version of a slot type
#'
#' @description
#' Returns information about a specific version of a slot type. In addition
#' to specifying the slot type name, you must specify the slot type
#' version.
#' 
#' This operation requires permissions for the `lex:GetSlotType` action.
#'
#' @usage
#' lexmodelbuildingservice_get_slot_type(name, version)
#'
#' @param name &#91;required&#93; The name of the slot type. The name is case sensitive.
#' @param version &#91;required&#93; The version of the slot type.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   enumerationValues = list(
#'     list(
#'       value = "string",
#'       synonyms = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   lastUpdatedDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   version = "string",
#'   checksum = "string",
#'   valueSelectionStrategy = "ORIGINAL_VALUE"|"TOP_RESOLUTION",
#'   parentSlotTypeSignature = "string",
#'   slotTypeConfigurations = list(
#'     list(
#'       regexConfiguration = list(
#'         pattern = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_slot_type(
#'   name = "string",
#'   version = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example shows how to get information about a slot type.
#' svc$get_slot_type(
#'   version = "$LATEST",
#'   name = "DocPizzaCrustType"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_slot_type
lexmodelbuildingservice_get_slot_type <- function(name, version) {
  op <- new_operation(
    name = "GetSlotType",
    http_method = "GET",
    http_path = "/slottypes/{name}/versions/{version}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_slot_type_input(name = name, version = version)
  output <- .lexmodelbuildingservice$get_slot_type_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_slot_type <- lexmodelbuildingservice_get_slot_type

#' Gets information about all versions of a slot type
#'
#' @description
#' Gets information about all versions of a slot type.
#' 
#' The
#' [`get_slot_type_versions`][lexmodelbuildingservice_get_slot_type_versions]
#' operation returns a `SlotTypeMetadata` object for each version of a slot
#' type. For example, if a slot type has three numbered versions, the
#' [`get_slot_type_versions`][lexmodelbuildingservice_get_slot_type_versions]
#' operation returns four `SlotTypeMetadata` objects in the response, one
#' for each numbered version and one for the `$LATEST` version.
#' 
#' The
#' [`get_slot_type_versions`][lexmodelbuildingservice_get_slot_type_versions]
#' operation always returns at least one version, the `$LATEST` version.
#' 
#' This operation requires permissions for the `lex:GetSlotTypeVersions`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_get_slot_type_versions(name, nextToken,
#'   maxResults)
#'
#' @param name &#91;required&#93; The name of the slot type for which versions should be returned.
#' @param nextToken A pagination token for fetching the next page of slot type versions. If
#' the response to this call is truncated, Amazon Lex returns a pagination
#' token in the response. To fetch the next page of versions, specify the
#' pagination token in the next request.
#' @param maxResults The maximum number of slot type versions to return in the response. The
#' default is 10.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   slotTypes = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       lastUpdatedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       createdDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       version = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_slot_type_versions(
#'   name = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_slot_type_versions
lexmodelbuildingservice_get_slot_type_versions <- function(name, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetSlotTypeVersions",
    http_method = "GET",
    http_path = "/slottypes/{name}/versions/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_slot_type_versions_input(name = name, nextToken = nextToken, maxResults = maxResults)
  output <- .lexmodelbuildingservice$get_slot_type_versions_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_slot_type_versions <- lexmodelbuildingservice_get_slot_type_versions

#' Returns slot type information as follows:
#'
#' @description
#' Returns slot type information as follows:
#' 
#' -   If you specify the `nameContains` field, returns the `$LATEST`
#'     version of all slot types that contain the specified string.
#' 
#' -   If you don't specify the `nameContains` field, returns information
#'     about the `$LATEST` version of all slot types.
#' 
#' The operation requires permission for the `lex:GetSlotTypes` action.
#'
#' @usage
#' lexmodelbuildingservice_get_slot_types(nextToken, maxResults,
#'   nameContains)
#'
#' @param nextToken A pagination token that fetches the next page of slot types. If the
#' response to this API call is truncated, Amazon Lex returns a pagination
#' token in the response. To fetch next page of slot types, specify the
#' pagination token in the next request.
#' @param maxResults The maximum number of slot types to return in the response. The default
#' is 10.
#' @param nameContains Substring to match in slot type names. A slot type will be returned if
#' any part of its name matches the substring. For example, "xyz" matches
#' both "xyzabc" and "abcxyz."
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   slotTypes = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       lastUpdatedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       createdDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       version = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_slot_types(
#'   nextToken = "string",
#'   maxResults = 123,
#'   nameContains = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example shows how to get a list of all of the slot types in your
#' # account.
#' svc$get_slot_types(
#'   maxResults = 10L,
#'   nextToken = ""
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_slot_types
lexmodelbuildingservice_get_slot_types <- function(nextToken = NULL, maxResults = NULL, nameContains = NULL) {
  op <- new_operation(
    name = "GetSlotTypes",
    http_method = "GET",
    http_path = "/slottypes/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_slot_types_input(nextToken = nextToken, maxResults = maxResults, nameContains = nameContains)
  output <- .lexmodelbuildingservice$get_slot_types_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_slot_types <- lexmodelbuildingservice_get_slot_types

#' Use the GetUtterancesView operation to get information about the
#' utterances that your users have made to your bot
#'
#' @description
#' Use the
#' [`get_utterances_view`][lexmodelbuildingservice_get_utterances_view]
#' operation to get information about the utterances that your users have
#' made to your bot. You can use this list to tune the utterances that your
#' bot responds to.
#' 
#' For example, say that you have created a bot to order flowers. After
#' your users have used your bot for a while, use the
#' [`get_utterances_view`][lexmodelbuildingservice_get_utterances_view]
#' operation to see the requests that they have made and whether they have
#' been successful. You might find that the utterance "I want flowers" is
#' not being recognized. You could add this utterance to the `OrderFlowers`
#' intent so that your bot recognizes that utterance.
#' 
#' After you publish a new version of a bot, you can get information about
#' the old version and the new so that you can compare the performance
#' across the two versions.
#' 
#' Utterance statistics are generated once a day. Data is available for the
#' last 15 days. You can request information for up to 5 versions of your
#' bot in each request. Amazon Lex returns the most frequent utterances
#' received by the bot in the last 15 days. The response contains
#' information about a maximum of 100 utterances for each version.
#' 
#' If you set `childDirected` field to true when you created your bot, or
#' if you opted out of participating in improving Amazon Lex, utterances
#' are not available.
#' 
#' This operation requires permissions for the `lex:GetUtterancesView`
#' action.
#'
#' @usage
#' lexmodelbuildingservice_get_utterances_view(botName, botVersions,
#'   statusType)
#'
#' @param botName &#91;required&#93; The name of the bot for which utterance information should be returned.
#' @param botVersions &#91;required&#93; An array of bot versions for which utterance information should be
#' returned. The limit is 5 versions per request.
#' @param statusType &#91;required&#93; To return utterances that were recognized and handled, use `Detected`.
#' To return utterances that were not recognized, use `Missed`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   botName = "string",
#'   utterances = list(
#'     list(
#'       botVersion = "string",
#'       utterances = list(
#'         list(
#'           utteranceString = "string",
#'           count = 123,
#'           distinctUsers = 123,
#'           firstUtteredDate = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           lastUtteredDate = as.POSIXct(
#'             "2015-01-01"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_utterances_view(
#'   botName = "string",
#'   botVersions = list(
#'     "string"
#'   ),
#'   statusType = "Detected"|"Missed"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_get_utterances_view
lexmodelbuildingservice_get_utterances_view <- function(botName, botVersions, statusType) {
  op <- new_operation(
    name = "GetUtterancesView",
    http_method = "GET",
    http_path = "/bots/{botname}/utterances?view=aggregation",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$get_utterances_view_input(botName = botName, botVersions = botVersions, statusType = statusType)
  output <- .lexmodelbuildingservice$get_utterances_view_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$get_utterances_view <- lexmodelbuildingservice_get_utterances_view

#' Gets a list of tags associated with the specified resource
#'
#' @description
#' Gets a list of tags associated with the specified resource. Only bots,
#' bot aliases, and bot channels can have tags associated with them.
#'
#' @usage
#' lexmodelbuildingservice_list_tags_for_resource(resourceArn)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to get a list of tags
#' for.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   resourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_list_tags_for_resource
lexmodelbuildingservice_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .lexmodelbuildingservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$list_tags_for_resource <- lexmodelbuildingservice_list_tags_for_resource

#' Creates an Amazon Lex conversational bot or replaces an existing bot
#'
#' @description
#' Creates an Amazon Lex conversational bot or replaces an existing bot.
#' When you create or update a bot you are only required to specify a name,
#' a locale, and whether the bot is directed toward children under age 13.
#' You can use this to add intents later, or to remove intents from an
#' existing bot. When you create a bot with the minimum information, the
#' bot is created or updated but Amazon Lex returns the `` response
#' `FAILED`. You can build the bot after you add one or more intents. For
#' more information about Amazon Lex bots, see how-it-works.
#' 
#' If you specify the name of an existing bot, the fields in the request
#' replace the existing values in the `$LATEST` version of the bot. Amazon
#' Lex removes any fields that you don't provide values for in the request,
#' except for the `idleTTLInSeconds` and `privacySettings` fields, which
#' are set to their default values. If you don't specify values for
#' required fields, Amazon Lex throws an exception.
#' 
#' This operation requires permissions for the `lex:PutBot` action. For
#' more information, see security-iam.
#'
#' @usage
#' lexmodelbuildingservice_put_bot(name, description, intents,
#'   enableModelImprovements, nluIntentConfidenceThreshold,
#'   clarificationPrompt, abortStatement, idleSessionTTLInSeconds, voiceId,
#'   checksum, processBehavior, locale, childDirected, detectSentiment,
#'   createVersion, tags)
#'
#' @param name &#91;required&#93; The name of the bot. The name is *not* case sensitive.
#' @param description A description of the bot.
#' @param intents An array of `Intent` objects. Each intent represents a command that a
#' user can express. For example, a pizza ordering bot might support an
#' OrderPizza intent. For more information, see how-it-works.
#' @param enableModelImprovements Set to `true` to enable access to natural language understanding
#' improvements.
#' 
#' When you set the `enableModelImprovements` parameter to `true` you can
#' use the `nluIntentConfidenceThreshold` parameter to configure confidence
#' scores. For more information, see [Confidence
#' Scores](https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html).
#' 
#' You can only set the `enableModelImprovements` parameter in certain
#' Regions. If you set the parameter to `true`, your bot has access to
#' accuracy improvements.
#' 
#' The Regions where you can set the `enableModelImprovements` parameter to
#' `true` are:
#' 
#' -   US East (N. Virginia) (us-east-1)
#' 
#' -   US West (Oregon) (us-west-2)
#' 
#' -   Asia Pacific (Sydney) (ap-southeast-2)
#' 
#' -   EU (Ireland) (eu-west-1)
#' 
#' In other Regions, the `enableModelImprovements` parameter is set to
#' `true` by default. In these Regions setting the parameter to `false`
#' throws a `ValidationException` exception.
#' @param nluIntentConfidenceThreshold Determines the threshold where Amazon Lex will insert the
#' `AMAZON.FallbackIntent`, `AMAZON.KendraSearchIntent`, or both when
#' returning alternative intents in a
#' [PostContent](https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html)
#' or
#' [PostText](https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html)
#' response. `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` are
#' only inserted if they are configured for the bot.
#' 
#' You must set the `enableModelImprovements` parameter to `true` to use
#' confidence scores in the following regions.
#' 
#' -   US East (N. Virginia) (us-east-1)
#' 
#' -   US West (Oregon) (us-west-2)
#' 
#' -   Asia Pacific (Sydney) (ap-southeast-2)
#' 
#' -   EU (Ireland) (eu-west-1)
#' 
#' In other Regions, the `enableModelImprovements` parameter is set to
#' `true` by default.
#' 
#' For example, suppose a bot is configured with the confidence threshold
#' of 0.80 and the `AMAZON.FallbackIntent`. Amazon Lex returns three
#' alternative intents with the following confidence scores: IntentA
#' (0.70), IntentB (0.60), IntentC (0.50). The response from the `PostText`
#' operation would be:
#' 
#' -   AMAZON.FallbackIntent
#' 
#' -   IntentA
#' 
#' -   IntentB
#' 
#' -   IntentC
#' @param clarificationPrompt When Amazon Lex doesn't understand the user's intent, it uses this
#' message to get clarification. To specify how many times Amazon Lex
#' should repeat the clarification prompt, use the `maxAttempts` field. If
#' Amazon Lex still doesn't understand, it sends the message in the
#' `abortStatement` field.
#' 
#' When you create a clarification prompt, make sure that it suggests the
#' correct response from the user. for example, for a bot that orders pizza
#' and drinks, you might create this clarification prompt: "What would you
#' like to do? You can say 'Order a pizza' or 'Order a drink.'"
#' 
#' If you have defined a fallback intent, it will be invoked if the
#' clarification prompt is repeated the number of times defined in the
#' `maxAttempts` field. For more information, see
#' [AMAZON.FallbackIntent](https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html).
#' 
#' If you don't define a clarification prompt, at runtime Amazon Lex will
#' return a 400 Bad Request exception in three cases:
#' 
#' -   Follow-up prompt - When the user responds to a follow-up prompt but
#'     does not provide an intent. For example, in response to a follow-up
#'     prompt that says "Would you like anything else today?" the user says
#'     "Yes." Amazon Lex will return a 400 Bad Request exception because it
#'     does not have a clarification prompt to send to the user to get an
#'     intent.
#' 
#' -   Lambda function - When using a Lambda function, you return an
#'     `ElicitIntent` dialog type. Since Amazon Lex does not have a
#'     clarification prompt to get an intent from the user, it returns a
#'     400 Bad Request exception.
#' 
#' -   PutSession operation - When using the `PutSession` operation, you
#'     send an `ElicitIntent` dialog type. Since Amazon Lex does not have a
#'     clarification prompt to get an intent from the user, it returns a
#'     400 Bad Request exception.
#' @param abortStatement When Amazon Lex can't understand the user's input in context, it tries
#' to elicit the information a few times. After that, Amazon Lex sends the
#' message defined in `abortStatement` to the user, and then cancels the
#' conversation. To set the number of retries, use the
#' `valueElicitationPrompt` field for the slot type.
#' 
#' For example, in a pizza ordering bot, Amazon Lex might ask a user "What
#' type of crust would you like?" If the user's response is not one of the
#' expected responses (for example, "thin crust, "deep dish," etc.), Amazon
#' Lex tries to elicit a correct response a few more times.
#' 
#' For example, in a pizza ordering application, `OrderPizza` might be one
#' of the intents. This intent might require the `CrustType` slot. You
#' specify the `valueElicitationPrompt` field when you create the
#' `CrustType` slot.
#' 
#' If you have defined a fallback intent the cancel statement will not be
#' sent to the user, the fallback intent is used instead. For more
#' information, see
#' [AMAZON.FallbackIntent](https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html).
#' @param idleSessionTTLInSeconds The maximum time in seconds that Amazon Lex retains the data gathered in
#' a conversation.
#' 
#' A user interaction session remains active for the amount of time
#' specified. If no conversation occurs during this time, the session
#' expires and Amazon Lex deletes any data provided before the timeout.
#' 
#' For example, suppose that a user chooses the OrderPizza intent, but gets
#' sidetracked halfway through placing an order. If the user doesn't
#' complete the order within the specified time, Amazon Lex discards the
#' slot information that it gathered, and the user must start over.
#' 
#' If you don't include the `idleSessionTTLInSeconds` element in a
#' [`put_bot`][lexmodelbuildingservice_put_bot] operation request, Amazon
#' Lex uses the default value. This is also true if the request replaces an
#' existing bot.
#' 
#' The default is 300 seconds (5 minutes).
#' @param voiceId The Amazon Polly voice ID that you want Amazon Lex to use for voice
#' interactions with the user. The locale configured for the voice must
#' match the locale of the bot. For more information, see [Voices in Amazon
#' Polly](https://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in
#' the *Amazon Polly Developer Guide*.
#' @param checksum Identifies a specific revision of the `$LATEST` version.
#' 
#' When you create a new bot, leave the `checksum` field blank. If you
#' specify a checksum you get a `BadRequestException` exception.
#' 
#' When you want to update a bot, set the `checksum` field to the checksum
#' of the most recent revision of the `$LATEST` version. If you don't
#' specify the ` checksum` field, or if the checksum does not match the
#' `$LATEST` version, you get a `PreconditionFailedException` exception.
#' @param processBehavior If you set the `processBehavior` element to `BUILD`, Amazon Lex builds
#' the bot so that it can be run. If you set the element to `SAVE` Amazon
#' Lex saves the bot, but doesn't build it.
#' 
#' If you don't specify this value, the default value is `BUILD`.
#' @param locale &#91;required&#93; Specifies the target locale for the bot. Any intent used in the bot must
#' be compatible with the locale of the bot.
#' 
#' The default is `en-US`.
#' @param childDirected &#91;required&#93; For each Amazon Lex bot created with the Amazon Lex Model Building
#' Service, you must specify whether your use of Amazon Lex is related to a
#' website, program, or other application that is directed or targeted, in
#' whole or in part, to children under age 13 and subject to the Children's
#' Online Privacy Protection Act (COPPA) by specifying `true` or `false` in
#' the `childDirected` field. By specifying `true` in the `childDirected`
#' field, you confirm that your use of Amazon Lex **is** related to a
#' website, program, or other application that is directed or targeted, in
#' whole or in part, to children under age 13 and subject to COPPA. By
#' specifying `false` in the `childDirected` field, you confirm that your
#' use of Amazon Lex **is not** related to a website, program, or other
#' application that is directed or targeted, in whole or in part, to
#' children under age 13 and subject to COPPA. You may not specify a
#' default value for the `childDirected` field that does not accurately
#' reflect whether your use of Amazon Lex is related to a website, program,
#' or other application that is directed or targeted, in whole or in part,
#' to children under age 13 and subject to COPPA.
#' 
#' If your use of Amazon Lex relates to a website, program, or other
#' application that is directed in whole or in part, to children under age
#' 13, you must obtain any required verifiable parental consent under
#' COPPA. For information regarding the use of Amazon Lex in connection
#' with websites, programs, or other applications that are directed or
#' targeted, in whole or in part, to children under age 13, see the [Amazon
#' Lex FAQ.](https://aws.amazon.com/lex/faqs/#data-security)
#' @param detectSentiment When set to `true` user utterances are sent to Amazon Comprehend for
#' sentiment analysis. If you don't specify `detectSentiment`, the default
#' is `false`.
#' @param createVersion When set to `true` a new numbered version of the bot is created. This is
#' the same as calling the
#' [`create_bot_version`][lexmodelbuildingservice_create_bot_version]
#' operation. If you don't specify `createVersion`, the default is `false`.
#' @param tags A list of tags to add to the bot. You can only add tags when you create
#' a bot, you can't use the [`put_bot`][lexmodelbuildingservice_put_bot]
#' operation to update the tags on a bot. To update tags, use the
#' [`tag_resource`][lexmodelbuildingservice_tag_resource] operation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   intents = list(
#'     list(
#'       intentName = "string",
#'       intentVersion = "string"
#'     )
#'   ),
#'   enableModelImprovements = TRUE|FALSE,
#'   nluIntentConfidenceThreshold = 123.0,
#'   clarificationPrompt = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     maxAttempts = 123,
#'     responseCard = "string"
#'   ),
#'   abortStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   status = "BUILDING"|"READY"|"READY_BASIC_TESTING"|"FAILED"|"NOT_BUILT",
#'   failureReason = "string",
#'   lastUpdatedDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   idleSessionTTLInSeconds = 123,
#'   voiceId = "string",
#'   checksum = "string",
#'   version = "string",
#'   locale = "de-DE"|"en-AU"|"en-GB"|"en-US"|"es-419"|"es-ES"|"es-US"|"fr-FR"|"fr-CA"|"it-IT",
#'   childDirected = TRUE|FALSE,
#'   createVersion = TRUE|FALSE,
#'   detectSentiment = TRUE|FALSE,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_bot(
#'   name = "string",
#'   description = "string",
#'   intents = list(
#'     list(
#'       intentName = "string",
#'       intentVersion = "string"
#'     )
#'   ),
#'   enableModelImprovements = TRUE|FALSE,
#'   nluIntentConfidenceThreshold = 123.0,
#'   clarificationPrompt = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     maxAttempts = 123,
#'     responseCard = "string"
#'   ),
#'   abortStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   idleSessionTTLInSeconds = 123,
#'   voiceId = "string",
#'   checksum = "string",
#'   processBehavior = "SAVE"|"BUILD",
#'   locale = "de-DE"|"en-AU"|"en-GB"|"en-US"|"es-419"|"es-ES"|"es-US"|"fr-FR"|"fr-CA"|"it-IT",
#'   childDirected = TRUE|FALSE,
#'   detectSentiment = TRUE|FALSE,
#'   createVersion = TRUE|FALSE,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example shows how to create a bot for ordering pizzas.
#' svc$put_bot(
#'   name = "DocOrderPizzaBot",
#'   abortStatement = list(
#'     messages = list(
#'       list(
#'         content = "I don't understand. Can you try again?",
#'         contentType = "PlainText"
#'       ),
#'       list(
#'         content = "I'm sorry, I don't understand.",
#'         contentType = "PlainText"
#'       )
#'     )
#'   ),
#'   childDirected = TRUE,
#'   clarificationPrompt = list(
#'     maxAttempts = 1L,
#'     messages = list(
#'       list(
#'         content = "I'm sorry, I didn't hear that. Can you repeat what you just said?",
#'         contentType = "PlainText"
#'       ),
#'       list(
#'         content = "Can you say that again?",
#'         contentType = "PlainText"
#'       )
#'     )
#'   ),
#'   description = "Orders a pizza from a local pizzeria.",
#'   idleSessionTTLInSeconds = 300L,
#'   intents = list(
#'     list(
#'       intentName = "DocOrderPizza",
#'       intentVersion = "$LATEST"
#'     )
#'   ),
#'   locale = "en-US",
#'   processBehavior = "SAVE"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_put_bot
lexmodelbuildingservice_put_bot <- function(name, description = NULL, intents = NULL, enableModelImprovements = NULL, nluIntentConfidenceThreshold = NULL, clarificationPrompt = NULL, abortStatement = NULL, idleSessionTTLInSeconds = NULL, voiceId = NULL, checksum = NULL, processBehavior = NULL, locale, childDirected, detectSentiment = NULL, createVersion = NULL, tags = NULL) {
  op <- new_operation(
    name = "PutBot",
    http_method = "PUT",
    http_path = "/bots/{name}/versions/$LATEST",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$put_bot_input(name = name, description = description, intents = intents, enableModelImprovements = enableModelImprovements, nluIntentConfidenceThreshold = nluIntentConfidenceThreshold, clarificationPrompt = clarificationPrompt, abortStatement = abortStatement, idleSessionTTLInSeconds = idleSessionTTLInSeconds, voiceId = voiceId, checksum = checksum, processBehavior = processBehavior, locale = locale, childDirected = childDirected, detectSentiment = detectSentiment, createVersion = createVersion, tags = tags)
  output <- .lexmodelbuildingservice$put_bot_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$put_bot <- lexmodelbuildingservice_put_bot

#' Creates an alias for the specified version of the bot or replaces an
#' alias for the specified bot
#'
#' @description
#' Creates an alias for the specified version of the bot or replaces an
#' alias for the specified bot. To change the version of the bot that the
#' alias points to, replace the alias. For more information about aliases,
#' see versioning-aliases.
#' 
#' This operation requires permissions for the `lex:PutBotAlias` action.
#'
#' @usage
#' lexmodelbuildingservice_put_bot_alias(name, description, botVersion,
#'   botName, checksum, conversationLogs, tags)
#'
#' @param name &#91;required&#93; The name of the alias. The name is *not* case sensitive.
#' @param description A description of the alias.
#' @param botVersion &#91;required&#93; The version of the bot.
#' @param botName &#91;required&#93; The name of the bot.
#' @param checksum Identifies a specific revision of the `$LATEST` version.
#' 
#' When you create a new bot alias, leave the `checksum` field blank. If
#' you specify a checksum you get a `BadRequestException` exception.
#' 
#' When you want to update a bot alias, set the `checksum` field to the
#' checksum of the most recent revision of the `$LATEST` version. If you
#' don't specify the ` checksum` field, or if the checksum does not match
#' the `$LATEST` version, you get a `PreconditionFailedException`
#' exception.
#' @param conversationLogs Settings for conversation logs for the alias.
#' @param tags A list of tags to add to the bot alias. You can only add tags when you
#' create an alias, you can't use the
#' [`put_bot_alias`][lexmodelbuildingservice_put_bot_alias] operation to
#' update the tags on a bot alias. To update tags, use the
#' [`tag_resource`][lexmodelbuildingservice_tag_resource] operation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   botVersion = "string",
#'   botName = "string",
#'   lastUpdatedDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   checksum = "string",
#'   conversationLogs = list(
#'     logSettings = list(
#'       list(
#'         logType = "AUDIO"|"TEXT",
#'         destination = "CLOUDWATCH_LOGS"|"S3",
#'         kmsKeyArn = "string",
#'         resourceArn = "string",
#'         resourcePrefix = "string"
#'       )
#'     ),
#'     iamRoleArn = "string"
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_bot_alias(
#'   name = "string",
#'   description = "string",
#'   botVersion = "string",
#'   botName = "string",
#'   checksum = "string",
#'   conversationLogs = list(
#'     logSettings = list(
#'       list(
#'         logType = "AUDIO"|"TEXT",
#'         destination = "CLOUDWATCH_LOGS"|"S3",
#'         kmsKeyArn = "string",
#'         resourceArn = "string"
#'       )
#'     ),
#'     iamRoleArn = "string"
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_put_bot_alias
lexmodelbuildingservice_put_bot_alias <- function(name, description = NULL, botVersion, botName, checksum = NULL, conversationLogs = NULL, tags = NULL) {
  op <- new_operation(
    name = "PutBotAlias",
    http_method = "PUT",
    http_path = "/bots/{botName}/aliases/{name}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$put_bot_alias_input(name = name, description = description, botVersion = botVersion, botName = botName, checksum = checksum, conversationLogs = conversationLogs, tags = tags)
  output <- .lexmodelbuildingservice$put_bot_alias_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$put_bot_alias <- lexmodelbuildingservice_put_bot_alias

#' Creates an intent or replaces an existing intent
#'
#' @description
#' Creates an intent or replaces an existing intent.
#' 
#' To define the interaction between the user and your bot, you use one or
#' more intents. For a pizza ordering bot, for example, you would create an
#' `OrderPizza` intent.
#' 
#' To create an intent or replace an existing intent, you must provide the
#' following:
#' 
#' -   Intent name. For example, `OrderPizza`.
#' 
#' -   Sample utterances. For example, "Can I order a pizza, please." and
#'     "I want to order a pizza."
#' 
#' -   Information to be gathered. You specify slot types for the
#'     information that your bot will request from the user. You can
#'     specify standard slot types, such as a date or a time, or custom
#'     slot types such as the size and crust of a pizza.
#' 
#' -   How the intent will be fulfilled. You can provide a Lambda function
#'     or configure the intent to return the intent information to the
#'     client application. If you use a Lambda function, when all of the
#'     intent information is available, Amazon Lex invokes your Lambda
#'     function. If you configure your intent to return the intent
#'     information to the client application.
#' 
#' You can specify other optional information in the request, such as:
#' 
#' -   A confirmation prompt to ask the user to confirm an intent. For
#'     example, "Shall I order your pizza?"
#' 
#' -   A conclusion statement to send to the user after the intent has been
#'     fulfilled. For example, "I placed your pizza order."
#' 
#' -   A follow-up prompt that asks the user for additional activity. For
#'     example, asking "Do you want to order a drink with your pizza?"
#' 
#' If you specify an existing intent name to update the intent, Amazon Lex
#' replaces the values in the `$LATEST` version of the intent with the
#' values in the request. Amazon Lex removes fields that you don't provide
#' in the request. If you don't specify the required fields, Amazon Lex
#' throws an exception. When you update the `$LATEST` version of an intent,
#' the `status` field of any bot that uses the `$LATEST` version of the
#' intent is set to `NOT_BUILT`.
#' 
#' For more information, see how-it-works.
#' 
#' This operation requires permissions for the `lex:PutIntent` action.
#'
#' @usage
#' lexmodelbuildingservice_put_intent(name, description, slots,
#'   sampleUtterances, confirmationPrompt, rejectionStatement,
#'   followUpPrompt, conclusionStatement, dialogCodeHook,
#'   fulfillmentActivity, parentIntentSignature, checksum, createVersion,
#'   kendraConfiguration, inputContexts, outputContexts)
#'
#' @param name &#91;required&#93; The name of the intent. The name is *not* case sensitive.
#' 
#' The name can't match a built-in intent name, or a built-in intent name
#' with "AMAZON." removed. For example, because there is a built-in intent
#' called `AMAZON.HelpIntent`, you can't create a custom intent called
#' `HelpIntent`.
#' 
#' For a list of built-in intents, see [Standard Built-in
#' Intents](https://developer.amazon.com/en-US/docs/alexa/custom-skills/standard-built-in-intents.html)
#' in the *Alexa Skills Kit*.
#' @param description A description of the intent.
#' @param slots An array of intent slots. At runtime, Amazon Lex elicits required slot
#' values from the user using prompts defined in the slots. For more
#' information, see how-it-works.
#' @param sampleUtterances An array of utterances (strings) that a user might say to signal the
#' intent. For example, "I want \{PizzaSize\} pizza", "Order
#' \{Quantity\} \{PizzaSize\} pizzas".
#' 
#' In each utterance, a slot name is enclosed in curly braces.
#' @param confirmationPrompt Prompts the user to confirm the intent. This question should have a yes
#' or no answer.
#' 
#' Amazon Lex uses this prompt to ensure that the user acknowledges that
#' the intent is ready for fulfillment. For example, with the `OrderPizza`
#' intent, you might want to confirm that the order is correct before
#' placing it. For other intents, such as intents that simply respond to
#' user questions, you might not need to ask the user for confirmation
#' before providing the information.
#' 
#' You you must provide both the `rejectionStatement` and the
#' `confirmationPrompt`, or neither.
#' @param rejectionStatement When the user answers "no" to the question defined in
#' `confirmationPrompt`, Amazon Lex responds with this statement to
#' acknowledge that the intent was canceled.
#' 
#' You must provide both the `rejectionStatement` and the
#' `confirmationPrompt`, or neither.
#' @param followUpPrompt Amazon Lex uses this prompt to solicit additional activity after
#' fulfilling an intent. For example, after the `OrderPizza` intent is
#' fulfilled, you might prompt the user to order a drink.
#' 
#' The action that Amazon Lex takes depends on the user's response, as
#' follows:
#' 
#' -   If the user says "Yes" it responds with the clarification prompt
#'     that is configured for the bot.
#' 
#' -   if the user says "Yes" and continues with an utterance that triggers
#'     an intent it starts a conversation for the intent.
#' 
#' -   If the user says "No" it responds with the rejection statement
#'     configured for the the follow-up prompt.
#' 
#' -   If it doesn't recognize the utterance it repeats the follow-up
#'     prompt again.
#' 
#' The `followUpPrompt` field and the `conclusionStatement` field are
#' mutually exclusive. You can specify only one.
#' @param conclusionStatement The statement that you want Amazon Lex to convey to the user after the
#' intent is successfully fulfilled by the Lambda function.
#' 
#' This element is relevant only if you provide a Lambda function in the
#' `fulfillmentActivity`. If you return the intent to the client
#' application, you can't specify this element.
#' 
#' The `followUpPrompt` and `conclusionStatement` are mutually exclusive.
#' You can specify only one.
#' @param dialogCodeHook Specifies a Lambda function to invoke for each user input. You can
#' invoke this Lambda function to personalize user interaction.
#' 
#' For example, suppose your bot determines that the user is John. Your
#' Lambda function might retrieve John's information from a backend
#' database and prepopulate some of the values. For example, if you find
#' that John is gluten intolerant, you might set the corresponding intent
#' slot, `GlutenIntolerant`, to true. You might find John's phone number
#' and set the corresponding session attribute.
#' @param fulfillmentActivity Required. Describes how the intent is fulfilled. For example, after a
#' user provides all of the information for a pizza order,
#' `fulfillmentActivity` defines how the bot places an order with a local
#' pizza store.
#' 
#' You might configure Amazon Lex to return all of the intent information
#' to the client application, or direct it to invoke a Lambda function that
#' can process the intent (for example, place an order with a pizzeria).
#' @param parentIntentSignature A unique identifier for the built-in intent to base this intent on. To
#' find the signature for an intent, see [Standard Built-in
#' Intents](https://developer.amazon.com/en-US/docs/alexa/custom-skills/standard-built-in-intents.html)
#' in the *Alexa Skills Kit*.
#' @param checksum Identifies a specific revision of the `$LATEST` version.
#' 
#' When you create a new intent, leave the `checksum` field blank. If you
#' specify a checksum you get a `BadRequestException` exception.
#' 
#' When you want to update a intent, set the `checksum` field to the
#' checksum of the most recent revision of the `$LATEST` version. If you
#' don't specify the ` checksum` field, or if the checksum does not match
#' the `$LATEST` version, you get a `PreconditionFailedException`
#' exception.
#' @param createVersion When set to `true` a new numbered version of the intent is created. This
#' is the same as calling the
#' [`create_intent_version`][lexmodelbuildingservice_create_intent_version]
#' operation. If you do not specify `createVersion`, the default is
#' `false`.
#' @param kendraConfiguration Configuration information required to use the
#' `AMAZON.KendraSearchIntent` intent to connect to an Amazon Kendra index.
#' For more information, see
#' [AMAZON.KendraSearchIntent](https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html).
#' @param inputContexts An array of `InputContext` objects that lists the contexts that must be
#' active for Amazon Lex to choose the intent in a conversation with the
#' user.
#' @param outputContexts An array of `OutputContext` objects that lists the contexts that the
#' intent activates when the intent is fulfilled.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   slots = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       slotConstraint = "Required"|"Optional",
#'       slotType = "string",
#'       slotTypeVersion = "string",
#'       valueElicitationPrompt = list(
#'         messages = list(
#'           list(
#'             contentType = "PlainText"|"SSML"|"CustomPayload",
#'             content = "string",
#'             groupNumber = 123
#'           )
#'         ),
#'         maxAttempts = 123,
#'         responseCard = "string"
#'       ),
#'       priority = 123,
#'       sampleUtterances = list(
#'         "string"
#'       ),
#'       responseCard = "string",
#'       obfuscationSetting = "NONE"|"DEFAULT_OBFUSCATION",
#'       defaultValueSpec = list(
#'         defaultValueList = list(
#'           list(
#'             defaultValue = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   sampleUtterances = list(
#'     "string"
#'   ),
#'   confirmationPrompt = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     maxAttempts = 123,
#'     responseCard = "string"
#'   ),
#'   rejectionStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   followUpPrompt = list(
#'     prompt = list(
#'       messages = list(
#'         list(
#'           contentType = "PlainText"|"SSML"|"CustomPayload",
#'           content = "string",
#'           groupNumber = 123
#'         )
#'       ),
#'       maxAttempts = 123,
#'       responseCard = "string"
#'     ),
#'     rejectionStatement = list(
#'       messages = list(
#'         list(
#'           contentType = "PlainText"|"SSML"|"CustomPayload",
#'           content = "string",
#'           groupNumber = 123
#'         )
#'       ),
#'       responseCard = "string"
#'     )
#'   ),
#'   conclusionStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   dialogCodeHook = list(
#'     uri = "string",
#'     messageVersion = "string"
#'   ),
#'   fulfillmentActivity = list(
#'     type = "ReturnIntent"|"CodeHook",
#'     codeHook = list(
#'       uri = "string",
#'       messageVersion = "string"
#'     )
#'   ),
#'   parentIntentSignature = "string",
#'   lastUpdatedDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   version = "string",
#'   checksum = "string",
#'   createVersion = TRUE|FALSE,
#'   kendraConfiguration = list(
#'     kendraIndex = "string",
#'     queryFilterString = "string",
#'     role = "string"
#'   ),
#'   inputContexts = list(
#'     list(
#'       name = "string"
#'     )
#'   ),
#'   outputContexts = list(
#'     list(
#'       name = "string",
#'       timeToLiveInSeconds = 123,
#'       turnsToLive = 123
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_intent(
#'   name = "string",
#'   description = "string",
#'   slots = list(
#'     list(
#'       name = "string",
#'       description = "string",
#'       slotConstraint = "Required"|"Optional",
#'       slotType = "string",
#'       slotTypeVersion = "string",
#'       valueElicitationPrompt = list(
#'         messages = list(
#'           list(
#'             contentType = "PlainText"|"SSML"|"CustomPayload",
#'             content = "string",
#'             groupNumber = 123
#'           )
#'         ),
#'         maxAttempts = 123,
#'         responseCard = "string"
#'       ),
#'       priority = 123,
#'       sampleUtterances = list(
#'         "string"
#'       ),
#'       responseCard = "string",
#'       obfuscationSetting = "NONE"|"DEFAULT_OBFUSCATION",
#'       defaultValueSpec = list(
#'         defaultValueList = list(
#'           list(
#'             defaultValue = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   sampleUtterances = list(
#'     "string"
#'   ),
#'   confirmationPrompt = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     maxAttempts = 123,
#'     responseCard = "string"
#'   ),
#'   rejectionStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   followUpPrompt = list(
#'     prompt = list(
#'       messages = list(
#'         list(
#'           contentType = "PlainText"|"SSML"|"CustomPayload",
#'           content = "string",
#'           groupNumber = 123
#'         )
#'       ),
#'       maxAttempts = 123,
#'       responseCard = "string"
#'     ),
#'     rejectionStatement = list(
#'       messages = list(
#'         list(
#'           contentType = "PlainText"|"SSML"|"CustomPayload",
#'           content = "string",
#'           groupNumber = 123
#'         )
#'       ),
#'       responseCard = "string"
#'     )
#'   ),
#'   conclusionStatement = list(
#'     messages = list(
#'       list(
#'         contentType = "PlainText"|"SSML"|"CustomPayload",
#'         content = "string",
#'         groupNumber = 123
#'       )
#'     ),
#'     responseCard = "string"
#'   ),
#'   dialogCodeHook = list(
#'     uri = "string",
#'     messageVersion = "string"
#'   ),
#'   fulfillmentActivity = list(
#'     type = "ReturnIntent"|"CodeHook",
#'     codeHook = list(
#'       uri = "string",
#'       messageVersion = "string"
#'     )
#'   ),
#'   parentIntentSignature = "string",
#'   checksum = "string",
#'   createVersion = TRUE|FALSE,
#'   kendraConfiguration = list(
#'     kendraIndex = "string",
#'     queryFilterString = "string",
#'     role = "string"
#'   ),
#'   inputContexts = list(
#'     list(
#'       name = "string"
#'     )
#'   ),
#'   outputContexts = list(
#'     list(
#'       name = "string",
#'       timeToLiveInSeconds = 123,
#'       turnsToLive = 123
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example shows how to create an intent for ordering pizzas.
#' svc$put_intent(
#'   name = "DocOrderPizza",
#'   conclusionStatement = list(
#'     messages = list(
#'       list(
#'         content = "All right, I ordered  you a {Crust} crust {Type} pizza with {Sauce} sauce.",
#'         contentType = "PlainText"
#'       ),
#'       list(
#'         content = "OK, your {Crust} crust {Type} pizza with {Sauce} sauce is on the way.",
#'         contentType = "PlainText"
#'       )
#'     ),
#'     responseCard = "foo"
#'   ),
#'   confirmationPrompt = list(
#'     maxAttempts = 1L,
#'     messages = list(
#'       list(
#'         content = "Should I order  your {Crust} crust {Type} pizza with {Sauce} sauce?",
#'         contentType = "PlainText"
#'       )
#'     )
#'   ),
#'   description = "Order a pizza from a local pizzeria.",
#'   fulfillmentActivity = list(
#'     type = "ReturnIntent"
#'   ),
#'   rejectionStatement = list(
#'     messages = list(
#'       list(
#'         content = "Ok, I'll cancel your order.",
#'         contentType = "PlainText"
#'       ),
#'       list(
#'         content = "I cancelled your order.",
#'         contentType = "PlainText"
#'       )
#'     )
#'   ),
#'   sampleUtterances = list(
#'     "Order me a pizza.",
#'     "Order me a {Type} pizza.",
#'     "I want a {Crust} crust {Type} pizza",
#'     "I want a {Crust} crust {Type} pizza with {Sauce} sauce."
#'   ),
#'   slots = list(
#'     list(
#'       name = "Type",
#'       description = "The type of pizza to order.",
#'       priority = 1L,
#'       sampleUtterances = list(
#'         "Get me a {Type} pizza.",
#'         "A {Type} pizza please.",
#'         "I'd like a {Type} pizza."
#'       ),
#'       slotConstraint = "Required",
#'       slotType = "DocPizzaType",
#'       slotTypeVersion = "$LATEST",
#'       valueElicitationPrompt = list(
#'         maxAttempts = 1L,
#'         messages = list(
#'           list(
#'             content = "What type of pizza would you like?",
#'             contentType = "PlainText"
#'           ),
#'           list(
#'             content = "Vegie or cheese pizza?",
#'             contentType = "PlainText"
#'           ),
#'           list(
#'             content = "I can get you a vegie or a cheese pizza.",
#'             contentType = "PlainText"
#'           )
#'         )
#'       )
#'     ),
#'     list(
#'       name = "Crust",
#'       description = "The type of pizza crust to order.",
#'       priority = 2L,
#'       sampleUtterances = list(
#'         "Make it a {Crust} crust.",
#'         "I'd like a {Crust} crust."
#'       ),
#'       slotConstraint = "Required",
#'       slotType = "DocPizzaCrustType",
#'       slotTypeVersion = "$LATEST",
#'       valueElicitationPrompt = list(
#'         maxAttempts = 1L,
#'         messages = list(
#'           list(
#'             content = "What type of crust would you like?",
#'             contentType = "PlainText"
#'           ),
#'           list(
#'             content = "Thick or thin crust?",
#'             contentType = "PlainText"
#'           )
#'         )
#'       )
#'     ),
#'     list(
#'       name = "Sauce",
#'       description = "The type of sauce to use on the pizza.",
#'       priority = 3L,
#'       sampleUtterances = list(
#'         "Make it {Sauce} sauce.",
#'         "I'd like {Sauce} sauce."
#'       ),
#'       slotConstraint = "Required",
#'       slotType = "DocPizzaSauceType",
#'       slotTypeVersion = "$LATEST",
#'       valueElicitationPrompt = list(
#'         maxAttempts = 1L,
#'         messages = list(
#'           list(
#'             content = "White or red sauce?",
#'             contentType = "PlainText"
#'           ),
#'           list(
#'             content = "Garlic or tomato sauce?",
#'             contentType = "PlainText"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_put_intent
lexmodelbuildingservice_put_intent <- function(name, description = NULL, slots = NULL, sampleUtterances = NULL, confirmationPrompt = NULL, rejectionStatement = NULL, followUpPrompt = NULL, conclusionStatement = NULL, dialogCodeHook = NULL, fulfillmentActivity = NULL, parentIntentSignature = NULL, checksum = NULL, createVersion = NULL, kendraConfiguration = NULL, inputContexts = NULL, outputContexts = NULL) {
  op <- new_operation(
    name = "PutIntent",
    http_method = "PUT",
    http_path = "/intents/{name}/versions/$LATEST",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$put_intent_input(name = name, description = description, slots = slots, sampleUtterances = sampleUtterances, confirmationPrompt = confirmationPrompt, rejectionStatement = rejectionStatement, followUpPrompt = followUpPrompt, conclusionStatement = conclusionStatement, dialogCodeHook = dialogCodeHook, fulfillmentActivity = fulfillmentActivity, parentIntentSignature = parentIntentSignature, checksum = checksum, createVersion = createVersion, kendraConfiguration = kendraConfiguration, inputContexts = inputContexts, outputContexts = outputContexts)
  output <- .lexmodelbuildingservice$put_intent_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$put_intent <- lexmodelbuildingservice_put_intent

#' Creates a custom slot type or replaces an existing custom slot type
#'
#' @description
#' Creates a custom slot type or replaces an existing custom slot type.
#' 
#' To create a custom slot type, specify a name for the slot type and a set
#' of enumeration values, which are the values that a slot of this type can
#' assume. For more information, see how-it-works.
#' 
#' If you specify the name of an existing slot type, the fields in the
#' request replace the existing values in the `$LATEST` version of the slot
#' type. Amazon Lex removes the fields that you don't provide in the
#' request. If you don't specify required fields, Amazon Lex throws an
#' exception. When you update the `$LATEST` version of a slot type, if a
#' bot uses the `$LATEST` version of an intent that contains the slot type,
#' the bot's `status` field is set to `NOT_BUILT`.
#' 
#' This operation requires permissions for the `lex:PutSlotType` action.
#'
#' @usage
#' lexmodelbuildingservice_put_slot_type(name, description,
#'   enumerationValues, checksum, valueSelectionStrategy, createVersion,
#'   parentSlotTypeSignature, slotTypeConfigurations)
#'
#' @param name &#91;required&#93; The name of the slot type. The name is *not* case sensitive.
#' 
#' The name can't match a built-in slot type name, or a built-in slot type
#' name with "AMAZON." removed. For example, because there is a built-in
#' slot type called `AMAZON.DATE`, you can't create a custom slot type
#' called `DATE`.
#' 
#' For a list of built-in slot types, see [Slot Type
#' Reference](https://developer.amazon.com/en-US/docs/alexa/custom-skills/slot-type-reference.html)
#' in the *Alexa Skills Kit*.
#' @param description A description of the slot type.
#' @param enumerationValues A list of `EnumerationValue` objects that defines the values that the
#' slot type can take. Each value can have a list of `synonyms`, which are
#' additional values that help train the machine learning model about the
#' values that it resolves for a slot.
#' 
#' A regular expression slot type doesn't require enumeration values. All
#' other slot types require a list of enumeration values.
#' 
#' When Amazon Lex resolves a slot value, it generates a resolution list
#' that contains up to five possible values for the slot. If you are using
#' a Lambda function, this resolution list is passed to the function. If
#' you are not using a Lambda function you can choose to return the value
#' that the user entered or the first value in the resolution list as the
#' slot value. The `valueSelectionStrategy` field indicates the option to
#' use.
#' @param checksum Identifies a specific revision of the `$LATEST` version.
#' 
#' When you create a new slot type, leave the `checksum` field blank. If
#' you specify a checksum you get a `BadRequestException` exception.
#' 
#' When you want to update a slot type, set the `checksum` field to the
#' checksum of the most recent revision of the `$LATEST` version. If you
#' don't specify the ` checksum` field, or if the checksum does not match
#' the `$LATEST` version, you get a `PreconditionFailedException`
#' exception.
#' @param valueSelectionStrategy Determines the slot resolution strategy that Amazon Lex uses to return
#' slot type values. The field can be set to one of the following values:
#' 
#' -   `ORIGINAL_VALUE` - Returns the value entered by the user, if the
#'     user value is similar to the slot value.
#' 
#' -   `TOP_RESOLUTION` - If there is a resolution list for the slot,
#'     return the first value in the resolution list as the slot type
#'     value. If there is no resolution list, null is returned.
#' 
#' If you don't specify the `valueSelectionStrategy`, the default is
#' `ORIGINAL_VALUE`.
#' @param createVersion When set to `true` a new numbered version of the slot type is created.
#' This is the same as calling the
#' [`create_slot_type_version`][lexmodelbuildingservice_create_slot_type_version]
#' operation. If you do not specify `createVersion`, the default is
#' `false`.
#' @param parentSlotTypeSignature The built-in slot type used as the parent of the slot type. When you
#' define a parent slot type, the new slot type has all of the same
#' configuration as the parent.
#' 
#' Only `AMAZON.AlphaNumeric` is supported.
#' @param slotTypeConfigurations Configuration information that extends the parent built-in slot type.
#' The configuration is added to the settings for the parent slot type.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   description = "string",
#'   enumerationValues = list(
#'     list(
#'       value = "string",
#'       synonyms = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   lastUpdatedDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   version = "string",
#'   checksum = "string",
#'   valueSelectionStrategy = "ORIGINAL_VALUE"|"TOP_RESOLUTION",
#'   createVersion = TRUE|FALSE,
#'   parentSlotTypeSignature = "string",
#'   slotTypeConfigurations = list(
#'     list(
#'       regexConfiguration = list(
#'         pattern = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_slot_type(
#'   name = "string",
#'   description = "string",
#'   enumerationValues = list(
#'     list(
#'       value = "string",
#'       synonyms = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   checksum = "string",
#'   valueSelectionStrategy = "ORIGINAL_VALUE"|"TOP_RESOLUTION",
#'   createVersion = TRUE|FALSE,
#'   parentSlotTypeSignature = "string",
#'   slotTypeConfigurations = list(
#'     list(
#'       regexConfiguration = list(
#'         pattern = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example shows how to create a slot type that describes pizza
#' # sauces.
#' svc$put_slot_type(
#'   name = "PizzaSauceType",
#'   description = "Available pizza sauces",
#'   enumerationValues = list(
#'     list(
#'       value = "red"
#'     ),
#'     list(
#'       value = "white"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_put_slot_type
lexmodelbuildingservice_put_slot_type <- function(name, description = NULL, enumerationValues = NULL, checksum = NULL, valueSelectionStrategy = NULL, createVersion = NULL, parentSlotTypeSignature = NULL, slotTypeConfigurations = NULL) {
  op <- new_operation(
    name = "PutSlotType",
    http_method = "PUT",
    http_path = "/slottypes/{name}/versions/$LATEST",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$put_slot_type_input(name = name, description = description, enumerationValues = enumerationValues, checksum = checksum, valueSelectionStrategy = valueSelectionStrategy, createVersion = createVersion, parentSlotTypeSignature = parentSlotTypeSignature, slotTypeConfigurations = slotTypeConfigurations)
  output <- .lexmodelbuildingservice$put_slot_type_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$put_slot_type <- lexmodelbuildingservice_put_slot_type

#' Starts a job to import a resource to Amazon Lex
#'
#' @description
#' Starts a job to import a resource to Amazon Lex.
#'
#' @usage
#' lexmodelbuildingservice_start_import(payload, resourceType,
#'   mergeStrategy, tags)
#'
#' @param payload &#91;required&#93; A zip archive in binary format. The archive should contain one file, a
#' JSON file containing the resource to import. The resource should match
#' the type specified in the `resourceType` field.
#' @param resourceType &#91;required&#93; Specifies the type of resource to export. Each resource also exports any
#' resources that it depends on.
#' 
#' -   A bot exports dependent intents.
#' 
#' -   An intent exports dependent slot types.
#' @param mergeStrategy &#91;required&#93; Specifies the action that the
#' [`start_import`][lexmodelbuildingservice_start_import] operation should
#' take when there is an existing resource with the same name.
#' 
#' -   FAIL_ON_CONFLICT - The import operation is stopped on the first
#'     conflict between a resource in the import file and an existing
#'     resource. The name of the resource causing the conflict is in the
#'     `failureReason` field of the response to the
#'     [`get_import`][lexmodelbuildingservice_get_import] operation.
#' 
#'     OVERWRITE_LATEST - The import operation proceeds even if there is a
#'     conflict with an existing resource. The $LASTEST version of the
#'     existing resource is overwritten with the data from the import file.
#' @param tags A list of tags to add to the imported bot. You can only add tags when
#' you import a bot, you can't add tags to an intent or slot type.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   name = "string",
#'   resourceType = "BOT"|"INTENT"|"SLOT_TYPE",
#'   mergeStrategy = "OVERWRITE_LATEST"|"FAIL_ON_CONFLICT",
#'   importId = "string",
#'   importStatus = "IN_PROGRESS"|"COMPLETE"|"FAILED",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   createdDate = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_import(
#'   payload = raw,
#'   resourceType = "BOT"|"INTENT"|"SLOT_TYPE",
#'   mergeStrategy = "OVERWRITE_LATEST"|"FAIL_ON_CONFLICT",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_start_import
lexmodelbuildingservice_start_import <- function(payload, resourceType, mergeStrategy, tags = NULL) {
  op <- new_operation(
    name = "StartImport",
    http_method = "POST",
    http_path = "/imports/",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$start_import_input(payload = payload, resourceType = resourceType, mergeStrategy = mergeStrategy, tags = tags)
  output <- .lexmodelbuildingservice$start_import_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$start_import <- lexmodelbuildingservice_start_import

#' Adds the specified tags to the specified resource
#'
#' @description
#' Adds the specified tags to the specified resource. If a tag key already
#' exists, the existing value is replaced with the new value.
#'
#' @usage
#' lexmodelbuildingservice_tag_resource(resourceArn, tags)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to
#' tag.
#' @param tags &#91;required&#93; A list of tag keys to add to the resource. If a tag key already exists,
#' the existing value is replaced with the new value.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   resourceArn = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_tag_resource
lexmodelbuildingservice_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .lexmodelbuildingservice$tag_resource_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$tag_resource <- lexmodelbuildingservice_tag_resource

#' Removes tags from a bot, bot alias or bot channel
#'
#' @description
#' Removes tags from a bot, bot alias or bot channel.
#'
#' @usage
#' lexmodelbuildingservice_untag_resource(resourceArn, tagKeys)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to remove the tags from.
#' @param tagKeys &#91;required&#93; A list of tag keys to remove from the resource. If a tag key does not
#' exist on the resource, it is ignored.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   resourceArn = "string",
#'   tagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexmodelbuildingservice_untag_resource
lexmodelbuildingservice_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .lexmodelbuildingservice$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .lexmodelbuildingservice$untag_resource_output()
  config <- get_config()
  svc <- .lexmodelbuildingservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelbuildingservice$operations$untag_resource <- lexmodelbuildingservice_untag_resource
