# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Lex Runtime Service
#'
#' @description
#' Amazon Lex provides both build and runtime endpoints. Each endpoint
#' provides a set of operations (API). Your conversational bot uses the
#' runtime API to understand user utterances (user input text or voice).
#' For example, suppose a user says "I want pizza", your bot sends this
#' input to Amazon Lex using the runtime API. Amazon Lex recognizes that
#' the user request is for the OrderPizza intent (one of the intents
#' defined in the bot). Then Amazon Lex engages in user conversation on
#' behalf of the bot to elicit required information (slot values, such as
#' pizza size and crust type), and then performs fulfillment activity (that
#' you configured when you created the bot). You use the build-time API to
#' create and manage your Amazon Lex bot. For a list of build-time
#' operations, see the build-time API, .
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- lexruntimeservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- lexruntimeservice()
#' svc$delete_session(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=lexruntimeservice_delete_session]{delete_session} \tab Removes session information for a specified bot, alias, and user ID\cr
#'  \link[=lexruntimeservice_get_session]{get_session} \tab Returns session information for a specified bot, alias, and user ID\cr
#'  \link[=lexruntimeservice_post_content]{post_content} \tab Sends user input (text or speech) to Amazon Lex\cr
#'  \link[=lexruntimeservice_post_text]{post_text} \tab Sends user input to Amazon Lex\cr
#'  \link[=lexruntimeservice_put_session]{put_session} \tab Creates a new session or modifies an existing session with an Amazon Lex bot
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname lexruntimeservice
#' @export
lexruntimeservice <- function(config = list()) {
  svc <- .lexruntimeservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.lexruntimeservice <- list()

.lexruntimeservice$operations <- list()

.lexruntimeservice$metadata <- list(
  service_name = "runtime.lex",
  endpoints = list("*" = list(endpoint = "runtime.lex.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "runtime.lex.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "runtime.lex.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "runtime.lex.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Lex Runtime Service",
  api_version = "2016-11-28",
  signing_name = "lex",
  json_version = "1.1",
  target_prefix = ""
)

.lexruntimeservice$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.lexruntimeservice$metadata, handlers, config)
}
