% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexruntimeservice_operations.R
\name{lexruntimeservice_get_session}
\alias{lexruntimeservice_get_session}
\title{Returns session information for a specified bot, alias, and user ID}
\usage{
lexruntimeservice_get_session(botName, botAlias, userId,
  checkpointLabelFilter)
}
\arguments{
\item{botName}{[required] The name of the bot that contains the session data.}

\item{botAlias}{[required] The alias in use for the bot that contains the session data.}

\item{userId}{[required] The ID of the client application user. Amazon Lex uses this to identify
a user's conversation with your bot.}

\item{checkpointLabelFilter}{A string used to filter the intents returned in the
\code{recentIntentSummaryView} structure.

When you specify a filter, only intents with their \code{checkpointLabel}
field set to that string are returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  recentIntentSummaryView = list(
    list(
      intentName = "string",
      checkpointLabel = "string",
      slots = list(
        "string"
      ),
      confirmationStatus = "None"|"Confirmed"|"Denied",
      dialogActionType = "ElicitIntent"|"ConfirmIntent"|"ElicitSlot"|"Close"|"Delegate",
      fulfillmentState = "Fulfilled"|"Failed"|"ReadyForFulfillment",
      slotToElicit = "string"
    )
  ),
  sessionAttributes = list(
    "string"
  ),
  sessionId = "string",
  dialogAction = list(
    type = "ElicitIntent"|"ConfirmIntent"|"ElicitSlot"|"Close"|"Delegate",
    intentName = "string",
    slots = list(
      "string"
    ),
    slotToElicit = "string",
    fulfillmentState = "Fulfilled"|"Failed"|"ReadyForFulfillment",
    message = "string",
    messageFormat = "PlainText"|"CustomPayload"|"SSML"|"Composite"
  ),
  activeContexts = list(
    list(
      name = "string",
      timeToLive = list(
        timeToLiveInSeconds = 123,
        turnsToLive = 123
      ),
      parameters = list(
        "string"
      )
    )
  )
)
}
}
\description{
Returns session information for a specified bot, alias, and user ID.
}
\section{Request syntax}{
\preformatted{svc$get_session(
  botName = "string",
  botAlias = "string",
  userId = "string",
  checkpointLabelFilter = "string"
)
}
}

\keyword{internal}
