% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_model_explainability_job_definitions}
\alias{sagemaker_list_model_explainability_job_definitions}
\title{Lists model explainability job definitions that satisfy various filters}
\usage{
sagemaker_list_model_explainability_job_definitions(EndpointName,
  SortBy, SortOrder, NextToken, MaxResults, NameContains,
  CreationTimeBefore, CreationTimeAfter)
}
\arguments{
\item{EndpointName}{Name of the endpoint to monitor for model explainability.}

\item{SortBy}{Whether to sort results by the \code{Name} or \code{CreationTime} field. The
default is \code{CreationTime}.}

\item{SortOrder}{Whether to sort the results in \code{Ascending} or \code{Descending} order. The
default is \code{Descending}.}

\item{NextToken}{The token returned if the response is truncated. To retrieve the next
set of job executions, use it in the next request.}

\item{MaxResults}{The maximum number of jobs to return in the response. The default value
is 10.}

\item{NameContains}{Filter for model explainability jobs whose name contains a specified
string.}

\item{CreationTimeBefore}{A filter that returns only model explainability jobs created before a
specified time.}

\item{CreationTimeAfter}{A filter that returns only model explainability jobs created after a
specified time.}
}
\value{
A list with the following syntax:\preformatted{list(
  JobDefinitionSummaries = list(
    list(
      MonitoringJobDefinitionName = "string",
      MonitoringJobDefinitionArn = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      EndpointName = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists model explainability job definitions that satisfy various filters.
}
\section{Request syntax}{
\preformatted{svc$list_model_explainability_job_definitions(
  EndpointName = "string",
  SortBy = "Name"|"CreationTime",
  SortOrder = "Ascending"|"Descending",
  NextToken = "string",
  MaxResults = 123,
  NameContains = "string",
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
