# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' Amazon Translate
#'
#' @description
#' Provides translation between one source language and another of the same
#' set of languages.
#'
#' @examples
#' \donttest{svc <- translate()
#' svc$delete_terminology(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=translate_delete_terminology]{delete_terminology} \tab A synchronous action that deletes a custom terminology \cr
#'  \link[=translate_get_terminology]{get_terminology} \tab Retrieves a custom terminology \cr
#'  \link[=translate_import_terminology]{import_terminology} \tab Creates or updates a custom terminology, depending on whether or not one already exists for the given terminology name\cr
#'  \link[=translate_list_terminologies]{list_terminologies} \tab Provides a list of custom terminologies associated with your account \cr
#'  \link[=translate_translate_text]{translate_text} \tab Translates input text from the source language to the target language 
#' }
#'
#' @rdname translate
#' @export
translate <- function() {
  .translate$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.translate <- list()

.translate$operations <- list()

.translate$metadata <- list(
  service_name = "translate",
  endpoints = list("*" = "translate.{region}.amazonaws.com", "cn-*" = "translate.{region}.amazonaws.com.cn"),
  service_id = "Translate",
  api_version = "2017-07-01",
  signing_name = "translate",
  json_version = "1.1",
  target_prefix = "AWSShineFrontendService_20170701"
)

.translate$handlers <- new_handlers("jsonrpc", "v4")

.translate$service <- function() {
  new_service(.translate$metadata, .translate$handlers)
}
