% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_labeling_jobs}
\alias{sagemaker_list_labeling_jobs}
\title{Gets a list of labeling jobs}
\usage{
sagemaker_list_labeling_jobs(CreationTimeAfter, CreationTimeBefore,
  LastModifiedTimeAfter, LastModifiedTimeBefore, MaxResults, NextToken,
  NameContains, SortBy, SortOrder, StatusEquals)
}
\arguments{
\item{CreationTimeAfter}{A filter that returns only labeling jobs created after the specified
time (timestamp).}

\item{CreationTimeBefore}{A filter that returns only labeling jobs created before the specified
time (timestamp).}

\item{LastModifiedTimeAfter}{A filter that returns only labeling jobs modified after the specified
time (timestamp).}

\item{LastModifiedTimeBefore}{A filter that returns only labeling jobs modified before the specified
time (timestamp).}

\item{MaxResults}{The maximum number of labeling jobs to return in each page of the
response.}

\item{NextToken}{If the result of the previous \code{ListLabelingJobs} request was truncated,
the response includes a \code{NextToken}. To retrieve the next set of
labeling jobs, use the token in the next request.}

\item{NameContains}{A string in the labeling job name. This filter returns only labeling
jobs whose name contains the specified string.}

\item{SortBy}{The field to sort results by. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}

\item{StatusEquals}{A filter that retrieves only labeling jobs with a specific status.}
}
\description{
Gets a list of labeling jobs.
}
\section{Request syntax}{
\preformatted{svc$list_labeling_jobs(
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  MaxResults = 123,
  NextToken = "string",
  NameContains = "string",
  SortBy = "Name"|"CreationTime"|"Status",
  SortOrder = "Ascending"|"Descending",
  StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped"
)
}
}

\keyword{internal}
