% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textract_operations.R
\name{textract_start_document_text_detection}
\alias{textract_start_document_text_detection}
\title{Starts the asynchronous detection of text in a document}
\usage{
textract_start_document_text_detection(DocumentLocation,
  ClientRequestToken, JobTag, NotificationChannel)
}
\arguments{
\item{DocumentLocation}{[required] The location of the document to be processed.}

\item{ClientRequestToken}{The idempotent token that's used to identify the start request. If you
use the same token with multiple \code{StartDocumentTextDetection} requests,
the same \code{JobId} is returned. Use \code{ClientRequestToken} to prevent the
same job from being accidentally started more than once.}

\item{JobTag}{An identifier you specify that's included in the completion
notification that's published to the Amazon SNS topic. For example, you
can use \code{JobTag} to identify the type of document, such as a tax form or
a receipt, that the completion notification corresponds to.}

\item{NotificationChannel}{The Amazon SNS topic ARN that you want Amazon Textract to publish the
completion status of the operation to.}
}
\description{
Starts the asynchronous detection of text in a document. Amazon Textract
can detect lines of text and the words that make up a line of text.
}
\details{
\code{StartDocumentTextDetection} can analyze text in documents that are in
JPG, PNG, and PDF format. The documents are stored in an Amazon S3
bucket. Use DocumentLocation to specify the bucket name and file name of
the document.

\code{StartTextDetection} returns a job identifier (\code{JobId}) that you use to
get the results of the operation. When text detection is finished,
Amazon Textract publishes a completion status to the Amazon Simple
Notification Service (Amazon SNS) topic that you specify in
\code{NotificationChannel}. To get the results of the text detection
operation, first check that the status value published to the Amazon SNS
topic is \code{SUCCEEDED}. If so, call GetDocumentTextDetection, and pass the
job identifier (\code{JobId}) from the initial call to
\code{StartDocumentTextDetection}.

For more information, see \href{https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html}{Document Text Detection}.
}
\section{Request syntax}{
\preformatted{svc$start_document_text_detection(
  DocumentLocation = list(
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  ClientRequestToken = "string",
  JobTag = "string",
  NotificationChannel = list(
    SNSTopicArn = "string",
    RoleArn = "string"
  )
)
}
}

\keyword{internal}
