% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_list_transcription_jobs}
\alias{transcribeservice_list_transcription_jobs}
\title{Lists transcription jobs with the specified status}
\usage{
transcribeservice_list_transcription_jobs(Status, JobNameContains,
  NextToken, MaxResults)
}
\arguments{
\item{Status}{When specified, returns only transcription jobs with the specified
status. Jobs are ordered by creation date, with the newest jobs returned
first. If you don't specify a status, Amazon Transcribe returns all
transcription jobs ordered by creation date.}

\item{JobNameContains}{When specified, the jobs returned in the list are limited to jobs whose
name contains the specified string.}

\item{NextToken}{If the result of the previous request to \code{ListTranscriptionJobs} was
truncated, include the \code{NextToken} to fetch the next set of jobs.}

\item{MaxResults}{The maximum number of jobs to return in the response. If there are fewer
results in the list, this response contains only the actual results.}
}
\description{
Lists transcription jobs with the specified status.
}
\section{Request syntax}{
\preformatted{svc$list_transcription_jobs(
  Status = "QUEUED"|"IN_PROGRESS"|"FAILED"|"COMPLETED",
  JobNameContains = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
