# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sagemaker_service.R
NULL

#' Adds or overwrites one or more tags for the specified Amazon SageMaker
#' resource
#'
#' Adds or overwrites one or more tags for the specified Amazon SageMaker
#' resource. You can add tags to notebook instances, training jobs,
#' hyperparameter tuning jobs, batch transform jobs, models, labeling jobs,
#' work teams, endpoint configurations, and endpoints.
#' 
#' Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource. For more information about tags, see For more
#' information, see [AWS Tagging
#' Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
#' 
#' Tags that you add to a hyperparameter tuning job by calling this API are
#' also added to any training jobs that the hyperparameter tuning job
#' launches after you call this API, but not to training jobs that the
#' hyperparameter tuning job launched before you called this API. To make
#' sure that the tags associated with a hyperparameter tuning job are also
#' added to all training jobs that the hyperparameter tuning job launches,
#' add the tags when you first create the tuning job by specifying them in
#' the `Tags` parameter of CreateHyperParameterTuningJob
#'
#' @usage
#' sagemaker_add_tags(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to tag.
#' @param Tags &#91;required&#93; An array of `Tag` objects. Each tag is a key-value pair. Only the `key`
#' parameter is required. If you don\'t specify a value, Amazon SageMaker
#' sets the value to an empty string.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags(
#'   ResourceArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_add_tags
sagemaker_add_tags <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$add_tags_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .sagemaker$add_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$add_tags <- sagemaker_add_tags

#' Associates a trial component with a trial
#'
#' Associates a trial component with a trial. A trial component can be
#' associated with multiple trials. To disassociate a trial component from
#' a trial, call the DisassociateTrialComponent API.
#'
#' @usage
#' sagemaker_associate_trial_component(TrialComponentName, TrialName)
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to associated with the trial.
#' @param TrialName &#91;required&#93; The name of the trial to associate with.
#'
#' @section Request syntax:
#' ```
#' svc$associate_trial_component(
#'   TrialComponentName = "string",
#'   TrialName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_associate_trial_component
sagemaker_associate_trial_component <- function(TrialComponentName, TrialName) {
  op <- new_operation(
    name = "AssociateTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$associate_trial_component_input(TrialComponentName = TrialComponentName, TrialName = TrialName)
  output <- .sagemaker$associate_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$associate_trial_component <- sagemaker_associate_trial_component

#' Create a machine learning algorithm that you can use in Amazon SageMaker
#' and list in the AWS Marketplace
#'
#' Create a machine learning algorithm that you can use in Amazon SageMaker
#' and list in the AWS Marketplace.
#'
#' @usage
#' sagemaker_create_algorithm(AlgorithmName, AlgorithmDescription,
#'   TrainingSpecification, InferenceSpecification, ValidationSpecification,
#'   CertifyForMarketplace)
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm.
#' @param AlgorithmDescription A description of the algorithm.
#' @param TrainingSpecification &#91;required&#93; Specifies details about training jobs run by this algorithm, including
#' the following:
#' 
#' -   The Amazon ECR path of the container and the version digest of the
#'     algorithm.
#' 
#' -   The hyperparameters that the algorithm supports.
#' 
#' -   The instance types that the algorithm supports for training.
#' 
#' -   Whether the algorithm supports distributed training.
#' 
#' -   The metrics that the algorithm emits to Amazon CloudWatch.
#' 
#' -   Which metrics that the algorithm emits can be used as the objective
#'     metric for hyperparameter tuning jobs.
#' 
#' -   The input channels that the algorithm supports for training data.
#'     For example, an algorithm might support `train`, `validation`, and
#'     `test` channels.
#' @param InferenceSpecification Specifies details about inference jobs that the algorithm runs,
#' including the following:
#' 
#' -   The Amazon ECR paths of containers that contain the inference code
#'     and model artifacts.
#' 
#' -   The instance types that the algorithm supports for transform jobs
#'     and real-time endpoints used for inference.
#' 
#' -   The input and output content formats that the algorithm supports for
#'     inference.
#' @param ValidationSpecification Specifies configurations for one or more training jobs and that Amazon
#' SageMaker runs to test the algorithm\'s training code and, optionally,
#' one or more batch transform jobs that Amazon SageMaker runs to test the
#' algorithm\'s inference code.
#' @param CertifyForMarketplace Whether to certify the algorithm so that it can be listed in AWS
#' Marketplace.
#'
#' @section Request syntax:
#' ```
#' svc$create_algorithm(
#'   AlgorithmName = "string",
#'   AlgorithmDescription = "string",
#'   TrainingSpecification = list(
#'     TrainingImage = "string",
#'     TrainingImageDigest = "string",
#'     SupportedHyperParameters = list(
#'       list(
#'         Name = "string",
#'         Description = "string",
#'         Type = "Integer"|"Continuous"|"Categorical"|"FreeText",
#'         Range = list(
#'           IntegerParameterRangeSpecification = list(
#'             MinValue = "string",
#'             MaxValue = "string"
#'           ),
#'           ContinuousParameterRangeSpecification = list(
#'             MinValue = "string",
#'             MaxValue = "string"
#'           ),
#'           CategoricalParameterRangeSpecification = list(
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         IsTunable = TRUE|FALSE,
#'         IsRequired = TRUE|FALSE,
#'         DefaultValue = "string"
#'       )
#'     ),
#'     SupportedTrainingInstanceTypes = list(
#'       "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.p3dn.24xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5n.xlarge"|"ml.c5n.2xlarge"|"ml.c5n.4xlarge"|"ml.c5n.9xlarge"|"ml.c5n.18xlarge"
#'     ),
#'     SupportsDistributedTraining = TRUE|FALSE,
#'     MetricDefinitions = list(
#'       list(
#'         Name = "string",
#'         Regex = "string"
#'       )
#'     ),
#'     TrainingChannels = list(
#'       list(
#'         Name = "string",
#'         Description = "string",
#'         IsRequired = TRUE|FALSE,
#'         SupportedContentTypes = list(
#'           "string"
#'         ),
#'         SupportedCompressionTypes = list(
#'           "None"|"Gzip"
#'         ),
#'         SupportedInputModes = list(
#'           "Pipe"|"File"
#'         )
#'       )
#'     ),
#'     SupportedTuningJobObjectiveMetrics = list(
#'       list(
#'         Type = "Maximize"|"Minimize",
#'         MetricName = "string"
#'       )
#'     )
#'   ),
#'   InferenceSpecification = list(
#'     Containers = list(
#'       list(
#'         ContainerHostname = "string",
#'         Image = "string",
#'         ImageDigest = "string",
#'         ModelDataUrl = "string",
#'         ProductId = "string"
#'       )
#'     ),
#'     SupportedTransformInstanceTypes = list(
#'       "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"
#'     ),
#'     SupportedRealtimeInferenceInstanceTypes = list(
#'       "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.m5d.large"|"ml.m5d.xlarge"|"ml.m5d.2xlarge"|"ml.m5d.4xlarge"|"ml.m5d.12xlarge"|"ml.m5d.24xlarge"|"ml.c4.large"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5d.large"|"ml.c5d.xlarge"|"ml.c5d.2xlarge"|"ml.c5d.4xlarge"|"ml.c5d.9xlarge"|"ml.c5d.18xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.12xlarge"|"ml.r5.24xlarge"|"ml.r5d.large"|"ml.r5d.xlarge"|"ml.r5d.2xlarge"|"ml.r5d.4xlarge"|"ml.r5d.12xlarge"|"ml.r5d.24xlarge"|"ml.inf1.xlarge"|"ml.inf1.2xlarge"|"ml.inf1.6xlarge"|"ml.inf1.24xlarge"
#'     ),
#'     SupportedContentTypes = list(
#'       "string"
#'     ),
#'     SupportedResponseMIMETypes = list(
#'       "string"
#'     )
#'   ),
#'   ValidationSpecification = list(
#'     ValidationRole = "string",
#'     ValidationProfiles = list(
#'       list(
#'         ProfileName = "string",
#'         TrainingJobDefinition = list(
#'           TrainingInputMode = "Pipe"|"File",
#'           HyperParameters = list(
#'             "string"
#'           ),
#'           InputDataConfig = list(
#'             list(
#'               ChannelName = "string",
#'               DataSource = list(
#'                 S3DataSource = list(
#'                   S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'                   S3Uri = "string",
#'                   S3DataDistributionType = "FullyReplicated"|"ShardedByS3Key",
#'                   AttributeNames = list(
#'                     "string"
#'                   )
#'                 ),
#'                 FileSystemDataSource = list(
#'                   FileSystemId = "string",
#'                   FileSystemAccessMode = "rw"|"ro",
#'                   FileSystemType = "EFS"|"FSxLustre",
#'                   DirectoryPath = "string"
#'                 )
#'               ),
#'               ContentType = "string",
#'               CompressionType = "None"|"Gzip",
#'               RecordWrapperType = "None"|"RecordIO",
#'               InputMode = "Pipe"|"File",
#'               ShuffleConfig = list(
#'                 Seed = 123
#'               )
#'             )
#'           ),
#'           OutputDataConfig = list(
#'             KmsKeyId = "string",
#'             S3OutputPath = "string"
#'           ),
#'           ResourceConfig = list(
#'             InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.p3dn.24xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5n.xlarge"|"ml.c5n.2xlarge"|"ml.c5n.4xlarge"|"ml.c5n.9xlarge"|"ml.c5n.18xlarge",
#'             InstanceCount = 123,
#'             VolumeSizeInGB = 123,
#'             VolumeKmsKeyId = "string"
#'           ),
#'           StoppingCondition = list(
#'             MaxRuntimeInSeconds = 123,
#'             MaxWaitTimeInSeconds = 123
#'           )
#'         ),
#'         TransformJobDefinition = list(
#'           MaxConcurrentTransforms = 123,
#'           MaxPayloadInMB = 123,
#'           BatchStrategy = "MultiRecord"|"SingleRecord",
#'           Environment = list(
#'             "string"
#'           ),
#'           TransformInput = list(
#'             DataSource = list(
#'               S3DataSource = list(
#'                 S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'                 S3Uri = "string"
#'               )
#'             ),
#'             ContentType = "string",
#'             CompressionType = "None"|"Gzip",
#'             SplitType = "None"|"Line"|"RecordIO"|"TFRecord"
#'           ),
#'           TransformOutput = list(
#'             S3OutputPath = "string",
#'             Accept = "string",
#'             AssembleWith = "None"|"Line",
#'             KmsKeyId = "string"
#'           ),
#'           TransformResources = list(
#'             InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge",
#'             InstanceCount = 123,
#'             VolumeKmsKeyId = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   CertifyForMarketplace = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_algorithm
sagemaker_create_algorithm <- function(AlgorithmName, AlgorithmDescription = NULL, TrainingSpecification, InferenceSpecification = NULL, ValidationSpecification = NULL, CertifyForMarketplace = NULL) {
  op <- new_operation(
    name = "CreateAlgorithm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_algorithm_input(AlgorithmName = AlgorithmName, AlgorithmDescription = AlgorithmDescription, TrainingSpecification = TrainingSpecification, InferenceSpecification = InferenceSpecification, ValidationSpecification = ValidationSpecification, CertifyForMarketplace = CertifyForMarketplace)
  output <- .sagemaker$create_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_algorithm <- sagemaker_create_algorithm

#' Creates a running App for the specified UserProfile
#'
#' Creates a running App for the specified UserProfile. Supported Apps are
#' JupyterServer and KernelGateway. This operation is automatically invoked
#' by Amazon SageMaker Studio upon access to the associated Domain, and
#' when new kernel configurations are selected by the user. A user may have
#' multiple Apps active simultaneously.
#'
#' @usage
#' sagemaker_create_app(DomainId, UserProfileName, AppType, AppName, Tags,
#'   ResourceSpec)
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#' @param AppType &#91;required&#93; The type of app.
#' @param AppName &#91;required&#93; The name of the app.
#' @param Tags Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource.
#' @param ResourceSpec The instance type and the Amazon Resource Name (ARN) of the SageMaker
#' image created on the instance.
#'
#' @section Request syntax:
#' ```
#' svc$create_app(
#'   DomainId = "string",
#'   UserProfileName = "string",
#'   AppType = "JupyterServer"|"KernelGateway"|"TensorBoard",
#'   AppName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ResourceSpec = list(
#'     SageMakerImageArn = "string",
#'     InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_app
sagemaker_create_app <- function(DomainId, UserProfileName, AppType, AppName, Tags = NULL, ResourceSpec = NULL) {
  op <- new_operation(
    name = "CreateApp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_app_input(DomainId = DomainId, UserProfileName = UserProfileName, AppType = AppType, AppName = AppName, Tags = Tags, ResourceSpec = ResourceSpec)
  output <- .sagemaker$create_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_app <- sagemaker_create_app

#' Creates an AutoPilot job
#'
#' Creates an AutoPilot job.
#' 
#' After you run an AutoPilot job, you can find the best performing model
#' by calling , and then deploy that model by following the steps described
#' in [Step 6.1: Deploy the Model to Amazon SageMaker Hosting
#' Services](https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html).
#' 
#' For information about how to use AutoPilot, see [Use AutoPilot to
#' Automate Model
#' Development](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html).
#'
#' @usage
#' sagemaker_create_auto_ml_job(AutoMLJobName, InputDataConfig,
#'   OutputDataConfig, ProblemType, AutoMLJobObjective, AutoMLJobConfig,
#'   RoleArn, GenerateCandidateDefinitionsOnly, Tags)
#'
#' @param AutoMLJobName &#91;required&#93; Identifies an AutoPilot job. Must be unique to your account and is
#' case-insensitive.
#' @param InputDataConfig &#91;required&#93; Similar to InputDataConfig supported by Tuning. Format(s) supported:
#' CSV. Minimum of 1000 rows.
#' @param OutputDataConfig &#91;required&#93; Similar to OutputDataConfig supported by Tuning. Format(s) supported:
#' CSV.
#' @param ProblemType Defines the kind of preprocessing and algorithms intended for the
#' candidates. Options include: BinaryClassification,
#' MulticlassClassification, and Regression.
#' @param AutoMLJobObjective Defines the job\'s objective. You provide a MetricName and AutoML will
#' infer minimize or maximize. If this is not provided, the most commonly
#' used ObjectiveMetric for problem type will be selected.
#' @param AutoMLJobConfig Contains CompletionCriteria and SecurityConfig.
#' @param RoleArn &#91;required&#93; The ARN of the role that will be used to access the data.
#' @param GenerateCandidateDefinitionsOnly This will generate possible candidates without training a model. A
#' candidate is a combination of data preprocessors, algorithms, and
#' algorithm parameter settings.
#' @param Tags Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource.
#'
#' @section Request syntax:
#' ```
#' svc$create_auto_ml_job(
#'   AutoMLJobName = "string",
#'   InputDataConfig = list(
#'     list(
#'       DataSource = list(
#'         S3DataSource = list(
#'           S3DataType = "ManifestFile"|"S3Prefix",
#'           S3Uri = "string"
#'         )
#'       ),
#'       CompressionType = "None"|"Gzip",
#'       TargetAttributeName = "string"
#'     )
#'   ),
#'   OutputDataConfig = list(
#'     KmsKeyId = "string",
#'     S3OutputPath = "string"
#'   ),
#'   ProblemType = "BinaryClassification"|"MulticlassClassification"|"Regression",
#'   AutoMLJobObjective = list(
#'     MetricName = "Accuracy"|"MSE"|"F1"|"F1macro"
#'   ),
#'   AutoMLJobConfig = list(
#'     CompletionCriteria = list(
#'       MaxCandidates = 123,
#'       MaxRuntimePerTrainingJobInSeconds = 123,
#'       MaxAutoMLJobRuntimeInSeconds = 123
#'     ),
#'     SecurityConfig = list(
#'       VolumeKmsKeyId = "string",
#'       EnableInterContainerTrafficEncryption = TRUE|FALSE,
#'       VpcConfig = list(
#'         SecurityGroupIds = list(
#'           "string"
#'         ),
#'         Subnets = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   RoleArn = "string",
#'   GenerateCandidateDefinitionsOnly = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_auto_ml_job
sagemaker_create_auto_ml_job <- function(AutoMLJobName, InputDataConfig, OutputDataConfig, ProblemType = NULL, AutoMLJobObjective = NULL, AutoMLJobConfig = NULL, RoleArn, GenerateCandidateDefinitionsOnly = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAutoMLJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_auto_ml_job_input(AutoMLJobName = AutoMLJobName, InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, ProblemType = ProblemType, AutoMLJobObjective = AutoMLJobObjective, AutoMLJobConfig = AutoMLJobConfig, RoleArn = RoleArn, GenerateCandidateDefinitionsOnly = GenerateCandidateDefinitionsOnly, Tags = Tags)
  output <- .sagemaker$create_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_auto_ml_job <- sagemaker_create_auto_ml_job

#' Creates a Git repository as a resource in your Amazon SageMaker account
#'
#' Creates a Git repository as a resource in your Amazon SageMaker account.
#' You can associate the repository with notebook instances so that you can
#' use Git source control for the notebooks you create. The Git repository
#' is a resource in your Amazon SageMaker account, so it can be associated
#' with more than one notebook instance, and it persists independently from
#' the lifecycle of any notebook instances it is associated with.
#' 
#' The repository can be hosted either in [AWS
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository.
#'
#' @usage
#' sagemaker_create_code_repository(CodeRepositoryName, GitConfig)
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository. The name must have 1 to 63 characters.
#' Valid characters are a-z, A-Z, 0-9, and - (hyphen).
#' @param GitConfig &#91;required&#93; Specifies details about the repository, including the URL where the
#' repository is located, the default branch, and credentials to use to
#' access the repository.
#'
#' @section Request syntax:
#' ```
#' svc$create_code_repository(
#'   CodeRepositoryName = "string",
#'   GitConfig = list(
#'     RepositoryUrl = "string",
#'     Branch = "string",
#'     SecretArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_code_repository
sagemaker_create_code_repository <- function(CodeRepositoryName, GitConfig) {
  op <- new_operation(
    name = "CreateCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_code_repository_input(CodeRepositoryName = CodeRepositoryName, GitConfig = GitConfig)
  output <- .sagemaker$create_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_code_repository <- sagemaker_create_code_repository

#' Starts a model compilation job
#'
#' Starts a model compilation job. After the model has been compiled,
#' Amazon SageMaker saves the resulting model artifacts to an Amazon Simple
#' Storage Service (Amazon S3) bucket that you specify.
#' 
#' If you choose to host your model using Amazon SageMaker hosting
#' services, you can use the resulting model artifacts as part of the
#' model. You can also use the artifacts with AWS IoT Greengrass. In that
#' case, deploy them as an ML resource.
#' 
#' In the request body, you provide the following:
#' 
#' -   A name for the compilation job
#' 
#' -   Information about the input model artifacts
#' 
#' -   The output location for the compiled model and the device (target)
#'     that the model runs on
#' 
#' -   `The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job`
#' 
#' You can also provide a `Tag` to track the model compilation job\'s
#' resource use and costs. The response body contains the
#' `CompilationJobArn` for the compiled job.
#' 
#' To stop a model compilation job, use StopCompilationJob. To get
#' information about a particular model compilation job, use
#' DescribeCompilationJob. To get information about multiple model
#' compilation jobs, use ListCompilationJobs.
#'
#' @usage
#' sagemaker_create_compilation_job(CompilationJobName, RoleArn,
#'   InputConfig, OutputConfig, StoppingCondition)
#'
#' @param CompilationJobName &#91;required&#93; A name for the model compilation job. The name must be unique within the
#' AWS Region and within your AWS account.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that enables Amazon
#' SageMaker to perform tasks on your behalf.
#' 
#' During model compilation, Amazon SageMaker needs your permission to:
#' 
#' -   Read input data from an S3 bucket
#' 
#' -   Write model artifacts to an S3 bucket
#' 
#' -   Write logs to Amazon CloudWatch Logs
#' 
#' -   Publish metrics to Amazon CloudWatch
#' 
#' You grant permissions for all of these tasks to an IAM role. To pass
#' this role to Amazon SageMaker, the caller of this API must have the
#' `iam:PassRole` permission. For more information, see [Amazon SageMaker
#' Roles.](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html)
#' @param InputConfig &#91;required&#93; Provides information about the location of input model artifacts, the
#' name and shape of the expected data inputs, and the framework in which
#' the model was trained.
#' @param OutputConfig &#91;required&#93; Provides information about the output location for the compiled model
#' and the target device the model runs on.
#' @param StoppingCondition &#91;required&#93; Specifies a limit to how long a model compilation job can run. When the
#' job reaches the time limit, Amazon SageMaker ends the compilation job.
#' Use this API to cap model training costs.
#'
#' @section Request syntax:
#' ```
#' svc$create_compilation_job(
#'   CompilationJobName = "string",
#'   RoleArn = "string",
#'   InputConfig = list(
#'     S3Uri = "string",
#'     DataInputConfig = "string",
#'     Framework = "TENSORFLOW"|"KERAS"|"MXNET"|"ONNX"|"PYTORCH"|"XGBOOST"|"TFLITE"
#'   ),
#'   OutputConfig = list(
#'     S3OutputLocation = "string",
#'     TargetDevice = "lambda"|"ml_m4"|"ml_m5"|"ml_c4"|"ml_c5"|"ml_p2"|"ml_p3"|"ml_inf1"|"jetson_tx1"|"jetson_tx2"|"jetson_nano"|"jetson_xavier"|"rasp3b"|"imx8qm"|"deeplens"|"rk3399"|"rk3288"|"aisage"|"sbe_c"|"qcs605"|"qcs603"|"sitara_am57x"|"amba_cv22"
#'   ),
#'   StoppingCondition = list(
#'     MaxRuntimeInSeconds = 123,
#'     MaxWaitTimeInSeconds = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_compilation_job
sagemaker_create_compilation_job <- function(CompilationJobName, RoleArn, InputConfig, OutputConfig, StoppingCondition) {
  op <- new_operation(
    name = "CreateCompilationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_compilation_job_input(CompilationJobName = CompilationJobName, RoleArn = RoleArn, InputConfig = InputConfig, OutputConfig = OutputConfig, StoppingCondition = StoppingCondition)
  output <- .sagemaker$create_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_compilation_job <- sagemaker_create_compilation_job

#' Creates a Domain used by SageMaker Studio
#'
#' Creates a `Domain` used by SageMaker Studio. A domain consists of an
#' associated directory, a list of authorized users, and a variety of
#' security, application, policy, and Amazon Virtual Private Cloud (VPC)
#' configurations. An AWS account is limited to one domain per region.
#' Users within a domain can share notebook files and other artifacts with
#' each other.
#' 
#' When a domain is created, an Amazon Elastic File System (EFS) volume is
#' also created for use by all of the users within the domain. Each user
#' receives a private home directory within the EFS for notebooks, Git
#' repositories, and data files.
#' 
#' All traffic between the domain and the EFS volume is communicated
#' through the specified subnet IDs. All other traffic goes over the
#' Internet through an Amazon SageMaker system VPC. The EFS traffic uses
#' the NFS/TCP protocol over port 2049.
#' 
#' NFS traffic over TCP on port 2049 needs to be allowed in both inbound
#' and outbound rules in order to launch a SageMaker Studio app
#' successfully.
#'
#' @usage
#' sagemaker_create_domain(DomainName, AuthMode, DefaultUserSettings,
#'   SubnetIds, VpcId, Tags, HomeEfsFileSystemKmsKeyId)
#'
#' @param DomainName &#91;required&#93; A name for the domain.
#' @param AuthMode &#91;required&#93; The mode of authentication that members use to access the domain.
#' @param DefaultUserSettings &#91;required&#93; The default user settings.
#' @param SubnetIds &#91;required&#93; The VPC subnets to use for communication with the EFS volume.
#' @param VpcId &#91;required&#93; The ID of the Amazon Virtual Private Cloud (VPC) to use for
#' communication with the EFS volume.
#' @param Tags Tags to associated with the Domain. Each tag consists of a key and an
#' optional value. Tag keys must be unique per resource. Tags are
#' searchable using the Search API.
#' @param HomeEfsFileSystemKmsKeyId The AWS Key Management Service (KMS) encryption key ID. Encryption with
#' a customer master key (CMK) is not supported.
#'
#' @section Request syntax:
#' ```
#' svc$create_domain(
#'   DomainName = "string",
#'   AuthMode = "SSO"|"IAM",
#'   DefaultUserSettings = list(
#'     ExecutionRole = "string",
#'     SecurityGroups = list(
#'       "string"
#'     ),
#'     SharingSettings = list(
#'       NotebookOutputOption = "Allowed"|"Disabled",
#'       S3OutputPath = "string",
#'       S3KmsKeyId = "string"
#'     ),
#'     JupyterServerAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     ),
#'     KernelGatewayAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     ),
#'     TensorBoardAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     )
#'   ),
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   VpcId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   HomeEfsFileSystemKmsKeyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_domain
sagemaker_create_domain <- function(DomainName, AuthMode, DefaultUserSettings, SubnetIds, VpcId, Tags = NULL, HomeEfsFileSystemKmsKeyId = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_domain_input(DomainName = DomainName, AuthMode = AuthMode, DefaultUserSettings = DefaultUserSettings, SubnetIds = SubnetIds, VpcId = VpcId, Tags = Tags, HomeEfsFileSystemKmsKeyId = HomeEfsFileSystemKmsKeyId)
  output <- .sagemaker$create_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_domain <- sagemaker_create_domain

#' Creates an endpoint using the endpoint configuration specified in the
#' request
#'
#' Creates an endpoint using the endpoint configuration specified in the
#' request. Amazon SageMaker uses the endpoint to provision resources and
#' deploy models. You create the endpoint configuration with the
#' CreateEndpointConfig API.
#' 
#' Use this API to deploy models using Amazon SageMaker hosting services.
#' 
#' For an example that calls this method when deploying a model to Amazon
#' SageMaker hosting services, see [Deploy the Model to Amazon SageMaker
#' Hosting Services (AWS SDK for Python (Boto
#' 3)).](https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
#' 
#' You must not delete an `EndpointConfig` that is in use by an endpoint
#' that is live or while the `UpdateEndpoint` or `CreateEndpoint`
#' operations are being performed on the endpoint. To update an endpoint,
#' you must create a new `EndpointConfig`.
#' 
#' The endpoint name must be unique within an AWS Region in your AWS
#' account.
#' 
#' When it receives the request, Amazon SageMaker creates the endpoint,
#' launches the resources (ML compute instances), and deploys the model(s)
#' on them.
#' 
#' When you call CreateEndpoint, a load call is made to DynamoDB to verify
#' that your endpoint configuration exists. When you read data from a
#' DynamoDB table supporting
#' [`Eventually Consistent Reads`](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html)
#' , the response might not reflect the results of a recently completed
#' write operation. The response might include some stale data. If the
#' dependent entities are not yet in DynamoDB, this causes a validation
#' error. If you repeat your read request after a short time, the response
#' should return the latest data. So retry logic is recommended to handle
#' these possible issues. We also recommend that customers call
#' DescribeEndpointConfig before calling CreateEndpoint to minimize the
#' potential impact of a DynamoDB eventually consistent read.
#' 
#' When Amazon SageMaker receives the request, it sets the endpoint status
#' to `Creating`. After it creates the endpoint, it sets the status to
#' `InService`. Amazon SageMaker can then process incoming requests for
#' inferences. To check the status of an endpoint, use the DescribeEndpoint
#' API.
#' 
#' If any of the models hosted at this endpoint get model data from an
#' Amazon S3 location, Amazon SageMaker uses AWS Security Token Service to
#' download model artifacts from the S3 path you provided. AWS STS is
#' activated in your IAM user account by default. If you previously
#' deactivated AWS STS for a region, you need to reactivate AWS STS for
#' that region. For more information, see [Activating and Deactivating AWS
#' STS in an AWS
#' Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
#' in the *AWS Identity and Access Management User Guide*.
#'
#' @usage
#' sagemaker_create_endpoint(EndpointName, EndpointConfigName, Tags)
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint. The name must be unique within an AWS Region
#' in your AWS account.
#' @param EndpointConfigName &#91;required&#93; The name of an endpoint configuration. For more information, see
#' CreateEndpointConfig.
#' @param Tags An array of key-value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)in
#' the *AWS Billing and Cost Management User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_endpoint(
#'   EndpointName = "string",
#'   EndpointConfigName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_endpoint
sagemaker_create_endpoint <- function(EndpointName, EndpointConfigName, Tags = NULL) {
  op <- new_operation(
    name = "CreateEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_endpoint_input(EndpointName = EndpointName, EndpointConfigName = EndpointConfigName, Tags = Tags)
  output <- .sagemaker$create_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_endpoint <- sagemaker_create_endpoint

#' Creates an endpoint configuration that Amazon SageMaker hosting services
#' uses to deploy models
#'
#' Creates an endpoint configuration that Amazon SageMaker hosting services
#' uses to deploy models. In the configuration, you identify one or more
#' models, created using the `CreateModel` API, to deploy and the resources
#' that you want Amazon SageMaker to provision. Then you call the
#' CreateEndpoint API.
#' 
#' Use this API if you want to use Amazon SageMaker hosting services to
#' deploy models into production.
#' 
#' In the request, you define a `ProductionVariant`, for each model that
#' you want to deploy. Each `ProductionVariant` parameter also describes
#' the resources that you want Amazon SageMaker to provision. This includes
#' the number and type of ML compute instances to deploy.
#' 
#' If you are hosting multiple models, you also assign a `VariantWeight` to
#' specify how much traffic you want to allocate to each model. For
#' example, suppose that you want to host two models, A and B, and you
#' assign traffic weight 2 for model A and 1 for model B. Amazon SageMaker
#' distributes two-thirds of the traffic to Model A, and one-third to model
#' B.
#' 
#' For an example that calls this method when deploying a model to Amazon
#' SageMaker hosting services, see [Deploy the Model to Amazon SageMaker
#' Hosting Services (AWS SDK for Python (Boto
#' 3)).](https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
#' 
#' When you call CreateEndpoint, a load call is made to DynamoDB to verify
#' that your endpoint configuration exists. When you read data from a
#' DynamoDB table supporting
#' [`Eventually Consistent Reads`](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html)
#' , the response might not reflect the results of a recently completed
#' write operation. The response might include some stale data. If the
#' dependent entities are not yet in DynamoDB, this causes a validation
#' error. If you repeat your read request after a short time, the response
#' should return the latest data. So retry logic is recommended to handle
#' these possible issues. We also recommend that customers call
#' DescribeEndpointConfig before calling CreateEndpoint to minimize the
#' potential impact of a DynamoDB eventually consistent read.
#'
#' @usage
#' sagemaker_create_endpoint_config(EndpointConfigName, ProductionVariants,
#'   DataCaptureConfig, Tags, KmsKeyId)
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration. You specify this name in a
#' CreateEndpoint request.
#' @param ProductionVariants &#91;required&#93; An list of `ProductionVariant` objects, one for each model that you want
#' to host at this endpoint.
#' @param DataCaptureConfig 
#' @param Tags A list of key-value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *AWS Billing and Cost Management User Guide*.
#' @param KmsKeyId The Amazon Resource Name (ARN) of a AWS Key Management Service key that
#' Amazon SageMaker uses to encrypt data on the storage volume attached to
#' the ML compute instance that hosts the endpoint.
#' 
#' The KmsKeyId can be any of the following formats:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias name ARN:
#'     `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
#' 
#' The KMS key policy must grant permission to the IAM role that you
#' specify in your `CreateEndpoint`, `UpdateEndpoint` requests. For more
#' information, refer to the AWS Key Management Service section [Using Key
#' Policies in AWS
#' KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
#' 
#' Certain Nitro-based instances include local storage, dependent on the
#' instance type. Local storage volumes are encrypted using a hardware
#' module on the instance. You can\'t request a `KmsKeyId` when using an
#' instance type with local storage. If any of the models that you specify
#' in the `ProductionVariants` parameter use nitro-based instances with
#' local storage, do not specify a value for the `KmsKeyId` parameter. If
#' you specify a value for `KmsKeyId` when using any nitro-based instances
#' with local storage, the call to `CreateEndpointConfig` fails.
#' 
#' For a list of instance types that support local instance storage, see
#' [Instance Store
#' Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
#' 
#' For more information about local instance storage encryption, see [SSD
#' Instance Store
#' Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_endpoint_config(
#'   EndpointConfigName = "string",
#'   ProductionVariants = list(
#'     list(
#'       VariantName = "string",
#'       ModelName = "string",
#'       InitialInstanceCount = 123,
#'       InstanceType = "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.m5d.large"|"ml.m5d.xlarge"|"ml.m5d.2xlarge"|"ml.m5d.4xlarge"|"ml.m5d.12xlarge"|"ml.m5d.24xlarge"|"ml.c4.large"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5d.large"|"ml.c5d.xlarge"|"ml.c5d.2xlarge"|"ml.c5d.4xlarge"|"ml.c5d.9xlarge"|"ml.c5d.18xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.12xlarge"|"ml.r5.24xlarge"|"ml.r5d.large"|"ml.r5d.xlarge"|"ml.r5d.2xlarge"|"ml.r5d.4xlarge"|"ml.r5d.12xlarge"|"ml.r5d.24xlarge"|"ml.inf1.xlarge"|"ml.inf1.2xlarge"|"ml.inf1.6xlarge"|"ml.inf1.24xlarge",
#'       InitialVariantWeight = 123.0,
#'       AcceleratorType = "ml.eia1.medium"|"ml.eia1.large"|"ml.eia1.xlarge"|"ml.eia2.medium"|"ml.eia2.large"|"ml.eia2.xlarge"
#'     )
#'   ),
#'   DataCaptureConfig = list(
#'     EnableCapture = TRUE|FALSE,
#'     InitialSamplingPercentage = 123,
#'     DestinationS3Uri = "string",
#'     KmsKeyId = "string",
#'     CaptureOptions = list(
#'       list(
#'         CaptureMode = "Input"|"Output"
#'       )
#'     ),
#'     CaptureContentTypeHeader = list(
#'       CsvContentTypes = list(
#'         "string"
#'       ),
#'       JsonContentTypes = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   KmsKeyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_endpoint_config
sagemaker_create_endpoint_config <- function(EndpointConfigName, ProductionVariants, DataCaptureConfig = NULL, Tags = NULL, KmsKeyId = NULL) {
  op <- new_operation(
    name = "CreateEndpointConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_endpoint_config_input(EndpointConfigName = EndpointConfigName, ProductionVariants = ProductionVariants, DataCaptureConfig = DataCaptureConfig, Tags = Tags, KmsKeyId = KmsKeyId)
  output <- .sagemaker$create_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_endpoint_config <- sagemaker_create_endpoint_config

#' Creates an Amazon SageMaker _experiment_
#'
#' Creates an Amazon SageMaker *experiment*. An experiment is a collection
#' of *trials* that are observed, compared and evaluated as a group. A
#' trial is a set of steps, called *trial components*, that produce a
#' machine learning model.
#' 
#' The goal of an experiment is to determine the components that produce
#' the best model. Multiple trials are performed, each one isolating and
#' measuring the impact of a change to one or more inputs, while keeping
#' the remaining inputs constant.
#' 
#' When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
#' all experiments, trials, and trial components are automatically tracked,
#' logged, and indexed. When you use the AWS SDK for Python (Boto), you
#' must use the logging APIs provided by the SDK.
#' 
#' You can add tags to experiments, trials, trial components and then use
#' the Search API to search for the tags.
#' 
#' To add a description to an experiment, specify the optional
#' `Description` parameter. To add a description later, or to change the
#' description, call the UpdateExperiment API.
#' 
#' To get a list of all your experiments, call the ListExperiments API. To
#' view an experiment\'s properties, call the DescribeExperiment API. To
#' get a list of all the trials associated with an experiment, call the
#' ListTrials API. To create a trial call the CreateTrial API.
#'
#' @usage
#' sagemaker_create_experiment(ExperimentName, DisplayName, Description,
#'   Tags)
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment. The name must be unique in your AWS account
#' and is not case-sensitive.
#' @param DisplayName The name of the experiment as displayed. The name doesn\'t need to be
#' unique. If you don\'t specify `DisplayName`, the value in
#' `ExperimentName` is displayed.
#' @param Description The description of the experiment.
#' @param Tags A list of tags to associate with the experiment. You can use Search API
#' to search on the tags.
#'
#' @section Request syntax:
#' ```
#' svc$create_experiment(
#'   ExperimentName = "string",
#'   DisplayName = "string",
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_experiment
sagemaker_create_experiment <- function(ExperimentName, DisplayName = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateExperiment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_experiment_input(ExperimentName = ExperimentName, DisplayName = DisplayName, Description = Description, Tags = Tags)
  output <- .sagemaker$create_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_experiment <- sagemaker_create_experiment

#' Creates a flow definition
#'
#' Creates a flow definition.
#'
#' @usage
#' sagemaker_create_flow_definition(FlowDefinitionName,
#'   HumanLoopRequestSource, HumanLoopActivationConfig, HumanLoopConfig,
#'   OutputConfig, RoleArn, Tags)
#'
#' @param FlowDefinitionName &#91;required&#93; The name of your flow definition.
#' @param HumanLoopRequestSource Container for configuring the source of human task requests. Use to
#' specify if Amazon Rekognition or Amazon Textract is used as an
#' integration source.
#' @param HumanLoopActivationConfig An object containing information about the events that trigger a human
#' workflow.
#' @param HumanLoopConfig &#91;required&#93; An object containing information about the tasks the human reviewers
#' will perform.
#' @param OutputConfig &#91;required&#93; An object containing information about where the human review results
#' will be uploaded.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role needed to call other services
#' on your behalf. For example,
#' `arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298`.
#' @param Tags An array of key-value pairs that contain metadata to help you categorize
#' and organize a flow definition. Each tag consists of a key and a value,
#' both of which you define.
#'
#' @section Request syntax:
#' ```
#' svc$create_flow_definition(
#'   FlowDefinitionName = "string",
#'   HumanLoopRequestSource = list(
#'     AwsManagedHumanLoopRequestSource = "AWS/Rekognition/DetectModerationLabels/Image/V3"|"AWS/Textract/AnalyzeDocument/Forms/V1"
#'   ),
#'   HumanLoopActivationConfig = list(
#'     HumanLoopActivationConditionsConfig = list(
#'       HumanLoopActivationConditions = "string"
#'     )
#'   ),
#'   HumanLoopConfig = list(
#'     WorkteamArn = "string",
#'     HumanTaskUiArn = "string",
#'     TaskTitle = "string",
#'     TaskDescription = "string",
#'     TaskCount = 123,
#'     TaskAvailabilityLifetimeInSeconds = 123,
#'     TaskTimeLimitInSeconds = 123,
#'     TaskKeywords = list(
#'       "string"
#'     ),
#'     PublicWorkforceTaskPrice = list(
#'       AmountInUsd = list(
#'         Dollars = 123,
#'         Cents = 123,
#'         TenthFractionsOfACent = 123
#'       )
#'     )
#'   ),
#'   OutputConfig = list(
#'     S3OutputPath = "string",
#'     KmsKeyId = "string"
#'   ),
#'   RoleArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_flow_definition
sagemaker_create_flow_definition <- function(FlowDefinitionName, HumanLoopRequestSource = NULL, HumanLoopActivationConfig = NULL, HumanLoopConfig, OutputConfig, RoleArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateFlowDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_flow_definition_input(FlowDefinitionName = FlowDefinitionName, HumanLoopRequestSource = HumanLoopRequestSource, HumanLoopActivationConfig = HumanLoopActivationConfig, HumanLoopConfig = HumanLoopConfig, OutputConfig = OutputConfig, RoleArn = RoleArn, Tags = Tags)
  output <- .sagemaker$create_flow_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_flow_definition <- sagemaker_create_flow_definition

#' Defines the settings you will use for the human review workflow user
#' interface
#'
#' Defines the settings you will use for the human review workflow user
#' interface. Reviewers will see a three-panel interface with an
#' instruction area, the item to review, and an input area.
#'
#' @usage
#' sagemaker_create_human_task_ui(HumanTaskUiName, UiTemplate, Tags)
#'
#' @param HumanTaskUiName &#91;required&#93; The name of the user interface you are creating.
#' @param UiTemplate &#91;required&#93; 
#' @param Tags An array of key-value pairs that contain metadata to help you categorize
#' and organize a human review workflow user interface. Each tag consists
#' of a key and a value, both of which you define.
#'
#' @section Request syntax:
#' ```
#' svc$create_human_task_ui(
#'   HumanTaskUiName = "string",
#'   UiTemplate = list(
#'     Content = "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_human_task_ui
sagemaker_create_human_task_ui <- function(HumanTaskUiName, UiTemplate, Tags = NULL) {
  op <- new_operation(
    name = "CreateHumanTaskUi",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_human_task_ui_input(HumanTaskUiName = HumanTaskUiName, UiTemplate = UiTemplate, Tags = Tags)
  output <- .sagemaker$create_human_task_ui_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_human_task_ui <- sagemaker_create_human_task_ui

#' Starts a hyperparameter tuning job
#'
#' Starts a hyperparameter tuning job. A hyperparameter tuning job finds
#' the best version of a model by running many training jobs on your
#' dataset using the algorithm you choose and values for hyperparameters
#' within ranges that you specify. It then chooses the hyperparameter
#' values that result in a model that performs the best, as measured by an
#' objective metric that you choose.
#'
#' @usage
#' sagemaker_create_hyper_parameter_tuning_job(HyperParameterTuningJobName,
#'   HyperParameterTuningJobConfig, TrainingJobDefinition,
#'   TrainingJobDefinitions, WarmStartConfig, Tags)
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job. This name is the prefix for the names of all
#' training jobs that this tuning job launches. The name must be unique
#' within the same AWS account and AWS Region. The name must have \{ \} to \{
#' \} characters. Valid characters are a-z, A-Z, 0-9, and : + = @@ \\_ % -
#' (hyphen). The name is not case sensitive.
#' @param HyperParameterTuningJobConfig &#91;required&#93; The HyperParameterTuningJobConfig object that describes the tuning job,
#' including the search strategy, the objective metric used to evaluate
#' training jobs, ranges of parameters to search, and resource limits for
#' the tuning job. For more information, see [How Hyperparameter Tuning
#' Works](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
#' @param TrainingJobDefinition The HyperParameterTrainingJobDefinition object that describes the
#' training jobs that this tuning job launches, including static
#' hyperparameters, input data configuration, output data configuration,
#' resource configuration, and stopping condition.
#' @param TrainingJobDefinitions A list of the HyperParameterTrainingJobDefinition objects launched for
#' this tuning job.
#' @param WarmStartConfig Specifies the configuration for starting the hyperparameter tuning job
#' using one or more previous tuning jobs as a starting point. The results
#' of previous tuning jobs are used to inform which combinations of
#' hyperparameters to search over in the new tuning job.
#' 
#' All training jobs launched by the new hyperparameter tuning job are
#' evaluated by using the objective metric. If you specify
#' `IDENTICAL_DATA_AND_ALGORITHM` as the `WarmStartType` value for the warm
#' start configuration, the training job that performs the best in the new
#' tuning job is compared to the best training jobs from the parent tuning
#' jobs. From these, the training job that performs the best as measured by
#' the objective metric is returned as the overall best training job.
#' 
#' All training jobs launched by parent hyperparameter tuning jobs and the
#' new hyperparameter tuning jobs count against the limit of training jobs
#' for the tuning job.
#' @param Tags An array of key-value pairs. You can use tags to categorize your AWS
#' resources in different ways, for example, by purpose, owner, or
#' environment. For more information, see [AWS Tagging
#' Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
#' 
#' Tags that you specify for the tuning job are also added to all training
#' jobs that the tuning job launches.
#'
#' @section Request syntax:
#' ```
#' svc$create_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName = "string",
#'   HyperParameterTuningJobConfig = list(
#'     Strategy = "Bayesian"|"Random",
#'     HyperParameterTuningJobObjective = list(
#'       Type = "Maximize"|"Minimize",
#'       MetricName = "string"
#'     ),
#'     ResourceLimits = list(
#'       MaxNumberOfTrainingJobs = 123,
#'       MaxParallelTrainingJobs = 123
#'     ),
#'     ParameterRanges = list(
#'       IntegerParameterRanges = list(
#'         list(
#'           Name = "string",
#'           MinValue = "string",
#'           MaxValue = "string",
#'           ScalingType = "Auto"|"Linear"|"Logarithmic"|"ReverseLogarithmic"
#'         )
#'       ),
#'       ContinuousParameterRanges = list(
#'         list(
#'           Name = "string",
#'           MinValue = "string",
#'           MaxValue = "string",
#'           ScalingType = "Auto"|"Linear"|"Logarithmic"|"ReverseLogarithmic"
#'         )
#'       ),
#'       CategoricalParameterRanges = list(
#'         list(
#'           Name = "string",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       )
#'     ),
#'     TrainingJobEarlyStoppingType = "Off"|"Auto",
#'     TuningJobCompletionCriteria = list(
#'       TargetObjectiveMetricValue = 123.0
#'     )
#'   ),
#'   TrainingJobDefinition = list(
#'     DefinitionName = "string",
#'     TuningObjective = list(
#'       Type = "Maximize"|"Minimize",
#'       MetricName = "string"
#'     ),
#'     HyperParameterRanges = list(
#'       IntegerParameterRanges = list(
#'         list(
#'           Name = "string",
#'           MinValue = "string",
#'           MaxValue = "string",
#'           ScalingType = "Auto"|"Linear"|"Logarithmic"|"ReverseLogarithmic"
#'         )
#'       ),
#'       ContinuousParameterRanges = list(
#'         list(
#'           Name = "string",
#'           MinValue = "string",
#'           MaxValue = "string",
#'           ScalingType = "Auto"|"Linear"|"Logarithmic"|"ReverseLogarithmic"
#'         )
#'       ),
#'       CategoricalParameterRanges = list(
#'         list(
#'           Name = "string",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       )
#'     ),
#'     StaticHyperParameters = list(
#'       "string"
#'     ),
#'     AlgorithmSpecification = list(
#'       TrainingImage = "string",
#'       TrainingInputMode = "Pipe"|"File",
#'       AlgorithmName = "string",
#'       MetricDefinitions = list(
#'         list(
#'           Name = "string",
#'           Regex = "string"
#'         )
#'       )
#'     ),
#'     RoleArn = "string",
#'     InputDataConfig = list(
#'       list(
#'         ChannelName = "string",
#'         DataSource = list(
#'           S3DataSource = list(
#'             S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'             S3Uri = "string",
#'             S3DataDistributionType = "FullyReplicated"|"ShardedByS3Key",
#'             AttributeNames = list(
#'               "string"
#'             )
#'           ),
#'           FileSystemDataSource = list(
#'             FileSystemId = "string",
#'             FileSystemAccessMode = "rw"|"ro",
#'             FileSystemType = "EFS"|"FSxLustre",
#'             DirectoryPath = "string"
#'           )
#'         ),
#'         ContentType = "string",
#'         CompressionType = "None"|"Gzip",
#'         RecordWrapperType = "None"|"RecordIO",
#'         InputMode = "Pipe"|"File",
#'         ShuffleConfig = list(
#'           Seed = 123
#'         )
#'       )
#'     ),
#'     VpcConfig = list(
#'       SecurityGroupIds = list(
#'         "string"
#'       ),
#'       Subnets = list(
#'         "string"
#'       )
#'     ),
#'     OutputDataConfig = list(
#'       KmsKeyId = "string",
#'       S3OutputPath = "string"
#'     ),
#'     ResourceConfig = list(
#'       InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.p3dn.24xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5n.xlarge"|"ml.c5n.2xlarge"|"ml.c5n.4xlarge"|"ml.c5n.9xlarge"|"ml.c5n.18xlarge",
#'       InstanceCount = 123,
#'       VolumeSizeInGB = 123,
#'       VolumeKmsKeyId = "string"
#'     ),
#'     StoppingCondition = list(
#'       MaxRuntimeInSeconds = 123,
#'       MaxWaitTimeInSeconds = 123
#'     ),
#'     EnableNetworkIsolation = TRUE|FALSE,
#'     EnableInterContainerTrafficEncryption = TRUE|FALSE,
#'     EnableManagedSpotTraining = TRUE|FALSE,
#'     CheckpointConfig = list(
#'       S3Uri = "string",
#'       LocalPath = "string"
#'     )
#'   ),
#'   TrainingJobDefinitions = list(
#'     list(
#'       DefinitionName = "string",
#'       TuningObjective = list(
#'         Type = "Maximize"|"Minimize",
#'         MetricName = "string"
#'       ),
#'       HyperParameterRanges = list(
#'         IntegerParameterRanges = list(
#'           list(
#'             Name = "string",
#'             MinValue = "string",
#'             MaxValue = "string",
#'             ScalingType = "Auto"|"Linear"|"Logarithmic"|"ReverseLogarithmic"
#'           )
#'         ),
#'         ContinuousParameterRanges = list(
#'           list(
#'             Name = "string",
#'             MinValue = "string",
#'             MaxValue = "string",
#'             ScalingType = "Auto"|"Linear"|"Logarithmic"|"ReverseLogarithmic"
#'           )
#'         ),
#'         CategoricalParameterRanges = list(
#'           list(
#'             Name = "string",
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       StaticHyperParameters = list(
#'         "string"
#'       ),
#'       AlgorithmSpecification = list(
#'         TrainingImage = "string",
#'         TrainingInputMode = "Pipe"|"File",
#'         AlgorithmName = "string",
#'         MetricDefinitions = list(
#'           list(
#'             Name = "string",
#'             Regex = "string"
#'           )
#'         )
#'       ),
#'       RoleArn = "string",
#'       InputDataConfig = list(
#'         list(
#'           ChannelName = "string",
#'           DataSource = list(
#'             S3DataSource = list(
#'               S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'               S3Uri = "string",
#'               S3DataDistributionType = "FullyReplicated"|"ShardedByS3Key",
#'               AttributeNames = list(
#'                 "string"
#'               )
#'             ),
#'             FileSystemDataSource = list(
#'               FileSystemId = "string",
#'               FileSystemAccessMode = "rw"|"ro",
#'               FileSystemType = "EFS"|"FSxLustre",
#'               DirectoryPath = "string"
#'             )
#'           ),
#'           ContentType = "string",
#'           CompressionType = "None"|"Gzip",
#'           RecordWrapperType = "None"|"RecordIO",
#'           InputMode = "Pipe"|"File",
#'           ShuffleConfig = list(
#'             Seed = 123
#'           )
#'         )
#'       ),
#'       VpcConfig = list(
#'         SecurityGroupIds = list(
#'           "string"
#'         ),
#'         Subnets = list(
#'           "string"
#'         )
#'       ),
#'       OutputDataConfig = list(
#'         KmsKeyId = "string",
#'         S3OutputPath = "string"
#'       ),
#'       ResourceConfig = list(
#'         InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.p3dn.24xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5n.xlarge"|"ml.c5n.2xlarge"|"ml.c5n.4xlarge"|"ml.c5n.9xlarge"|"ml.c5n.18xlarge",
#'         InstanceCount = 123,
#'         VolumeSizeInGB = 123,
#'         VolumeKmsKeyId = "string"
#'       ),
#'       StoppingCondition = list(
#'         MaxRuntimeInSeconds = 123,
#'         MaxWaitTimeInSeconds = 123
#'       ),
#'       EnableNetworkIsolation = TRUE|FALSE,
#'       EnableInterContainerTrafficEncryption = TRUE|FALSE,
#'       EnableManagedSpotTraining = TRUE|FALSE,
#'       CheckpointConfig = list(
#'         S3Uri = "string",
#'         LocalPath = "string"
#'       )
#'     )
#'   ),
#'   WarmStartConfig = list(
#'     ParentHyperParameterTuningJobs = list(
#'       list(
#'         HyperParameterTuningJobName = "string"
#'       )
#'     ),
#'     WarmStartType = "IdenticalDataAndAlgorithm"|"TransferLearning"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_hyper_parameter_tuning_job
sagemaker_create_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName, HyperParameterTuningJobConfig, TrainingJobDefinition = NULL, TrainingJobDefinitions = NULL, WarmStartConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName, HyperParameterTuningJobConfig = HyperParameterTuningJobConfig, TrainingJobDefinition = TrainingJobDefinition, TrainingJobDefinitions = TrainingJobDefinitions, WarmStartConfig = WarmStartConfig, Tags = Tags)
  output <- .sagemaker$create_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_hyper_parameter_tuning_job <- sagemaker_create_hyper_parameter_tuning_job

#' Creates a job that uses workers to label the data objects in your input
#' dataset
#'
#' Creates a job that uses workers to label the data objects in your input
#' dataset. You can use the labeled data to train machine learning models.
#' 
#' You can select your workforce from one of three providers:
#' 
#' -   A private workforce that you create. It can include employees,
#'     contractors, and outside experts. Use a private workforce when want
#'     the data to stay within your organization or when a specific set of
#'     skills is required.
#' 
#' -   One or more vendors that you select from the AWS Marketplace.
#'     Vendors provide expertise in specific areas.
#' 
#' -   The Amazon Mechanical Turk workforce. This is the largest workforce,
#'     but it should only be used for public data or data that has been
#'     stripped of any personally identifiable information.
#' 
#' You can also use *automated data labeling* to reduce the number of data
#' objects that need to be labeled by a human. Automated data labeling uses
#' *active learning* to determine if a data object can be labeled by
#' machine or if it needs to be sent to a human worker. For more
#' information, see [Using Automated Data
#' Labeling](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html).
#' 
#' The data objects to be labeled are contained in an Amazon S3 bucket. You
#' create a *manifest file* that describes the location of each object. For
#' more information, see [Using Input and Output
#' Data](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html).
#' 
#' The output can be used as the manifest file for another labeling job or
#' as training data for your machine learning models.
#'
#' @usage
#' sagemaker_create_labeling_job(LabelingJobName, LabelAttributeName,
#'   InputConfig, OutputConfig, RoleArn, LabelCategoryConfigS3Uri,
#'   StoppingConditions, LabelingJobAlgorithmsConfig, HumanTaskConfig, Tags)
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job. This name is used to identify the job in a
#' list of labeling jobs.
#' @param LabelAttributeName &#91;required&#93; The attribute name to use for the label in the output manifest file.
#' This is the key for the key/value pair formed with the label that a
#' worker assigns to the object. The name can\'t end with \"-metadata\". If
#' you are running a semantic segmentation labeling job, the attribute name
#' must end with \"-ref\". If you are running any other kind of labeling
#' job, the attribute name must not end with \"-ref\".
#' @param InputConfig &#91;required&#93; Input data for the labeling job, such as the Amazon S3 location of the
#' data objects and the location of the manifest file that describes the
#' data objects.
#' @param OutputConfig &#91;required&#93; The location of the output data and the AWS Key Management Service key
#' ID for the key used to encrypt the output data, if any.
#' @param RoleArn &#91;required&#93; The Amazon Resource Number (ARN) that Amazon SageMaker assumes to
#' perform tasks on your behalf during data labeling. You must grant this
#' role the necessary permissions so that Amazon SageMaker can successfully
#' complete data labeling.
#' @param LabelCategoryConfigS3Uri The S3 URL of the file that defines the categories used to label the
#' data objects.
#' 
#' For 3D point cloud task types, see [Create a Labeling Category
#' Configuration File for 3D Point Cloud Labeling
#' Jobs](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html).
#' 
#' For all other [built-in task
#' types](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html)
#' and [custom
#' tasks](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html),
#' your label category configuration file must be a JSON file in the
#' following format. Identify the labels you want to use by replacing
#' `label_1`, `label_2`,`...`,`label_n` with your label categories.
#' 
#' `\{`
#' 
#' ` "document-version": "2018-11-28"`
#' 
#' ` "labels": \\[`
#' 
#' ` \{`
#' 
#' ` "label": "<i>label_1</i>"`
#' 
#' ` \},`
#' 
#' ` \{`
#' 
#' ` "label": "<i>label_2</i>"`
#' 
#' ` \},`
#' 
#' ` ...`
#' 
#' ` \{`
#' 
#' ` "label": "<i>label_n</i>"`
#' 
#' ` \}`
#' 
#' ` \\]`
#' 
#' `\}`
#' @param StoppingConditions A set of conditions for stopping the labeling job. If any of the
#' conditions are met, the job is automatically stopped. You can use these
#' conditions to control the cost of data labeling.
#' @param LabelingJobAlgorithmsConfig Configures the information required to perform automated data labeling.
#' @param HumanTaskConfig &#91;required&#93; Configures the labeling task and how it is presented to workers;
#' including, but not limited to price, keywords, and batch size (task
#' count).
#' @param Tags An array of key/value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *AWS Billing and Cost Management User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_labeling_job(
#'   LabelingJobName = "string",
#'   LabelAttributeName = "string",
#'   InputConfig = list(
#'     DataSource = list(
#'       S3DataSource = list(
#'         ManifestS3Uri = "string"
#'       )
#'     ),
#'     DataAttributes = list(
#'       ContentClassifiers = list(
#'         "FreeOfPersonallyIdentifiableInformation"|"FreeOfAdultContent"
#'       )
#'     )
#'   ),
#'   OutputConfig = list(
#'     S3OutputPath = "string",
#'     KmsKeyId = "string"
#'   ),
#'   RoleArn = "string",
#'   LabelCategoryConfigS3Uri = "string",
#'   StoppingConditions = list(
#'     MaxHumanLabeledObjectCount = 123,
#'     MaxPercentageOfInputDatasetLabeled = 123
#'   ),
#'   LabelingJobAlgorithmsConfig = list(
#'     LabelingJobAlgorithmSpecificationArn = "string",
#'     InitialActiveLearningModelArn = "string",
#'     LabelingJobResourceConfig = list(
#'       VolumeKmsKeyId = "string"
#'     )
#'   ),
#'   HumanTaskConfig = list(
#'     WorkteamArn = "string",
#'     UiConfig = list(
#'       UiTemplateS3Uri = "string",
#'       HumanTaskUiArn = "string"
#'     ),
#'     PreHumanTaskLambdaArn = "string",
#'     TaskKeywords = list(
#'       "string"
#'     ),
#'     TaskTitle = "string",
#'     TaskDescription = "string",
#'     NumberOfHumanWorkersPerDataObject = 123,
#'     TaskTimeLimitInSeconds = 123,
#'     TaskAvailabilityLifetimeInSeconds = 123,
#'     MaxConcurrentTaskCount = 123,
#'     AnnotationConsolidationConfig = list(
#'       AnnotationConsolidationLambdaArn = "string"
#'     ),
#'     PublicWorkforceTaskPrice = list(
#'       AmountInUsd = list(
#'         Dollars = 123,
#'         Cents = 123,
#'         TenthFractionsOfACent = 123
#'       )
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_labeling_job
sagemaker_create_labeling_job <- function(LabelingJobName, LabelAttributeName, InputConfig, OutputConfig, RoleArn, LabelCategoryConfigS3Uri = NULL, StoppingConditions = NULL, LabelingJobAlgorithmsConfig = NULL, HumanTaskConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateLabelingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_labeling_job_input(LabelingJobName = LabelingJobName, LabelAttributeName = LabelAttributeName, InputConfig = InputConfig, OutputConfig = OutputConfig, RoleArn = RoleArn, LabelCategoryConfigS3Uri = LabelCategoryConfigS3Uri, StoppingConditions = StoppingConditions, LabelingJobAlgorithmsConfig = LabelingJobAlgorithmsConfig, HumanTaskConfig = HumanTaskConfig, Tags = Tags)
  output <- .sagemaker$create_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_labeling_job <- sagemaker_create_labeling_job

#' Creates a model in Amazon SageMaker
#'
#' Creates a model in Amazon SageMaker. In the request, you name the model
#' and describe a primary container. For the primary container, you specify
#' the Docker image that contains inference code, artifacts (from prior
#' training), and a custom environment map that the inference code uses
#' when you deploy the model for predictions.
#' 
#' Use this API to create a model if you want to use Amazon SageMaker
#' hosting services or run a batch transform job.
#' 
#' To host your model, you create an endpoint configuration with the
#' `CreateEndpointConfig` API, and then create an endpoint with the
#' `CreateEndpoint` API. Amazon SageMaker then deploys all of the
#' containers that you defined for the model in the hosting environment.
#' 
#' For an example that calls this method when deploying a model to Amazon
#' SageMaker hosting services, see [Deploy the Model to Amazon SageMaker
#' Hosting Services (AWS SDK for Python (Boto
#' 3)).](https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
#' 
#' To run a batch transform using your model, you start a job with the
#' `CreateTransformJob` API. Amazon SageMaker uses your model and your
#' dataset to get inferences which are then saved to a specified S3
#' location.
#' 
#' In the `CreateModel` request, you must define a container with the
#' `PrimaryContainer` parameter.
#' 
#' In the request, you also provide an IAM role that Amazon SageMaker can
#' assume to access model artifacts and docker image for deployment on ML
#' compute hosting instances or for batch transform jobs. In addition, you
#' also use the IAM role to manage permissions the inference code needs.
#' For example, if the inference code access any other AWS resources, you
#' grant necessary permissions via this role.
#'
#' @usage
#' sagemaker_create_model(ModelName, PrimaryContainer, Containers,
#'   ExecutionRoleArn, Tags, VpcConfig, EnableNetworkIsolation)
#'
#' @param ModelName &#91;required&#93; The name of the new model.
#' @param PrimaryContainer The location of the primary docker image containing inference code,
#' associated artifacts, and custom environment map that the inference code
#' uses when the model is deployed for predictions.
#' @param Containers Specifies the containers in the inference pipeline.
#' @param ExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can
#' assume to access model artifacts and docker image for deployment on ML
#' compute instances or for batch transform jobs. Deploying on ML compute
#' instances is part of model hosting. For more information, see [Amazon
#' SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to Amazon SageMaker, the caller of this API
#' must have the `iam:PassRole` permission.
#' @param Tags An array of key-value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *AWS Billing and Cost Management User Guide*.
#' @param VpcConfig A VpcConfig object that specifies the VPC that you want your model to
#' connect to. Control access to and from your model container by
#' configuring the VPC. `VpcConfig` is used in hosting services and in
#' batch transform. For more information, see [Protect Endpoints by Using
#' an Amazon Virtual Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
#' and [Protect Data in Batch Transform Jobs by Using an Amazon Virtual
#' Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html).
#' @param EnableNetworkIsolation Isolates the model container. No inbound or outbound network calls can
#' be made to or from the model container.
#'
#' @section Request syntax:
#' ```
#' svc$create_model(
#'   ModelName = "string",
#'   PrimaryContainer = list(
#'     ContainerHostname = "string",
#'     Image = "string",
#'     Mode = "SingleModel"|"MultiModel",
#'     ModelDataUrl = "string",
#'     Environment = list(
#'       "string"
#'     ),
#'     ModelPackageName = "string"
#'   ),
#'   Containers = list(
#'     list(
#'       ContainerHostname = "string",
#'       Image = "string",
#'       Mode = "SingleModel"|"MultiModel",
#'       ModelDataUrl = "string",
#'       Environment = list(
#'         "string"
#'       ),
#'       ModelPackageName = "string"
#'     )
#'   ),
#'   ExecutionRoleArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   ),
#'   EnableNetworkIsolation = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model
sagemaker_create_model <- function(ModelName, PrimaryContainer = NULL, Containers = NULL, ExecutionRoleArn, Tags = NULL, VpcConfig = NULL, EnableNetworkIsolation = NULL) {
  op <- new_operation(
    name = "CreateModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_model_input(ModelName = ModelName, PrimaryContainer = PrimaryContainer, Containers = Containers, ExecutionRoleArn = ExecutionRoleArn, Tags = Tags, VpcConfig = VpcConfig, EnableNetworkIsolation = EnableNetworkIsolation)
  output <- .sagemaker$create_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model <- sagemaker_create_model

#' Creates a model package that you can use to create Amazon SageMaker
#' models or list on AWS Marketplace
#'
#' Creates a model package that you can use to create Amazon SageMaker
#' models or list on AWS Marketplace. Buyers can subscribe to model
#' packages listed on AWS Marketplace to create models in Amazon SageMaker.
#' 
#' To create a model package by specifying a Docker container that contains
#' your inference code and the Amazon S3 location of your model artifacts,
#' provide values for `InferenceSpecification`. To create a model from an
#' algorithm resource that you created or subscribed to in AWS Marketplace,
#' provide a value for `SourceAlgorithmSpecification`.
#'
#' @usage
#' sagemaker_create_model_package(ModelPackageName,
#'   ModelPackageDescription, InferenceSpecification,
#'   ValidationSpecification, SourceAlgorithmSpecification,
#'   CertifyForMarketplace)
#'
#' @param ModelPackageName &#91;required&#93; The name of the model package. The name must have 1 to 63 characters.
#' Valid characters are a-z, A-Z, 0-9, and - (hyphen).
#' @param ModelPackageDescription A description of the model package.
#' @param InferenceSpecification Specifies details about inference jobs that can be run with models based
#' on this model package, including the following:
#' 
#' -   The Amazon ECR paths of containers that contain the inference code
#'     and model artifacts.
#' 
#' -   The instance types that the model package supports for transform
#'     jobs and real-time endpoints used for inference.
#' 
#' -   The input and output content formats that the model package supports
#'     for inference.
#' @param ValidationSpecification Specifies configurations for one or more transform jobs that Amazon
#' SageMaker runs to test the model package.
#' @param SourceAlgorithmSpecification Details about the algorithm that was used to create the model package.
#' @param CertifyForMarketplace Whether to certify the model package for listing on AWS Marketplace.
#'
#' @section Request syntax:
#' ```
#' svc$create_model_package(
#'   ModelPackageName = "string",
#'   ModelPackageDescription = "string",
#'   InferenceSpecification = list(
#'     Containers = list(
#'       list(
#'         ContainerHostname = "string",
#'         Image = "string",
#'         ImageDigest = "string",
#'         ModelDataUrl = "string",
#'         ProductId = "string"
#'       )
#'     ),
#'     SupportedTransformInstanceTypes = list(
#'       "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"
#'     ),
#'     SupportedRealtimeInferenceInstanceTypes = list(
#'       "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.m5d.large"|"ml.m5d.xlarge"|"ml.m5d.2xlarge"|"ml.m5d.4xlarge"|"ml.m5d.12xlarge"|"ml.m5d.24xlarge"|"ml.c4.large"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5d.large"|"ml.c5d.xlarge"|"ml.c5d.2xlarge"|"ml.c5d.4xlarge"|"ml.c5d.9xlarge"|"ml.c5d.18xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.12xlarge"|"ml.r5.24xlarge"|"ml.r5d.large"|"ml.r5d.xlarge"|"ml.r5d.2xlarge"|"ml.r5d.4xlarge"|"ml.r5d.12xlarge"|"ml.r5d.24xlarge"|"ml.inf1.xlarge"|"ml.inf1.2xlarge"|"ml.inf1.6xlarge"|"ml.inf1.24xlarge"
#'     ),
#'     SupportedContentTypes = list(
#'       "string"
#'     ),
#'     SupportedResponseMIMETypes = list(
#'       "string"
#'     )
#'   ),
#'   ValidationSpecification = list(
#'     ValidationRole = "string",
#'     ValidationProfiles = list(
#'       list(
#'         ProfileName = "string",
#'         TransformJobDefinition = list(
#'           MaxConcurrentTransforms = 123,
#'           MaxPayloadInMB = 123,
#'           BatchStrategy = "MultiRecord"|"SingleRecord",
#'           Environment = list(
#'             "string"
#'           ),
#'           TransformInput = list(
#'             DataSource = list(
#'               S3DataSource = list(
#'                 S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'                 S3Uri = "string"
#'               )
#'             ),
#'             ContentType = "string",
#'             CompressionType = "None"|"Gzip",
#'             SplitType = "None"|"Line"|"RecordIO"|"TFRecord"
#'           ),
#'           TransformOutput = list(
#'             S3OutputPath = "string",
#'             Accept = "string",
#'             AssembleWith = "None"|"Line",
#'             KmsKeyId = "string"
#'           ),
#'           TransformResources = list(
#'             InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge",
#'             InstanceCount = 123,
#'             VolumeKmsKeyId = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   SourceAlgorithmSpecification = list(
#'     SourceAlgorithms = list(
#'       list(
#'         ModelDataUrl = "string",
#'         AlgorithmName = "string"
#'       )
#'     )
#'   ),
#'   CertifyForMarketplace = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_package
sagemaker_create_model_package <- function(ModelPackageName, ModelPackageDescription = NULL, InferenceSpecification = NULL, ValidationSpecification = NULL, SourceAlgorithmSpecification = NULL, CertifyForMarketplace = NULL) {
  op <- new_operation(
    name = "CreateModelPackage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_model_package_input(ModelPackageName = ModelPackageName, ModelPackageDescription = ModelPackageDescription, InferenceSpecification = InferenceSpecification, ValidationSpecification = ValidationSpecification, SourceAlgorithmSpecification = SourceAlgorithmSpecification, CertifyForMarketplace = CertifyForMarketplace)
  output <- .sagemaker$create_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_package <- sagemaker_create_model_package

#' Creates a schedule that regularly starts Amazon SageMaker Processing
#' Jobs to monitor the data captured for an Amazon SageMaker Endoint
#'
#' Creates a schedule that regularly starts Amazon SageMaker Processing
#' Jobs to monitor the data captured for an Amazon SageMaker Endoint.
#'
#' @usage
#' sagemaker_create_monitoring_schedule(MonitoringScheduleName,
#'   MonitoringScheduleConfig, Tags)
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the monitoring schedule. The name must be unique within an
#' AWS Region within an AWS account.
#' @param MonitoringScheduleConfig &#91;required&#93; The configuration object that specifies the monitoring schedule and
#' defines the monitoring job.
#' @param Tags (Optional) An array of key-value pairs. For more information, see Using
#' Cost Allocation Tags in the *AWS Billing and Cost Management User
#' Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_monitoring_schedule(
#'   MonitoringScheduleName = "string",
#'   MonitoringScheduleConfig = list(
#'     ScheduleConfig = list(
#'       ScheduleExpression = "string"
#'     ),
#'     MonitoringJobDefinition = list(
#'       BaselineConfig = list(
#'         ConstraintsResource = list(
#'           S3Uri = "string"
#'         ),
#'         StatisticsResource = list(
#'           S3Uri = "string"
#'         )
#'       ),
#'       MonitoringInputs = list(
#'         list(
#'           EndpointInput = list(
#'             EndpointName = "string",
#'             LocalPath = "string",
#'             S3InputMode = "Pipe"|"File",
#'             S3DataDistributionType = "FullyReplicated"|"ShardedByS3Key"
#'           )
#'         )
#'       ),
#'       MonitoringOutputConfig = list(
#'         MonitoringOutputs = list(
#'           list(
#'             S3Output = list(
#'               S3Uri = "string",
#'               LocalPath = "string",
#'               S3UploadMode = "Continuous"|"EndOfJob"
#'             )
#'           )
#'         ),
#'         KmsKeyId = "string"
#'       ),
#'       MonitoringResources = list(
#'         ClusterConfig = list(
#'           InstanceCount = 123,
#'           InstanceType = "ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.8xlarge"|"ml.r5.12xlarge"|"ml.r5.16xlarge"|"ml.r5.24xlarge",
#'           VolumeSizeInGB = 123,
#'           VolumeKmsKeyId = "string"
#'         )
#'       ),
#'       MonitoringAppSpecification = list(
#'         ImageUri = "string",
#'         ContainerEntrypoint = list(
#'           "string"
#'         ),
#'         ContainerArguments = list(
#'           "string"
#'         ),
#'         RecordPreprocessorSourceUri = "string",
#'         PostAnalyticsProcessorSourceUri = "string"
#'       ),
#'       StoppingCondition = list(
#'         MaxRuntimeInSeconds = 123
#'       ),
#'       Environment = list(
#'         "string"
#'       ),
#'       NetworkConfig = list(
#'         EnableInterContainerTrafficEncryption = TRUE|FALSE,
#'         EnableNetworkIsolation = TRUE|FALSE,
#'         VpcConfig = list(
#'           SecurityGroupIds = list(
#'             "string"
#'           ),
#'           Subnets = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       RoleArn = "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_monitoring_schedule
sagemaker_create_monitoring_schedule <- function(MonitoringScheduleName, MonitoringScheduleConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName, MonitoringScheduleConfig = MonitoringScheduleConfig, Tags = Tags)
  output <- .sagemaker$create_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_monitoring_schedule <- sagemaker_create_monitoring_schedule

#' Creates an Amazon SageMaker notebook instance
#'
#' Creates an Amazon SageMaker notebook instance. A notebook instance is a
#' machine learning (ML) compute instance running on a Jupyter notebook.
#' 
#' In a `CreateNotebookInstance` request, specify the type of ML compute
#' instance that you want to run. Amazon SageMaker launches the instance,
#' installs common libraries that you can use to explore datasets for model
#' training, and attaches an ML storage volume to the notebook instance.
#' 
#' Amazon SageMaker also provides a set of example notebooks. Each notebook
#' demonstrates how to use Amazon SageMaker with a specific algorithm or
#' with a machine learning framework.
#' 
#' After receiving the request, Amazon SageMaker does the following:
#' 
#' 1.  Creates a network interface in the Amazon SageMaker VPC.
#' 
#' 2.  (Option) If you specified `SubnetId`, Amazon SageMaker creates a
#'     network interface in your own VPC, which is inferred from the subnet
#'     ID that you provide in the input. When creating this network
#'     interface, Amazon SageMaker attaches the security group that you
#'     specified in the request to the network interface that it creates in
#'     your VPC.
#' 
#' 3.  Launches an EC2 instance of the type specified in the request in the
#'     Amazon SageMaker VPC. If you specified `SubnetId` of your VPC,
#'     Amazon SageMaker specifies both network interfaces when launching
#'     this instance. This enables inbound traffic from your own VPC to the
#'     notebook instance, assuming that the security groups allow it.
#' 
#' After creating the notebook instance, Amazon SageMaker returns its
#' Amazon Resource Name (ARN). You can\'t change the name of a notebook
#' instance after you create it.
#' 
#' After Amazon SageMaker creates the notebook instance, you can connect to
#' the Jupyter server and work in Jupyter notebooks. For example, you can
#' write code to explore a dataset that you can use for model training,
#' train a model, host models by creating Amazon SageMaker endpoints, and
#' validate hosted models.
#' 
#' For more information, see [How It
#' Works](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
#'
#' @usage
#' sagemaker_create_notebook_instance(NotebookInstanceName, InstanceType,
#'   SubnetId, SecurityGroupIds, RoleArn, KmsKeyId, Tags,
#'   LifecycleConfigName, DirectInternetAccess, VolumeSizeInGB,
#'   AcceleratorTypes, DefaultCodeRepository, AdditionalCodeRepositories,
#'   RootAccess)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the new notebook instance.
#' @param InstanceType &#91;required&#93; The type of ML compute instance to launch for the notebook instance.
#' @param SubnetId The ID of the subnet in a VPC to which you would like to have a
#' connectivity from your ML compute instance.
#' @param SecurityGroupIds The VPC security group IDs, in the form sg-xxxxxxxx. The security groups
#' must be for the same VPC as specified in the subnet.
#' @param RoleArn &#91;required&#93; When you send any requests to AWS resources from the notebook instance,
#' Amazon SageMaker assumes this role to perform tasks on your behalf. You
#' must grant this role necessary permissions so Amazon SageMaker can
#' perform these tasks. The policy must allow the Amazon SageMaker service
#' principal (sagemaker.amazonaws.com) permissions to assume this role. For
#' more information, see [Amazon SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to Amazon SageMaker, the caller of this API
#' must have the `iam:PassRole` permission.
#' @param KmsKeyId The Amazon Resource Name (ARN) of a AWS Key Management Service key that
#' Amazon SageMaker uses to encrypt data on the storage volume attached to
#' your notebook instance. The KMS key you provide must be enabled. For
#' information, see [Enabling and Disabling
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html)
#' in the *AWS Key Management Service Developer Guide*.
#' @param Tags A list of tags to associate with the notebook instance. You can add tags
#' later by using the `CreateTags` API.
#' @param LifecycleConfigName The name of a lifecycle configuration to associate with the notebook
#' instance. For information about lifestyle configurations, see [Step 2.1:
#' (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#' @param DirectInternetAccess Sets whether Amazon SageMaker provides internet access to the notebook
#' instance. If you set this to `Disabled` this notebook instance will be
#' able to access resources only in your VPC, and will not be able to
#' connect to Amazon SageMaker training and endpoint services unless your
#' configure a NAT Gateway in your VPC.
#' 
#' For more information, see [Notebook Instances Are Internet-Enabled by
#' Default](https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access).
#' You can set the value of this parameter to `Disabled` only if you set a
#' value for the `SubnetId` parameter.
#' @param VolumeSizeInGB The size, in GB, of the ML storage volume to attach to the notebook
#' instance. The default value is 5 GB.
#' @param AcceleratorTypes A list of Elastic Inference (EI) instance types to associate with this
#' notebook instance. Currently, only one instance type can be associated
#' with a notebook instance. For more information, see [Using Elastic
#' Inference in Amazon
#' SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
#' @param DefaultCodeRepository A Git repository to associate with the notebook instance as its default
#' code repository. This can be either the name of a Git repository stored
#' as a resource in your account, or the URL of a Git repository in [AWS
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. When you open a notebook instance, it
#' opens in the directory that contains this repository. For more
#' information, see [Associating Git Repositories with Amazon SageMaker
#' Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AdditionalCodeRepositories An array of up to three Git repositories to associate with the notebook
#' instance. These can be either the names of Git repositories stored as
#' resources in your account, or the URL of Git repositories in [AWS
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. These repositories are cloned at the
#' same level as the default repository of your notebook instance. For more
#' information, see [Associating Git Repositories with Amazon SageMaker
#' Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param RootAccess Whether root access is enabled or disabled for users of the notebook
#' instance. The default value is `Enabled`.
#' 
#' Lifecycle configurations need root access to be able to set up a
#' notebook instance. Because of this, lifecycle configurations associated
#' with a notebook instance always run with root access even if you disable
#' root access for users.
#'
#' @section Request syntax:
#' ```
#' svc$create_notebook_instance(
#'   NotebookInstanceName = "string",
#'   InstanceType = "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5d.xlarge"|"ml.c5d.2xlarge"|"ml.c5d.4xlarge"|"ml.c5d.9xlarge"|"ml.c5d.18xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge",
#'   SubnetId = "string",
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   RoleArn = "string",
#'   KmsKeyId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   LifecycleConfigName = "string",
#'   DirectInternetAccess = "Enabled"|"Disabled",
#'   VolumeSizeInGB = 123,
#'   AcceleratorTypes = list(
#'     "ml.eia1.medium"|"ml.eia1.large"|"ml.eia1.xlarge"|"ml.eia2.medium"|"ml.eia2.large"|"ml.eia2.xlarge"
#'   ),
#'   DefaultCodeRepository = "string",
#'   AdditionalCodeRepositories = list(
#'     "string"
#'   ),
#'   RootAccess = "Enabled"|"Disabled"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_notebook_instance
sagemaker_create_notebook_instance <- function(NotebookInstanceName, InstanceType, SubnetId = NULL, SecurityGroupIds = NULL, RoleArn, KmsKeyId = NULL, Tags = NULL, LifecycleConfigName = NULL, DirectInternetAccess = NULL, VolumeSizeInGB = NULL, AcceleratorTypes = NULL, DefaultCodeRepository = NULL, AdditionalCodeRepositories = NULL, RootAccess = NULL) {
  op <- new_operation(
    name = "CreateNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_notebook_instance_input(NotebookInstanceName = NotebookInstanceName, InstanceType = InstanceType, SubnetId = SubnetId, SecurityGroupIds = SecurityGroupIds, RoleArn = RoleArn, KmsKeyId = KmsKeyId, Tags = Tags, LifecycleConfigName = LifecycleConfigName, DirectInternetAccess = DirectInternetAccess, VolumeSizeInGB = VolumeSizeInGB, AcceleratorTypes = AcceleratorTypes, DefaultCodeRepository = DefaultCodeRepository, AdditionalCodeRepositories = AdditionalCodeRepositories, RootAccess = RootAccess)
  output <- .sagemaker$create_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_notebook_instance <- sagemaker_create_notebook_instance

#' Creates a lifecycle configuration that you can associate with a notebook
#' instance
#'
#' Creates a lifecycle configuration that you can associate with a notebook
#' instance. A *lifecycle configuration* is a collection of shell scripts
#' that run when you create or start a notebook instance.
#' 
#' Each lifecycle configuration script has a limit of 16384 characters.
#' 
#' The value of the `$PATH` environment variable that is available to both
#' scripts is `/sbin:bin:/usr/sbin:/usr/bin`.
#' 
#' View CloudWatch Logs for notebook instance lifecycle configurations in
#' log group `/aws/sagemaker/NotebookInstances` in log stream
#' `\\[notebook-instance-name\\]/\\[LifecycleConfigHook\\]`.
#' 
#' Lifecycle configuration scripts cannot run for longer than 5 minutes. If
#' a script runs for longer than 5 minutes, it fails and the notebook
#' instance is not created or started.
#' 
#' For information about notebook instance lifestyle configurations, see
#' [Step 2.1: (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#'
#' @usage
#' sagemaker_create_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName, OnCreate, OnStart)
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration.
#' @param OnCreate A shell script that runs only once, when you create a notebook instance.
#' The shell script must be a base64-encoded string.
#' @param OnStart A shell script that runs every time you start a notebook instance,
#' including when you create the notebook instance. The shell script must
#' be a base64-encoded string.
#'
#' @section Request syntax:
#' ```
#' svc$create_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName = "string",
#'   OnCreate = list(
#'     list(
#'       Content = "string"
#'     )
#'   ),
#'   OnStart = list(
#'     list(
#'       Content = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_notebook_instance_lifecycle_config
sagemaker_create_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName, OnCreate = NULL, OnStart = NULL) {
  op <- new_operation(
    name = "CreateNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName, OnCreate = OnCreate, OnStart = OnStart)
  output <- .sagemaker$create_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_notebook_instance_lifecycle_config <- sagemaker_create_notebook_instance_lifecycle_config

#' Creates a URL for a specified UserProfile in a Domain
#'
#' Creates a URL for a specified UserProfile in a Domain. When accessed in
#' a web browser, the user will be automatically signed in to Amazon
#' SageMaker Studio, and granted access to all of the Apps and files
#' associated with the Domain\'s Amazon Elastic File System (EFS) volume.
#' This operation can only be called when the authentication mode equals
#' IAM.
#'
#' @usage
#' sagemaker_create_presigned_domain_url(DomainId, UserProfileName,
#'   SessionExpirationDurationInSeconds)
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The name of the UserProfile to sign-in as.
#' @param SessionExpirationDurationInSeconds The session expiration duration in seconds.
#'
#' @section Request syntax:
#' ```
#' svc$create_presigned_domain_url(
#'   DomainId = "string",
#'   UserProfileName = "string",
#'   SessionExpirationDurationInSeconds = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_presigned_domain_url
sagemaker_create_presigned_domain_url <- function(DomainId, UserProfileName, SessionExpirationDurationInSeconds = NULL) {
  op <- new_operation(
    name = "CreatePresignedDomainUrl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_presigned_domain_url_input(DomainId = DomainId, UserProfileName = UserProfileName, SessionExpirationDurationInSeconds = SessionExpirationDurationInSeconds)
  output <- .sagemaker$create_presigned_domain_url_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_presigned_domain_url <- sagemaker_create_presigned_domain_url

#' Returns a URL that you can use to connect to the Jupyter server from a
#' notebook instance
#'
#' Returns a URL that you can use to connect to the Jupyter server from a
#' notebook instance. In the Amazon SageMaker console, when you choose
#' `Open` next to a notebook instance, Amazon SageMaker opens a new tab
#' showing the Jupyter server home page from the notebook instance. The
#' console uses this API to get the URL and show the page.
#' 
#' The IAM role or user used to call this API defines the permissions to
#' access the notebook instance. Once the presigned URL is created, no
#' additional permission is required to access this URL. IAM authorization
#' policies for this API are also enforced for every HTTP request and
#' WebSocket frame that attempts to connect to the notebook instance.
#' 
#' You can restrict access to this API and to the URL that it returns to a
#' list of IP addresses that you specify. Use the `NotIpAddress` condition
#' operator and the `aws:SourceIP` condition context key to specify the
#' list of IP addresses that you want to have access to the notebook
#' instance. For more information, see [Limit Access to a Notebook Instance
#' by IP
#' Address](https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter).
#' 
#' The URL that you get from a call to CreatePresignedNotebookInstanceUrl
#' is valid only for 5 minutes. If you try to use the URL after the
#' 5-minute limit expires, you are directed to the AWS console sign-in
#' page.
#'
#' @usage
#' sagemaker_create_presigned_notebook_instance_url(NotebookInstanceName,
#'   SessionExpirationDurationInSeconds)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance.
#' @param SessionExpirationDurationInSeconds The duration of the session, in seconds. The default is 12 hours.
#'
#' @section Request syntax:
#' ```
#' svc$create_presigned_notebook_instance_url(
#'   NotebookInstanceName = "string",
#'   SessionExpirationDurationInSeconds = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_presigned_notebook_instance_url
sagemaker_create_presigned_notebook_instance_url <- function(NotebookInstanceName, SessionExpirationDurationInSeconds = NULL) {
  op <- new_operation(
    name = "CreatePresignedNotebookInstanceUrl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_presigned_notebook_instance_url_input(NotebookInstanceName = NotebookInstanceName, SessionExpirationDurationInSeconds = SessionExpirationDurationInSeconds)
  output <- .sagemaker$create_presigned_notebook_instance_url_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_presigned_notebook_instance_url <- sagemaker_create_presigned_notebook_instance_url

#' Creates a processing job
#'
#' Creates a processing job.
#'
#' @usage
#' sagemaker_create_processing_job(ProcessingInputs,
#'   ProcessingOutputConfig, ProcessingJobName, ProcessingResources,
#'   StoppingCondition, AppSpecification, Environment, NetworkConfig,
#'   RoleArn, Tags, ExperimentConfig)
#'
#' @param ProcessingInputs For each input, data is downloaded from S3 into the processing container
#' before the processing job begins running if \"S3InputMode\" is set to
#' `File`.
#' @param ProcessingOutputConfig Output configuration for the processing job.
#' @param ProcessingJobName &#91;required&#93; The name of the processing job. The name must be unique within an AWS
#' Region in the AWS account.
#' @param ProcessingResources &#91;required&#93; Identifies the resources, ML compute instances, and ML storage volumes
#' to deploy for a processing job. In distributed training, you specify
#' more than one instance.
#' @param StoppingCondition The time limit for how long the processing job is allowed to run.
#' @param AppSpecification &#91;required&#93; Configures the processing job to run a specified Docker container image.
#' @param Environment Sets the environment variables in the Docker container.
#' @param NetworkConfig Networking options for a processing job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can
#' assume to perform tasks on your behalf.
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
#' in the *AWS Billing and Cost Management User Guide*.
#' @param ExperimentConfig 
#'
#' @section Request syntax:
#' ```
#' svc$create_processing_job(
#'   ProcessingInputs = list(
#'     list(
#'       InputName = "string",
#'       S3Input = list(
#'         S3Uri = "string",
#'         LocalPath = "string",
#'         S3DataType = "ManifestFile"|"S3Prefix",
#'         S3InputMode = "Pipe"|"File",
#'         S3DataDistributionType = "FullyReplicated"|"ShardedByS3Key",
#'         S3CompressionType = "None"|"Gzip"
#'       )
#'     )
#'   ),
#'   ProcessingOutputConfig = list(
#'     Outputs = list(
#'       list(
#'         OutputName = "string",
#'         S3Output = list(
#'           S3Uri = "string",
#'           LocalPath = "string",
#'           S3UploadMode = "Continuous"|"EndOfJob"
#'         )
#'       )
#'     ),
#'     KmsKeyId = "string"
#'   ),
#'   ProcessingJobName = "string",
#'   ProcessingResources = list(
#'     ClusterConfig = list(
#'       InstanceCount = 123,
#'       InstanceType = "ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.8xlarge"|"ml.r5.12xlarge"|"ml.r5.16xlarge"|"ml.r5.24xlarge",
#'       VolumeSizeInGB = 123,
#'       VolumeKmsKeyId = "string"
#'     )
#'   ),
#'   StoppingCondition = list(
#'     MaxRuntimeInSeconds = 123
#'   ),
#'   AppSpecification = list(
#'     ImageUri = "string",
#'     ContainerEntrypoint = list(
#'       "string"
#'     ),
#'     ContainerArguments = list(
#'       "string"
#'     )
#'   ),
#'   Environment = list(
#'     "string"
#'   ),
#'   NetworkConfig = list(
#'     EnableInterContainerTrafficEncryption = TRUE|FALSE,
#'     EnableNetworkIsolation = TRUE|FALSE,
#'     VpcConfig = list(
#'       SecurityGroupIds = list(
#'         "string"
#'       ),
#'       Subnets = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   RoleArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ExperimentConfig = list(
#'     ExperimentName = "string",
#'     TrialName = "string",
#'     TrialComponentDisplayName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_processing_job
sagemaker_create_processing_job <- function(ProcessingInputs = NULL, ProcessingOutputConfig = NULL, ProcessingJobName, ProcessingResources, StoppingCondition = NULL, AppSpecification, Environment = NULL, NetworkConfig = NULL, RoleArn, Tags = NULL, ExperimentConfig = NULL) {
  op <- new_operation(
    name = "CreateProcessingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_processing_job_input(ProcessingInputs = ProcessingInputs, ProcessingOutputConfig = ProcessingOutputConfig, ProcessingJobName = ProcessingJobName, ProcessingResources = ProcessingResources, StoppingCondition = StoppingCondition, AppSpecification = AppSpecification, Environment = Environment, NetworkConfig = NetworkConfig, RoleArn = RoleArn, Tags = Tags, ExperimentConfig = ExperimentConfig)
  output <- .sagemaker$create_processing_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_processing_job <- sagemaker_create_processing_job

#' Starts a model training job
#'
#' Starts a model training job. After training completes, Amazon SageMaker
#' saves the resulting model artifacts to an Amazon S3 location that you
#' specify.
#' 
#' If you choose to host your model using Amazon SageMaker hosting
#' services, you can use the resulting model artifacts as part of the
#' model. You can also use the artifacts in a machine learning service
#' other than Amazon SageMaker, provided that you know how to use them for
#' inferences.
#' 
#' In the request body, you provide the following:
#' 
#' -   `AlgorithmSpecification` - Identifies the training algorithm to use.
#' 
#' -   `HyperParameters` - Specify these algorithm-specific parameters to
#'     enable the estimation of model parameters during training.
#'     Hyperparameters can be tuned to optimize this learning process. For
#'     a list of hyperparameters for each training algorithm provided by
#'     Amazon SageMaker, see
#'     [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
#' 
#' -   `InputDataConfig` - Describes the training dataset and the Amazon
#'     S3, EFS, or FSx location where it is stored.
#' 
#' -   `OutputDataConfig` - Identifies the Amazon S3 bucket where you want
#'     Amazon SageMaker to save the results of model training.
#' 
#' -   `ResourceConfig` - Identifies the resources, ML compute instances,
#'     and ML storage volumes to deploy for model training. In distributed
#'     training, you specify more than one instance.
#' 
#' -   `EnableManagedSpotTraining` - Optimize the cost of training machine
#'     learning models by up to 80% by using Amazon EC2 Spot instances. For
#'     more information, see [Managed Spot
#'     Training](https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html).
#' 
#' -   `RoleARN` - The Amazon Resource Number (ARN) that Amazon SageMaker
#'     assumes to perform tasks on your behalf during model training. You
#'     must grant this role the necessary permissions so that Amazon
#'     SageMaker can successfully complete model training.
#' 
#' -   `StoppingCondition` - To help cap training costs, use
#'     `MaxRuntimeInSeconds` to set a time limit for training. Use
#'     `MaxWaitTimeInSeconds` to specify how long you are willing to wait
#'     for a managed spot training job to complete.
#' 
#' For more information about Amazon SageMaker, see [How It
#' Works](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
#'
#' @usage
#' sagemaker_create_training_job(TrainingJobName, HyperParameters,
#'   AlgorithmSpecification, RoleArn, InputDataConfig, OutputDataConfig,
#'   ResourceConfig, VpcConfig, StoppingCondition, Tags,
#'   EnableNetworkIsolation, EnableInterContainerTrafficEncryption,
#'   EnableManagedSpotTraining, CheckpointConfig, DebugHookConfig,
#'   DebugRuleConfigurations, TensorBoardOutputConfig, ExperimentConfig)
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job. The name must be unique within an AWS
#' Region in an AWS account.
#' @param HyperParameters Algorithm-specific parameters that influence the quality of the model.
#' You set hyperparameters before you start the learning process. For a
#' list of hyperparameters for each training algorithm provided by Amazon
#' SageMaker, see
#' [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
#' 
#' You can specify a maximum of 100 hyperparameters. Each hyperparameter is
#' a key-value pair. Each key and value is limited to 256 characters, as
#' specified by the `Length Constraint`.
#' @param AlgorithmSpecification &#91;required&#93; The registry path of the Docker image that contains the training
#' algorithm and algorithm-specific metadata, including the input mode. For
#' more information about algorithms provided by Amazon SageMaker, see
#' [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
#' For information about providing your own algorithms, see [Using Your Own
#' Algorithms with Amazon
#' SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can
#' assume to perform tasks on your behalf.
#' 
#' During model training, Amazon SageMaker needs your permission to read
#' input data from an S3 bucket, download a Docker image that contains
#' training code, write model artifacts to an S3 bucket, write logs to
#' Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You
#' grant permissions for all of these tasks to an IAM role. For more
#' information, see [Amazon SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to Amazon SageMaker, the caller of this API
#' must have the `iam:PassRole` permission.
#' @param InputDataConfig An array of `Channel` objects. Each channel is a named input source.
#' `InputDataConfig` describes the input data and its location.
#' 
#' Algorithms can accept input data from one or more channels. For example,
#' an algorithm might have two channels of input data, `training_data` and
#' `validation_data`. The configuration for each channel provides the S3,
#' EFS, or FSx location where the input data is stored. It also provides
#' information about the stored data: the MIME type, compression method,
#' and whether the data is wrapped in RecordIO format.
#' 
#' Depending on the input mode that the algorithm supports, Amazon
#' SageMaker either copies input data files from an S3 bucket to a local
#' directory in the Docker container, or makes it available as input
#' streams. For example, if you specify an EFS location, input data files
#' will be made available as input streams. They do not need to be
#' downloaded.
#' @param OutputDataConfig &#91;required&#93; Specifies the path to the S3 location where you want to store model
#' artifacts. Amazon SageMaker creates subfolders for the artifacts.
#' @param ResourceConfig &#91;required&#93; The resources, including the ML compute instances and ML storage
#' volumes, to use for model training.
#' 
#' ML storage volumes store model artifacts and incremental states.
#' Training algorithms might also use ML storage volumes for scratch space.
#' If you want Amazon SageMaker to use the ML storage volume to store the
#' training data, choose `File` as the `TrainingInputMode` in the algorithm
#' specification. For distributed training algorithms, specify an instance
#' count greater than 1.
#' @param VpcConfig A VpcConfig object that specifies the VPC that you want your training
#' job to connect to. Control access to and from your training container by
#' configuring the VPC. For more information, see [Protect Training Jobs by
#' Using an Amazon Virtual Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
#' @param StoppingCondition &#91;required&#93; Specifies a limit to how long a model training job can run. When the job
#' reaches the time limit, Amazon SageMaker ends the training job. Use this
#' API to cap model training costs.
#' 
#' To stop a job, Amazon SageMaker sends the algorithm the `SIGTERM`
#' signal, which delays job termination for 120 seconds. Algorithms can use
#' this 120-second window to save the model artifacts, so the results of
#' training are not lost.
#' @param Tags An array of key-value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *AWS Billing and Cost Management User Guide*.
#' @param EnableNetworkIsolation Isolates the training container. No inbound or outbound network calls
#' can be made, except for calls between peers within a training cluster
#' for distributed training. If you enable network isolation for training
#' jobs that are configured to use a VPC, Amazon SageMaker downloads and
#' uploads customer data and model artifacts through the specified VPC, but
#' the training container does not have network access.
#' @param EnableInterContainerTrafficEncryption To encrypt all communications between ML compute instances in
#' distributed training, choose `True`. Encryption provides greater
#' security for distributed training, but training might take longer. How
#' long it takes depends on the amount of communication between compute
#' instances, especially if you use a deep learning algorithm in
#' distributed training. For more information, see [Protect Communications
#' Between ML Compute Instances in a Distributed Training
#' Job](https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html).
#' @param EnableManagedSpotTraining To train models using managed spot training, choose `True`. Managed spot
#' training provides a fully managed and scalable infrastructure for
#' training machine learning models. this option is useful when training
#' jobs can be interrupted and when there is flexibility when the training
#' job is run.
#' 
#' The complete and intermediate results of jobs are stored in an Amazon S3
#' bucket, and can be used as a starting point to train models
#' incrementally. Amazon SageMaker provides metrics and logs in CloudWatch.
#' They can be used to see when managed spot training jobs are running,
#' interrupted, resumed, or completed.
#' @param CheckpointConfig Contains information about the output location for managed spot training
#' checkpoint data.
#' @param DebugHookConfig 
#' @param DebugRuleConfigurations Configuration information for debugging rules.
#' @param TensorBoardOutputConfig 
#' @param ExperimentConfig 
#'
#' @section Request syntax:
#' ```
#' svc$create_training_job(
#'   TrainingJobName = "string",
#'   HyperParameters = list(
#'     "string"
#'   ),
#'   AlgorithmSpecification = list(
#'     TrainingImage = "string",
#'     AlgorithmName = "string",
#'     TrainingInputMode = "Pipe"|"File",
#'     MetricDefinitions = list(
#'       list(
#'         Name = "string",
#'         Regex = "string"
#'       )
#'     ),
#'     EnableSageMakerMetricsTimeSeries = TRUE|FALSE
#'   ),
#'   RoleArn = "string",
#'   InputDataConfig = list(
#'     list(
#'       ChannelName = "string",
#'       DataSource = list(
#'         S3DataSource = list(
#'           S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'           S3Uri = "string",
#'           S3DataDistributionType = "FullyReplicated"|"ShardedByS3Key",
#'           AttributeNames = list(
#'             "string"
#'           )
#'         ),
#'         FileSystemDataSource = list(
#'           FileSystemId = "string",
#'           FileSystemAccessMode = "rw"|"ro",
#'           FileSystemType = "EFS"|"FSxLustre",
#'           DirectoryPath = "string"
#'         )
#'       ),
#'       ContentType = "string",
#'       CompressionType = "None"|"Gzip",
#'       RecordWrapperType = "None"|"RecordIO",
#'       InputMode = "Pipe"|"File",
#'       ShuffleConfig = list(
#'         Seed = 123
#'       )
#'     )
#'   ),
#'   OutputDataConfig = list(
#'     KmsKeyId = "string",
#'     S3OutputPath = "string"
#'   ),
#'   ResourceConfig = list(
#'     InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.p3dn.24xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5n.xlarge"|"ml.c5n.2xlarge"|"ml.c5n.4xlarge"|"ml.c5n.9xlarge"|"ml.c5n.18xlarge",
#'     InstanceCount = 123,
#'     VolumeSizeInGB = 123,
#'     VolumeKmsKeyId = "string"
#'   ),
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   ),
#'   StoppingCondition = list(
#'     MaxRuntimeInSeconds = 123,
#'     MaxWaitTimeInSeconds = 123
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   EnableNetworkIsolation = TRUE|FALSE,
#'   EnableInterContainerTrafficEncryption = TRUE|FALSE,
#'   EnableManagedSpotTraining = TRUE|FALSE,
#'   CheckpointConfig = list(
#'     S3Uri = "string",
#'     LocalPath = "string"
#'   ),
#'   DebugHookConfig = list(
#'     LocalPath = "string",
#'     S3OutputPath = "string",
#'     HookParameters = list(
#'       "string"
#'     ),
#'     CollectionConfigurations = list(
#'       list(
#'         CollectionName = "string",
#'         CollectionParameters = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   DebugRuleConfigurations = list(
#'     list(
#'       RuleConfigurationName = "string",
#'       LocalPath = "string",
#'       S3OutputPath = "string",
#'       RuleEvaluatorImage = "string",
#'       InstanceType = "ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.8xlarge"|"ml.r5.12xlarge"|"ml.r5.16xlarge"|"ml.r5.24xlarge",
#'       VolumeSizeInGB = 123,
#'       RuleParameters = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   TensorBoardOutputConfig = list(
#'     LocalPath = "string",
#'     S3OutputPath = "string"
#'   ),
#'   ExperimentConfig = list(
#'     ExperimentName = "string",
#'     TrialName = "string",
#'     TrialComponentDisplayName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_training_job
sagemaker_create_training_job <- function(TrainingJobName, HyperParameters = NULL, AlgorithmSpecification, RoleArn, InputDataConfig = NULL, OutputDataConfig, ResourceConfig, VpcConfig = NULL, StoppingCondition, Tags = NULL, EnableNetworkIsolation = NULL, EnableInterContainerTrafficEncryption = NULL, EnableManagedSpotTraining = NULL, CheckpointConfig = NULL, DebugHookConfig = NULL, DebugRuleConfigurations = NULL, TensorBoardOutputConfig = NULL, ExperimentConfig = NULL) {
  op <- new_operation(
    name = "CreateTrainingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_training_job_input(TrainingJobName = TrainingJobName, HyperParameters = HyperParameters, AlgorithmSpecification = AlgorithmSpecification, RoleArn = RoleArn, InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, ResourceConfig = ResourceConfig, VpcConfig = VpcConfig, StoppingCondition = StoppingCondition, Tags = Tags, EnableNetworkIsolation = EnableNetworkIsolation, EnableInterContainerTrafficEncryption = EnableInterContainerTrafficEncryption, EnableManagedSpotTraining = EnableManagedSpotTraining, CheckpointConfig = CheckpointConfig, DebugHookConfig = DebugHookConfig, DebugRuleConfigurations = DebugRuleConfigurations, TensorBoardOutputConfig = TensorBoardOutputConfig, ExperimentConfig = ExperimentConfig)
  output <- .sagemaker$create_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_training_job <- sagemaker_create_training_job

#' Starts a transform job
#'
#' Starts a transform job. A transform job uses a trained model to get
#' inferences on a dataset and saves these results to an Amazon S3 location
#' that you specify.
#' 
#' To perform batch transformations, you create a transform job and use the
#' data that you have readily available.
#' 
#' In the request body, you provide the following:
#' 
#' -   `TransformJobName` - Identifies the transform job. The name must be
#'     unique within an AWS Region in an AWS account.
#' 
#' -   `ModelName` - Identifies the model to use. `ModelName` must be the
#'     name of an existing Amazon SageMaker model in the same AWS Region
#'     and AWS account. For information on creating a model, see
#'     CreateModel.
#' 
#' -   `TransformInput` - Describes the dataset to be transformed and the
#'     Amazon S3 location where it is stored.
#' 
#' -   `TransformOutput` - Identifies the Amazon S3 location where you want
#'     Amazon SageMaker to save the results from the transform job.
#' 
#' -   `TransformResources` - Identifies the ML compute instances for the
#'     transform job.
#' 
#' For more information about how batch transformation works, see [Batch
#' Transform](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html).
#'
#' @usage
#' sagemaker_create_transform_job(TransformJobName, ModelName,
#'   MaxConcurrentTransforms, ModelClientConfig, MaxPayloadInMB,
#'   BatchStrategy, Environment, TransformInput, TransformOutput,
#'   TransformResources, DataProcessing, Tags, ExperimentConfig)
#'
#' @param TransformJobName &#91;required&#93; The name of the transform job. The name must be unique within an AWS
#' Region in an AWS account.
#' @param ModelName &#91;required&#93; The name of the model that you want to use for the transform job.
#' `ModelName` must be the name of an existing Amazon SageMaker model
#' within an AWS Region in an AWS account.
#' @param MaxConcurrentTransforms The maximum number of parallel requests that can be sent to each
#' instance in a transform job. If `MaxConcurrentTransforms` is set to `0`
#' or left unset, Amazon SageMaker checks the optional execution-parameters
#' to determine the settings for your chosen algorithm. If the
#' execution-parameters endpoint is not enabled, the default value is `1`.
#' For more information on execution-parameters, see [How Containers Serve
#' Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests).
#' For built-in algorithms, you don\'t need to set a value for
#' `MaxConcurrentTransforms`.
#' @param ModelClientConfig Configures the timeout and maximum number of retries for processing a
#' transform job invocation.
#' @param MaxPayloadInMB The maximum allowed size of the payload, in MB. A *payload* is the data
#' portion of a record (without metadata). The value in `MaxPayloadInMB`
#' must be greater than, or equal to, the size of a single record. To
#' estimate the size of a record in MB, divide the size of your dataset by
#' the number of records. To ensure that the records fit within the maximum
#' payload size, we recommend using a slightly larger value. The default
#' value is `6` MB.
#' 
#' For cases where the payload might be arbitrarily large and is
#' transmitted using HTTP chunked encoding, set the value to `0`. This
#' feature works only in supported algorithms. Currently, Amazon SageMaker
#' built-in algorithms do not support HTTP chunked encoding.
#' @param BatchStrategy Specifies the number of records to include in a mini-batch for an HTTP
#' inference request. A *record* is a single unit of input data that
#' inference can be made on. For example, a single line in a CSV file is a
#' record.
#' 
#' To enable the batch strategy, you must set the `SplitType` property to
#' `Line`, `RecordIO`, or `TFRecord`.
#' 
#' To use only one record when making an HTTP invocation request to a
#' container, set `BatchStrategy` to `SingleRecord` and `SplitType` to
#' `Line`.
#' 
#' To fit as many records in a mini-batch as can fit within the
#' `MaxPayloadInMB` limit, set `BatchStrategy` to `MultiRecord` and
#' `SplitType` to `Line`.
#' @param Environment The environment variables to set in the Docker container. We support up
#' to 16 key and values entries in the map.
#' @param TransformInput &#91;required&#93; Describes the input source and the way the transform job consumes it.
#' @param TransformOutput &#91;required&#93; Describes the results of the transform job.
#' @param TransformResources &#91;required&#93; Describes the resources, including ML instance types and ML instance
#' count, to use for the transform job.
#' @param DataProcessing The data structure used to specify the data to be used for inference in
#' a batch transform job and to associate the data that is relevant to the
#' prediction results in the output. The input filter provided allows you
#' to exclude input data that is not needed for inference in a batch
#' transform job. The output filter provided allows you to include input
#' data relevant to interpreting the predictions in the output from the
#' job. For more information, see [Associate Prediction Results with their
#' Corresponding Input
#' Records](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *AWS Billing and Cost Management User Guide*.
#' @param ExperimentConfig 
#'
#' @section Request syntax:
#' ```
#' svc$create_transform_job(
#'   TransformJobName = "string",
#'   ModelName = "string",
#'   MaxConcurrentTransforms = 123,
#'   ModelClientConfig = list(
#'     InvocationsTimeoutInSeconds = 123,
#'     InvocationsMaxRetries = 123
#'   ),
#'   MaxPayloadInMB = 123,
#'   BatchStrategy = "MultiRecord"|"SingleRecord",
#'   Environment = list(
#'     "string"
#'   ),
#'   TransformInput = list(
#'     DataSource = list(
#'       S3DataSource = list(
#'         S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'         S3Uri = "string"
#'       )
#'     ),
#'     ContentType = "string",
#'     CompressionType = "None"|"Gzip",
#'     SplitType = "None"|"Line"|"RecordIO"|"TFRecord"
#'   ),
#'   TransformOutput = list(
#'     S3OutputPath = "string",
#'     Accept = "string",
#'     AssembleWith = "None"|"Line",
#'     KmsKeyId = "string"
#'   ),
#'   TransformResources = list(
#'     InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge",
#'     InstanceCount = 123,
#'     VolumeKmsKeyId = "string"
#'   ),
#'   DataProcessing = list(
#'     InputFilter = "string",
#'     OutputFilter = "string",
#'     JoinSource = "Input"|"None"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ExperimentConfig = list(
#'     ExperimentName = "string",
#'     TrialName = "string",
#'     TrialComponentDisplayName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_transform_job
sagemaker_create_transform_job <- function(TransformJobName, ModelName, MaxConcurrentTransforms = NULL, ModelClientConfig = NULL, MaxPayloadInMB = NULL, BatchStrategy = NULL, Environment = NULL, TransformInput, TransformOutput, TransformResources, DataProcessing = NULL, Tags = NULL, ExperimentConfig = NULL) {
  op <- new_operation(
    name = "CreateTransformJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_transform_job_input(TransformJobName = TransformJobName, ModelName = ModelName, MaxConcurrentTransforms = MaxConcurrentTransforms, ModelClientConfig = ModelClientConfig, MaxPayloadInMB = MaxPayloadInMB, BatchStrategy = BatchStrategy, Environment = Environment, TransformInput = TransformInput, TransformOutput = TransformOutput, TransformResources = TransformResources, DataProcessing = DataProcessing, Tags = Tags, ExperimentConfig = ExperimentConfig)
  output <- .sagemaker$create_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_transform_job <- sagemaker_create_transform_job

#' Creates an Amazon SageMaker _trial_
#'
#' Creates an Amazon SageMaker *trial*. A trial is a set of steps called
#' *trial components* that produce a machine learning model. A trial is
#' part of a single Amazon SageMaker *experiment*.
#' 
#' When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
#' all experiments, trials, and trial components are automatically tracked,
#' logged, and indexed. When you use the AWS SDK for Python (Boto), you
#' must use the logging APIs provided by the SDK.
#' 
#' You can add tags to a trial and then use the Search API to search for
#' the tags.
#' 
#' To get a list of all your trials, call the ListTrials API. To view a
#' trial\'s properties, call the DescribeTrial API. To create a trial
#' component, call the CreateTrialComponent API.
#'
#' @usage
#' sagemaker_create_trial(TrialName, DisplayName, ExperimentName, Tags)
#'
#' @param TrialName &#91;required&#93; The name of the trial. The name must be unique in your AWS account and
#' is not case-sensitive.
#' @param DisplayName The name of the trial as displayed. The name doesn\'t need to be unique.
#' If `DisplayName` isn\'t specified, `TrialName` is displayed.
#' @param ExperimentName &#91;required&#93; The name of the experiment to associate the trial with.
#' @param Tags A list of tags to associate with the trial. You can use Search API to
#' search on the tags.
#'
#' @section Request syntax:
#' ```
#' svc$create_trial(
#'   TrialName = "string",
#'   DisplayName = "string",
#'   ExperimentName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_trial
sagemaker_create_trial <- function(TrialName, DisplayName = NULL, ExperimentName, Tags = NULL) {
  op <- new_operation(
    name = "CreateTrial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_trial_input(TrialName = TrialName, DisplayName = DisplayName, ExperimentName = ExperimentName, Tags = Tags)
  output <- .sagemaker$create_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_trial <- sagemaker_create_trial

#' Creates a _trial component_, which is a stage of a machine learning
#' _trial_
#'
#' Creates a *trial component*, which is a stage of a machine learning
#' *trial*. A trial is composed of one or more trial components. A trial
#' component can be used in multiple trials.
#' 
#' Trial components include pre-processing jobs, training jobs, and batch
#' transform jobs.
#' 
#' When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
#' all experiments, trials, and trial components are automatically tracked,
#' logged, and indexed. When you use the AWS SDK for Python (Boto), you
#' must use the logging APIs provided by the SDK.
#' 
#' You can add tags to a trial component and then use the Search API to
#' search for the tags.
#' 
#' `CreateTrialComponent` can only be invoked from within an Amazon
#' SageMaker managed environment. This includes Amazon SageMaker training
#' jobs, processing jobs, transform jobs, and Amazon SageMaker notebooks. A
#' call to `CreateTrialComponent` from outside one of these environments
#' results in an error.
#'
#' @usage
#' sagemaker_create_trial_component(TrialComponentName, DisplayName,
#'   Status, StartTime, EndTime, Parameters, InputArtifacts, OutputArtifacts,
#'   Tags)
#'
#' @param TrialComponentName &#91;required&#93; The name of the component. The name must be unique in your AWS account
#' and is not case-sensitive.
#' @param DisplayName The name of the component as displayed. The name doesn\'t need to be
#' unique. If `DisplayName` isn\'t specified, `TrialComponentName` is
#' displayed.
#' @param Status The status of the component. States include:
#' 
#' -   InProgress
#' 
#' -   Completed
#' 
#' -   Failed
#' @param StartTime When the component started.
#' @param EndTime When the component ended.
#' @param Parameters The hyperparameters for the component.
#' @param InputArtifacts The input artifacts for the component. Examples of input artifacts are
#' datasets, algorithms, hyperparameters, source code, and instance types.
#' @param OutputArtifacts The output artifacts for the component. Examples of output artifacts are
#' metrics, snapshots, logs, and images.
#' @param Tags A list of tags to associate with the component. You can use Search API
#' to search on the tags.
#'
#' @section Request syntax:
#' ```
#' svc$create_trial_component(
#'   TrialComponentName = "string",
#'   DisplayName = "string",
#'   Status = list(
#'     PrimaryStatus = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
#'     Message = "string"
#'   ),
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Parameters = list(
#'     list(
#'       StringValue = "string",
#'       NumberValue = 123.0
#'     )
#'   ),
#'   InputArtifacts = list(
#'     list(
#'       MediaType = "string",
#'       Value = "string"
#'     )
#'   ),
#'   OutputArtifacts = list(
#'     list(
#'       MediaType = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_trial_component
sagemaker_create_trial_component <- function(TrialComponentName, DisplayName = NULL, Status = NULL, StartTime = NULL, EndTime = NULL, Parameters = NULL, InputArtifacts = NULL, OutputArtifacts = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_trial_component_input(TrialComponentName = TrialComponentName, DisplayName = DisplayName, Status = Status, StartTime = StartTime, EndTime = EndTime, Parameters = Parameters, InputArtifacts = InputArtifacts, OutputArtifacts = OutputArtifacts, Tags = Tags)
  output <- .sagemaker$create_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_trial_component <- sagemaker_create_trial_component

#' Creates a user profile
#'
#' Creates a user profile. A user profile represents a single user within a
#' domain, and is the main way to reference a \"person\" for the purposes
#' of sharing, reporting, and other user-oriented features. This entity is
#' created when a user onboards to Amazon SageMaker Studio. If an
#' administrator invites a person by email or imports them from SSO, a user
#' profile is automatically created. A user profile is the primary holder
#' of settings for an individual user and has a reference to the user\'s
#' private Amazon Elastic File System (EFS) home directory.
#'
#' @usage
#' sagemaker_create_user_profile(DomainId, UserProfileName,
#'   SingleSignOnUserIdentifier, SingleSignOnUserValue, Tags, UserSettings)
#'
#' @param DomainId &#91;required&#93; The ID of the associated Domain.
#' @param UserProfileName &#91;required&#93; A name for the UserProfile.
#' @param SingleSignOnUserIdentifier A specifier for the type of value specified in SingleSignOnUserValue.
#' Currently, the only supported value is \"UserName\". If the Domain\'s
#' AuthMode is SSO, this field is required. If the Domain\'s AuthMode is
#' not SSO, this field cannot be specified.
#' @param SingleSignOnUserValue The username of the associated AWS Single Sign-On User for this
#' UserProfile. If the Domain\'s AuthMode is SSO, this field is required,
#' and must match a valid username of a user in your directory. If the
#' Domain\'s AuthMode is not SSO, this field cannot be specified.
#' @param Tags Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource.
#' @param UserSettings A collection of settings.
#'
#' @section Request syntax:
#' ```
#' svc$create_user_profile(
#'   DomainId = "string",
#'   UserProfileName = "string",
#'   SingleSignOnUserIdentifier = "string",
#'   SingleSignOnUserValue = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   UserSettings = list(
#'     ExecutionRole = "string",
#'     SecurityGroups = list(
#'       "string"
#'     ),
#'     SharingSettings = list(
#'       NotebookOutputOption = "Allowed"|"Disabled",
#'       S3OutputPath = "string",
#'       S3KmsKeyId = "string"
#'     ),
#'     JupyterServerAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     ),
#'     KernelGatewayAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     ),
#'     TensorBoardAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_user_profile
sagemaker_create_user_profile <- function(DomainId, UserProfileName, SingleSignOnUserIdentifier = NULL, SingleSignOnUserValue = NULL, Tags = NULL, UserSettings = NULL) {
  op <- new_operation(
    name = "CreateUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName, SingleSignOnUserIdentifier = SingleSignOnUserIdentifier, SingleSignOnUserValue = SingleSignOnUserValue, Tags = Tags, UserSettings = UserSettings)
  output <- .sagemaker$create_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_user_profile <- sagemaker_create_user_profile

#' Creates a new work team for labeling your data
#'
#' Creates a new work team for labeling your data. A work team is defined
#' by one or more Amazon Cognito user pools. You must first create the user
#' pools before you can create a work team.
#' 
#' You cannot create more than 25 work teams in an account and region.
#'
#' @usage
#' sagemaker_create_workteam(WorkteamName, MemberDefinitions, Description,
#'   NotificationConfiguration, Tags)
#'
#' @param WorkteamName &#91;required&#93; The name of the work team. Use this name to identify the work team.
#' @param MemberDefinitions &#91;required&#93; A list of `MemberDefinition` objects that contains objects that identify
#' the Amazon Cognito user pool that makes up the work team. For more
#' information, see [Amazon Cognito User
#' Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
#' 
#' All of the `CognitoMemberDefinition` objects that make up the member
#' definition must have the same `ClientId` and `UserPool` values.
#' @param Description &#91;required&#93; A description of the work team.
#' @param NotificationConfiguration Configures notification of workers regarding available or expiring work
#' items.
#' @param Tags An array of key-value pairs.
#' 
#' For more information, see [Resource
#' Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html)
#' and [Using Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *AWS Billing and Cost Management User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_workteam(
#'   WorkteamName = "string",
#'   MemberDefinitions = list(
#'     list(
#'       CognitoMemberDefinition = list(
#'         UserPool = "string",
#'         UserGroup = "string",
#'         ClientId = "string"
#'       )
#'     )
#'   ),
#'   Description = "string",
#'   NotificationConfiguration = list(
#'     NotificationTopicArn = "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_workteam
sagemaker_create_workteam <- function(WorkteamName, MemberDefinitions, Description, NotificationConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_workteam_input(WorkteamName = WorkteamName, MemberDefinitions = MemberDefinitions, Description = Description, NotificationConfiguration = NotificationConfiguration, Tags = Tags)
  output <- .sagemaker$create_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_workteam <- sagemaker_create_workteam

#' Removes the specified algorithm from your account
#'
#' Removes the specified algorithm from your account.
#'
#' @usage
#' sagemaker_delete_algorithm(AlgorithmName)
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_algorithm(
#'   AlgorithmName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_algorithm
sagemaker_delete_algorithm <- function(AlgorithmName) {
  op <- new_operation(
    name = "DeleteAlgorithm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_algorithm_input(AlgorithmName = AlgorithmName)
  output <- .sagemaker$delete_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_algorithm <- sagemaker_delete_algorithm

#' Used to stop and delete an app
#'
#' Used to stop and delete an app.
#'
#' @usage
#' sagemaker_delete_app(DomainId, UserProfileName, AppType, AppName)
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#' @param AppType &#91;required&#93; The type of app.
#' @param AppName &#91;required&#93; The name of the app.
#'
#' @section Request syntax:
#' ```
#' svc$delete_app(
#'   DomainId = "string",
#'   UserProfileName = "string",
#'   AppType = "JupyterServer"|"KernelGateway"|"TensorBoard",
#'   AppName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_app
sagemaker_delete_app <- function(DomainId, UserProfileName, AppType, AppName) {
  op <- new_operation(
    name = "DeleteApp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_app_input(DomainId = DomainId, UserProfileName = UserProfileName, AppType = AppType, AppName = AppName)
  output <- .sagemaker$delete_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_app <- sagemaker_delete_app

#' Deletes the specified Git repository from your account
#'
#' Deletes the specified Git repository from your account.
#'
#' @usage
#' sagemaker_delete_code_repository(CodeRepositoryName)
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_code_repository(
#'   CodeRepositoryName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_code_repository
sagemaker_delete_code_repository <- function(CodeRepositoryName) {
  op <- new_operation(
    name = "DeleteCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_code_repository_input(CodeRepositoryName = CodeRepositoryName)
  output <- .sagemaker$delete_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_code_repository <- sagemaker_delete_code_repository

#' Used to delete a domain
#'
#' Used to delete a domain. If you onboarded with IAM mode, you will need
#' to delete your domain to onboard again using SSO. Use with caution. All
#' of the members of the domain will lose access to their EFS volume,
#' including data, notebooks, and other artifacts.
#'
#' @usage
#' sagemaker_delete_domain(DomainId, RetentionPolicy)
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param RetentionPolicy The retention policy for this domain, which specifies whether resources
#' will be retained after the Domain is deleted. By default, all resources
#' are retained (not automatically deleted).
#'
#' @section Request syntax:
#' ```
#' svc$delete_domain(
#'   DomainId = "string",
#'   RetentionPolicy = list(
#'     HomeEfsFileSystem = "Retain"|"Delete"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_domain
sagemaker_delete_domain <- function(DomainId, RetentionPolicy = NULL) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_domain_input(DomainId = DomainId, RetentionPolicy = RetentionPolicy)
  output <- .sagemaker$delete_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_domain <- sagemaker_delete_domain

#' Deletes an endpoint
#'
#' Deletes an endpoint. Amazon SageMaker frees up all of the resources that
#' were deployed when the endpoint was created.
#' 
#' Amazon SageMaker retires any custom KMS key grants associated with the
#' endpoint, meaning you don\'t need to use the
#' [RevokeGrant](http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html)
#' API call.
#'
#' @usage
#' sagemaker_delete_endpoint(EndpointName)
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_endpoint(
#'   EndpointName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_endpoint
sagemaker_delete_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_endpoint_input(EndpointName = EndpointName)
  output <- .sagemaker$delete_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_endpoint <- sagemaker_delete_endpoint

#' Deletes an endpoint configuration
#'
#' Deletes an endpoint configuration. The `DeleteEndpointConfig` API
#' deletes only the specified configuration. It does not delete endpoints
#' created using the configuration.
#' 
#' You must not delete an `EndpointConfig` in use by an endpoint that is
#' live or while the `UpdateEndpoint` or `CreateEndpoint` operations are
#' being performed on the endpoint. If you delete the `EndpointConfig` of
#' an endpoint that is active or being created or updated you may lose
#' visibility into the instance type the endpoint is using. The endpoint
#' must be deleted in order to stop incurring charges.
#'
#' @usage
#' sagemaker_delete_endpoint_config(EndpointConfigName)
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_endpoint_config(
#'   EndpointConfigName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_endpoint_config
sagemaker_delete_endpoint_config <- function(EndpointConfigName) {
  op <- new_operation(
    name = "DeleteEndpointConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_endpoint_config_input(EndpointConfigName = EndpointConfigName)
  output <- .sagemaker$delete_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_endpoint_config <- sagemaker_delete_endpoint_config

#' Deletes an Amazon SageMaker experiment
#'
#' Deletes an Amazon SageMaker experiment. All trials associated with the
#' experiment must be deleted first. Use the ListTrials API to get a list
#' of the trials associated with the experiment.
#'
#' @usage
#' sagemaker_delete_experiment(ExperimentName)
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_experiment(
#'   ExperimentName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_experiment
sagemaker_delete_experiment <- function(ExperimentName) {
  op <- new_operation(
    name = "DeleteExperiment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_experiment_input(ExperimentName = ExperimentName)
  output <- .sagemaker$delete_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_experiment <- sagemaker_delete_experiment

#' Deletes the specified flow definition
#'
#' Deletes the specified flow definition.
#'
#' @usage
#' sagemaker_delete_flow_definition(FlowDefinitionName)
#'
#' @param FlowDefinitionName &#91;required&#93; The name of the flow definition you are deleting.
#'
#' @section Request syntax:
#' ```
#' svc$delete_flow_definition(
#'   FlowDefinitionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_flow_definition
sagemaker_delete_flow_definition <- function(FlowDefinitionName) {
  op <- new_operation(
    name = "DeleteFlowDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_flow_definition_input(FlowDefinitionName = FlowDefinitionName)
  output <- .sagemaker$delete_flow_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_flow_definition <- sagemaker_delete_flow_definition

#' Use this operation to delete a worker task template (HumanTaskUi)
#'
#' Use this operation to delete a worker task template (`HumanTaskUi`).
#' 
#' To see a list of human task user interfaces (work task templates) in
#' your account, use . When you delete a worker task template, it no longer
#' appears when you call `ListHumanTaskUis`.
#'
#' @usage
#' sagemaker_delete_human_task_ui(HumanTaskUiName)
#'
#' @param HumanTaskUiName &#91;required&#93; The name of the human task user interface (work task template) you want
#' to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_human_task_ui(
#'   HumanTaskUiName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_human_task_ui
sagemaker_delete_human_task_ui <- function(HumanTaskUiName) {
  op <- new_operation(
    name = "DeleteHumanTaskUi",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_human_task_ui_input(HumanTaskUiName = HumanTaskUiName)
  output <- .sagemaker$delete_human_task_ui_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_human_task_ui <- sagemaker_delete_human_task_ui

#' Deletes a model
#'
#' Deletes a model. The `DeleteModel` API deletes only the model entry that
#' was created in Amazon SageMaker when you called the CreateModel API. It
#' does not delete model artifacts, inference code, or the IAM role that
#' you specified when creating the model.
#'
#' @usage
#' sagemaker_delete_model(ModelName)
#'
#' @param ModelName &#91;required&#93; The name of the model to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_model(
#'   ModelName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model
sagemaker_delete_model <- function(ModelName) {
  op <- new_operation(
    name = "DeleteModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_model_input(ModelName = ModelName)
  output <- .sagemaker$delete_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model <- sagemaker_delete_model

#' Deletes a model package
#'
#' Deletes a model package.
#' 
#' A model package is used to create Amazon SageMaker models or list on AWS
#' Marketplace. Buyers can subscribe to model packages listed on AWS
#' Marketplace to create models in Amazon SageMaker.
#'
#' @usage
#' sagemaker_delete_model_package(ModelPackageName)
#'
#' @param ModelPackageName &#91;required&#93; The name of the model package. The name must have 1 to 63 characters.
#' Valid characters are a-z, A-Z, 0-9, and - (hyphen).
#'
#' @section Request syntax:
#' ```
#' svc$delete_model_package(
#'   ModelPackageName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_package
sagemaker_delete_model_package <- function(ModelPackageName) {
  op <- new_operation(
    name = "DeleteModelPackage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_model_package_input(ModelPackageName = ModelPackageName)
  output <- .sagemaker$delete_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_package <- sagemaker_delete_model_package

#' Deletes a monitoring schedule
#'
#' Deletes a monitoring schedule. Also stops the schedule had not already
#' been stopped. This does not delete the job execution history of the
#' monitoring schedule.
#'
#' @usage
#' sagemaker_delete_monitoring_schedule(MonitoringScheduleName)
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the monitoring schedule to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_monitoring_schedule(
#'   MonitoringScheduleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_monitoring_schedule
sagemaker_delete_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "DeleteMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$delete_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_monitoring_schedule <- sagemaker_delete_monitoring_schedule

#' Deletes an Amazon SageMaker notebook instance
#'
#' Deletes an Amazon SageMaker notebook instance. Before you can delete a
#' notebook instance, you must call the `StopNotebookInstance` API.
#' 
#' When you delete a notebook instance, you lose all of your data. Amazon
#' SageMaker removes the ML compute instance, and deletes the ML storage
#' volume and the network interface associated with the notebook instance.
#'
#' @usage
#' sagemaker_delete_notebook_instance(NotebookInstanceName)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the Amazon SageMaker notebook instance to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_notebook_instance(
#'   NotebookInstanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_notebook_instance
sagemaker_delete_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "DeleteNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$delete_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_notebook_instance <- sagemaker_delete_notebook_instance

#' Deletes a notebook instance lifecycle configuration
#'
#' Deletes a notebook instance lifecycle configuration.
#'
#' @usage
#' sagemaker_delete_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName)
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_notebook_instance_lifecycle_config
sagemaker_delete_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName) {
  op <- new_operation(
    name = "DeleteNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName)
  output <- .sagemaker$delete_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_notebook_instance_lifecycle_config <- sagemaker_delete_notebook_instance_lifecycle_config

#' Deletes the specified tags from an Amazon SageMaker resource
#'
#' Deletes the specified tags from an Amazon SageMaker resource.
#' 
#' To list a resource\'s tags, use the `ListTags` API.
#' 
#' When you call this API to delete tags from a hyperparameter tuning job,
#' the deleted tags are not removed from training jobs that the
#' hyperparameter tuning job launched before you called this API.
#'
#' @usage
#' sagemaker_delete_tags(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' delete.
#' @param TagKeys &#91;required&#93; An array or one or more tag keys to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_tags(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_tags
sagemaker_delete_tags <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_tags_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .sagemaker$delete_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_tags <- sagemaker_delete_tags

#' Deletes the specified trial
#'
#' Deletes the specified trial. All trial components that make up the trial
#' must be deleted first. Use the DescribeTrialComponent API to get the
#' list of trial components.
#'
#' @usage
#' sagemaker_delete_trial(TrialName)
#'
#' @param TrialName &#91;required&#93; The name of the trial to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_trial(
#'   TrialName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_trial
sagemaker_delete_trial <- function(TrialName) {
  op <- new_operation(
    name = "DeleteTrial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_trial_input(TrialName = TrialName)
  output <- .sagemaker$delete_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_trial <- sagemaker_delete_trial

#' Deletes the specified trial component
#'
#' Deletes the specified trial component. A trial component must be
#' disassociated from all trials before the trial component can be deleted.
#' To disassociate a trial component from a trial, call the
#' DisassociateTrialComponent API.
#'
#' @usage
#' sagemaker_delete_trial_component(TrialComponentName)
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_trial_component(
#'   TrialComponentName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_trial_component
sagemaker_delete_trial_component <- function(TrialComponentName) {
  op <- new_operation(
    name = "DeleteTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_trial_component_input(TrialComponentName = TrialComponentName)
  output <- .sagemaker$delete_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_trial_component <- sagemaker_delete_trial_component

#' Deletes a user profile
#'
#' Deletes a user profile. When a user profile is deleted, the user loses
#' access to their EFS volume, including data, notebooks, and other
#' artifacts.
#'
#' @usage
#' sagemaker_delete_user_profile(DomainId, UserProfileName)
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_profile(
#'   DomainId = "string",
#'   UserProfileName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_user_profile
sagemaker_delete_user_profile <- function(DomainId, UserProfileName) {
  op <- new_operation(
    name = "DeleteUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName)
  output <- .sagemaker$delete_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_user_profile <- sagemaker_delete_user_profile

#' Deletes an existing work team
#'
#' Deletes an existing work team. This operation can\'t be undone.
#'
#' @usage
#' sagemaker_delete_workteam(WorkteamName)
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_workteam(
#'   WorkteamName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_workteam
sagemaker_delete_workteam <- function(WorkteamName) {
  op <- new_operation(
    name = "DeleteWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_workteam_input(WorkteamName = WorkteamName)
  output <- .sagemaker$delete_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_workteam <- sagemaker_delete_workteam

#' Returns a description of the specified algorithm that is in your account
#'
#' Returns a description of the specified algorithm that is in your
#' account.
#'
#' @usage
#' sagemaker_describe_algorithm(AlgorithmName)
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_algorithm(
#'   AlgorithmName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_algorithm
sagemaker_describe_algorithm <- function(AlgorithmName) {
  op <- new_operation(
    name = "DescribeAlgorithm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_algorithm_input(AlgorithmName = AlgorithmName)
  output <- .sagemaker$describe_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_algorithm <- sagemaker_describe_algorithm

#' Describes the app
#'
#' Describes the app.
#'
#' @usage
#' sagemaker_describe_app(DomainId, UserProfileName, AppType, AppName)
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#' @param AppType &#91;required&#93; The type of app.
#' @param AppName &#91;required&#93; The name of the app.
#'
#' @section Request syntax:
#' ```
#' svc$describe_app(
#'   DomainId = "string",
#'   UserProfileName = "string",
#'   AppType = "JupyterServer"|"KernelGateway"|"TensorBoard",
#'   AppName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_app
sagemaker_describe_app <- function(DomainId, UserProfileName, AppType, AppName) {
  op <- new_operation(
    name = "DescribeApp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_app_input(DomainId = DomainId, UserProfileName = UserProfileName, AppType = AppType, AppName = AppName)
  output <- .sagemaker$describe_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_app <- sagemaker_describe_app

#' Returns information about an Amazon SageMaker job
#'
#' Returns information about an Amazon SageMaker job.
#'
#' @usage
#' sagemaker_describe_auto_ml_job(AutoMLJobName)
#'
#' @param AutoMLJobName &#91;required&#93; Request information about a job using that job\'s unique name.
#'
#' @section Request syntax:
#' ```
#' svc$describe_auto_ml_job(
#'   AutoMLJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_auto_ml_job
sagemaker_describe_auto_ml_job <- function(AutoMLJobName) {
  op <- new_operation(
    name = "DescribeAutoMLJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_auto_ml_job_input(AutoMLJobName = AutoMLJobName)
  output <- .sagemaker$describe_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_auto_ml_job <- sagemaker_describe_auto_ml_job

#' Gets details about the specified Git repository
#'
#' Gets details about the specified Git repository.
#'
#' @usage
#' sagemaker_describe_code_repository(CodeRepositoryName)
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_code_repository(
#'   CodeRepositoryName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_code_repository
sagemaker_describe_code_repository <- function(CodeRepositoryName) {
  op <- new_operation(
    name = "DescribeCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_code_repository_input(CodeRepositoryName = CodeRepositoryName)
  output <- .sagemaker$describe_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_code_repository <- sagemaker_describe_code_repository

#' Returns information about a model compilation job
#'
#' Returns information about a model compilation job.
#' 
#' To create a model compilation job, use CreateCompilationJob. To get
#' information about multiple model compilation jobs, use
#' ListCompilationJobs.
#'
#' @usage
#' sagemaker_describe_compilation_job(CompilationJobName)
#'
#' @param CompilationJobName &#91;required&#93; The name of the model compilation job that you want information about.
#'
#' @section Request syntax:
#' ```
#' svc$describe_compilation_job(
#'   CompilationJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_compilation_job
sagemaker_describe_compilation_job <- function(CompilationJobName) {
  op <- new_operation(
    name = "DescribeCompilationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_compilation_job_input(CompilationJobName = CompilationJobName)
  output <- .sagemaker$describe_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_compilation_job <- sagemaker_describe_compilation_job

#' The description of the domain
#'
#' The description of the domain.
#'
#' @usage
#' sagemaker_describe_domain(DomainId)
#'
#' @param DomainId &#91;required&#93; The domain ID.
#'
#' @section Request syntax:
#' ```
#' svc$describe_domain(
#'   DomainId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_domain
sagemaker_describe_domain <- function(DomainId) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_domain_input(DomainId = DomainId)
  output <- .sagemaker$describe_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_domain <- sagemaker_describe_domain

#' Returns the description of an endpoint
#'
#' Returns the description of an endpoint.
#'
#' @usage
#' sagemaker_describe_endpoint(EndpointName)
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint.
#'
#' @section Request syntax:
#' ```
#' svc$describe_endpoint(
#'   EndpointName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_endpoint
sagemaker_describe_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DescribeEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_endpoint_input(EndpointName = EndpointName)
  output <- .sagemaker$describe_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_endpoint <- sagemaker_describe_endpoint

#' Returns the description of an endpoint configuration created using the
#' CreateEndpointConfig API
#'
#' Returns the description of an endpoint configuration created using the
#' `CreateEndpointConfig` API.
#'
#' @usage
#' sagemaker_describe_endpoint_config(EndpointConfigName)
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration.
#'
#' @section Request syntax:
#' ```
#' svc$describe_endpoint_config(
#'   EndpointConfigName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_endpoint_config
sagemaker_describe_endpoint_config <- function(EndpointConfigName) {
  op <- new_operation(
    name = "DescribeEndpointConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_endpoint_config_input(EndpointConfigName = EndpointConfigName)
  output <- .sagemaker$describe_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_endpoint_config <- sagemaker_describe_endpoint_config

#' Provides a list of an experiment's properties
#'
#' Provides a list of an experiment\'s properties.
#'
#' @usage
#' sagemaker_describe_experiment(ExperimentName)
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_experiment(
#'   ExperimentName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_experiment
sagemaker_describe_experiment <- function(ExperimentName) {
  op <- new_operation(
    name = "DescribeExperiment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_experiment_input(ExperimentName = ExperimentName)
  output <- .sagemaker$describe_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_experiment <- sagemaker_describe_experiment

#' Returns information about the specified flow definition
#'
#' Returns information about the specified flow definition.
#'
#' @usage
#' sagemaker_describe_flow_definition(FlowDefinitionName)
#'
#' @param FlowDefinitionName &#91;required&#93; The name of the flow definition.
#'
#' @section Request syntax:
#' ```
#' svc$describe_flow_definition(
#'   FlowDefinitionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_flow_definition
sagemaker_describe_flow_definition <- function(FlowDefinitionName) {
  op <- new_operation(
    name = "DescribeFlowDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_flow_definition_input(FlowDefinitionName = FlowDefinitionName)
  output <- .sagemaker$describe_flow_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_flow_definition <- sagemaker_describe_flow_definition

#' Returns information about the requested human task user interface
#' (worker task template)
#'
#' Returns information about the requested human task user interface
#' (worker task template).
#'
#' @usage
#' sagemaker_describe_human_task_ui(HumanTaskUiName)
#'
#' @param HumanTaskUiName &#91;required&#93; The name of the human task user interface (worker task template) you
#' want information about.
#'
#' @section Request syntax:
#' ```
#' svc$describe_human_task_ui(
#'   HumanTaskUiName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_human_task_ui
sagemaker_describe_human_task_ui <- function(HumanTaskUiName) {
  op <- new_operation(
    name = "DescribeHumanTaskUi",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_human_task_ui_input(HumanTaskUiName = HumanTaskUiName)
  output <- .sagemaker$describe_human_task_ui_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_human_task_ui <- sagemaker_describe_human_task_ui

#' Gets a description of a hyperparameter tuning job
#'
#' Gets a description of a hyperparameter tuning job.
#'
#' @usage
#' sagemaker_describe_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName)
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job.
#'
#' @section Request syntax:
#' ```
#' svc$describe_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_hyper_parameter_tuning_job
sagemaker_describe_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName) {
  op <- new_operation(
    name = "DescribeHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName)
  output <- .sagemaker$describe_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_hyper_parameter_tuning_job <- sagemaker_describe_hyper_parameter_tuning_job

#' Gets information about a labeling job
#'
#' Gets information about a labeling job.
#'
#' @usage
#' sagemaker_describe_labeling_job(LabelingJobName)
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job to return information for.
#'
#' @section Request syntax:
#' ```
#' svc$describe_labeling_job(
#'   LabelingJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_labeling_job
sagemaker_describe_labeling_job <- function(LabelingJobName) {
  op <- new_operation(
    name = "DescribeLabelingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_labeling_job_input(LabelingJobName = LabelingJobName)
  output <- .sagemaker$describe_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_labeling_job <- sagemaker_describe_labeling_job

#' Describes a model that you created using the CreateModel API
#'
#' Describes a model that you created using the `CreateModel` API.
#'
#' @usage
#' sagemaker_describe_model(ModelName)
#'
#' @param ModelName &#91;required&#93; The name of the model.
#'
#' @section Request syntax:
#' ```
#' svc$describe_model(
#'   ModelName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model
sagemaker_describe_model <- function(ModelName) {
  op <- new_operation(
    name = "DescribeModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_model_input(ModelName = ModelName)
  output <- .sagemaker$describe_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model <- sagemaker_describe_model

#' Returns a description of the specified model package, which is used to
#' create Amazon SageMaker models or list them on AWS Marketplace
#'
#' Returns a description of the specified model package, which is used to
#' create Amazon SageMaker models or list them on AWS Marketplace.
#' 
#' To create models in Amazon SageMaker, buyers can subscribe to model
#' packages listed on AWS Marketplace.
#'
#' @usage
#' sagemaker_describe_model_package(ModelPackageName)
#'
#' @param ModelPackageName &#91;required&#93; The name of the model package to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_model_package(
#'   ModelPackageName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_package
sagemaker_describe_model_package <- function(ModelPackageName) {
  op <- new_operation(
    name = "DescribeModelPackage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_model_package_input(ModelPackageName = ModelPackageName)
  output <- .sagemaker$describe_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_package <- sagemaker_describe_model_package

#' Describes the schedule for a monitoring job
#'
#' Describes the schedule for a monitoring job.
#'
#' @usage
#' sagemaker_describe_monitoring_schedule(MonitoringScheduleName)
#'
#' @param MonitoringScheduleName &#91;required&#93; Name of a previously created monitoring schedule.
#'
#' @section Request syntax:
#' ```
#' svc$describe_monitoring_schedule(
#'   MonitoringScheduleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_monitoring_schedule
sagemaker_describe_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "DescribeMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$describe_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_monitoring_schedule <- sagemaker_describe_monitoring_schedule

#' Returns information about a notebook instance
#'
#' Returns information about a notebook instance.
#'
#' @usage
#' sagemaker_describe_notebook_instance(NotebookInstanceName)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance that you want information about.
#'
#' @section Request syntax:
#' ```
#' svc$describe_notebook_instance(
#'   NotebookInstanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_notebook_instance
sagemaker_describe_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "DescribeNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$describe_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_notebook_instance <- sagemaker_describe_notebook_instance

#' Returns a description of a notebook instance lifecycle configuration
#'
#' Returns a description of a notebook instance lifecycle configuration.
#' 
#' For information about notebook instance lifestyle configurations, see
#' [Step 2.1: (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#'
#' @usage
#' sagemaker_describe_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName)
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_notebook_instance_lifecycle_config
sagemaker_describe_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName) {
  op <- new_operation(
    name = "DescribeNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName)
  output <- .sagemaker$describe_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_notebook_instance_lifecycle_config <- sagemaker_describe_notebook_instance_lifecycle_config

#' Returns a description of a processing job
#'
#' Returns a description of a processing job.
#'
#' @usage
#' sagemaker_describe_processing_job(ProcessingJobName)
#'
#' @param ProcessingJobName &#91;required&#93; The name of the processing job. The name must be unique within an AWS
#' Region in the AWS account.
#'
#' @section Request syntax:
#' ```
#' svc$describe_processing_job(
#'   ProcessingJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_processing_job
sagemaker_describe_processing_job <- function(ProcessingJobName) {
  op <- new_operation(
    name = "DescribeProcessingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_processing_job_input(ProcessingJobName = ProcessingJobName)
  output <- .sagemaker$describe_processing_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_processing_job <- sagemaker_describe_processing_job

#' Gets information about a work team provided by a vendor
#'
#' Gets information about a work team provided by a vendor. It returns
#' details about the subscription with a vendor in the AWS Marketplace.
#'
#' @usage
#' sagemaker_describe_subscribed_workteam(WorkteamArn)
#'
#' @param WorkteamArn &#91;required&#93; The Amazon Resource Name (ARN) of the subscribed work team to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_subscribed_workteam(
#'   WorkteamArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_subscribed_workteam
sagemaker_describe_subscribed_workteam <- function(WorkteamArn) {
  op <- new_operation(
    name = "DescribeSubscribedWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_subscribed_workteam_input(WorkteamArn = WorkteamArn)
  output <- .sagemaker$describe_subscribed_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_subscribed_workteam <- sagemaker_describe_subscribed_workteam

#' Returns information about a training job
#'
#' Returns information about a training job.
#'
#' @usage
#' sagemaker_describe_training_job(TrainingJobName)
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job.
#'
#' @section Request syntax:
#' ```
#' svc$describe_training_job(
#'   TrainingJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_training_job
sagemaker_describe_training_job <- function(TrainingJobName) {
  op <- new_operation(
    name = "DescribeTrainingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_training_job_input(TrainingJobName = TrainingJobName)
  output <- .sagemaker$describe_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_training_job <- sagemaker_describe_training_job

#' Returns information about a transform job
#'
#' Returns information about a transform job.
#'
#' @usage
#' sagemaker_describe_transform_job(TransformJobName)
#'
#' @param TransformJobName &#91;required&#93; The name of the transform job that you want to view details of.
#'
#' @section Request syntax:
#' ```
#' svc$describe_transform_job(
#'   TransformJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_transform_job
sagemaker_describe_transform_job <- function(TransformJobName) {
  op <- new_operation(
    name = "DescribeTransformJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_transform_job_input(TransformJobName = TransformJobName)
  output <- .sagemaker$describe_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_transform_job <- sagemaker_describe_transform_job

#' Provides a list of a trial's properties
#'
#' Provides a list of a trial\'s properties.
#'
#' @usage
#' sagemaker_describe_trial(TrialName)
#'
#' @param TrialName &#91;required&#93; The name of the trial to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_trial(
#'   TrialName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_trial
sagemaker_describe_trial <- function(TrialName) {
  op <- new_operation(
    name = "DescribeTrial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_trial_input(TrialName = TrialName)
  output <- .sagemaker$describe_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_trial <- sagemaker_describe_trial

#' Provides a list of a trials component's properties
#'
#' Provides a list of a trials component\'s properties.
#'
#' @usage
#' sagemaker_describe_trial_component(TrialComponentName)
#'
#' @param TrialComponentName &#91;required&#93; The name of the trial component to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_trial_component(
#'   TrialComponentName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_trial_component
sagemaker_describe_trial_component <- function(TrialComponentName) {
  op <- new_operation(
    name = "DescribeTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_trial_component_input(TrialComponentName = TrialComponentName)
  output <- .sagemaker$describe_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_trial_component <- sagemaker_describe_trial_component

#' Describes a user profile
#'
#' Describes a user profile. For more information, see `CreateUserProfile`.
#'
#' @usage
#' sagemaker_describe_user_profile(DomainId, UserProfileName)
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#'
#' @section Request syntax:
#' ```
#' svc$describe_user_profile(
#'   DomainId = "string",
#'   UserProfileName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_user_profile
sagemaker_describe_user_profile <- function(DomainId, UserProfileName) {
  op <- new_operation(
    name = "DescribeUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName)
  output <- .sagemaker$describe_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_user_profile <- sagemaker_describe_user_profile

#' Lists private workforce information, including workforce name, Amazon
#' Resource Name (ARN), and, if applicable, allowed IP address ranges
#' (CIDRs)
#'
#' Lists private workforce information, including workforce name, Amazon
#' Resource Name (ARN), and, if applicable, allowed IP address ranges
#' ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)).
#' Allowable IP address ranges are the IP addresses that workers can use to
#' access tasks.
#' 
#' This operation applies only to private workforces.
#'
#' @usage
#' sagemaker_describe_workforce(WorkforceName)
#'
#' @param WorkforceName &#91;required&#93; The name of the private workforce whose access you want to restrict.
#' `WorkforceName` is automatically set to `default` when a workforce is
#' created and cannot be modified.
#'
#' @section Request syntax:
#' ```
#' svc$describe_workforce(
#'   WorkforceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_workforce
sagemaker_describe_workforce <- function(WorkforceName) {
  op <- new_operation(
    name = "DescribeWorkforce",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_workforce_input(WorkforceName = WorkforceName)
  output <- .sagemaker$describe_workforce_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_workforce <- sagemaker_describe_workforce

#' Gets information about a specific work team
#'
#' Gets information about a specific work team. You can see information
#' such as the create date, the last updated date, membership information,
#' and the work team\'s Amazon Resource Name (ARN).
#'
#' @usage
#' sagemaker_describe_workteam(WorkteamName)
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to return a description of.
#'
#' @section Request syntax:
#' ```
#' svc$describe_workteam(
#'   WorkteamName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_workteam
sagemaker_describe_workteam <- function(WorkteamName) {
  op <- new_operation(
    name = "DescribeWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_workteam_input(WorkteamName = WorkteamName)
  output <- .sagemaker$describe_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_workteam <- sagemaker_describe_workteam

#' Disassociates a trial component from a trial
#'
#' Disassociates a trial component from a trial. This doesn\'t effect other
#' trials the component is associated with. Before you can delete a
#' component, you must disassociate the component from all trials it is
#' associated with. To associate a trial component with a trial, call the
#' AssociateTrialComponent API.
#' 
#' To get a list of the trials a component is associated with, use the
#' Search API. Specify `ExperimentTrialComponent` for the `Resource`
#' parameter. The list appears in the response under
#' `Results.TrialComponent.Parents`.
#'
#' @usage
#' sagemaker_disassociate_trial_component(TrialComponentName, TrialName)
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to disassociate from the trial.
#' @param TrialName &#91;required&#93; The name of the trial to disassociate from.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_trial_component(
#'   TrialComponentName = "string",
#'   TrialName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_disassociate_trial_component
sagemaker_disassociate_trial_component <- function(TrialComponentName, TrialName) {
  op <- new_operation(
    name = "DisassociateTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$disassociate_trial_component_input(TrialComponentName = TrialComponentName, TrialName = TrialName)
  output <- .sagemaker$disassociate_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$disassociate_trial_component <- sagemaker_disassociate_trial_component

#' An auto-complete API for the search functionality in the Amazon
#' SageMaker console
#'
#' An auto-complete API for the search functionality in the Amazon
#' SageMaker console. It returns suggestions of possible matches for the
#' property name to use in `Search` queries. Provides suggestions for
#' `HyperParameters`, `Tags`, and `Metrics`.
#'
#' @usage
#' sagemaker_get_search_suggestions(Resource, SuggestionQuery)
#'
#' @param Resource &#91;required&#93; The name of the Amazon SageMaker resource to search for.
#' @param SuggestionQuery Limits the property names that are included in the response.
#'
#' @section Request syntax:
#' ```
#' svc$get_search_suggestions(
#'   Resource = "TrainingJob"|"Experiment"|"ExperimentTrial"|"ExperimentTrialComponent",
#'   SuggestionQuery = list(
#'     PropertyNameQuery = list(
#'       PropertyNameHint = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_search_suggestions
sagemaker_get_search_suggestions <- function(Resource, SuggestionQuery = NULL) {
  op <- new_operation(
    name = "GetSearchSuggestions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$get_search_suggestions_input(Resource = Resource, SuggestionQuery = SuggestionQuery)
  output <- .sagemaker$get_search_suggestions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_search_suggestions <- sagemaker_get_search_suggestions

#' Lists the machine learning algorithms that have been created
#'
#' Lists the machine learning algorithms that have been created.
#'
#' @usage
#' sagemaker_list_algorithms(CreationTimeAfter, CreationTimeBefore,
#'   MaxResults, NameContains, NextToken, SortBy, SortOrder)
#'
#' @param CreationTimeAfter A filter that returns only algorithms created after the specified time
#' (timestamp).
#' @param CreationTimeBefore A filter that returns only algorithms created before the specified time
#' (timestamp).
#' @param MaxResults The maximum number of algorithms to return in the response.
#' @param NameContains A string in the algorithm name. This filter returns only algorithms
#' whose name contains the specified string.
#' @param NextToken If the response to a previous `ListAlgorithms` request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of
#' algorithms, use the token in the next request.
#' @param SortBy The parameter by which to sort the results. The default is
#' `CreationTime`.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_algorithms(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxResults = 123,
#'   NameContains = "string",
#'   NextToken = "string",
#'   SortBy = "Name"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_algorithms
sagemaker_list_algorithms <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListAlgorithms",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_algorithms_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_algorithms_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_algorithms <- sagemaker_list_algorithms

#' Lists apps
#'
#' Lists apps.
#'
#' @usage
#' sagemaker_list_apps(NextToken, MaxResults, SortOrder, SortBy,
#'   DomainIdEquals, UserProfileNameEquals)
#'
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults Returns a list up to a specified limit.
#' @param SortOrder The sort order for the results. The default is Ascending.
#' @param SortBy The parameter by which to sort the results. The default is CreationTime.
#' @param DomainIdEquals A parameter to search for the domain ID.
#' @param UserProfileNameEquals A parameter to search by user profile name.
#'
#' @section Request syntax:
#' ```
#' svc$list_apps(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   SortOrder = "Ascending"|"Descending",
#'   SortBy = "CreationTime",
#'   DomainIdEquals = "string",
#'   UserProfileNameEquals = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_apps
sagemaker_list_apps <- function(NextToken = NULL, MaxResults = NULL, SortOrder = NULL, SortBy = NULL, DomainIdEquals = NULL, UserProfileNameEquals = NULL) {
  op <- new_operation(
    name = "ListApps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_apps_input(NextToken = NextToken, MaxResults = MaxResults, SortOrder = SortOrder, SortBy = SortBy, DomainIdEquals = DomainIdEquals, UserProfileNameEquals = UserProfileNameEquals)
  output <- .sagemaker$list_apps_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_apps <- sagemaker_list_apps

#' Request a list of jobs
#'
#' Request a list of jobs.
#'
#' @usage
#' sagemaker_list_auto_ml_jobs(CreationTimeAfter, CreationTimeBefore,
#'   LastModifiedTimeAfter, LastModifiedTimeBefore, NameContains,
#'   StatusEquals, SortOrder, SortBy, MaxResults, NextToken)
#'
#' @param CreationTimeAfter Request a list of jobs, using a filter for time.
#' @param CreationTimeBefore Request a list of jobs, using a filter for time.
#' @param LastModifiedTimeAfter Request a list of jobs, using a filter for time.
#' @param LastModifiedTimeBefore Request a list of jobs, using a filter for time.
#' @param NameContains Request a list of jobs, using a search filter for name.
#' @param StatusEquals Request a list of jobs, using a filter for status.
#' @param SortOrder The sort order for the results. The default is Descending.
#' @param SortBy The parameter by which to sort the results. The default is
#' AutoMLJobName.
#' @param MaxResults Request a list of jobs up to a specified limit.
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_auto_ml_jobs(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NameContains = "string",
#'   StatusEquals = "Completed"|"InProgress"|"Failed"|"Stopped"|"Stopping",
#'   SortOrder = "Ascending"|"Descending",
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_auto_ml_jobs
sagemaker_list_auto_ml_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortOrder = NULL, SortBy = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAutoMLJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_auto_ml_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortOrder = SortOrder, SortBy = SortBy, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_auto_ml_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_auto_ml_jobs <- sagemaker_list_auto_ml_jobs

#' List the Candidates created for the job
#'
#' List the Candidates created for the job.
#'
#' @usage
#' sagemaker_list_candidates_for_auto_ml_job(AutoMLJobName, StatusEquals,
#'   CandidateNameEquals, SortOrder, SortBy, MaxResults, NextToken)
#'
#' @param AutoMLJobName &#91;required&#93; List the Candidates created for the job by providing the job\'s name.
#' @param StatusEquals List the Candidates for the job and filter by status.
#' @param CandidateNameEquals List the Candidates for the job and filter by candidate name.
#' @param SortOrder The sort order for the results. The default is Ascending.
#' @param SortBy The parameter by which to sort the results. The default is Descending.
#' @param MaxResults List the job\'s Candidates up to a specified limit.
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_candidates_for_auto_ml_job(
#'   AutoMLJobName = "string",
#'   StatusEquals = "Completed"|"InProgress"|"Failed"|"Stopped"|"Stopping",
#'   CandidateNameEquals = "string",
#'   SortOrder = "Ascending"|"Descending",
#'   SortBy = "CreationTime"|"Status"|"FinalObjectiveMetricValue",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_candidates_for_auto_ml_job
sagemaker_list_candidates_for_auto_ml_job <- function(AutoMLJobName, StatusEquals = NULL, CandidateNameEquals = NULL, SortOrder = NULL, SortBy = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCandidatesForAutoMLJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_candidates_for_auto_ml_job_input(AutoMLJobName = AutoMLJobName, StatusEquals = StatusEquals, CandidateNameEquals = CandidateNameEquals, SortOrder = SortOrder, SortBy = SortBy, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_candidates_for_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_candidates_for_auto_ml_job <- sagemaker_list_candidates_for_auto_ml_job

#' Gets a list of the Git repositories in your account
#'
#' Gets a list of the Git repositories in your account.
#'
#' @usage
#' sagemaker_list_code_repositories(CreationTimeAfter, CreationTimeBefore,
#'   LastModifiedTimeAfter, LastModifiedTimeBefore, MaxResults, NameContains,
#'   NextToken, SortBy, SortOrder)
#'
#' @param CreationTimeAfter A filter that returns only Git repositories that were created after the
#' specified time.
#' @param CreationTimeBefore A filter that returns only Git repositories that were created before the
#' specified time.
#' @param LastModifiedTimeAfter A filter that returns only Git repositories that were last modified
#' after the specified time.
#' @param LastModifiedTimeBefore A filter that returns only Git repositories that were last modified
#' before the specified time.
#' @param MaxResults The maximum number of Git repositories to return in the response.
#' @param NameContains A string in the Git repositories name. This filter returns only
#' repositories whose name contains the specified string.
#' @param NextToken If the result of a `ListCodeRepositoriesOutput` request was truncated,
#' the response includes a `NextToken`. To get the next set of Git
#' repositories, use the token in the next request.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_code_repositories(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxResults = 123,
#'   NameContains = "string",
#'   NextToken = "string",
#'   SortBy = "Name"|"CreationTime"|"LastModifiedTime",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_code_repositories
sagemaker_list_code_repositories <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListCodeRepositories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_code_repositories_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_code_repositories_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_code_repositories <- sagemaker_list_code_repositories

#' Lists model compilation jobs that satisfy various filters
#'
#' Lists model compilation jobs that satisfy various filters.
#' 
#' To create a model compilation job, use CreateCompilationJob. To get
#' information about a particular model compilation job you have created,
#' use DescribeCompilationJob.
#'
#' @usage
#' sagemaker_list_compilation_jobs(NextToken, MaxResults,
#'   CreationTimeAfter, CreationTimeBefore, LastModifiedTimeAfter,
#'   LastModifiedTimeBefore, NameContains, StatusEquals, SortBy, SortOrder)
#'
#' @param NextToken If the result of the previous `ListCompilationJobs` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of model compilation jobs, use the token in the next request.
#' @param MaxResults The maximum number of model compilation jobs to return in the response.
#' @param CreationTimeAfter A filter that returns the model compilation jobs that were created after
#' a specified time.
#' @param CreationTimeBefore A filter that returns the model compilation jobs that were created
#' before a specified time.
#' @param LastModifiedTimeAfter A filter that returns the model compilation jobs that were modified
#' after a specified time.
#' @param LastModifiedTimeBefore A filter that returns the model compilation jobs that were modified
#' before a specified time.
#' @param NameContains A filter that returns the model compilation jobs whose name contains a
#' specified string.
#' @param StatusEquals A filter that retrieves model compilation jobs with a specific
#' DescribeCompilationJobResponse\\$CompilationJobStatus status.
#' @param SortBy The field by which to sort results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_compilation_jobs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NameContains = "string",
#'   StatusEquals = "INPROGRESS"|"COMPLETED"|"FAILED"|"STARTING"|"STOPPING"|"STOPPED",
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_compilation_jobs
sagemaker_list_compilation_jobs <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListCompilationJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_compilation_jobs_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_compilation_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_compilation_jobs <- sagemaker_list_compilation_jobs

#' Lists the domains
#'
#' Lists the domains.
#'
#' @usage
#' sagemaker_list_domains(NextToken, MaxResults)
#'
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults Returns a list up to a specified limit.
#'
#' @section Request syntax:
#' ```
#' svc$list_domains(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_domains
sagemaker_list_domains <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_domains_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_domains_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_domains <- sagemaker_list_domains

#' Lists endpoint configurations
#'
#' Lists endpoint configurations.
#'
#' @usage
#' sagemaker_list_endpoint_configs(SortBy, SortOrder, NextToken,
#'   MaxResults, NameContains, CreationTimeBefore, CreationTimeAfter)
#'
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of the previous `ListEndpointConfig` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of endpoint configurations, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return in the response.
#' @param NameContains A string in the endpoint configuration name. This filter returns only
#' endpoint configurations whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only endpoint configurations created before the
#' specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only endpoint configurations with a creation time
#' greater than or equal to the specified time (timestamp).
#'
#' @section Request syntax:
#' ```
#' svc$list_endpoint_configs(
#'   SortBy = "Name"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   NameContains = "string",
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_endpoint_configs
sagemaker_list_endpoint_configs <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListEndpointConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_endpoint_configs_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_endpoint_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_endpoint_configs <- sagemaker_list_endpoint_configs

#' Lists endpoints
#'
#' Lists endpoints.
#'
#' @usage
#' sagemaker_list_endpoints(SortBy, SortOrder, NextToken, MaxResults,
#'   NameContains, CreationTimeBefore, CreationTimeAfter,
#'   LastModifiedTimeBefore, LastModifiedTimeAfter, StatusEquals)
#'
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of a `ListEndpoints` request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of endpoints, use the
#' token in the next request.
#' @param MaxResults The maximum number of endpoints to return in the response.
#' @param NameContains A string in endpoint names. This filter returns only endpoints whose
#' name contains the specified string.
#' @param CreationTimeBefore A filter that returns only endpoints that were created before the
#' specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only endpoints with a creation time greater than
#' or equal to the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only endpoints that were modified before the
#' specified timestamp.
#' @param LastModifiedTimeAfter A filter that returns only endpoints that were modified after the
#' specified timestamp.
#' @param StatusEquals A filter that returns only endpoints with the specified status.
#'
#' @section Request syntax:
#' ```
#' svc$list_endpoints(
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   NameContains = "string",
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   StatusEquals = "OutOfService"|"Creating"|"Updating"|"SystemUpdating"|"RollingBack"|"InService"|"Deleting"|"Failed"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_endpoints
sagemaker_list_endpoints <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_endpoints_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals)
  output <- .sagemaker$list_endpoints_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_endpoints <- sagemaker_list_endpoints

#' Lists all the experiments in your account
#'
#' Lists all the experiments in your account. The list can be filtered to
#' show only experiments that were created in a specific time range. The
#' list can be sorted by experiment name or creation time.
#'
#' @usage
#' sagemaker_list_experiments(CreatedAfter, CreatedBefore, SortBy,
#'   SortOrder, NextToken, MaxResults)
#'
#' @param CreatedAfter A filter that returns only experiments created after the specified time.
#' @param CreatedBefore A filter that returns only experiments created before the specified
#' time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param NextToken If the previous call to `ListExperiments` didn\'t return the full set of
#' experiments, the call returns a token for getting the next set of
#' experiments.
#' @param MaxResults The maximum number of experiments to return in the response. The default
#' value is 10.
#'
#' @section Request syntax:
#' ```
#' svc$list_experiments(
#'   CreatedAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreatedBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   SortBy = "Name"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_experiments
sagemaker_list_experiments <- function(CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListExperiments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_experiments_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_experiments_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_experiments <- sagemaker_list_experiments

#' Returns information about the flow definitions in your account
#'
#' Returns information about the flow definitions in your account.
#'
#' @usage
#' sagemaker_list_flow_definitions(CreationTimeAfter, CreationTimeBefore,
#'   SortOrder, NextToken, MaxResults)
#'
#' @param CreationTimeAfter A filter that returns only flow definitions with a creation time greater
#' than or equal to the specified timestamp.
#' @param CreationTimeBefore A filter that returns only flow definitions that were created before the
#' specified timestamp.
#' @param SortOrder An optional value that specifies whether you want the results sorted in
#' `Ascending` or `Descending` order.
#' @param NextToken A token to resume pagination.
#' @param MaxResults The total number of items to return. If the total number of available
#' items is more than the value specified in `MaxResults`, then a
#' `NextToken` will be provided in the output that you can use to resume
#' pagination.
#'
#' @section Request syntax:
#' ```
#' svc$list_flow_definitions(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_flow_definitions
sagemaker_list_flow_definitions <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFlowDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_flow_definitions_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_flow_definitions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_flow_definitions <- sagemaker_list_flow_definitions

#' Returns information about the human task user interfaces in your account
#'
#' Returns information about the human task user interfaces in your
#' account.
#'
#' @usage
#' sagemaker_list_human_task_uis(CreationTimeAfter, CreationTimeBefore,
#'   SortOrder, NextToken, MaxResults)
#'
#' @param CreationTimeAfter A filter that returns only human task user interfaces with a creation
#' time greater than or equal to the specified timestamp.
#' @param CreationTimeBefore A filter that returns only human task user interfaces that were created
#' before the specified timestamp.
#' @param SortOrder An optional value that specifies whether you want the results sorted in
#' `Ascending` or `Descending` order.
#' @param NextToken A token to resume pagination.
#' @param MaxResults The total number of items to return. If the total number of available
#' items is more than the value specified in `MaxResults`, then a
#' `NextToken` will be provided in the output that you can use to resume
#' pagination.
#'
#' @section Request syntax:
#' ```
#' svc$list_human_task_uis(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_human_task_uis
sagemaker_list_human_task_uis <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHumanTaskUis",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_human_task_uis_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_human_task_uis_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_human_task_uis <- sagemaker_list_human_task_uis

#' Gets a list of HyperParameterTuningJobSummary objects that describe the
#' hyperparameter tuning jobs launched in your account
#'
#' Gets a list of HyperParameterTuningJobSummary objects that describe the
#' hyperparameter tuning jobs launched in your account.
#'
#' @usage
#' sagemaker_list_hyper_parameter_tuning_jobs(NextToken, MaxResults,
#'   SortBy, SortOrder, NameContains, CreationTimeAfter, CreationTimeBefore,
#'   LastModifiedTimeAfter, LastModifiedTimeBefore, StatusEquals)
#'
#' @param NextToken If the result of the previous `ListHyperParameterTuningJobs` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of tuning jobs, use the token in the next request.
#' @param MaxResults The maximum number of tuning jobs to return. The default value is 10.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param NameContains A string in the tuning job name. This filter returns only tuning jobs
#' whose name contains the specified string.
#' @param CreationTimeAfter A filter that returns only tuning jobs that were created after the
#' specified time.
#' @param CreationTimeBefore A filter that returns only tuning jobs that were created before the
#' specified time.
#' @param LastModifiedTimeAfter A filter that returns only tuning jobs that were modified after the
#' specified time.
#' @param LastModifiedTimeBefore A filter that returns only tuning jobs that were modified before the
#' specified time.
#' @param StatusEquals A filter that returns only tuning jobs with the specified status.
#'
#' @section Request syntax:
#' ```
#' svc$list_hyper_parameter_tuning_jobs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   SortBy = "Name"|"Status"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending",
#'   NameContains = "string",
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   StatusEquals = "Completed"|"InProgress"|"Failed"|"Stopped"|"Stopping"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_hyper_parameter_tuning_jobs
sagemaker_list_hyper_parameter_tuning_jobs <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListHyperParameterTuningJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_hyper_parameter_tuning_jobs_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, StatusEquals = StatusEquals)
  output <- .sagemaker$list_hyper_parameter_tuning_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_hyper_parameter_tuning_jobs <- sagemaker_list_hyper_parameter_tuning_jobs

#' Gets a list of labeling jobs
#'
#' Gets a list of labeling jobs.
#'
#' @usage
#' sagemaker_list_labeling_jobs(CreationTimeAfter, CreationTimeBefore,
#'   LastModifiedTimeAfter, LastModifiedTimeBefore, MaxResults, NextToken,
#'   NameContains, SortBy, SortOrder, StatusEquals)
#'
#' @param CreationTimeAfter A filter that returns only labeling jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only labeling jobs created before the specified
#' time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only labeling jobs modified after the specified
#' time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only labeling jobs modified before the specified
#' time (timestamp).
#' @param MaxResults The maximum number of labeling jobs to return in each page of the
#' response.
#' @param NextToken If the result of the previous `ListLabelingJobs` request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of
#' labeling jobs, use the token in the next request.
#' @param NameContains A string in the labeling job name. This filter returns only labeling
#' jobs whose name contains the specified string.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param StatusEquals A filter that retrieves only labeling jobs with a specific status.
#'
#' @section Request syntax:
#' ```
#' svc$list_labeling_jobs(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   NameContains = "string",
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending",
#'   StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_labeling_jobs
sagemaker_list_labeling_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NextToken = NULL, NameContains = NULL, SortBy = NULL, SortOrder = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListLabelingJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_labeling_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NextToken = NextToken, NameContains = NameContains, SortBy = SortBy, SortOrder = SortOrder, StatusEquals = StatusEquals)
  output <- .sagemaker$list_labeling_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_labeling_jobs <- sagemaker_list_labeling_jobs

#' Gets a list of labeling jobs assigned to a specified work team
#'
#' Gets a list of labeling jobs assigned to a specified work team.
#'
#' @usage
#' sagemaker_list_labeling_jobs_for_workteam(WorkteamArn, MaxResults,
#'   NextToken, CreationTimeAfter, CreationTimeBefore,
#'   JobReferenceCodeContains, SortBy, SortOrder)
#'
#' @param WorkteamArn &#91;required&#93; The Amazon Resource Name (ARN) of the work team for which you want to
#' see labeling jobs for.
#' @param MaxResults The maximum number of labeling jobs to return in each page of the
#' response.
#' @param NextToken If the result of the previous `ListLabelingJobsForWorkteam` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of labeling jobs, use the token in the next request.
#' @param CreationTimeAfter A filter that returns only labeling jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only labeling jobs created before the specified
#' time (timestamp).
#' @param JobReferenceCodeContains A filter the limits jobs to only the ones whose job reference code
#' contains the specified string.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_labeling_jobs_for_workteam(
#'   WorkteamArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   JobReferenceCodeContains = "string",
#'   SortBy = "CreationTime",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_labeling_jobs_for_workteam
sagemaker_list_labeling_jobs_for_workteam <- function(WorkteamArn, MaxResults = NULL, NextToken = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, JobReferenceCodeContains = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListLabelingJobsForWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_labeling_jobs_for_workteam_input(WorkteamArn = WorkteamArn, MaxResults = MaxResults, NextToken = NextToken, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, JobReferenceCodeContains = JobReferenceCodeContains, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_labeling_jobs_for_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_labeling_jobs_for_workteam <- sagemaker_list_labeling_jobs_for_workteam

#' Lists the model packages that have been created
#'
#' Lists the model packages that have been created.
#'
#' @usage
#' sagemaker_list_model_packages(CreationTimeAfter, CreationTimeBefore,
#'   MaxResults, NameContains, NextToken, SortBy, SortOrder)
#'
#' @param CreationTimeAfter A filter that returns only model packages created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only model packages created before the specified
#' time (timestamp).
#' @param MaxResults The maximum number of model packages to return in the response.
#' @param NameContains A string in the model package name. This filter returns only model
#' packages whose name contains the specified string.
#' @param NextToken If the response to a previous `ListModelPackages` request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of model
#' packages, use the token in the next request.
#' @param SortBy The parameter by which to sort the results. The default is
#' `CreationTime`.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_model_packages(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxResults = 123,
#'   NameContains = "string",
#'   NextToken = "string",
#'   SortBy = "Name"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_packages
sagemaker_list_model_packages <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListModelPackages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_model_packages_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_model_packages_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_packages <- sagemaker_list_model_packages

#' Lists models created with the CreateModel API
#'
#' Lists models created with the CreateModel API.
#'
#' @usage
#' sagemaker_list_models(SortBy, SortOrder, NextToken, MaxResults,
#'   NameContains, CreationTimeBefore, CreationTimeAfter)
#'
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the response to a previous `ListModels` request was truncated, the
#' response includes a `NextToken`. To retrieve the next set of models, use
#' the token in the next request.
#' @param MaxResults The maximum number of models to return in the response.
#' @param NameContains A string in the training job name. This filter returns only models in
#' the training job whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only models created before the specified time
#' (timestamp).
#' @param CreationTimeAfter A filter that returns only models with a creation time greater than or
#' equal to the specified time (timestamp).
#'
#' @section Request syntax:
#' ```
#' svc$list_models(
#'   SortBy = "Name"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   NameContains = "string",
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_models
sagemaker_list_models <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListModels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_models_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_models_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_models <- sagemaker_list_models

#' Returns list of all monitoring job executions
#'
#' Returns list of all monitoring job executions.
#'
#' @usage
#' sagemaker_list_monitoring_executions(MonitoringScheduleName,
#'   EndpointName, SortBy, SortOrder, NextToken, MaxResults,
#'   ScheduledTimeBefore, ScheduledTimeAfter, CreationTimeBefore,
#'   CreationTimeAfter, LastModifiedTimeBefore, LastModifiedTimeAfter,
#'   StatusEquals)
#'
#' @param MonitoringScheduleName Name of a specific schedule to fetch jobs for.
#' @param EndpointName Name of a specific endpoint to fetch jobs for.
#' @param SortBy Whether to sort results by `Status`, `CreationTime`, `ScheduledTime`
#' field. The default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken The token returned if the response is truncated. To retrieve the next
#' set of job executions, use it in the next request.
#' @param MaxResults The maximum number of jobs to return in the response. The default value
#' is 10.
#' @param ScheduledTimeBefore Filter for jobs scheduled before a specified time.
#' @param ScheduledTimeAfter Filter for jobs scheduled after a specified time.
#' @param CreationTimeBefore A filter that returns only jobs created before a specified time.
#' @param CreationTimeAfter A filter that returns only jobs created after a specified time.
#' @param LastModifiedTimeBefore A filter that returns only jobs modified after a specified time.
#' @param LastModifiedTimeAfter A filter that returns only jobs modified before a specified time.
#' @param StatusEquals A filter that retrieves only jobs with a specific status.
#'
#' @section Request syntax:
#' ```
#' svc$list_monitoring_executions(
#'   MonitoringScheduleName = "string",
#'   EndpointName = "string",
#'   SortBy = "CreationTime"|"ScheduledTime"|"Status",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   ScheduledTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ScheduledTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   StatusEquals = "Pending"|"Completed"|"CompletedWithViolations"|"InProgress"|"Failed"|"Stopping"|"Stopped"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_monitoring_executions
sagemaker_list_monitoring_executions <- function(MonitoringScheduleName = NULL, EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, ScheduledTimeBefore = NULL, ScheduledTimeAfter = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListMonitoringExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_monitoring_executions_input(MonitoringScheduleName = MonitoringScheduleName, EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, ScheduledTimeBefore = ScheduledTimeBefore, ScheduledTimeAfter = ScheduledTimeAfter, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals)
  output <- .sagemaker$list_monitoring_executions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_monitoring_executions <- sagemaker_list_monitoring_executions

#' Returns list of all monitoring schedules
#'
#' Returns list of all monitoring schedules.
#'
#' @usage
#' sagemaker_list_monitoring_schedules(EndpointName, SortBy, SortOrder,
#'   NextToken, MaxResults, NameContains, CreationTimeBefore,
#'   CreationTimeAfter, LastModifiedTimeBefore, LastModifiedTimeAfter,
#'   StatusEquals)
#'
#' @param EndpointName Name of a specific endpoint to fetch schedules for.
#' @param SortBy Whether to sort results by `Status`, `CreationTime`, `ScheduledTime`
#' field. The default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken The token returned if the response is truncated. To retrieve the next
#' set of job executions, use it in the next request.
#' @param MaxResults The maximum number of jobs to return in the response. The default value
#' is 10.
#' @param NameContains Filter for monitoring schedules whose name contains a specified string.
#' @param CreationTimeBefore A filter that returns only monitoring schedules created before a
#' specified time.
#' @param CreationTimeAfter A filter that returns only monitoring schedules created after a
#' specified time.
#' @param LastModifiedTimeBefore A filter that returns only monitoring schedules modified before a
#' specified time.
#' @param LastModifiedTimeAfter A filter that returns only monitoring schedules modified after a
#' specified time.
#' @param StatusEquals A filter that returns only monitoring schedules modified before a
#' specified time.
#'
#' @section Request syntax:
#' ```
#' svc$list_monitoring_schedules(
#'   EndpointName = "string",
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   NameContains = "string",
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   StatusEquals = "Pending"|"Failed"|"Scheduled"|"Stopped"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_monitoring_schedules
sagemaker_list_monitoring_schedules <- function(EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListMonitoringSchedules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_monitoring_schedules_input(EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals)
  output <- .sagemaker$list_monitoring_schedules_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_monitoring_schedules <- sagemaker_list_monitoring_schedules

#' Lists notebook instance lifestyle configurations created with the
#' CreateNotebookInstanceLifecycleConfig API
#'
#' Lists notebook instance lifestyle configurations created with the
#' CreateNotebookInstanceLifecycleConfig API.
#'
#' @usage
#' sagemaker_list_notebook_instance_lifecycle_configs(NextToken,
#'   MaxResults, SortBy, SortOrder, NameContains, CreationTimeBefore,
#'   CreationTimeAfter, LastModifiedTimeBefore, LastModifiedTimeAfter)
#'
#' @param NextToken If the result of a `ListNotebookInstanceLifecycleConfigs` request was
#' truncated, the response includes a `NextToken`. To get the next set of
#' lifecycle configurations, use the token in the next request.
#' @param MaxResults The maximum number of lifecycle configurations to return in the
#' response.
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results.
#' @param NameContains A string in the lifecycle configuration name. This filter returns only
#' lifecycle configurations whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only lifecycle configurations that were created
#' before the specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only lifecycle configurations that were created
#' after the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only lifecycle configurations that were modified
#' before the specified time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only lifecycle configurations that were modified
#' after the specified time (timestamp).
#'
#' @section Request syntax:
#' ```
#' svc$list_notebook_instance_lifecycle_configs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   SortBy = "Name"|"CreationTime"|"LastModifiedTime",
#'   SortOrder = "Ascending"|"Descending",
#'   NameContains = "string",
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_notebook_instance_lifecycle_configs
sagemaker_list_notebook_instance_lifecycle_configs <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL) {
  op <- new_operation(
    name = "ListNotebookInstanceLifecycleConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_notebook_instance_lifecycle_configs_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter)
  output <- .sagemaker$list_notebook_instance_lifecycle_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_notebook_instance_lifecycle_configs <- sagemaker_list_notebook_instance_lifecycle_configs

#' Returns a list of the Amazon SageMaker notebook instances in the
#' requester's account in an AWS Region
#'
#' Returns a list of the Amazon SageMaker notebook instances in the
#' requester\'s account in an AWS Region.
#'
#' @usage
#' sagemaker_list_notebook_instances(NextToken, MaxResults, SortBy,
#'   SortOrder, NameContains, CreationTimeBefore, CreationTimeAfter,
#'   LastModifiedTimeBefore, LastModifiedTimeAfter, StatusEquals,
#'   NotebookInstanceLifecycleConfigNameContains,
#'   DefaultCodeRepositoryContains, AdditionalCodeRepositoryEquals)
#'
#' @param NextToken If the previous call to the `ListNotebookInstances` is truncated, the
#' response includes a `NextToken`. You can use this token in your
#' subsequent `ListNotebookInstances` request to fetch the next set of
#' notebook instances.
#' 
#' You might specify a filter or a sort order in your request. When
#' response is truncated, you must use the same values for the filer and
#' sort order in the next request.
#' @param MaxResults The maximum number of notebook instances to return.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results.
#' @param NameContains A string in the notebook instances\' name. This filter returns only
#' notebook instances whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only notebook instances that were created before
#' the specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only notebook instances that were created after
#' the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only notebook instances that were modified before
#' the specified time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only notebook instances that were modified after
#' the specified time (timestamp).
#' @param StatusEquals A filter that returns only notebook instances with the specified status.
#' @param NotebookInstanceLifecycleConfigNameContains A string in the name of a notebook instances lifecycle configuration
#' associated with this notebook instance. This filter returns only
#' notebook instances associated with a lifecycle configuration with a name
#' that contains the specified string.
#' @param DefaultCodeRepositoryContains A string in the name or URL of a Git repository associated with this
#' notebook instance. This filter returns only notebook instances
#' associated with a git repository with a name that contains the specified
#' string.
#' @param AdditionalCodeRepositoryEquals A filter that returns only notebook instances with associated with the
#' specified git repository.
#'
#' @section Request syntax:
#' ```
#' svc$list_notebook_instances(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending",
#'   NameContains = "string",
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   StatusEquals = "Pending"|"InService"|"Stopping"|"Stopped"|"Failed"|"Deleting"|"Updating",
#'   NotebookInstanceLifecycleConfigNameContains = "string",
#'   DefaultCodeRepositoryContains = "string",
#'   AdditionalCodeRepositoryEquals = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_notebook_instances
sagemaker_list_notebook_instances <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL, NotebookInstanceLifecycleConfigNameContains = NULL, DefaultCodeRepositoryContains = NULL, AdditionalCodeRepositoryEquals = NULL) {
  op <- new_operation(
    name = "ListNotebookInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_notebook_instances_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals, NotebookInstanceLifecycleConfigNameContains = NotebookInstanceLifecycleConfigNameContains, DefaultCodeRepositoryContains = DefaultCodeRepositoryContains, AdditionalCodeRepositoryEquals = AdditionalCodeRepositoryEquals)
  output <- .sagemaker$list_notebook_instances_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_notebook_instances <- sagemaker_list_notebook_instances

#' Lists processing jobs that satisfy various filters
#'
#' Lists processing jobs that satisfy various filters.
#'
#' @usage
#' sagemaker_list_processing_jobs(CreationTimeAfter, CreationTimeBefore,
#'   LastModifiedTimeAfter, LastModifiedTimeBefore, NameContains,
#'   StatusEquals, SortBy, SortOrder, NextToken, MaxResults)
#'
#' @param CreationTimeAfter A filter that returns only processing jobs created after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only processing jobs created after the specified
#' time.
#' @param LastModifiedTimeAfter A filter that returns only processing jobs modified after the specified
#' time.
#' @param LastModifiedTimeBefore A filter that returns only processing jobs modified before the specified
#' time.
#' @param NameContains A string in the processing job name. This filter returns only processing
#' jobs whose name contains the specified string.
#' @param StatusEquals A filter that retrieves only processing jobs with a specific status.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param NextToken If the result of the previous `ListProcessingJobs` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of processing jobs, use the token in the next request.
#' @param MaxResults The maximum number of processing jobs to return in the response.
#'
#' @section Request syntax:
#' ```
#' svc$list_processing_jobs(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NameContains = "string",
#'   StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_processing_jobs
sagemaker_list_processing_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProcessingJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_processing_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_processing_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_processing_jobs <- sagemaker_list_processing_jobs

#' Gets a list of the work teams that you are subscribed to in the AWS
#' Marketplace
#'
#' Gets a list of the work teams that you are subscribed to in the AWS
#' Marketplace. The list may be empty if no work team satisfies the filter
#' specified in the `NameContains` parameter.
#'
#' @usage
#' sagemaker_list_subscribed_workteams(NameContains, NextToken, MaxResults)
#'
#' @param NameContains A string in the work team name. This filter returns only work teams
#' whose name contains the specified string.
#' @param NextToken If the result of the previous `ListSubscribedWorkteams` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of labeling jobs, use the token in the next request.
#' @param MaxResults The maximum number of work teams to return in each page of the response.
#'
#' @section Request syntax:
#' ```
#' svc$list_subscribed_workteams(
#'   NameContains = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_subscribed_workteams
sagemaker_list_subscribed_workteams <- function(NameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSubscribedWorkteams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_subscribed_workteams_input(NameContains = NameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_subscribed_workteams_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_subscribed_workteams <- sagemaker_list_subscribed_workteams

#' Returns the tags for the specified Amazon SageMaker resource
#'
#' Returns the tags for the specified Amazon SageMaker resource.
#'
#' @usage
#' sagemaker_list_tags(ResourceArn, NextToken, MaxResults)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' retrieve.
#' @param NextToken If the response to the previous `ListTags` request is truncated, Amazon
#' SageMaker returns this token. To retrieve the next set of tags, use it
#' in the subsequent request.
#' @param MaxResults Maximum number of tags to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags(
#'   ResourceArn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_tags
sagemaker_list_tags <- function(ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_tags_input(ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_tags <- sagemaker_list_tags

#' Lists training jobs
#'
#' Lists training jobs.
#'
#' @usage
#' sagemaker_list_training_jobs(NextToken, MaxResults, CreationTimeAfter,
#'   CreationTimeBefore, LastModifiedTimeAfter, LastModifiedTimeBefore,
#'   NameContains, StatusEquals, SortBy, SortOrder)
#'
#' @param NextToken If the result of the previous `ListTrainingJobs` request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of
#' training jobs, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return in the response.
#' @param CreationTimeAfter A filter that returns only training jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only training jobs created before the specified
#' time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only training jobs modified after the specified
#' time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only training jobs modified before the specified
#' time (timestamp).
#' @param NameContains A string in the training job name. This filter returns only training
#' jobs whose name contains the specified string.
#' @param StatusEquals A filter that retrieves only training jobs with a specific status.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_training_jobs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NameContains = "string",
#'   StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_training_jobs
sagemaker_list_training_jobs <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListTrainingJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_training_jobs_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_training_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_training_jobs <- sagemaker_list_training_jobs

#' Gets a list of TrainingJobSummary objects that describe the training
#' jobs that a hyperparameter tuning job launched
#'
#' Gets a list of TrainingJobSummary objects that describe the training
#' jobs that a hyperparameter tuning job launched.
#'
#' @usage
#' sagemaker_list_training_jobs_for_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName, NextToken, MaxResults, StatusEquals,
#'   SortBy, SortOrder)
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job whose training jobs you want to list.
#' @param NextToken If the result of the previous
#' `ListTrainingJobsForHyperParameterTuningJob` request was truncated, the
#' response includes a `NextToken`. To retrieve the next set of training
#' jobs, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return. The default value is 10.
#' @param StatusEquals A filter that returns only training jobs with the specified status.
#' @param SortBy The field to sort results by. The default is `Name`.
#' 
#' If the value of this field is `FinalObjectiveMetricValue`, any training
#' jobs that did not return an objective metric are not listed.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_training_jobs_for_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
#'   SortBy = "Name"|"CreationTime"|"Status"|"FinalObjectiveMetricValue",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_training_jobs_for_hyper_parameter_tuning_job
sagemaker_list_training_jobs_for_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName, NextToken = NULL, MaxResults = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListTrainingJobsForHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_training_jobs_for_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName, NextToken = NextToken, MaxResults = MaxResults, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_training_jobs_for_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_training_jobs_for_hyper_parameter_tuning_job <- sagemaker_list_training_jobs_for_hyper_parameter_tuning_job

#' Lists transform jobs
#'
#' Lists transform jobs.
#'
#' @usage
#' sagemaker_list_transform_jobs(CreationTimeAfter, CreationTimeBefore,
#'   LastModifiedTimeAfter, LastModifiedTimeBefore, NameContains,
#'   StatusEquals, SortBy, SortOrder, NextToken, MaxResults)
#'
#' @param CreationTimeAfter A filter that returns only transform jobs created after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only transform jobs created before the specified
#' time.
#' @param LastModifiedTimeAfter A filter that returns only transform jobs modified after the specified
#' time.
#' @param LastModifiedTimeBefore A filter that returns only transform jobs modified before the specified
#' time.
#' @param NameContains A string in the transform job name. This filter returns only transform
#' jobs whose name contains the specified string.
#' @param StatusEquals A filter that retrieves only transform jobs with a specific status.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of the previous `ListTransformJobs` request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of
#' transform jobs, use the token in the next request.
#' @param MaxResults The maximum number of transform jobs to return in the response. The
#' default value is `10`.
#'
#' @section Request syntax:
#' ```
#' svc$list_transform_jobs(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NameContains = "string",
#'   StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_transform_jobs
sagemaker_list_transform_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTransformJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_transform_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_transform_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_transform_jobs <- sagemaker_list_transform_jobs

#' Lists the trial components in your account
#'
#' Lists the trial components in your account. You can sort the list by
#' trial component name or creation time. You can filter the list to show
#' only components that were created in a specific time range. You can also
#' filter on one of the following:
#' 
#' -   `ExperimentName`
#' 
#' -   `SourceArn`
#' 
#' -   `TrialName`
#'
#' @usage
#' sagemaker_list_trial_components(ExperimentName, TrialName, SourceArn,
#'   CreatedAfter, CreatedBefore, SortBy, SortOrder, MaxResults, NextToken)
#'
#' @param ExperimentName A filter that returns only components that are part of the specified
#' experiment. If you specify `ExperimentName`, you can\'t filter by
#' `SourceArn` or `TrialName`.
#' @param TrialName A filter that returns only components that are part of the specified
#' trial. If you specify `TrialName`, you can\'t filter by `ExperimentName`
#' or `SourceArn`.
#' @param SourceArn A filter that returns only components that have the specified source
#' Amazon Resource Name (ARN). If you specify `SourceArn`, you can\'t
#' filter by `ExperimentName` or `TrialName`.
#' @param CreatedAfter A filter that returns only components created after the specified time.
#' @param CreatedBefore A filter that returns only components created before the specified time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param MaxResults The maximum number of components to return in the response. The default
#' value is 10.
#' @param NextToken If the previous call to `ListTrialComponents` didn\'t return the full
#' set of components, the call returns a token for getting the next set of
#' components.
#'
#' @section Request syntax:
#' ```
#' svc$list_trial_components(
#'   ExperimentName = "string",
#'   TrialName = "string",
#'   SourceArn = "string",
#'   CreatedAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreatedBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   SortBy = "Name"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_trial_components
sagemaker_list_trial_components <- function(ExperimentName = NULL, TrialName = NULL, SourceArn = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTrialComponents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_trial_components_input(ExperimentName = ExperimentName, TrialName = TrialName, SourceArn = SourceArn, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_trial_components_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_trial_components <- sagemaker_list_trial_components

#' Lists the trials in your account
#'
#' Lists the trials in your account. Specify an experiment name to limit
#' the list to the trials that are part of that experiment. Specify a trial
#' component name to limit the list to the trials that associated with that
#' trial component. The list can be filtered to show only trials that were
#' created in a specific time range. The list can be sorted by trial name
#' or creation time.
#'
#' @usage
#' sagemaker_list_trials(ExperimentName, TrialComponentName, CreatedAfter,
#'   CreatedBefore, SortBy, SortOrder, MaxResults, NextToken)
#'
#' @param ExperimentName A filter that returns only trials that are part of the specified
#' experiment.
#' @param TrialComponentName A filter that returns only trials that are associated with the specified
#' trial component.
#' @param CreatedAfter A filter that returns only trials created after the specified time.
#' @param CreatedBefore A filter that returns only trials created before the specified time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param MaxResults The maximum number of trials to return in the response. The default
#' value is 10.
#' @param NextToken If the previous call to `ListTrials` didn\'t return the full set of
#' trials, the call returns a token for getting the next set of trials.
#'
#' @section Request syntax:
#' ```
#' svc$list_trials(
#'   ExperimentName = "string",
#'   TrialComponentName = "string",
#'   CreatedAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreatedBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   SortBy = "Name"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_trials
sagemaker_list_trials <- function(ExperimentName = NULL, TrialComponentName = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTrials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_trials_input(ExperimentName = ExperimentName, TrialComponentName = TrialComponentName, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_trials_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_trials <- sagemaker_list_trials

#' Lists user profiles
#'
#' Lists user profiles.
#'
#' @usage
#' sagemaker_list_user_profiles(NextToken, MaxResults, SortOrder, SortBy,
#'   DomainIdEquals, UserProfileNameContains)
#'
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults Returns a list up to a specified limit.
#' @param SortOrder The sort order for the results. The default is Ascending.
#' @param SortBy The parameter by which to sort the results. The default is CreationTime.
#' @param DomainIdEquals A parameter by which to filter the results.
#' @param UserProfileNameContains A parameter by which to filter the results.
#'
#' @section Request syntax:
#' ```
#' svc$list_user_profiles(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   SortOrder = "Ascending"|"Descending",
#'   SortBy = "CreationTime"|"LastModifiedTime",
#'   DomainIdEquals = "string",
#'   UserProfileNameContains = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_user_profiles
sagemaker_list_user_profiles <- function(NextToken = NULL, MaxResults = NULL, SortOrder = NULL, SortBy = NULL, DomainIdEquals = NULL, UserProfileNameContains = NULL) {
  op <- new_operation(
    name = "ListUserProfiles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_user_profiles_input(NextToken = NextToken, MaxResults = MaxResults, SortOrder = SortOrder, SortBy = SortBy, DomainIdEquals = DomainIdEquals, UserProfileNameContains = UserProfileNameContains)
  output <- .sagemaker$list_user_profiles_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_user_profiles <- sagemaker_list_user_profiles

#' Gets a list of work teams that you have defined in a region
#'
#' Gets a list of work teams that you have defined in a region. The list
#' may be empty if no work team satisfies the filter specified in the
#' `NameContains` parameter.
#'
#' @usage
#' sagemaker_list_workteams(SortBy, SortOrder, NameContains, NextToken,
#'   MaxResults)
#'
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param NameContains A string in the work team\'s name. This filter returns only work teams
#' whose name contains the specified string.
#' @param NextToken If the result of the previous `ListWorkteams` request was truncated, the
#' response includes a `NextToken`. To retrieve the next set of labeling
#' jobs, use the token in the next request.
#' @param MaxResults The maximum number of work teams to return in each page of the response.
#'
#' @section Request syntax:
#' ```
#' svc$list_workteams(
#'   SortBy = "Name"|"CreateDate",
#'   SortOrder = "Ascending"|"Descending",
#'   NameContains = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_workteams
sagemaker_list_workteams <- function(SortBy = NULL, SortOrder = NULL, NameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkteams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_workteams_input(SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_workteams_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_workteams <- sagemaker_list_workteams

#' Renders the UI template so that you can preview the worker's experience
#'
#' Renders the UI template so that you can preview the worker\'s
#' experience.
#'
#' @usage
#' sagemaker_render_ui_template(UiTemplate, Task, RoleArn, HumanTaskUiArn)
#'
#' @param UiTemplate A `Template` object containing the worker UI template to render.
#' @param Task &#91;required&#93; A `RenderableTask` object containing a representative task to render.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) that has access to the S3 objects that
#' are used by the template.
#' @param HumanTaskUiArn The `HumanTaskUiArn` of the worker UI that you want to render. Do not
#' provide a `HumanTaskUiArn` if you use the `UiTemplate` parameter.
#' 
#' See a list of available Human Ui Amazon Resource Names (ARNs) in
#' UiConfig.
#'
#' @section Request syntax:
#' ```
#' svc$render_ui_template(
#'   UiTemplate = list(
#'     Content = "string"
#'   ),
#'   Task = list(
#'     Input = "string"
#'   ),
#'   RoleArn = "string",
#'   HumanTaskUiArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_render_ui_template
sagemaker_render_ui_template <- function(UiTemplate = NULL, Task, RoleArn, HumanTaskUiArn = NULL) {
  op <- new_operation(
    name = "RenderUiTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$render_ui_template_input(UiTemplate = UiTemplate, Task = Task, RoleArn = RoleArn, HumanTaskUiArn = HumanTaskUiArn)
  output <- .sagemaker$render_ui_template_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$render_ui_template <- sagemaker_render_ui_template

#' Finds Amazon SageMaker resources that match a search query
#'
#' Finds Amazon SageMaker resources that match a search query. Matching
#' resources are returned as a list of `SearchRecord` objects in the
#' response. You can sort the search results by any resource property in a
#' ascending or descending order.
#' 
#' You can query against the following value types: numeric, text, Boolean,
#' and timestamp.
#'
#' @usage
#' sagemaker_search(Resource, SearchExpression, SortBy, SortOrder,
#'   NextToken, MaxResults)
#'
#' @param Resource &#91;required&#93; The name of the Amazon SageMaker resource to search for.
#' @param SearchExpression A Boolean conditional statement. Resources must satisfy this condition
#' to be included in search results. You must provide at least one
#' subexpression, filter, or nested filter. The maximum number of recursive
#' `SubExpressions`, `NestedFilters`, and `Filters` that can be included in
#' a `SearchExpression` object is 50.
#' @param SortBy The name of the resource property used to sort the `SearchResults`. The
#' default is `LastModifiedTime`.
#' @param SortOrder How `SearchResults` are ordered. Valid values are `Ascending` or
#' `Descending`. The default is `Descending`.
#' @param NextToken If more than `MaxResults` resources match the specified
#' `SearchExpression`, the response includes a `NextToken`. The `NextToken`
#' can be passed to the next `SearchRequest` to continue retrieving
#' results.
#' @param MaxResults The maximum number of results to return.
#'
#' @section Request syntax:
#' ```
#' svc$search(
#'   Resource = "TrainingJob"|"Experiment"|"ExperimentTrial"|"ExperimentTrialComponent",
#'   SearchExpression = list(
#'     Filters = list(
#'       list(
#'         Name = "string",
#'         Operator = "Equals"|"NotEquals"|"GreaterThan"|"GreaterThanOrEqualTo"|"LessThan"|"LessThanOrEqualTo"|"Contains"|"Exists"|"NotExists"|"In",
#'         Value = "string"
#'       )
#'     ),
#'     NestedFilters = list(
#'       list(
#'         NestedPropertyName = "string",
#'         Filters = list(
#'           list(
#'             Name = "string",
#'             Operator = "Equals"|"NotEquals"|"GreaterThan"|"GreaterThanOrEqualTo"|"LessThan"|"LessThanOrEqualTo"|"Contains"|"Exists"|"NotExists"|"In",
#'             Value = "string"
#'           )
#'         )
#'       )
#'     ),
#'     SubExpressions = list(
#'       list()
#'     ),
#'     Operator = "And"|"Or"
#'   ),
#'   SortBy = "string",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_search
sagemaker_search <- function(Resource, SearchExpression = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "Search",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$search_input(Resource = Resource, SearchExpression = SearchExpression, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$search_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$search <- sagemaker_search

#' Starts a previously stopped monitoring schedule
#'
#' Starts a previously stopped monitoring schedule.
#' 
#' New monitoring schedules are immediately started after creation.
#'
#' @usage
#' sagemaker_start_monitoring_schedule(MonitoringScheduleName)
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the schedule to start.
#'
#' @section Request syntax:
#' ```
#' svc$start_monitoring_schedule(
#'   MonitoringScheduleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_monitoring_schedule
sagemaker_start_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "StartMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$start_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$start_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_monitoring_schedule <- sagemaker_start_monitoring_schedule

#' Launches an ML compute instance with the latest version of the libraries
#' and attaches your ML storage volume
#'
#' Launches an ML compute instance with the latest version of the libraries
#' and attaches your ML storage volume. After configuring the notebook
#' instance, Amazon SageMaker sets the notebook instance status to
#' `InService`. A notebook instance\'s status must be `InService` before
#' you can connect to your Jupyter notebook.
#'
#' @usage
#' sagemaker_start_notebook_instance(NotebookInstanceName)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to start.
#'
#' @section Request syntax:
#' ```
#' svc$start_notebook_instance(
#'   NotebookInstanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_notebook_instance
sagemaker_start_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "StartNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$start_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$start_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_notebook_instance <- sagemaker_start_notebook_instance

#' A method for forcing the termination of a running job
#'
#' A method for forcing the termination of a running job.
#'
#' @usage
#' sagemaker_stop_auto_ml_job(AutoMLJobName)
#'
#' @param AutoMLJobName &#91;required&#93; The name of the object you are requesting.
#'
#' @section Request syntax:
#' ```
#' svc$stop_auto_ml_job(
#'   AutoMLJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_auto_ml_job
sagemaker_stop_auto_ml_job <- function(AutoMLJobName) {
  op <- new_operation(
    name = "StopAutoMLJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_auto_ml_job_input(AutoMLJobName = AutoMLJobName)
  output <- .sagemaker$stop_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_auto_ml_job <- sagemaker_stop_auto_ml_job

#' Stops a model compilation job
#'
#' Stops a model compilation job.
#' 
#' To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal.
#' This gracefully shuts the job down. If the job hasn\'t stopped, it sends
#' the SIGKILL signal.
#' 
#' When it receives a `StopCompilationJob` request, Amazon SageMaker
#' changes the CompilationJobSummary\\$CompilationJobStatus of the job to
#' `Stopping`. After Amazon SageMaker stops the job, it sets the
#' CompilationJobSummary\\$CompilationJobStatus to `Stopped`.
#'
#' @usage
#' sagemaker_stop_compilation_job(CompilationJobName)
#'
#' @param CompilationJobName &#91;required&#93; The name of the model compilation job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_compilation_job(
#'   CompilationJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_compilation_job
sagemaker_stop_compilation_job <- function(CompilationJobName) {
  op <- new_operation(
    name = "StopCompilationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_compilation_job_input(CompilationJobName = CompilationJobName)
  output <- .sagemaker$stop_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_compilation_job <- sagemaker_stop_compilation_job

#' Stops a running hyperparameter tuning job and all running training jobs
#' that the tuning job launched
#'
#' Stops a running hyperparameter tuning job and all running training jobs
#' that the tuning job launched.
#' 
#' All model artifacts output from the training jobs are stored in Amazon
#' Simple Storage Service (Amazon S3). All data that the training jobs
#' write to Amazon CloudWatch Logs are still available in CloudWatch. After
#' the tuning job moves to the `Stopped` state, it releases all reserved
#' resources for the tuning job.
#'
#' @usage
#' sagemaker_stop_hyper_parameter_tuning_job(HyperParameterTuningJobName)
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_hyper_parameter_tuning_job
sagemaker_stop_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName) {
  op <- new_operation(
    name = "StopHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName)
  output <- .sagemaker$stop_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_hyper_parameter_tuning_job <- sagemaker_stop_hyper_parameter_tuning_job

#' Stops a running labeling job
#'
#' Stops a running labeling job. A job that is stopped cannot be restarted.
#' Any results obtained before the job is stopped are placed in the Amazon
#' S3 output bucket.
#'
#' @usage
#' sagemaker_stop_labeling_job(LabelingJobName)
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_labeling_job(
#'   LabelingJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_labeling_job
sagemaker_stop_labeling_job <- function(LabelingJobName) {
  op <- new_operation(
    name = "StopLabelingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_labeling_job_input(LabelingJobName = LabelingJobName)
  output <- .sagemaker$stop_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_labeling_job <- sagemaker_stop_labeling_job

#' Stops a previously started monitoring schedule
#'
#' Stops a previously started monitoring schedule.
#'
#' @usage
#' sagemaker_stop_monitoring_schedule(MonitoringScheduleName)
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the schedule to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_monitoring_schedule(
#'   MonitoringScheduleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_monitoring_schedule
sagemaker_stop_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "StopMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$stop_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_monitoring_schedule <- sagemaker_stop_monitoring_schedule

#' Terminates the ML compute instance
#'
#' Terminates the ML compute instance. Before terminating the instance,
#' Amazon SageMaker disconnects the ML storage volume from it. Amazon
#' SageMaker preserves the ML storage volume. Amazon SageMaker stops
#' charging you for the ML compute instance when you call
#' `StopNotebookInstance`.
#' 
#' To access data on the ML storage volume for a notebook instance that has
#' been terminated, call the `StartNotebookInstance` API.
#' `StartNotebookInstance` launches another ML compute instance, configures
#' it, and attaches the preserved ML storage volume so you can continue
#' your work.
#'
#' @usage
#' sagemaker_stop_notebook_instance(NotebookInstanceName)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to terminate.
#'
#' @section Request syntax:
#' ```
#' svc$stop_notebook_instance(
#'   NotebookInstanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_notebook_instance
sagemaker_stop_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "StopNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$stop_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_notebook_instance <- sagemaker_stop_notebook_instance

#' Stops a processing job
#'
#' Stops a processing job.
#'
#' @usage
#' sagemaker_stop_processing_job(ProcessingJobName)
#'
#' @param ProcessingJobName &#91;required&#93; The name of the processing job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_processing_job(
#'   ProcessingJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_processing_job
sagemaker_stop_processing_job <- function(ProcessingJobName) {
  op <- new_operation(
    name = "StopProcessingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_processing_job_input(ProcessingJobName = ProcessingJobName)
  output <- .sagemaker$stop_processing_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_processing_job <- sagemaker_stop_processing_job

#' Stops a training job
#'
#' Stops a training job. To stop a job, Amazon SageMaker sends the
#' algorithm the `SIGTERM` signal, which delays job termination for 120
#' seconds. Algorithms might use this 120-second window to save the model
#' artifacts, so the results of the training is not lost.
#' 
#' When it receives a `StopTrainingJob` request, Amazon SageMaker changes
#' the status of the job to `Stopping`. After Amazon SageMaker stops the
#' job, it sets the status to `Stopped`.
#'
#' @usage
#' sagemaker_stop_training_job(TrainingJobName)
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_training_job(
#'   TrainingJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_training_job
sagemaker_stop_training_job <- function(TrainingJobName) {
  op <- new_operation(
    name = "StopTrainingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_training_job_input(TrainingJobName = TrainingJobName)
  output <- .sagemaker$stop_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_training_job <- sagemaker_stop_training_job

#' Stops a transform job
#'
#' Stops a transform job.
#' 
#' When Amazon SageMaker receives a `StopTransformJob` request, the status
#' of the job changes to `Stopping`. After Amazon SageMaker stops the job,
#' the status is set to `Stopped`. When you stop a transform job before it
#' is completed, Amazon SageMaker doesn\'t store the job\'s output in
#' Amazon S3.
#'
#' @usage
#' sagemaker_stop_transform_job(TransformJobName)
#'
#' @param TransformJobName &#91;required&#93; The name of the transform job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_transform_job(
#'   TransformJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_transform_job
sagemaker_stop_transform_job <- function(TransformJobName) {
  op <- new_operation(
    name = "StopTransformJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_transform_job_input(TransformJobName = TransformJobName)
  output <- .sagemaker$stop_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_transform_job <- sagemaker_stop_transform_job

#' Updates the specified Git repository with the specified values
#'
#' Updates the specified Git repository with the specified values.
#'
#' @usage
#' sagemaker_update_code_repository(CodeRepositoryName, GitConfig)
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to update.
#' @param GitConfig The configuration of the git repository, including the URL and the
#' Amazon Resource Name (ARN) of the AWS Secrets Manager secret that
#' contains the credentials used to access the repository. The secret must
#' have a staging label of `AWSCURRENT` and must be in the following
#' format:
#' 
#' `\{"username": <i>UserName</i>, "password": <i>Password</i>\}`
#'
#' @section Request syntax:
#' ```
#' svc$update_code_repository(
#'   CodeRepositoryName = "string",
#'   GitConfig = list(
#'     SecretArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_code_repository
sagemaker_update_code_repository <- function(CodeRepositoryName, GitConfig = NULL) {
  op <- new_operation(
    name = "UpdateCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_code_repository_input(CodeRepositoryName = CodeRepositoryName, GitConfig = GitConfig)
  output <- .sagemaker$update_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_code_repository <- sagemaker_update_code_repository

#' Updates the default settings for new user profiles in the domain
#'
#' Updates the default settings for new user profiles in the domain.
#'
#' @usage
#' sagemaker_update_domain(DomainId, DefaultUserSettings)
#'
#' @param DomainId &#91;required&#93; The ID of the domain to be updated.
#' @param DefaultUserSettings A collection of settings.
#'
#' @section Request syntax:
#' ```
#' svc$update_domain(
#'   DomainId = "string",
#'   DefaultUserSettings = list(
#'     ExecutionRole = "string",
#'     SecurityGroups = list(
#'       "string"
#'     ),
#'     SharingSettings = list(
#'       NotebookOutputOption = "Allowed"|"Disabled",
#'       S3OutputPath = "string",
#'       S3KmsKeyId = "string"
#'     ),
#'     JupyterServerAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     ),
#'     KernelGatewayAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     ),
#'     TensorBoardAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_domain
sagemaker_update_domain <- function(DomainId, DefaultUserSettings = NULL) {
  op <- new_operation(
    name = "UpdateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_domain_input(DomainId = DomainId, DefaultUserSettings = DefaultUserSettings)
  output <- .sagemaker$update_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_domain <- sagemaker_update_domain

#' Deploys the new EndpointConfig specified in the request, switches to
#' using newly created endpoint, and then deletes resources provisioned for
#' the endpoint using the previous EndpointConfig (there is no availability
#' loss)
#'
#' Deploys the new `EndpointConfig` specified in the request, switches to
#' using newly created endpoint, and then deletes resources provisioned for
#' the endpoint using the previous `EndpointConfig` (there is no
#' availability loss).
#' 
#' When Amazon SageMaker receives the request, it sets the endpoint status
#' to `Updating`. After updating the endpoint, it sets the status to
#' `InService`. To check the status of an endpoint, use the
#' DescribeEndpoint API.
#' 
#' You must not delete an `EndpointConfig` in use by an endpoint that is
#' live or while the `UpdateEndpoint` or `CreateEndpoint` operations are
#' being performed on the endpoint. To update an endpoint, you must create
#' a new `EndpointConfig`.
#' 
#' If you delete the `EndpointConfig` of an endpoint that is active or
#' being created or updated you may lose visibility into the instance type
#' the endpoint is using. The endpoint must be deleted in order to stop
#' incurring charges.
#'
#' @usage
#' sagemaker_update_endpoint(EndpointName, EndpointConfigName,
#'   RetainAllVariantProperties, ExcludeRetainedVariantProperties)
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint whose configuration you want to update.
#' @param EndpointConfigName &#91;required&#93; The name of the new endpoint configuration.
#' @param RetainAllVariantProperties When updating endpoint resources, enables or disables the retention of
#' variant properties, such as the instance count or the variant weight. To
#' retain the variant properties of an endpoint when updating it, set
#' `RetainAllVariantProperties` to `true`. To use the variant properties
#' specified in a new `EndpointConfig` call when updating an endpoint, set
#' `RetainAllVariantProperties` to `false`.
#' @param ExcludeRetainedVariantProperties When you are updating endpoint resources with
#' UpdateEndpointInput\\$RetainAllVariantProperties, whose value is set to
#' `true`, `ExcludeRetainedVariantProperties` specifies the list of type
#' VariantProperty to override with the values provided by
#' `EndpointConfig`. If you don\'t specify a value for
#' `ExcludeAllVariantProperties`, no variant properties are overridden.
#'
#' @section Request syntax:
#' ```
#' svc$update_endpoint(
#'   EndpointName = "string",
#'   EndpointConfigName = "string",
#'   RetainAllVariantProperties = TRUE|FALSE,
#'   ExcludeRetainedVariantProperties = list(
#'     list(
#'       VariantPropertyType = "DesiredInstanceCount"|"DesiredWeight"|"DataCaptureConfig"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_endpoint
sagemaker_update_endpoint <- function(EndpointName, EndpointConfigName, RetainAllVariantProperties = NULL, ExcludeRetainedVariantProperties = NULL) {
  op <- new_operation(
    name = "UpdateEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_endpoint_input(EndpointName = EndpointName, EndpointConfigName = EndpointConfigName, RetainAllVariantProperties = RetainAllVariantProperties, ExcludeRetainedVariantProperties = ExcludeRetainedVariantProperties)
  output <- .sagemaker$update_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_endpoint <- sagemaker_update_endpoint

#' Updates variant weight of one or more variants associated with an
#' existing endpoint, or capacity of one variant associated with an
#' existing endpoint
#'
#' Updates variant weight of one or more variants associated with an
#' existing endpoint, or capacity of one variant associated with an
#' existing endpoint. When it receives the request, Amazon SageMaker sets
#' the endpoint status to `Updating`. After updating the endpoint, it sets
#' the status to `InService`. To check the status of an endpoint, use the
#' DescribeEndpoint API.
#'
#' @usage
#' sagemaker_update_endpoint_weights_and_capacities(EndpointName,
#'   DesiredWeightsAndCapacities)
#'
#' @param EndpointName &#91;required&#93; The name of an existing Amazon SageMaker endpoint.
#' @param DesiredWeightsAndCapacities &#91;required&#93; An object that provides new capacity and weight values for a variant.
#'
#' @section Request syntax:
#' ```
#' svc$update_endpoint_weights_and_capacities(
#'   EndpointName = "string",
#'   DesiredWeightsAndCapacities = list(
#'     list(
#'       VariantName = "string",
#'       DesiredWeight = 123.0,
#'       DesiredInstanceCount = 123
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_endpoint_weights_and_capacities
sagemaker_update_endpoint_weights_and_capacities <- function(EndpointName, DesiredWeightsAndCapacities) {
  op <- new_operation(
    name = "UpdateEndpointWeightsAndCapacities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_endpoint_weights_and_capacities_input(EndpointName = EndpointName, DesiredWeightsAndCapacities = DesiredWeightsAndCapacities)
  output <- .sagemaker$update_endpoint_weights_and_capacities_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_endpoint_weights_and_capacities <- sagemaker_update_endpoint_weights_and_capacities

#' Adds, updates, or removes the description of an experiment
#'
#' Adds, updates, or removes the description of an experiment. Updates the
#' display name of an experiment.
#'
#' @usage
#' sagemaker_update_experiment(ExperimentName, DisplayName, Description)
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment to update.
#' @param DisplayName The name of the experiment as displayed. The name doesn\'t need to be
#' unique. If `DisplayName` isn\'t specified, `ExperimentName` is
#' displayed.
#' @param Description The description of the experiment.
#'
#' @section Request syntax:
#' ```
#' svc$update_experiment(
#'   ExperimentName = "string",
#'   DisplayName = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_experiment
sagemaker_update_experiment <- function(ExperimentName, DisplayName = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateExperiment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_experiment_input(ExperimentName = ExperimentName, DisplayName = DisplayName, Description = Description)
  output <- .sagemaker$update_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_experiment <- sagemaker_update_experiment

#' Updates a previously created schedule
#'
#' Updates a previously created schedule.
#'
#' @usage
#' sagemaker_update_monitoring_schedule(MonitoringScheduleName,
#'   MonitoringScheduleConfig)
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the monitoring schedule. The name must be unique within an
#' AWS Region within an AWS account.
#' @param MonitoringScheduleConfig &#91;required&#93; The configuration object that specifies the monitoring schedule and
#' defines the monitoring job.
#'
#' @section Request syntax:
#' ```
#' svc$update_monitoring_schedule(
#'   MonitoringScheduleName = "string",
#'   MonitoringScheduleConfig = list(
#'     ScheduleConfig = list(
#'       ScheduleExpression = "string"
#'     ),
#'     MonitoringJobDefinition = list(
#'       BaselineConfig = list(
#'         ConstraintsResource = list(
#'           S3Uri = "string"
#'         ),
#'         StatisticsResource = list(
#'           S3Uri = "string"
#'         )
#'       ),
#'       MonitoringInputs = list(
#'         list(
#'           EndpointInput = list(
#'             EndpointName = "string",
#'             LocalPath = "string",
#'             S3InputMode = "Pipe"|"File",
#'             S3DataDistributionType = "FullyReplicated"|"ShardedByS3Key"
#'           )
#'         )
#'       ),
#'       MonitoringOutputConfig = list(
#'         MonitoringOutputs = list(
#'           list(
#'             S3Output = list(
#'               S3Uri = "string",
#'               LocalPath = "string",
#'               S3UploadMode = "Continuous"|"EndOfJob"
#'             )
#'           )
#'         ),
#'         KmsKeyId = "string"
#'       ),
#'       MonitoringResources = list(
#'         ClusterConfig = list(
#'           InstanceCount = 123,
#'           InstanceType = "ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.8xlarge"|"ml.r5.12xlarge"|"ml.r5.16xlarge"|"ml.r5.24xlarge",
#'           VolumeSizeInGB = 123,
#'           VolumeKmsKeyId = "string"
#'         )
#'       ),
#'       MonitoringAppSpecification = list(
#'         ImageUri = "string",
#'         ContainerEntrypoint = list(
#'           "string"
#'         ),
#'         ContainerArguments = list(
#'           "string"
#'         ),
#'         RecordPreprocessorSourceUri = "string",
#'         PostAnalyticsProcessorSourceUri = "string"
#'       ),
#'       StoppingCondition = list(
#'         MaxRuntimeInSeconds = 123
#'       ),
#'       Environment = list(
#'         "string"
#'       ),
#'       NetworkConfig = list(
#'         EnableInterContainerTrafficEncryption = TRUE|FALSE,
#'         EnableNetworkIsolation = TRUE|FALSE,
#'         VpcConfig = list(
#'           SecurityGroupIds = list(
#'             "string"
#'           ),
#'           Subnets = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       RoleArn = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_monitoring_schedule
sagemaker_update_monitoring_schedule <- function(MonitoringScheduleName, MonitoringScheduleConfig) {
  op <- new_operation(
    name = "UpdateMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName, MonitoringScheduleConfig = MonitoringScheduleConfig)
  output <- .sagemaker$update_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_monitoring_schedule <- sagemaker_update_monitoring_schedule

#' Updates a notebook instance
#'
#' Updates a notebook instance. NotebookInstance updates include upgrading
#' or downgrading the ML compute instance used for your notebook instance
#' to accommodate changes in your workload requirements.
#'
#' @usage
#' sagemaker_update_notebook_instance(NotebookInstanceName, InstanceType,
#'   RoleArn, LifecycleConfigName, DisassociateLifecycleConfig,
#'   VolumeSizeInGB, DefaultCodeRepository, AdditionalCodeRepositories,
#'   AcceleratorTypes, DisassociateAcceleratorTypes,
#'   DisassociateDefaultCodeRepository,
#'   DisassociateAdditionalCodeRepositories, RootAccess)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to update.
#' @param InstanceType The Amazon ML compute instance type.
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can
#' assume to access the notebook instance. For more information, see
#' [Amazon SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to Amazon SageMaker, the caller of this API
#' must have the `iam:PassRole` permission.
#' @param LifecycleConfigName The name of a lifecycle configuration to associate with the notebook
#' instance. For information about lifestyle configurations, see [Step 2.1:
#' (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#' @param DisassociateLifecycleConfig Set to `true` to remove the notebook instance lifecycle configuration
#' currently associated with the notebook instance. This operation is
#' idempotent. If you specify a lifecycle configuration that is not
#' associated with the notebook instance when you call this method, it does
#' not throw an error.
#' @param VolumeSizeInGB The size, in GB, of the ML storage volume to attach to the notebook
#' instance. The default value is 5 GB. ML storage volumes are encrypted,
#' so Amazon SageMaker can\'t determine the amount of available free space
#' on the volume. Because of this, you can increase the volume size when
#' you update a notebook instance, but you can\'t decrease the volume size.
#' If you want to decrease the size of the ML storage volume in use, create
#' a new notebook instance with the desired size.
#' @param DefaultCodeRepository The Git repository to associate with the notebook instance as its
#' default code repository. This can be either the name of a Git repository
#' stored as a resource in your account, or the URL of a Git repository in
#' [AWS
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. When you open a notebook instance, it
#' opens in the directory that contains this repository. For more
#' information, see [Associating Git Repositories with Amazon SageMaker
#' Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AdditionalCodeRepositories An array of up to three Git repositories to associate with the notebook
#' instance. These can be either the names of Git repositories stored as
#' resources in your account, or the URL of Git repositories in [AWS
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. These repositories are cloned at the
#' same level as the default repository of your notebook instance. For more
#' information, see [Associating Git Repositories with Amazon SageMaker
#' Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AcceleratorTypes A list of the Elastic Inference (EI) instance types to associate with
#' this notebook instance. Currently only one EI instance type can be
#' associated with a notebook instance. For more information, see [Using
#' Elastic Inference in Amazon
#' SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
#' @param DisassociateAcceleratorTypes A list of the Elastic Inference (EI) instance types to remove from this
#' notebook instance. This operation is idempotent. If you specify an
#' accelerator type that is not associated with the notebook instance when
#' you call this method, it does not throw an error.
#' @param DisassociateDefaultCodeRepository The name or URL of the default Git repository to remove from this
#' notebook instance. This operation is idempotent. If you specify a Git
#' repository that is not associated with the notebook instance when you
#' call this method, it does not throw an error.
#' @param DisassociateAdditionalCodeRepositories A list of names or URLs of the default Git repositories to remove from
#' this notebook instance. This operation is idempotent. If you specify a
#' Git repository that is not associated with the notebook instance when
#' you call this method, it does not throw an error.
#' @param RootAccess Whether root access is enabled or disabled for users of the notebook
#' instance. The default value is `Enabled`.
#' 
#' If you set this to `Disabled`, users don\'t have root access on the
#' notebook instance, but lifecycle configuration scripts still run with
#' root permissions.
#'
#' @section Request syntax:
#' ```
#' svc$update_notebook_instance(
#'   NotebookInstanceName = "string",
#'   InstanceType = "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5d.xlarge"|"ml.c5d.2xlarge"|"ml.c5d.4xlarge"|"ml.c5d.9xlarge"|"ml.c5d.18xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge",
#'   RoleArn = "string",
#'   LifecycleConfigName = "string",
#'   DisassociateLifecycleConfig = TRUE|FALSE,
#'   VolumeSizeInGB = 123,
#'   DefaultCodeRepository = "string",
#'   AdditionalCodeRepositories = list(
#'     "string"
#'   ),
#'   AcceleratorTypes = list(
#'     "ml.eia1.medium"|"ml.eia1.large"|"ml.eia1.xlarge"|"ml.eia2.medium"|"ml.eia2.large"|"ml.eia2.xlarge"
#'   ),
#'   DisassociateAcceleratorTypes = TRUE|FALSE,
#'   DisassociateDefaultCodeRepository = TRUE|FALSE,
#'   DisassociateAdditionalCodeRepositories = TRUE|FALSE,
#'   RootAccess = "Enabled"|"Disabled"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_notebook_instance
sagemaker_update_notebook_instance <- function(NotebookInstanceName, InstanceType = NULL, RoleArn = NULL, LifecycleConfigName = NULL, DisassociateLifecycleConfig = NULL, VolumeSizeInGB = NULL, DefaultCodeRepository = NULL, AdditionalCodeRepositories = NULL, AcceleratorTypes = NULL, DisassociateAcceleratorTypes = NULL, DisassociateDefaultCodeRepository = NULL, DisassociateAdditionalCodeRepositories = NULL, RootAccess = NULL) {
  op <- new_operation(
    name = "UpdateNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_notebook_instance_input(NotebookInstanceName = NotebookInstanceName, InstanceType = InstanceType, RoleArn = RoleArn, LifecycleConfigName = LifecycleConfigName, DisassociateLifecycleConfig = DisassociateLifecycleConfig, VolumeSizeInGB = VolumeSizeInGB, DefaultCodeRepository = DefaultCodeRepository, AdditionalCodeRepositories = AdditionalCodeRepositories, AcceleratorTypes = AcceleratorTypes, DisassociateAcceleratorTypes = DisassociateAcceleratorTypes, DisassociateDefaultCodeRepository = DisassociateDefaultCodeRepository, DisassociateAdditionalCodeRepositories = DisassociateAdditionalCodeRepositories, RootAccess = RootAccess)
  output <- .sagemaker$update_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_notebook_instance <- sagemaker_update_notebook_instance

#' Updates a notebook instance lifecycle configuration created with the
#' CreateNotebookInstanceLifecycleConfig API
#'
#' Updates a notebook instance lifecycle configuration created with the
#' CreateNotebookInstanceLifecycleConfig API.
#'
#' @usage
#' sagemaker_update_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName, OnCreate, OnStart)
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration.
#' @param OnCreate The shell script that runs only once, when you create a notebook
#' instance. The shell script must be a base64-encoded string.
#' @param OnStart The shell script that runs every time you start a notebook instance,
#' including when you create the notebook instance. The shell script must
#' be a base64-encoded string.
#'
#' @section Request syntax:
#' ```
#' svc$update_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName = "string",
#'   OnCreate = list(
#'     list(
#'       Content = "string"
#'     )
#'   ),
#'   OnStart = list(
#'     list(
#'       Content = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_notebook_instance_lifecycle_config
sagemaker_update_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName, OnCreate = NULL, OnStart = NULL) {
  op <- new_operation(
    name = "UpdateNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName, OnCreate = OnCreate, OnStart = OnStart)
  output <- .sagemaker$update_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_notebook_instance_lifecycle_config <- sagemaker_update_notebook_instance_lifecycle_config

#' Updates the display name of a trial
#'
#' Updates the display name of a trial.
#'
#' @usage
#' sagemaker_update_trial(TrialName, DisplayName)
#'
#' @param TrialName &#91;required&#93; The name of the trial to update.
#' @param DisplayName The name of the trial as displayed. The name doesn\'t need to be unique.
#' If `DisplayName` isn\'t specified, `TrialName` is displayed.
#'
#' @section Request syntax:
#' ```
#' svc$update_trial(
#'   TrialName = "string",
#'   DisplayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_trial
sagemaker_update_trial <- function(TrialName, DisplayName = NULL) {
  op <- new_operation(
    name = "UpdateTrial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_trial_input(TrialName = TrialName, DisplayName = DisplayName)
  output <- .sagemaker$update_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_trial <- sagemaker_update_trial

#' Updates one or more properties of a trial component
#'
#' Updates one or more properties of a trial component.
#'
#' @usage
#' sagemaker_update_trial_component(TrialComponentName, DisplayName,
#'   Status, StartTime, EndTime, Parameters, ParametersToRemove,
#'   InputArtifacts, InputArtifactsToRemove, OutputArtifacts,
#'   OutputArtifactsToRemove)
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to update.
#' @param DisplayName The name of the component as displayed. The name doesn\'t need to be
#' unique. If `DisplayName` isn\'t specified, `TrialComponentName` is
#' displayed.
#' @param Status The new status of the component.
#' @param StartTime When the component started.
#' @param EndTime When the component ended.
#' @param Parameters Replaces all of the component\'s hyperparameters with the specified
#' hyperparameters.
#' @param ParametersToRemove The hyperparameters to remove from the component.
#' @param InputArtifacts Replaces all of the component\'s input artifacts with the specified
#' artifacts.
#' @param InputArtifactsToRemove The input artifacts to remove from the component.
#' @param OutputArtifacts Replaces all of the component\'s output artifacts with the specified
#' artifacts.
#' @param OutputArtifactsToRemove The output artifacts to remove from the component.
#'
#' @section Request syntax:
#' ```
#' svc$update_trial_component(
#'   TrialComponentName = "string",
#'   DisplayName = "string",
#'   Status = list(
#'     PrimaryStatus = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
#'     Message = "string"
#'   ),
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Parameters = list(
#'     list(
#'       StringValue = "string",
#'       NumberValue = 123.0
#'     )
#'   ),
#'   ParametersToRemove = list(
#'     "string"
#'   ),
#'   InputArtifacts = list(
#'     list(
#'       MediaType = "string",
#'       Value = "string"
#'     )
#'   ),
#'   InputArtifactsToRemove = list(
#'     "string"
#'   ),
#'   OutputArtifacts = list(
#'     list(
#'       MediaType = "string",
#'       Value = "string"
#'     )
#'   ),
#'   OutputArtifactsToRemove = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_trial_component
sagemaker_update_trial_component <- function(TrialComponentName, DisplayName = NULL, Status = NULL, StartTime = NULL, EndTime = NULL, Parameters = NULL, ParametersToRemove = NULL, InputArtifacts = NULL, InputArtifactsToRemove = NULL, OutputArtifacts = NULL, OutputArtifactsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_trial_component_input(TrialComponentName = TrialComponentName, DisplayName = DisplayName, Status = Status, StartTime = StartTime, EndTime = EndTime, Parameters = Parameters, ParametersToRemove = ParametersToRemove, InputArtifacts = InputArtifacts, InputArtifactsToRemove = InputArtifactsToRemove, OutputArtifacts = OutputArtifacts, OutputArtifactsToRemove = OutputArtifactsToRemove)
  output <- .sagemaker$update_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_trial_component <- sagemaker_update_trial_component

#' Updates a user profile
#'
#' Updates a user profile.
#'
#' @usage
#' sagemaker_update_user_profile(DomainId, UserProfileName, UserSettings)
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#' @param UserSettings A collection of settings.
#'
#' @section Request syntax:
#' ```
#' svc$update_user_profile(
#'   DomainId = "string",
#'   UserProfileName = "string",
#'   UserSettings = list(
#'     ExecutionRole = "string",
#'     SecurityGroups = list(
#'       "string"
#'     ),
#'     SharingSettings = list(
#'       NotebookOutputOption = "Allowed"|"Disabled",
#'       S3OutputPath = "string",
#'       S3KmsKeyId = "string"
#'     ),
#'     JupyterServerAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     ),
#'     KernelGatewayAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     ),
#'     TensorBoardAppSettings = list(
#'       DefaultResourceSpec = list(
#'         SageMakerImageArn = "string",
#'         InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_user_profile
sagemaker_update_user_profile <- function(DomainId, UserProfileName, UserSettings = NULL) {
  op <- new_operation(
    name = "UpdateUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName, UserSettings = UserSettings)
  output <- .sagemaker$update_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_user_profile <- sagemaker_update_user_profile

#' Restricts access to tasks assigned to workers in the specified workforce
#' to those within specific ranges of IP addresses
#'
#' Restricts access to tasks assigned to workers in the specified workforce
#' to those within specific ranges of IP addresses. You specify allowed IP
#' addresses by creating a list of up to ten
#' [CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html).
#' 
#' By default, a workforce isn\'t restricted to specific IP addresses. If
#' you specify a range of IP addresses, workers who attempt to access tasks
#' using any IP address outside the specified range are denied access and
#' get a `Not Found` error message on the worker portal. After restricting
#' access with this operation, you can see the allowed IP values for a
#' private workforce with the operation.
#' 
#' This operation applies only to private workforces.
#'
#' @usage
#' sagemaker_update_workforce(WorkforceName, SourceIpConfig)
#'
#' @param WorkforceName &#91;required&#93; The name of the private workforce whose access you want to restrict.
#' `WorkforceName` is automatically set to `default` when a workforce is
#' created and cannot be modified.
#' @param SourceIpConfig A list of one to ten worker IP address ranges
#' ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html))
#' that can be used to access tasks assigned to this workforce.
#' 
#' Maximum: Ten CIDR values
#'
#' @section Request syntax:
#' ```
#' svc$update_workforce(
#'   WorkforceName = "string",
#'   SourceIpConfig = list(
#'     Cidrs = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_workforce
sagemaker_update_workforce <- function(WorkforceName, SourceIpConfig = NULL) {
  op <- new_operation(
    name = "UpdateWorkforce",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_workforce_input(WorkforceName = WorkforceName, SourceIpConfig = SourceIpConfig)
  output <- .sagemaker$update_workforce_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_workforce <- sagemaker_update_workforce

#' Updates an existing work team with new member definitions or description
#'
#' Updates an existing work team with new member definitions or
#' description.
#'
#' @usage
#' sagemaker_update_workteam(WorkteamName, MemberDefinitions, Description,
#'   NotificationConfiguration)
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to update.
#' @param MemberDefinitions A list of `MemberDefinition` objects that contain the updated work team
#' members.
#' @param Description An updated description for the work team.
#' @param NotificationConfiguration Configures SNS topic notifications for available or expiring work items
#'
#' @section Request syntax:
#' ```
#' svc$update_workteam(
#'   WorkteamName = "string",
#'   MemberDefinitions = list(
#'     list(
#'       CognitoMemberDefinition = list(
#'         UserPool = "string",
#'         UserGroup = "string",
#'         ClientId = "string"
#'       )
#'     )
#'   ),
#'   Description = "string",
#'   NotificationConfiguration = list(
#'     NotificationTopicArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_workteam
sagemaker_update_workteam <- function(WorkteamName, MemberDefinitions = NULL, Description = NULL, NotificationConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_workteam_input(WorkteamName = WorkteamName, MemberDefinitions = MemberDefinitions, Description = Description, NotificationConfiguration = NotificationConfiguration)
  output <- .sagemaker$update_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_workteam <- sagemaker_update_workteam
