% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_get_search_suggestions}
\alias{sagemaker_get_search_suggestions}
\title{An auto-complete API for the search functionality in the Amazon
SageMaker console}
\usage{
sagemaker_get_search_suggestions(Resource, SuggestionQuery)
}
\arguments{
\item{Resource}{[required] The name of the Amazon SageMaker resource to search for.}

\item{SuggestionQuery}{Limits the property names that are included in the response.}
}
\description{
An auto-complete API for the search functionality in the Amazon
SageMaker console. It returns suggestions of possible matches for the
property name to use in \code{Search} queries. Provides suggestions for
\code{HyperParameters}, \code{Tags}, and \code{Metrics}.
}
\section{Request syntax}{
\preformatted{svc$get_search_suggestions(
  Resource = "TrainingJob"|"Experiment"|"ExperimentTrial"|"ExperimentTrialComponent",
  SuggestionQuery = list(
    PropertyNameQuery = list(
      PropertyNameHint = "string"
    )
  )
)
}
}

\keyword{internal}
