# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include personalizeruntime_service.R
NULL

#' Returns a list of recommended actions in sorted in descending order by
#' prediction score
#'
#' @description
#' Returns a list of recommended actions in sorted in descending order by prediction score. Use the [`get_action_recommendations`][personalizeruntime_get_action_recommendations] API if you have a custom campaign that deploys a solution version trained with a PERSONALIZED_ACTIONS recipe.
#'
#' See [https://www.paws-r-sdk.com/docs/personalizeruntime_get_action_recommendations/](https://www.paws-r-sdk.com/docs/personalizeruntime_get_action_recommendations/) for full documentation.
#'
#' @param campaignArn The Amazon Resource Name (ARN) of the campaign to use for getting action
#' recommendations. This campaign must deploy a solution version trained
#' with a PERSONALIZED_ACTIONS recipe.
#' @param userId The user ID of the user to provide action recommendations for.
#' @param numResults The number of results to return. The default is 5. The maximum is 100.
#' @param filterArn The ARN of the filter to apply to the returned recommendations. For more
#' information, see [Filtering
#' Recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
#' 
#' When using this parameter, be sure the filter resource is `ACTIVE`.
#' @param filterValues The values to use when filtering recommendations. For each placeholder
#' parameter in your filter expression, provide the parameter name (in
#' matching case) as a key and the filter value(s) as the corresponding
#' value. Separate multiple values for one parameter with a comma.
#' 
#' For filter expressions that use an `INCLUDE` element to include actions,
#' you must provide values for all parameters that are defined in the
#' expression. For filters with expressions that use an `EXCLUDE` element
#' to exclude actions, you can omit the `filter-values`. In this case,
#' Amazon Personalize doesn't use that portion of the expression to filter
#' recommendations.
#' 
#' For more information, see [Filtering recommendations and user
#' segments](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
#'
#' @keywords internal
#'
#' @rdname personalizeruntime_get_action_recommendations
personalizeruntime_get_action_recommendations <- function(campaignArn = NULL, userId = NULL, numResults = NULL, filterArn = NULL, filterValues = NULL) {
  op <- new_operation(
    name = "GetActionRecommendations",
    http_method = "POST",
    http_path = "/action-recommendations",
    paginator = list()
  )
  input <- .personalizeruntime$get_action_recommendations_input(campaignArn = campaignArn, userId = userId, numResults = numResults, filterArn = filterArn, filterValues = filterValues)
  output <- .personalizeruntime$get_action_recommendations_output()
  config <- get_config()
  svc <- .personalizeruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalizeruntime$operations$get_action_recommendations <- personalizeruntime_get_action_recommendations

#' Re-ranks a list of recommended items for the given user
#'
#' @description
#' Re-ranks a list of recommended items for the given user. The first item in the list is deemed the most likely item to be of interest to the user.
#'
#' See [https://www.paws-r-sdk.com/docs/personalizeruntime_get_personalized_ranking/](https://www.paws-r-sdk.com/docs/personalizeruntime_get_personalized_ranking/) for full documentation.
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign to use for generating the
#' personalized ranking.
#' @param inputList &#91;required&#93; A list of items (by `itemId`) to rank. If an item was not included in
#' the training dataset, the item is appended to the end of the reranked
#' list. If you are including metadata in recommendations, the maximum is
#' 50. Otherwise, the maximum is 500.
#' @param userId &#91;required&#93; The user for which you want the campaign to provide a personalized
#' ranking.
#' @param context The contextual metadata to use when getting recommendations. Contextual
#' metadata includes any interaction information that might be relevant
#' when getting a user's recommendations, such as the user's current
#' location or device type.
#' @param filterArn The Amazon Resource Name (ARN) of a filter you created to include items
#' or exclude items from recommendations for a given user. For more
#' information, see [Filtering
#' Recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
#' @param filterValues The values to use when filtering recommendations. For each placeholder
#' parameter in your filter expression, provide the parameter name (in
#' matching case) as a key and the filter value(s) as the corresponding
#' value. Separate multiple values for one parameter with a comma.
#' 
#' For filter expressions that use an `INCLUDE` element to include items,
#' you must provide values for all parameters that are defined in the
#' expression. For filters with expressions that use an `EXCLUDE` element
#' to exclude items, you can omit the `filter-values`.In this case, Amazon
#' Personalize doesn't use that portion of the expression to filter
#' recommendations.
#' 
#' For more information, see [Filtering
#' Recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
#' @param metadataColumns If you enabled metadata in recommendations when you created or updated
#' the campaign, specify metadata columns from your Items dataset to
#' include in the personalized ranking. The map key is `ITEMS` and the
#' value is a list of column names from your Items dataset. The maximum
#' number of columns you can provide is 10.
#' 
#' For information about enabling metadata for a campaign, see [Enabling
#' metadata in recommendations for a
#' campaign](https://docs.aws.amazon.com/personalize/latest/dg/).
#'
#' @keywords internal
#'
#' @rdname personalizeruntime_get_personalized_ranking
personalizeruntime_get_personalized_ranking <- function(campaignArn, inputList, userId, context = NULL, filterArn = NULL, filterValues = NULL, metadataColumns = NULL) {
  op <- new_operation(
    name = "GetPersonalizedRanking",
    http_method = "POST",
    http_path = "/personalize-ranking",
    paginator = list()
  )
  input <- .personalizeruntime$get_personalized_ranking_input(campaignArn = campaignArn, inputList = inputList, userId = userId, context = context, filterArn = filterArn, filterValues = filterValues, metadataColumns = metadataColumns)
  output <- .personalizeruntime$get_personalized_ranking_output()
  config <- get_config()
  svc <- .personalizeruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalizeruntime$operations$get_personalized_ranking <- personalizeruntime_get_personalized_ranking

#' Returns a list of recommended items
#'
#' @description
#' Returns a list of recommended items. For campaigns, the campaign's Amazon Resource Name (ARN) is required and the required user and item input depends on the recipe type used to create the solution backing the campaign as follows:
#'
#' See [https://www.paws-r-sdk.com/docs/personalizeruntime_get_recommendations/](https://www.paws-r-sdk.com/docs/personalizeruntime_get_recommendations/) for full documentation.
#'
#' @param campaignArn The Amazon Resource Name (ARN) of the campaign to use for getting
#' recommendations.
#' @param itemId The item ID to provide recommendations for.
#' 
#' Required for `RELATED_ITEMS` recipe type.
#' @param userId The user ID to provide recommendations for.
#' 
#' Required for `USER_PERSONALIZATION` recipe type.
#' @param numResults The number of results to return. The default is 25. If you are including
#' metadata in recommendations, the maximum is 50. Otherwise, the maximum
#' is 500.
#' @param context The contextual metadata to use when getting recommendations. Contextual
#' metadata includes any interaction information that might be relevant
#' when getting a user's recommendations, such as the user's current
#' location or device type.
#' @param filterArn The ARN of the filter to apply to the returned recommendations. For more
#' information, see [Filtering
#' Recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
#' 
#' When using this parameter, be sure the filter resource is `ACTIVE`.
#' @param filterValues The values to use when filtering recommendations. For each placeholder
#' parameter in your filter expression, provide the parameter name (in
#' matching case) as a key and the filter value(s) as the corresponding
#' value. Separate multiple values for one parameter with a comma.
#' 
#' For filter expressions that use an `INCLUDE` element to include items,
#' you must provide values for all parameters that are defined in the
#' expression. For filters with expressions that use an `EXCLUDE` element
#' to exclude items, you can omit the `filter-values`.In this case, Amazon
#' Personalize doesn't use that portion of the expression to filter
#' recommendations.
#' 
#' For more information, see [Filtering recommendations and user
#' segments](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
#' @param recommenderArn The Amazon Resource Name (ARN) of the recommender to use to get
#' recommendations. Provide a recommender ARN if you created a Domain
#' dataset group with a recommender for a domain use case.
#' @param promotions The promotions to apply to the recommendation request. A promotion
#' defines additional business rules that apply to a configurable subset of
#' recommended items.
#' @param metadataColumns If you enabled metadata in recommendations when you created or updated
#' the campaign or recommender, specify the metadata columns from your
#' Items dataset to include in item recommendations. The map key is `ITEMS`
#' and the value is a list of column names from your Items dataset. The
#' maximum number of columns you can provide is 10.
#' 
#' For information about enabling metadata for a campaign, see [Enabling
#' metadata in recommendations for a
#' campaign](https://docs.aws.amazon.com/personalize/latest/dg/). For
#' information about enabling metadata for a recommender, see [Enabling
#' metadata in recommendations for a
#' recommender](https://docs.aws.amazon.com/personalize/latest/dg/).
#'
#' @keywords internal
#'
#' @rdname personalizeruntime_get_recommendations
personalizeruntime_get_recommendations <- function(campaignArn = NULL, itemId = NULL, userId = NULL, numResults = NULL, context = NULL, filterArn = NULL, filterValues = NULL, recommenderArn = NULL, promotions = NULL, metadataColumns = NULL) {
  op <- new_operation(
    name = "GetRecommendations",
    http_method = "POST",
    http_path = "/recommendations",
    paginator = list()
  )
  input <- .personalizeruntime$get_recommendations_input(campaignArn = campaignArn, itemId = itemId, userId = userId, numResults = numResults, context = context, filterArn = filterArn, filterValues = filterValues, recommenderArn = recommenderArn, promotions = promotions, metadataColumns = metadataColumns)
  output <- .personalizeruntime$get_recommendations_output()
  config <- get_config()
  svc <- .personalizeruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalizeruntime$operations$get_recommendations <- personalizeruntime_get_recommendations
