# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Voice ID
#'
#' @description
#' Amazon Connect Voice ID provides real-time caller authentication and
#' fraud risk detection, which make voice interactions in contact centers
#' more secure and efficient.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- voiceid(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- voiceid()
#' svc$associate_fraudster(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=voiceid_associate_fraudster]{associate_fraudster} \tab Associates the fraudsters with the watchlist specified in the same domain\cr
#'  \link[=voiceid_create_domain]{create_domain} \tab Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio, and voiceprints\cr
#'  \link[=voiceid_create_watchlist]{create_watchlist} \tab Creates a watchlist that fraudsters can be a part of\cr
#'  \link[=voiceid_delete_domain]{delete_domain} \tab Deletes the specified domain from Voice ID\cr
#'  \link[=voiceid_delete_fraudster]{delete_fraudster} \tab Deletes the specified fraudster from Voice ID\cr
#'  \link[=voiceid_delete_speaker]{delete_speaker} \tab Deletes the specified speaker from Voice ID\cr
#'  \link[=voiceid_delete_watchlist]{delete_watchlist} \tab Deletes the specified watchlist from Voice ID\cr
#'  \link[=voiceid_describe_domain]{describe_domain} \tab Describes the specified domain\cr
#'  \link[=voiceid_describe_fraudster]{describe_fraudster} \tab Describes the specified fraudster\cr
#'  \link[=voiceid_describe_fraudster_registration_job]{describe_fraudster_registration_job} \tab Describes the specified fraudster registration job\cr
#'  \link[=voiceid_describe_speaker]{describe_speaker} \tab Describes the specified speaker\cr
#'  \link[=voiceid_describe_speaker_enrollment_job]{describe_speaker_enrollment_job} \tab Describes the specified speaker enrollment job\cr
#'  \link[=voiceid_describe_watchlist]{describe_watchlist} \tab Describes the specified watchlist\cr
#'  \link[=voiceid_disassociate_fraudster]{disassociate_fraudster} \tab Disassociates the fraudsters from the watchlist specified\cr
#'  \link[=voiceid_evaluate_session]{evaluate_session} \tab Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call\cr
#'  \link[=voiceid_list_domains]{list_domains} \tab Lists all the domains in the Amazon Web Services account\cr
#'  \link[=voiceid_list_fraudster_registration_jobs]{list_fraudster_registration_jobs} \tab Lists all the fraudster registration jobs in the domain with the given JobStatus\cr
#'  \link[=voiceid_list_fraudsters]{list_fraudsters} \tab Lists all fraudsters in a specified watchlist or domain\cr
#'  \link[=voiceid_list_speaker_enrollment_jobs]{list_speaker_enrollment_jobs} \tab Lists all the speaker enrollment jobs in the domain with the specified JobStatus\cr
#'  \link[=voiceid_list_speakers]{list_speakers} \tab Lists all speakers in a specified domain\cr
#'  \link[=voiceid_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags associated with a specified Voice ID resource\cr
#'  \link[=voiceid_list_watchlists]{list_watchlists} \tab Lists all watchlists in a specified domain\cr
#'  \link[=voiceid_opt_out_speaker]{opt_out_speaker} \tab Opts out a speaker from Voice ID\cr
#'  \link[=voiceid_start_fraudster_registration_job]{start_fraudster_registration_job} \tab Starts a new batch fraudster registration job using provided details\cr
#'  \link[=voiceid_start_speaker_enrollment_job]{start_speaker_enrollment_job} \tab Starts a new batch speaker enrollment job using specified details\cr
#'  \link[=voiceid_tag_resource]{tag_resource} \tab Tags a Voice ID resource with the provided list of tags\cr
#'  \link[=voiceid_untag_resource]{untag_resource} \tab Removes specified tags from a specified Amazon Connect Voice ID resource\cr
#'  \link[=voiceid_update_domain]{update_domain} \tab Updates the specified domain\cr
#'  \link[=voiceid_update_watchlist]{update_watchlist} \tab Updates the specified watchlist
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname voiceid
#' @export
voiceid <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .voiceid$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.voiceid <- list()

.voiceid$operations <- list()

.voiceid$metadata <- list(
  service_name = "voiceid",
  endpoints = list("*" = list(endpoint = "voiceid.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "voiceid.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "voiceid.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "voiceid.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Voice ID",
  api_version = "2021-09-27",
  signing_name = "voiceid",
  json_version = "1.0",
  target_prefix = "VoiceID"
)

.voiceid$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.voiceid$metadata, handlers, config)
}
