% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_start_face_search}
\alias{rekognition_start_face_search}
\title{Starts the asynchronous search for faces in a collection that match the
faces of persons detected in a stored video}
\usage{
rekognition_start_face_search(
  Video,
  ClientRequestToken = NULL,
  FaceMatchThreshold = NULL,
  CollectionId,
  NotificationChannel = NULL,
  JobTag = NULL
)
}
\arguments{
\item{Video}{[required] The video you want to search. The video must be stored in an Amazon S3
bucket.}

\item{ClientRequestToken}{Idempotent token used to identify the start request. If you use the same
token with multiple \code{\link[=rekognition_start_face_search]{start_face_search}}
requests, the same \code{JobId} is returned. Use \code{ClientRequestToken} to
prevent the same job from being accidently started more than once.}

\item{FaceMatchThreshold}{The minimum confidence in the person match to return. For example, don't
return any matches where confidence in matches is less than 70\%. The
default value is 80\%.}

\item{CollectionId}{[required] ID of the collection that contains the faces you want to search for.}

\item{NotificationChannel}{The ARN of the Amazon SNS topic to which you want Amazon Rekognition
Video to publish the completion status of the search. The Amazon SNS
topic must have a topic name that begins with \emph{AmazonRekognition} if you
are using the AmazonRekognitionServiceRole permissions policy to access
the topic.}

\item{JobTag}{An identifier you specify that's returned in the completion notification
that's published to your Amazon Simple Notification Service topic. For
example, you can use \code{JobTag} to group related jobs and identify them in
the completion notification.}
}
\description{
Starts the asynchronous search for faces in a collection that match the faces of persons detected in a stored video.

See \url{https://www.paws-r-sdk.com/docs/rekognition_start_face_search/} for full documentation.
}
\keyword{internal}
