% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voiceid_operations.R
\name{voiceid_start_speaker_enrollment_job}
\alias{voiceid_start_speaker_enrollment_job}
\title{Starts a new batch speaker enrollment job using specified details}
\usage{
voiceid_start_speaker_enrollment_job(
  ClientToken = NULL,
  DataAccessRoleArn,
  DomainId,
  EnrollmentConfig = NULL,
  InputDataConfig,
  JobName = NULL,
  OutputDataConfig
)
}
\arguments{
\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}

\item{DataAccessRoleArn}{[required] The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions
to access customer's buckets to read the input manifest file and write
the job output file. Refer to \href{https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html}{Batch enrollment using audio data from prior calls}
for the permissions needed in this role.}

\item{DomainId}{[required] The identifier of the domain that contains the speaker enrollment job
and in which the speakers are enrolled.}

\item{EnrollmentConfig}{The enrollment config that contains details such as the action to take
when a speaker is already enrolled in Voice ID or when a speaker is
identified as a fraudster.}

\item{InputDataConfig}{[required] The input data config containing the S3 location for the input manifest
file that contains the list of speaker enrollment requests.}

\item{JobName}{A name for your speaker enrollment job.}

\item{OutputDataConfig}{[required] The output data config containing the S3 location where Voice ID writes
the job output file; you must also include a KMS key ID to encrypt the
file.}
}
\description{
Starts a new batch speaker enrollment job using specified details.

See \url{https://www.paws-r-sdk.com/docs/voiceid_start_speaker_enrollment_job/} for full documentation.
}
\keyword{internal}
