% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_delete_user}
\alias{rekognition_delete_user}
\title{Deletes the specified UserID within the collection}
\usage{
rekognition_delete_user(CollectionId, UserId, ClientRequestToken = NULL)
}
\arguments{
\item{CollectionId}{[required] The ID of an existing collection from which the UserID needs to be
deleted.}

\item{UserId}{[required] ID for the UserID to be deleted.}

\item{ClientRequestToken}{Idempotent token used to identify the request to
\code{\link[=rekognition_delete_user]{delete_user}}. If you use the same token with
multiple \code{\link[=rekognition_delete_user]{delete_user}}requests, the same
response is returned. Use ClientRequestToken to prevent the same request
from being processed more than once.}
}
\description{
Deletes the specified UserID within the collection. Faces that are associated with the UserID are disassociated from the UserID before deleting the specified UserID. If the specified \code{Collection} or \code{UserID} is already deleted or not found, a \code{ResourceNotFoundException} will be thrown. If the action is successful with a 200 response, an empty HTTP body is returned.

See \url{https://www.paws-r-sdk.com/docs/rekognition_delete_user/} for full documentation.
}
\keyword{internal}
