# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include transcribeservice_service.R
NULL

#' Creates a new Call Analytics category
#'
#' @description
#' Creates a new Call Analytics category.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_create_call_analytics_category/](https://www.paws-r-sdk.com/docs/transcribeservice_create_call_analytics_category/) for full documentation.
#'
#' @param CategoryName &#91;required&#93; A unique name, chosen by you, for your Call Analytics category. It's
#' helpful to use a detailed naming system that will make sense to you in
#' the future. For example, it's better to use
#' `sentiment-positive-last30seconds` for a category over a generic name
#' like `test-category`.
#' 
#' Category names are case sensitive.
#' @param Rules &#91;required&#93; Rules define a Call Analytics category. When creating a new category,
#' you must create between 1 and 20 rules for that category. For each rule,
#' you specify a filter you want applied to the attributes of a call. For
#' example, you can choose a sentiment filter that detects if a customer's
#' sentiment was positive during the last 30 seconds of the call.
#' @param InputType Choose whether you want to create a real-time or a post-call category
#' for your Call Analytics transcription.
#' 
#' Specifying `POST_CALL` assigns your category to post-call
#' transcriptions; categories with this input type cannot be applied to
#' streaming (real-time) transcriptions.
#' 
#' Specifying `REAL_TIME` assigns your category to streaming
#' transcriptions; categories with this input type cannot be applied to
#' post-call transcriptions.
#' 
#' If you do not include `InputType`, your category is created as a
#' post-call category by default.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_create_call_analytics_category
transcribeservice_create_call_analytics_category <- function(CategoryName, Rules, InputType = NULL) {
  op <- new_operation(
    name = "CreateCallAnalyticsCategory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$create_call_analytics_category_input(CategoryName = CategoryName, Rules = Rules, InputType = InputType)
  output <- .transcribeservice$create_call_analytics_category_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$create_call_analytics_category <- transcribeservice_create_call_analytics_category

#' Creates a new custom language model
#'
#' @description
#' Creates a new custom language model.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_create_language_model/](https://www.paws-r-sdk.com/docs/transcribeservice_create_language_model/) for full documentation.
#'
#' @param LanguageCode &#91;required&#93; The language code that represents the language of your model. Each
#' custom language model must contain terms in only one language, and the
#' language you select for your custom language model must match the
#' language of your training and tuning data.
#' 
#' For a list of supported languages and their associated language codes,
#' refer to the [Supported
#' languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
#' table. Note that US English (`en-US`) is the only language supported
#' with Amazon Transcribe Medical.
#' 
#' A custom language model can only be used to transcribe files in the same
#' language as the model. For example, if you create a custom language
#' model using US English (`en-US`), you can only apply this model to files
#' that contain English audio.
#' @param BaseModelName &#91;required&#93; The Amazon Transcribe standard language model, or base model, used to
#' create your custom language model. Amazon Transcribe offers two options
#' for base models: Wideband and Narrowband.
#' 
#' If the audio you want to transcribe has a sample rate of 16,000 Hz or
#' greater, choose `WideBand`. To transcribe audio with a sample rate less
#' than 16,000 Hz, choose `NarrowBand`.
#' @param ModelName &#91;required&#93; A unique name, chosen by you, for your custom language model.
#' 
#' This name is case sensitive, cannot contain spaces, and must be unique
#' within an Amazon Web Services account. If you try to create a new custom
#' language model with the same name as an existing custom language model,
#' you get a `ConflictException` error.
#' @param InputDataConfig &#91;required&#93; Contains the Amazon S3 location of the training data you want to use to
#' create a new custom language model, and permissions to access this
#' location.
#' 
#' When using `InputDataConfig`, you must include these sub-parameters:
#' `S3Uri`, which is the Amazon S3 location of your training data, and
#' `DataAccessRoleArn`, which is the Amazon Resource Name (ARN) of the role
#' that has permission to access your specified Amazon S3 location. You can
#' optionally include `TuningDataS3Uri`, which is the Amazon S3 location of
#' your tuning data. If you specify different Amazon S3 locations for
#' training and tuning data, the ARN you use must have permissions to
#' access both locations.
#' @param Tags Adds one or more custom tags, each in the form of a key:value pair, to a
#' new custom language model at the time you create this new model.
#' 
#' To learn more about using tags with Amazon Transcribe, refer to [Tagging
#' resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
#'
#' @keywords internal
#'
#' @rdname transcribeservice_create_language_model
transcribeservice_create_language_model <- function(LanguageCode, BaseModelName, ModelName, InputDataConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateLanguageModel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$create_language_model_input(LanguageCode = LanguageCode, BaseModelName = BaseModelName, ModelName = ModelName, InputDataConfig = InputDataConfig, Tags = Tags)
  output <- .transcribeservice$create_language_model_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$create_language_model <- transcribeservice_create_language_model

#' Creates a new custom medical vocabulary
#'
#' @description
#' Creates a new custom medical vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_create_medical_vocabulary/](https://www.paws-r-sdk.com/docs/transcribeservice_create_medical_vocabulary/) for full documentation.
#'
#' @param VocabularyName &#91;required&#93; A unique name, chosen by you, for your new custom medical vocabulary.
#' 
#' This name is case sensitive, cannot contain spaces, and must be unique
#' within an Amazon Web Services account. If you try to create a new custom
#' medical vocabulary with the same name as an existing custom medical
#' vocabulary, you get a `ConflictException` error.
#' @param LanguageCode &#91;required&#93; The language code that represents the language of the entries in your
#' custom vocabulary. US English (`en-US`) is the only language supported
#' with Amazon Transcribe Medical.
#' @param VocabularyFileUri &#91;required&#93; The Amazon S3 location (URI) of the text file that contains your custom
#' medical vocabulary. The URI must be in the same Amazon Web Services
#' Region as the resource you're calling.
#' 
#' Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt`
#' @param Tags Adds one or more custom tags, each in the form of a key:value pair, to a
#' new custom medical vocabulary at the time you create this new custom
#' vocabulary.
#' 
#' To learn more about using tags with Amazon Transcribe, refer to [Tagging
#' resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
#'
#' @keywords internal
#'
#' @rdname transcribeservice_create_medical_vocabulary
transcribeservice_create_medical_vocabulary <- function(VocabularyName, LanguageCode, VocabularyFileUri, Tags = NULL) {
  op <- new_operation(
    name = "CreateMedicalVocabulary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$create_medical_vocabulary_input(VocabularyName = VocabularyName, LanguageCode = LanguageCode, VocabularyFileUri = VocabularyFileUri, Tags = Tags)
  output <- .transcribeservice$create_medical_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$create_medical_vocabulary <- transcribeservice_create_medical_vocabulary

#' Creates a new custom vocabulary
#'
#' @description
#' Creates a new custom vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_create_vocabulary/](https://www.paws-r-sdk.com/docs/transcribeservice_create_vocabulary/) for full documentation.
#'
#' @param VocabularyName &#91;required&#93; A unique name, chosen by you, for your new custom vocabulary.
#' 
#' This name is case sensitive, cannot contain spaces, and must be unique
#' within an Amazon Web Services account. If you try to create a new custom
#' vocabulary with the same name as an existing custom vocabulary, you get
#' a `ConflictException` error.
#' @param LanguageCode &#91;required&#93; The language code that represents the language of the entries in your
#' custom vocabulary. Each custom vocabulary must contain terms in only one
#' language.
#' 
#' A custom vocabulary can only be used to transcribe files in the same
#' language as the custom vocabulary. For example, if you create a custom
#' vocabulary using US English (`en-US`), you can only apply this custom
#' vocabulary to files that contain English audio.
#' 
#' For a list of supported languages and their associated language codes,
#' refer to the [Supported
#' languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
#' table.
#' @param Phrases Use this parameter if you want to create your custom vocabulary by
#' including all desired terms, as comma-separated values, within your
#' request. The other option for creating your custom vocabulary is to save
#' your entries in a text file and upload them to an Amazon S3 bucket, then
#' specify the location of your file using the `VocabularyFileUri`
#' parameter.
#' 
#' Note that if you include `Phrases` in your request, you cannot use
#' `VocabularyFileUri`; you must choose one or the other.
#' 
#' Each language has a character set that contains all allowed characters
#' for that specific language. If you use unsupported characters, your
#' custom vocabulary filter request fails. Refer to [Character Sets for
#' Custom
#' Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
#' to get the character set for your language.
#' @param VocabularyFileUri The Amazon S3 location of the text file that contains your custom
#' vocabulary. The URI must be located in the same Amazon Web Services
#' Region as the resource you're calling.
#' 
#' Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt`
#' 
#' Note that if you include `VocabularyFileUri` in your request, you cannot
#' use the `Phrases` flag; you must choose one or the other.
#' @param Tags Adds one or more custom tags, each in the form of a key:value pair, to a
#' new custom vocabulary at the time you create this new custom vocabulary.
#' 
#' To learn more about using tags with Amazon Transcribe, refer to [Tagging
#' resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
#' @param DataAccessRoleArn The Amazon Resource Name (ARN) of an IAM role that has permissions to
#' access the Amazon S3 bucket that contains your input files (in this
#' case, your custom vocabulary). If the role that you specify doesn’t have
#' the appropriate permissions to access the specified Amazon S3 location,
#' your request fails.
#' 
#' IAM role ARNs have the format
#' `arn:partition:iam::account:role/role-name-with-path`. For example:
#' `arn:aws:iam::111122223333:role/Admin`.
#' 
#' For more information, see [IAM
#' ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
#'
#' @keywords internal
#'
#' @rdname transcribeservice_create_vocabulary
transcribeservice_create_vocabulary <- function(VocabularyName, LanguageCode, Phrases = NULL, VocabularyFileUri = NULL, Tags = NULL, DataAccessRoleArn = NULL) {
  op <- new_operation(
    name = "CreateVocabulary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$create_vocabulary_input(VocabularyName = VocabularyName, LanguageCode = LanguageCode, Phrases = Phrases, VocabularyFileUri = VocabularyFileUri, Tags = Tags, DataAccessRoleArn = DataAccessRoleArn)
  output <- .transcribeservice$create_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$create_vocabulary <- transcribeservice_create_vocabulary

#' Creates a new custom vocabulary filter
#'
#' @description
#' Creates a new custom vocabulary filter.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_create_vocabulary_filter/](https://www.paws-r-sdk.com/docs/transcribeservice_create_vocabulary_filter/) for full documentation.
#'
#' @param VocabularyFilterName &#91;required&#93; A unique name, chosen by you, for your new custom vocabulary filter.
#' 
#' This name is case sensitive, cannot contain spaces, and must be unique
#' within an Amazon Web Services account. If you try to create a new custom
#' vocabulary filter with the same name as an existing custom vocabulary
#' filter, you get a `ConflictException` error.
#' @param LanguageCode &#91;required&#93; The language code that represents the language of the entries in your
#' vocabulary filter. Each custom vocabulary filter must contain terms in
#' only one language.
#' 
#' A custom vocabulary filter can only be used to transcribe files in the
#' same language as the filter. For example, if you create a custom
#' vocabulary filter using US English (`en-US`), you can only apply this
#' filter to files that contain English audio.
#' 
#' For a list of supported languages and their associated language codes,
#' refer to the [Supported
#' languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
#' table.
#' @param Words Use this parameter if you want to create your custom vocabulary filter
#' by including all desired terms, as comma-separated values, within your
#' request. The other option for creating your vocabulary filter is to save
#' your entries in a text file and upload them to an Amazon S3 bucket, then
#' specify the location of your file using the `VocabularyFilterFileUri`
#' parameter.
#' 
#' Note that if you include `Words` in your request, you cannot use
#' `VocabularyFilterFileUri`; you must choose one or the other.
#' 
#' Each language has a character set that contains all allowed characters
#' for that specific language. If you use unsupported characters, your
#' custom vocabulary filter request fails. Refer to [Character Sets for
#' Custom
#' Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
#' to get the character set for your language.
#' @param VocabularyFilterFileUri The Amazon S3 location of the text file that contains your custom
#' vocabulary filter terms. The URI must be located in the same Amazon Web
#' Services Region as the resource you're calling.
#' 
#' Here's an example URI path:
#' `s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt`
#' 
#' Note that if you include `VocabularyFilterFileUri` in your request, you
#' cannot use `Words`; you must choose one or the other.
#' @param Tags Adds one or more custom tags, each in the form of a key:value pair, to a
#' new custom vocabulary filter at the time you create this new vocabulary
#' filter.
#' 
#' To learn more about using tags with Amazon Transcribe, refer to [Tagging
#' resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
#' @param DataAccessRoleArn The Amazon Resource Name (ARN) of an IAM role that has permissions to
#' access the Amazon S3 bucket that contains your input files (in this
#' case, your custom vocabulary filter). If the role that you specify
#' doesn’t have the appropriate permissions to access the specified Amazon
#' S3 location, your request fails.
#' 
#' IAM role ARNs have the format
#' `arn:partition:iam::account:role/role-name-with-path`. For example:
#' `arn:aws:iam::111122223333:role/Admin`.
#' 
#' For more information, see [IAM
#' ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
#'
#' @keywords internal
#'
#' @rdname transcribeservice_create_vocabulary_filter
transcribeservice_create_vocabulary_filter <- function(VocabularyFilterName, LanguageCode, Words = NULL, VocabularyFilterFileUri = NULL, Tags = NULL, DataAccessRoleArn = NULL) {
  op <- new_operation(
    name = "CreateVocabularyFilter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$create_vocabulary_filter_input(VocabularyFilterName = VocabularyFilterName, LanguageCode = LanguageCode, Words = Words, VocabularyFilterFileUri = VocabularyFilterFileUri, Tags = Tags, DataAccessRoleArn = DataAccessRoleArn)
  output <- .transcribeservice$create_vocabulary_filter_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$create_vocabulary_filter <- transcribeservice_create_vocabulary_filter

#' Deletes a Call Analytics category
#'
#' @description
#' Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete using `CategoryName`. Category names are case sensitive.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_delete_call_analytics_category/](https://www.paws-r-sdk.com/docs/transcribeservice_delete_call_analytics_category/) for full documentation.
#'
#' @param CategoryName &#91;required&#93; The name of the Call Analytics category you want to delete. Category
#' names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_delete_call_analytics_category
transcribeservice_delete_call_analytics_category <- function(CategoryName) {
  op <- new_operation(
    name = "DeleteCallAnalyticsCategory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$delete_call_analytics_category_input(CategoryName = CategoryName)
  output <- .transcribeservice$delete_call_analytics_category_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$delete_call_analytics_category <- transcribeservice_delete_call_analytics_category

#' Deletes a Call Analytics job
#'
#' @description
#' Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using `CallAnalyticsJobName`. Job names are case sensitive.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_delete_call_analytics_job/](https://www.paws-r-sdk.com/docs/transcribeservice_delete_call_analytics_job/) for full documentation.
#'
#' @param CallAnalyticsJobName &#91;required&#93; The name of the Call Analytics job you want to delete. Job names are
#' case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_delete_call_analytics_job
transcribeservice_delete_call_analytics_job <- function(CallAnalyticsJobName) {
  op <- new_operation(
    name = "DeleteCallAnalyticsJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$delete_call_analytics_job_input(CallAnalyticsJobName = CallAnalyticsJobName)
  output <- .transcribeservice$delete_call_analytics_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$delete_call_analytics_job <- transcribeservice_delete_call_analytics_job

#' Deletes a custom language model
#'
#' @description
#' Deletes a custom language model. To use this operation, specify the name of the language model you want to delete using `ModelName`. custom language model names are case sensitive.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_delete_language_model/](https://www.paws-r-sdk.com/docs/transcribeservice_delete_language_model/) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name of the custom language model you want to delete. Model names
#' are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_delete_language_model
transcribeservice_delete_language_model <- function(ModelName) {
  op <- new_operation(
    name = "DeleteLanguageModel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$delete_language_model_input(ModelName = ModelName)
  output <- .transcribeservice$delete_language_model_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$delete_language_model <- transcribeservice_delete_language_model

#' Deletes a Medical Scribe job
#'
#' @description
#' Deletes a Medical Scribe job. To use this operation, specify the name of the job you want to delete using `MedicalScribeJobName`. Job names are case sensitive.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_delete_medical_scribe_job/](https://www.paws-r-sdk.com/docs/transcribeservice_delete_medical_scribe_job/) for full documentation.
#'
#' @param MedicalScribeJobName &#91;required&#93; The name of the Medical Scribe job you want to delete. Job names are
#' case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_delete_medical_scribe_job
transcribeservice_delete_medical_scribe_job <- function(MedicalScribeJobName) {
  op <- new_operation(
    name = "DeleteMedicalScribeJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$delete_medical_scribe_job_input(MedicalScribeJobName = MedicalScribeJobName)
  output <- .transcribeservice$delete_medical_scribe_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$delete_medical_scribe_job <- transcribeservice_delete_medical_scribe_job

#' Deletes a medical transcription job
#'
#' @description
#' Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using `MedicalTranscriptionJobName`. Job names are case sensitive.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_delete_medical_transcription_job/](https://www.paws-r-sdk.com/docs/transcribeservice_delete_medical_transcription_job/) for full documentation.
#'
#' @param MedicalTranscriptionJobName &#91;required&#93; The name of the medical transcription job you want to delete. Job names
#' are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_delete_medical_transcription_job
transcribeservice_delete_medical_transcription_job <- function(MedicalTranscriptionJobName) {
  op <- new_operation(
    name = "DeleteMedicalTranscriptionJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$delete_medical_transcription_job_input(MedicalTranscriptionJobName = MedicalTranscriptionJobName)
  output <- .transcribeservice$delete_medical_transcription_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$delete_medical_transcription_job <- transcribeservice_delete_medical_transcription_job

#' Deletes a custom medical vocabulary
#'
#' @description
#' Deletes a custom medical vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete using `VocabularyName`. Custom vocabulary names are case sensitive.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_delete_medical_vocabulary/](https://www.paws-r-sdk.com/docs/transcribeservice_delete_medical_vocabulary/) for full documentation.
#'
#' @param VocabularyName &#91;required&#93; The name of the custom medical vocabulary you want to delete. Custom
#' medical vocabulary names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_delete_medical_vocabulary
transcribeservice_delete_medical_vocabulary <- function(VocabularyName) {
  op <- new_operation(
    name = "DeleteMedicalVocabulary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$delete_medical_vocabulary_input(VocabularyName = VocabularyName)
  output <- .transcribeservice$delete_medical_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$delete_medical_vocabulary <- transcribeservice_delete_medical_vocabulary

#' Deletes a transcription job
#'
#' @description
#' Deletes a transcription job. To use this operation, specify the name of the job you want to delete using `TranscriptionJobName`. Job names are case sensitive.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_delete_transcription_job/](https://www.paws-r-sdk.com/docs/transcribeservice_delete_transcription_job/) for full documentation.
#'
#' @param TranscriptionJobName &#91;required&#93; The name of the transcription job you want to delete. Job names are case
#' sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_delete_transcription_job
transcribeservice_delete_transcription_job <- function(TranscriptionJobName) {
  op <- new_operation(
    name = "DeleteTranscriptionJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$delete_transcription_job_input(TranscriptionJobName = TranscriptionJobName)
  output <- .transcribeservice$delete_transcription_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$delete_transcription_job <- transcribeservice_delete_transcription_job

#' Deletes a custom vocabulary
#'
#' @description
#' Deletes a custom vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete using `VocabularyName`. Custom vocabulary names are case sensitive.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_delete_vocabulary/](https://www.paws-r-sdk.com/docs/transcribeservice_delete_vocabulary/) for full documentation.
#'
#' @param VocabularyName &#91;required&#93; The name of the custom vocabulary you want to delete. Custom vocabulary
#' names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_delete_vocabulary
transcribeservice_delete_vocabulary <- function(VocabularyName) {
  op <- new_operation(
    name = "DeleteVocabulary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$delete_vocabulary_input(VocabularyName = VocabularyName)
  output <- .transcribeservice$delete_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$delete_vocabulary <- transcribeservice_delete_vocabulary

#' Deletes a custom vocabulary filter
#'
#' @description
#' Deletes a custom vocabulary filter. To use this operation, specify the name of the custom vocabulary filter you want to delete using `VocabularyFilterName`. Custom vocabulary filter names are case sensitive.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_delete_vocabulary_filter/](https://www.paws-r-sdk.com/docs/transcribeservice_delete_vocabulary_filter/) for full documentation.
#'
#' @param VocabularyFilterName &#91;required&#93; The name of the custom vocabulary filter you want to delete. Custom
#' vocabulary filter names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_delete_vocabulary_filter
transcribeservice_delete_vocabulary_filter <- function(VocabularyFilterName) {
  op <- new_operation(
    name = "DeleteVocabularyFilter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$delete_vocabulary_filter_input(VocabularyFilterName = VocabularyFilterName)
  output <- .transcribeservice$delete_vocabulary_filter_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$delete_vocabulary_filter <- transcribeservice_delete_vocabulary_filter

#' Provides information about the specified custom language model
#'
#' @description
#' Provides information about the specified custom language model.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_describe_language_model/](https://www.paws-r-sdk.com/docs/transcribeservice_describe_language_model/) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name of the custom language model you want information about. Model
#' names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_describe_language_model
transcribeservice_describe_language_model <- function(ModelName) {
  op <- new_operation(
    name = "DescribeLanguageModel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$describe_language_model_input(ModelName = ModelName)
  output <- .transcribeservice$describe_language_model_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$describe_language_model <- transcribeservice_describe_language_model

#' Provides information about the specified Call Analytics category
#'
#' @description
#' Provides information about the specified Call Analytics category.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_get_call_analytics_category/](https://www.paws-r-sdk.com/docs/transcribeservice_get_call_analytics_category/) for full documentation.
#'
#' @param CategoryName &#91;required&#93; The name of the Call Analytics category you want information about.
#' Category names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_get_call_analytics_category
transcribeservice_get_call_analytics_category <- function(CategoryName) {
  op <- new_operation(
    name = "GetCallAnalyticsCategory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$get_call_analytics_category_input(CategoryName = CategoryName)
  output <- .transcribeservice$get_call_analytics_category_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$get_call_analytics_category <- transcribeservice_get_call_analytics_category

#' Provides information about the specified Call Analytics job
#'
#' @description
#' Provides information about the specified Call Analytics job.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_get_call_analytics_job/](https://www.paws-r-sdk.com/docs/transcribeservice_get_call_analytics_job/) for full documentation.
#'
#' @param CallAnalyticsJobName &#91;required&#93; The name of the Call Analytics job you want information about. Job names
#' are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_get_call_analytics_job
transcribeservice_get_call_analytics_job <- function(CallAnalyticsJobName) {
  op <- new_operation(
    name = "GetCallAnalyticsJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$get_call_analytics_job_input(CallAnalyticsJobName = CallAnalyticsJobName)
  output <- .transcribeservice$get_call_analytics_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$get_call_analytics_job <- transcribeservice_get_call_analytics_job

#' Provides information about the specified Medical Scribe job
#'
#' @description
#' Provides information about the specified Medical Scribe job.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_get_medical_scribe_job/](https://www.paws-r-sdk.com/docs/transcribeservice_get_medical_scribe_job/) for full documentation.
#'
#' @param MedicalScribeJobName &#91;required&#93; The name of the Medical Scribe job you want information about. Job names
#' are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_get_medical_scribe_job
transcribeservice_get_medical_scribe_job <- function(MedicalScribeJobName) {
  op <- new_operation(
    name = "GetMedicalScribeJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$get_medical_scribe_job_input(MedicalScribeJobName = MedicalScribeJobName)
  output <- .transcribeservice$get_medical_scribe_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$get_medical_scribe_job <- transcribeservice_get_medical_scribe_job

#' Provides information about the specified medical transcription job
#'
#' @description
#' Provides information about the specified medical transcription job.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_get_medical_transcription_job/](https://www.paws-r-sdk.com/docs/transcribeservice_get_medical_transcription_job/) for full documentation.
#'
#' @param MedicalTranscriptionJobName &#91;required&#93; The name of the medical transcription job you want information about.
#' Job names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_get_medical_transcription_job
transcribeservice_get_medical_transcription_job <- function(MedicalTranscriptionJobName) {
  op <- new_operation(
    name = "GetMedicalTranscriptionJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$get_medical_transcription_job_input(MedicalTranscriptionJobName = MedicalTranscriptionJobName)
  output <- .transcribeservice$get_medical_transcription_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$get_medical_transcription_job <- transcribeservice_get_medical_transcription_job

#' Provides information about the specified custom medical vocabulary
#'
#' @description
#' Provides information about the specified custom medical vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_get_medical_vocabulary/](https://www.paws-r-sdk.com/docs/transcribeservice_get_medical_vocabulary/) for full documentation.
#'
#' @param VocabularyName &#91;required&#93; The name of the custom medical vocabulary you want information about.
#' Custom medical vocabulary names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_get_medical_vocabulary
transcribeservice_get_medical_vocabulary <- function(VocabularyName) {
  op <- new_operation(
    name = "GetMedicalVocabulary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$get_medical_vocabulary_input(VocabularyName = VocabularyName)
  output <- .transcribeservice$get_medical_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$get_medical_vocabulary <- transcribeservice_get_medical_vocabulary

#' Provides information about the specified transcription job
#'
#' @description
#' Provides information about the specified transcription job.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_get_transcription_job/](https://www.paws-r-sdk.com/docs/transcribeservice_get_transcription_job/) for full documentation.
#'
#' @param TranscriptionJobName &#91;required&#93; The name of the transcription job you want information about. Job names
#' are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_get_transcription_job
transcribeservice_get_transcription_job <- function(TranscriptionJobName) {
  op <- new_operation(
    name = "GetTranscriptionJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$get_transcription_job_input(TranscriptionJobName = TranscriptionJobName)
  output <- .transcribeservice$get_transcription_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$get_transcription_job <- transcribeservice_get_transcription_job

#' Provides information about the specified custom vocabulary
#'
#' @description
#' Provides information about the specified custom vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_get_vocabulary/](https://www.paws-r-sdk.com/docs/transcribeservice_get_vocabulary/) for full documentation.
#'
#' @param VocabularyName &#91;required&#93; The name of the custom vocabulary you want information about. Custom
#' vocabulary names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_get_vocabulary
transcribeservice_get_vocabulary <- function(VocabularyName) {
  op <- new_operation(
    name = "GetVocabulary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$get_vocabulary_input(VocabularyName = VocabularyName)
  output <- .transcribeservice$get_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$get_vocabulary <- transcribeservice_get_vocabulary

#' Provides information about the specified custom vocabulary filter
#'
#' @description
#' Provides information about the specified custom vocabulary filter.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_get_vocabulary_filter/](https://www.paws-r-sdk.com/docs/transcribeservice_get_vocabulary_filter/) for full documentation.
#'
#' @param VocabularyFilterName &#91;required&#93; The name of the custom vocabulary filter you want information about.
#' Custom vocabulary filter names are case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_get_vocabulary_filter
transcribeservice_get_vocabulary_filter <- function(VocabularyFilterName) {
  op <- new_operation(
    name = "GetVocabularyFilter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$get_vocabulary_filter_input(VocabularyFilterName = VocabularyFilterName)
  output <- .transcribeservice$get_vocabulary_filter_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$get_vocabulary_filter <- transcribeservice_get_vocabulary_filter

#' Provides a list of Call Analytics categories, including all rules that
#' make up each category
#'
#' @description
#' Provides a list of Call Analytics categories, including all rules that make up each category.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_list_call_analytics_categories/](https://www.paws-r-sdk.com/docs/transcribeservice_list_call_analytics_categories/) for full documentation.
#'
#' @param NextToken If your
#' [`list_call_analytics_categories`][transcribeservice_list_call_analytics_categories]
#' request returns more results than can be displayed, `NextToken` is
#' displayed in the response with an associated string. To get the next
#' page of results, copy this string and repeat your request, including
#' `NextToken` with the value of the copied string. Repeat as needed to
#' view all your results.
#' @param MaxResults The maximum number of Call Analytics categories to return in each page
#' of results. If there are fewer results than the value that you specify,
#' only the actual results are returned. If you do not specify a value, a
#' default of 5 is used.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_call_analytics_categories
transcribeservice_list_call_analytics_categories <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCallAnalyticsCategories",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .transcribeservice$list_call_analytics_categories_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .transcribeservice$list_call_analytics_categories_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_call_analytics_categories <- transcribeservice_list_call_analytics_categories

#' Provides a list of Call Analytics jobs that match the specified criteria
#'
#' @description
#' Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call Analytics jobs are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_list_call_analytics_jobs/](https://www.paws-r-sdk.com/docs/transcribeservice_list_call_analytics_jobs/) for full documentation.
#'
#' @param Status Returns only Call Analytics jobs with the specified status. Jobs are
#' ordered by creation date, with the newest job first. If you do not
#' include `Status`, all Call Analytics jobs are returned.
#' @param JobNameContains Returns only the Call Analytics jobs that contain the specified string.
#' The search is not case sensitive.
#' @param NextToken If your
#' [`list_call_analytics_jobs`][transcribeservice_list_call_analytics_jobs]
#' request returns more results than can be displayed, `NextToken` is
#' displayed in the response with an associated string. To get the next
#' page of results, copy this string and repeat your request, including
#' `NextToken` with the value of the copied string. Repeat as needed to
#' view all your results.
#' @param MaxResults The maximum number of Call Analytics jobs to return in each page of
#' results. If there are fewer results than the value that you specify,
#' only the actual results are returned. If you do not specify a value, a
#' default of 5 is used.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_call_analytics_jobs
transcribeservice_list_call_analytics_jobs <- function(Status = NULL, JobNameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCallAnalyticsJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .transcribeservice$list_call_analytics_jobs_input(Status = Status, JobNameContains = JobNameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .transcribeservice$list_call_analytics_jobs_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_call_analytics_jobs <- transcribeservice_list_call_analytics_jobs

#' Provides a list of custom language models that match the specified
#' criteria
#'
#' @description
#' Provides a list of custom language models that match the specified criteria. If no criteria are specified, all custom language models are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_list_language_models/](https://www.paws-r-sdk.com/docs/transcribeservice_list_language_models/) for full documentation.
#'
#' @param StatusEquals Returns only custom language models with the specified status. Language
#' models are ordered by creation date, with the newest model first. If you
#' do not include `StatusEquals`, all custom language models are returned.
#' @param NameContains Returns only the custom language models that contain the specified
#' string. The search is not case sensitive.
#' @param NextToken If your [`list_language_models`][transcribeservice_list_language_models]
#' request returns more results than can be displayed, `NextToken` is
#' displayed in the response with an associated string. To get the next
#' page of results, copy this string and repeat your request, including
#' `NextToken` with the value of the copied string. Repeat as needed to
#' view all your results.
#' @param MaxResults The maximum number of custom language models to return in each page of
#' results. If there are fewer results than the value that you specify,
#' only the actual results are returned. If you do not specify a value, a
#' default of 5 is used.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_language_models
transcribeservice_list_language_models <- function(StatusEquals = NULL, NameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLanguageModels",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .transcribeservice$list_language_models_input(StatusEquals = StatusEquals, NameContains = NameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .transcribeservice$list_language_models_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_language_models <- transcribeservice_list_language_models

#' Provides a list of Medical Scribe jobs that match the specified criteria
#'
#' @description
#' Provides a list of Medical Scribe jobs that match the specified criteria. If no criteria are specified, all Medical Scribe jobs are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_list_medical_scribe_jobs/](https://www.paws-r-sdk.com/docs/transcribeservice_list_medical_scribe_jobs/) for full documentation.
#'
#' @param Status Returns only Medical Scribe jobs with the specified status. Jobs are
#' ordered by creation date, with the newest job first. If you do not
#' include `Status`, all Medical Scribe jobs are returned.
#' @param JobNameContains Returns only the Medical Scribe jobs that contain the specified string.
#' The search is not case sensitive.
#' @param NextToken If your
#' [`list_medical_scribe_jobs`][transcribeservice_list_medical_scribe_jobs]
#' request returns more results than can be displayed, `NextToken` is
#' displayed in the response with an associated string. To get the next
#' page of results, copy this string and repeat your request, including
#' `NextToken` with the value of the copied string. Repeat as needed to
#' view all your results.
#' @param MaxResults The maximum number of Medical Scribe jobs to return in each page of
#' results. If there are fewer results than the value that you specify,
#' only the actual results are returned. If you do not specify a value, a
#' default of 5 is used.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_medical_scribe_jobs
transcribeservice_list_medical_scribe_jobs <- function(Status = NULL, JobNameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMedicalScribeJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .transcribeservice$list_medical_scribe_jobs_input(Status = Status, JobNameContains = JobNameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .transcribeservice$list_medical_scribe_jobs_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_medical_scribe_jobs <- transcribeservice_list_medical_scribe_jobs

#' Provides a list of medical transcription jobs that match the specified
#' criteria
#'
#' @description
#' Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified, all medical transcription jobs are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_list_medical_transcription_jobs/](https://www.paws-r-sdk.com/docs/transcribeservice_list_medical_transcription_jobs/) for full documentation.
#'
#' @param Status Returns only medical transcription jobs with the specified status. Jobs
#' are ordered by creation date, with the newest job first. If you do not
#' include `Status`, all medical transcription jobs are returned.
#' @param JobNameContains Returns only the medical transcription jobs that contain the specified
#' string. The search is not case sensitive.
#' @param NextToken If your
#' [`list_medical_transcription_jobs`][transcribeservice_list_medical_transcription_jobs]
#' request returns more results than can be displayed, `NextToken` is
#' displayed in the response with an associated string. To get the next
#' page of results, copy this string and repeat your request, including
#' `NextToken` with the value of the copied string. Repeat as needed to
#' view all your results.
#' @param MaxResults The maximum number of medical transcription jobs to return in each page
#' of results. If there are fewer results than the value that you specify,
#' only the actual results are returned. If you do not specify a value, a
#' default of 5 is used.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_medical_transcription_jobs
transcribeservice_list_medical_transcription_jobs <- function(Status = NULL, JobNameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMedicalTranscriptionJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .transcribeservice$list_medical_transcription_jobs_input(Status = Status, JobNameContains = JobNameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .transcribeservice$list_medical_transcription_jobs_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_medical_transcription_jobs <- transcribeservice_list_medical_transcription_jobs

#' Provides a list of custom medical vocabularies that match the specified
#' criteria
#'
#' @description
#' Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified, all custom medical vocabularies are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_list_medical_vocabularies/](https://www.paws-r-sdk.com/docs/transcribeservice_list_medical_vocabularies/) for full documentation.
#'
#' @param NextToken If your
#' [`list_medical_vocabularies`][transcribeservice_list_medical_vocabularies]
#' request returns more results than can be displayed, `NextToken` is
#' displayed in the response with an associated string. To get the next
#' page of results, copy this string and repeat your request, including
#' `NextToken` with the value of the copied string. Repeat as needed to
#' view all your results.
#' @param MaxResults The maximum number of custom medical vocabularies to return in each page
#' of results. If there are fewer results than the value that you specify,
#' only the actual results are returned. If you do not specify a value, a
#' default of 5 is used.
#' @param StateEquals Returns only custom medical vocabularies with the specified state.
#' Custom vocabularies are ordered by creation date, with the newest
#' vocabulary first. If you do not include `StateEquals`, all custom
#' medical vocabularies are returned.
#' @param NameContains Returns only the custom medical vocabularies that contain the specified
#' string. The search is not case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_medical_vocabularies
transcribeservice_list_medical_vocabularies <- function(NextToken = NULL, MaxResults = NULL, StateEquals = NULL, NameContains = NULL) {
  op <- new_operation(
    name = "ListMedicalVocabularies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .transcribeservice$list_medical_vocabularies_input(NextToken = NextToken, MaxResults = MaxResults, StateEquals = StateEquals, NameContains = NameContains)
  output <- .transcribeservice$list_medical_vocabularies_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_medical_vocabularies <- transcribeservice_list_medical_vocabularies

#' Lists all tags associated with the specified transcription job,
#' vocabulary, model, or resource
#'
#' @description
#' Lists all tags associated with the specified transcription job, vocabulary, model, or resource.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/transcribeservice_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Returns a list of all tags associated with the specified Amazon Resource
#' Name (ARN). ARNs have the format
#' `arn:partition:service:region:account-id:resource-type/resource-id`.
#' 
#' For example,
#' `arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name`.
#' 
#' Valid values for `resource-type` are: `transcription-job`,
#' `medical-transcription-job`, `vocabulary`, `medical-vocabulary`,
#' `vocabulary-filter`, and `language-model`.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_tags_for_resource
transcribeservice_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .transcribeservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_tags_for_resource <- transcribeservice_list_tags_for_resource

#' Provides a list of transcription jobs that match the specified criteria
#'
#' @description
#' Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all transcription jobs are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_list_transcription_jobs/](https://www.paws-r-sdk.com/docs/transcribeservice_list_transcription_jobs/) for full documentation.
#'
#' @param Status Returns only transcription jobs with the specified status. Jobs are
#' ordered by creation date, with the newest job first. If you do not
#' include `Status`, all transcription jobs are returned.
#' @param JobNameContains Returns only the transcription jobs that contain the specified string.
#' The search is not case sensitive.
#' @param NextToken If your
#' [`list_transcription_jobs`][transcribeservice_list_transcription_jobs]
#' request returns more results than can be displayed, `NextToken` is
#' displayed in the response with an associated string. To get the next
#' page of results, copy this string and repeat your request, including
#' `NextToken` with the value of the copied string. Repeat as needed to
#' view all your results.
#' @param MaxResults The maximum number of transcription jobs to return in each page of
#' results. If there are fewer results than the value that you specify,
#' only the actual results are returned. If you do not specify a value, a
#' default of 5 is used.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_transcription_jobs
transcribeservice_list_transcription_jobs <- function(Status = NULL, JobNameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTranscriptionJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .transcribeservice$list_transcription_jobs_input(Status = Status, JobNameContains = JobNameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .transcribeservice$list_transcription_jobs_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_transcription_jobs <- transcribeservice_list_transcription_jobs

#' Provides a list of custom vocabularies that match the specified criteria
#'
#' @description
#' Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_list_vocabularies/](https://www.paws-r-sdk.com/docs/transcribeservice_list_vocabularies/) for full documentation.
#'
#' @param NextToken If your [`list_vocabularies`][transcribeservice_list_vocabularies]
#' request returns more results than can be displayed, `NextToken` is
#' displayed in the response with an associated string. To get the next
#' page of results, copy this string and repeat your request, including
#' `NextToken` with the value of the copied string. Repeat as needed to
#' view all your results.
#' @param MaxResults The maximum number of custom vocabularies to return in each page of
#' results. If there are fewer results than the value that you specify,
#' only the actual results are returned. If you do not specify a value, a
#' default of 5 is used.
#' @param StateEquals Returns only custom vocabularies with the specified state. Vocabularies
#' are ordered by creation date, with the newest vocabulary first. If you
#' do not include `StateEquals`, all custom medical vocabularies are
#' returned.
#' @param NameContains Returns only the custom vocabularies that contain the specified string.
#' The search is not case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_vocabularies
transcribeservice_list_vocabularies <- function(NextToken = NULL, MaxResults = NULL, StateEquals = NULL, NameContains = NULL) {
  op <- new_operation(
    name = "ListVocabularies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .transcribeservice$list_vocabularies_input(NextToken = NextToken, MaxResults = MaxResults, StateEquals = StateEquals, NameContains = NameContains)
  output <- .transcribeservice$list_vocabularies_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_vocabularies <- transcribeservice_list_vocabularies

#' Provides a list of custom vocabulary filters that match the specified
#' criteria
#'
#' @description
#' Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_list_vocabulary_filters/](https://www.paws-r-sdk.com/docs/transcribeservice_list_vocabulary_filters/) for full documentation.
#'
#' @param NextToken If your
#' [`list_vocabulary_filters`][transcribeservice_list_vocabulary_filters]
#' request returns more results than can be displayed, `NextToken` is
#' displayed in the response with an associated string. To get the next
#' page of results, copy this string and repeat your request, including
#' `NextToken` with the value of the copied string. Repeat as needed to
#' view all your results.
#' @param MaxResults The maximum number of custom vocabulary filters to return in each page
#' of results. If there are fewer results than the value that you specify,
#' only the actual results are returned. If you do not specify a value, a
#' default of 5 is used.
#' @param NameContains Returns only the custom vocabulary filters that contain the specified
#' string. The search is not case sensitive.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_vocabulary_filters
transcribeservice_list_vocabulary_filters <- function(NextToken = NULL, MaxResults = NULL, NameContains = NULL) {
  op <- new_operation(
    name = "ListVocabularyFilters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .transcribeservice$list_vocabulary_filters_input(NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains)
  output <- .transcribeservice$list_vocabulary_filters_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_vocabulary_filters <- transcribeservice_list_vocabulary_filters

#' Transcribes the audio from a customer service call and applies any
#' additional Request Parameters you choose to include in your request
#'
#' @description
#' Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to include in your request.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_start_call_analytics_job/](https://www.paws-r-sdk.com/docs/transcribeservice_start_call_analytics_job/) for full documentation.
#'
#' @param CallAnalyticsJobName &#91;required&#93; A unique name, chosen by you, for your Call Analytics job.
#' 
#' This name is case sensitive, cannot contain spaces, and must be unique
#' within an Amazon Web Services account. If you try to create a new job
#' with the same name as an existing job, you get a `ConflictException`
#' error.
#' @param Media &#91;required&#93; Describes the Amazon S3 location of the media file you want to use in
#' your Call Analytics request.
#' @param OutputLocation The Amazon S3 location where you want your Call Analytics transcription
#' output stored. You can use any of the following formats to specify the
#' output location:
#' 
#' 1.  s3://DOC-EXAMPLE-BUCKET
#' 
#' 2.  s3://DOC-EXAMPLE-BUCKET/my-output-folder/
#' 
#' 3.  s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
#' 
#' Unless you specify a file name (option 3), the name of your output file
#' has a default value that matches the name you specified for your
#' transcription job using the `CallAnalyticsJobName` parameter.
#' 
#' You can specify a KMS key to encrypt your output using the
#' `OutputEncryptionKMSKeyId` parameter. If you do not specify a KMS key,
#' Amazon Transcribe uses the default Amazon S3 key for server-side
#' encryption.
#' 
#' If you do not specify `OutputLocation`, your transcript is placed in a
#' service-managed Amazon S3 bucket and you are provided with a URI to
#' access your transcript.
#' @param OutputEncryptionKMSKeyId The KMS key you want to use to encrypt your Call Analytics output.
#' 
#' If using a key located in the **current** Amazon Web Services account,
#' you can specify your KMS key in one of four ways:
#' 
#' 1.  Use the KMS key ID itself. For example,
#'     `1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 2.  Use an alias for the KMS key ID. For example, `alias/ExampleAlias`.
#' 
#' 3.  Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
#'     `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 4.  Use the ARN for the KMS key alias. For example,
#'     `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
#' 
#' If using a key located in a **different** Amazon Web Services account
#' than the current Amazon Web Services account, you can specify your KMS
#' key in one of two ways:
#' 
#' 1.  Use the ARN for the KMS key ID. For example,
#'     `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 2.  Use the ARN for the KMS key alias. For example,
#'     `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
#' 
#' If you do not specify an encryption key, your output is encrypted with
#' the default Amazon S3 key (SSE-S3).
#' 
#' If you specify a KMS key to encrypt your output, you must also specify
#' an output location using the `OutputLocation` parameter.
#' 
#' Note that the role making the request must have permission to use the
#' specified KMS key.
#' @param DataAccessRoleArn The Amazon Resource Name (ARN) of an IAM role that has permissions to
#' access the Amazon S3 bucket that contains your input files. If the role
#' that you specify doesn’t have the appropriate permissions to access the
#' specified Amazon S3 location, your request fails.
#' 
#' IAM role ARNs have the format
#' `arn:partition:iam::account:role/role-name-with-path`. For example:
#' `arn:aws:iam::111122223333:role/Admin`.
#' 
#' For more information, see [IAM
#' ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
#' @param Settings Specify additional optional settings in your request, including content
#' redaction; allows you to apply custom language models, vocabulary
#' filters, and custom vocabularies to your Call Analytics job.
#' @param ChannelDefinitions Makes it possible to specify which speaker is on which channel. For
#' example, if your agent is the first participant to speak, you would set
#' `ChannelId` to `0` (to indicate the first channel) and `ParticipantRole`
#' to `AGENT` (to indicate that it's the agent speaking).
#'
#' @keywords internal
#'
#' @rdname transcribeservice_start_call_analytics_job
transcribeservice_start_call_analytics_job <- function(CallAnalyticsJobName, Media, OutputLocation = NULL, OutputEncryptionKMSKeyId = NULL, DataAccessRoleArn = NULL, Settings = NULL, ChannelDefinitions = NULL) {
  op <- new_operation(
    name = "StartCallAnalyticsJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$start_call_analytics_job_input(CallAnalyticsJobName = CallAnalyticsJobName, Media = Media, OutputLocation = OutputLocation, OutputEncryptionKMSKeyId = OutputEncryptionKMSKeyId, DataAccessRoleArn = DataAccessRoleArn, Settings = Settings, ChannelDefinitions = ChannelDefinitions)
  output <- .transcribeservice$start_call_analytics_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$start_call_analytics_job <- transcribeservice_start_call_analytics_job

#' Transcribes patient-clinician conversations and generates clinical notes
#'
#' @description
#' Transcribes patient-clinician conversations and generates clinical notes.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_start_medical_scribe_job/](https://www.paws-r-sdk.com/docs/transcribeservice_start_medical_scribe_job/) for full documentation.
#'
#' @param MedicalScribeJobName &#91;required&#93; A unique name, chosen by you, for your Medical Scribe job.
#' 
#' This name is case sensitive, cannot contain spaces, and must be unique
#' within an Amazon Web Services account. If you try to create a new job
#' with the same name as an existing job, you get a `ConflictException`
#' error.
#' @param Media &#91;required&#93; 
#' @param OutputBucketName &#91;required&#93; The name of the Amazon S3 bucket where you want your Medical Scribe
#' output stored. Do not include the `S3://` prefix of the specified
#' bucket.
#' 
#' Note that the role specified in the `DataAccessRoleArn` request
#' parameter must have permission to use the specified location. You can
#' change Amazon S3 permissions using the [Amazon Web Services Management
#' Console](https://console.aws.amazon.com/s3/home). See also [Permissions
#' Required for IAM User
#' Roles](https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
#' @param OutputEncryptionKMSKeyId The KMS key you want to use to encrypt your Medical Scribe output.
#' 
#' If using a key located in the **current** Amazon Web Services account,
#' you can specify your KMS key in one of four ways:
#' 
#' 1.  Use the KMS key ID itself. For example,
#'     `1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 2.  Use an alias for the KMS key ID. For example, `alias/ExampleAlias`.
#' 
#' 3.  Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
#'     `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 4.  Use the ARN for the KMS key alias. For example,
#'     `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
#' 
#' If using a key located in a **different** Amazon Web Services account
#' than the current Amazon Web Services account, you can specify your KMS
#' key in one of two ways:
#' 
#' 1.  Use the ARN for the KMS key ID. For example,
#'     `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 2.  Use the ARN for the KMS key alias. For example,
#'     `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
#' 
#' If you do not specify an encryption key, your output is encrypted with
#' the default Amazon S3 key (SSE-S3).
#' 
#' Note that the role specified in the `DataAccessRoleArn` request
#' parameter must have permission to use the specified KMS key.
#' @param KMSEncryptionContext A map of plain text, non-secret key:value pairs, known as encryption
#' context pairs, that provide an added layer of security for your data.
#' For more information, see [KMS encryption
#' context](https://docs.aws.amazon.com/transcribe/latest/dg/#kms-context)
#' and [Asymmetric keys in
#' KMS](https://docs.aws.amazon.com/transcribe/latest/dg/).
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that has permissions to
#' access the Amazon S3 bucket that contains your input files, write to the
#' output bucket, and use your KMS key if supplied. If the role that you
#' specify doesn’t have the appropriate permissions your request fails.
#' 
#' IAM role ARNs have the format
#' `arn:partition:iam::account:role/role-name-with-path`. For example:
#' `arn:aws:iam::111122223333:role/Admin`.
#' 
#' For more information, see [IAM
#' ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
#' @param Settings &#91;required&#93; Makes it possible to control how your Medical Scribe job is processed
#' using a `MedicalScribeSettings` object. Specify `ChannelIdentification`
#' if `ChannelDefinitions` are set. Enabled `ShowSpeakerLabels` if
#' `ChannelIdentification` and `ChannelDefinitions` are not set. One and
#' only one of `ChannelIdentification` and `ShowSpeakerLabels` must be set.
#' If `ShowSpeakerLabels` is set, `MaxSpeakerLabels` must also be set. Use
#' `Settings` to specify a vocabulary or vocabulary filter or both using
#' `VocabularyName`, `VocabularyFilterName`. `VocabularyFilterMethod` must
#' be specified if `VocabularyFilterName` is set.
#' @param ChannelDefinitions Makes it possible to specify which speaker is on which channel. For
#' example, if the clinician is the first participant to speak, you would
#' set `ChannelId` of the first `ChannelDefinition` in the list to `0` (to
#' indicate the first channel) and `ParticipantRole` to `CLINICIAN` (to
#' indicate that it's the clinician speaking). Then you would set the
#' `ChannelId` of the second `ChannelDefinition` in the list to `1` (to
#' indicate the second channel) and `ParticipantRole` to `PATIENT` (to
#' indicate that it's the patient speaking).
#' @param Tags Adds one or more custom tags, each in the form of a key:value pair, to
#' the Medica Scribe job.
#' 
#' To learn more about using tags with Amazon Transcribe, refer to [Tagging
#' resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
#'
#' @keywords internal
#'
#' @rdname transcribeservice_start_medical_scribe_job
transcribeservice_start_medical_scribe_job <- function(MedicalScribeJobName, Media, OutputBucketName, OutputEncryptionKMSKeyId = NULL, KMSEncryptionContext = NULL, DataAccessRoleArn, Settings, ChannelDefinitions = NULL, Tags = NULL) {
  op <- new_operation(
    name = "StartMedicalScribeJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$start_medical_scribe_job_input(MedicalScribeJobName = MedicalScribeJobName, Media = Media, OutputBucketName = OutputBucketName, OutputEncryptionKMSKeyId = OutputEncryptionKMSKeyId, KMSEncryptionContext = KMSEncryptionContext, DataAccessRoleArn = DataAccessRoleArn, Settings = Settings, ChannelDefinitions = ChannelDefinitions, Tags = Tags)
  output <- .transcribeservice$start_medical_scribe_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$start_medical_scribe_job <- transcribeservice_start_medical_scribe_job

#' Transcribes the audio from a medical dictation or conversation and
#' applies any additional Request Parameters you choose to include in your
#' request
#'
#' @description
#' Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you choose to include in your request.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_start_medical_transcription_job/](https://www.paws-r-sdk.com/docs/transcribeservice_start_medical_transcription_job/) for full documentation.
#'
#' @param MedicalTranscriptionJobName &#91;required&#93; A unique name, chosen by you, for your medical transcription job. The
#' name that you specify is also used as the default name of your
#' transcription output file. If you want to specify a different name for
#' your transcription output, use the `OutputKey` parameter.
#' 
#' This name is case sensitive, cannot contain spaces, and must be unique
#' within an Amazon Web Services account. If you try to create a new job
#' with the same name as an existing job, you get a `ConflictException`
#' error.
#' @param LanguageCode &#91;required&#93; The language code that represents the language spoken in the input media
#' file. US English (`en-US`) is the only valid value for medical
#' transcription jobs. Any other value you enter for language code results
#' in a `BadRequestException` error.
#' @param MediaSampleRateHertz The sample rate, in hertz, of the audio track in your input media file.
#' 
#' If you do not specify the media sample rate, Amazon Transcribe Medical
#' determines it for you. If you specify the sample rate, it must match the
#' rate detected by Amazon Transcribe Medical; if there's a mismatch
#' between the value that you specify and the value detected, your job
#' fails. Therefore, in most cases, it's advised to omit
#' `MediaSampleRateHertz` and let Amazon Transcribe Medical determine the
#' sample rate.
#' @param MediaFormat Specify the format of your input media file.
#' @param Media &#91;required&#93; 
#' @param OutputBucketName &#91;required&#93; The name of the Amazon S3 bucket where you want your medical
#' transcription output stored. Do not include the `S3://` prefix of the
#' specified bucket.
#' 
#' If you want your output to go to a sub-folder of this bucket, specify it
#' using the `OutputKey` parameter; `OutputBucketName` only accepts the
#' name of a bucket.
#' 
#' For example, if you want your output stored in
#' `S3://DOC-EXAMPLE-BUCKET`, set `OutputBucketName` to
#' `DOC-EXAMPLE-BUCKET`. However, if you want your output stored in
#' `S3://DOC-EXAMPLE-BUCKET/test-files/`, set `OutputBucketName` to
#' `DOC-EXAMPLE-BUCKET` and `OutputKey` to `test-files/`.
#' 
#' Note that Amazon Transcribe must have permission to use the specified
#' location. You can change Amazon S3 permissions using the [Amazon Web
#' Services Management Console](https://console.aws.amazon.com/s3/home).
#' See also [Permissions Required for IAM User
#' Roles](https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
#' @param OutputKey Use in combination with `OutputBucketName` to specify the output
#' location of your transcript and, optionally, a unique name for your
#' output file. The default name for your transcription output is the same
#' as the name you specified for your medical transcription job
#' (`MedicalTranscriptionJobName`).
#' 
#' Here are some examples of how you can use `OutputKey`:
#' 
#' -   If you specify 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName` and
#'     'my-transcript.json' as the `OutputKey`, your transcription output
#'     path is `s3://DOC-EXAMPLE-BUCKET/my-transcript.json`.
#' 
#' -   If you specify 'my-first-transcription' as the
#'     `MedicalTranscriptionJobName`, 'DOC-EXAMPLE-BUCKET' as the
#'     `OutputBucketName`, and 'my-transcript' as the `OutputKey`, your
#'     transcription output path is
#'     `s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json`.
#' 
#' -   If you specify 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName` and
#'     'test-files/my-transcript.json' as the `OutputKey`, your
#'     transcription output path is
#'     `s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json`.
#' 
#' -   If you specify 'my-first-transcription' as the
#'     `MedicalTranscriptionJobName`, 'DOC-EXAMPLE-BUCKET' as the
#'     `OutputBucketName`, and 'test-files/my-transcript' as the
#'     `OutputKey`, your transcription output path is
#'     `s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json`.
#' 
#' If you specify the name of an Amazon S3 bucket sub-folder that doesn't
#' exist, one is created for you.
#' @param OutputEncryptionKMSKeyId The KMS key you want to use to encrypt your medical transcription
#' output.
#' 
#' If using a key located in the **current** Amazon Web Services account,
#' you can specify your KMS key in one of four ways:
#' 
#' 1.  Use the KMS key ID itself. For example,
#'     `1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 2.  Use an alias for the KMS key ID. For example, `alias/ExampleAlias`.
#' 
#' 3.  Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
#'     `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 4.  Use the ARN for the KMS key alias. For example,
#'     `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
#' 
#' If using a key located in a **different** Amazon Web Services account
#' than the current Amazon Web Services account, you can specify your KMS
#' key in one of two ways:
#' 
#' 1.  Use the ARN for the KMS key ID. For example,
#'     `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 2.  Use the ARN for the KMS key alias. For example,
#'     `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
#' 
#' If you do not specify an encryption key, your output is encrypted with
#' the default Amazon S3 key (SSE-S3).
#' 
#' If you specify a KMS key to encrypt your output, you must also specify
#' an output location using the `OutputLocation` parameter.
#' 
#' Note that the role making the request must have permission to use the
#' specified KMS key.
#' @param KMSEncryptionContext A map of plain text, non-secret key:value pairs, known as encryption
#' context pairs, that provide an added layer of security for your data.
#' For more information, see [KMS encryption
#' context](https://docs.aws.amazon.com/transcribe/latest/dg/#kms-context)
#' and [Asymmetric keys in
#' KMS](https://docs.aws.amazon.com/transcribe/latest/dg/).
#' @param Settings Specify additional optional settings in your request, including channel
#' identification, alternative transcriptions, and speaker partitioning.
#' You can use that to apply custom vocabularies to your transcription job.
#' @param ContentIdentificationType Labels all personal health information (PHI) identified in your
#' transcript. For more information, see [Identifying personal health
#' information (PHI) in a
#' transcription](https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html).
#' @param Specialty &#91;required&#93; Specify the predominant medical specialty represented in your media. For
#' batch transcriptions, `PRIMARYCARE` is the only valid value. If you
#' require additional specialties, refer to .
#' @param Type &#91;required&#93; Specify whether your input media contains only one person (`DICTATION`)
#' or contains a conversation between two people (`CONVERSATION`).
#' 
#' For example, `DICTATION` could be used for a medical professional
#' wanting to transcribe voice memos; `CONVERSATION` could be used for
#' transcribing the doctor-patient dialogue during the patient's office
#' visit.
#' @param Tags Adds one or more custom tags, each in the form of a key:value pair, to a
#' new medical transcription job at the time you start this new job.
#' 
#' To learn more about using tags with Amazon Transcribe, refer to [Tagging
#' resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
#'
#' @keywords internal
#'
#' @rdname transcribeservice_start_medical_transcription_job
transcribeservice_start_medical_transcription_job <- function(MedicalTranscriptionJobName, LanguageCode, MediaSampleRateHertz = NULL, MediaFormat = NULL, Media, OutputBucketName, OutputKey = NULL, OutputEncryptionKMSKeyId = NULL, KMSEncryptionContext = NULL, Settings = NULL, ContentIdentificationType = NULL, Specialty, Type, Tags = NULL) {
  op <- new_operation(
    name = "StartMedicalTranscriptionJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$start_medical_transcription_job_input(MedicalTranscriptionJobName = MedicalTranscriptionJobName, LanguageCode = LanguageCode, MediaSampleRateHertz = MediaSampleRateHertz, MediaFormat = MediaFormat, Media = Media, OutputBucketName = OutputBucketName, OutputKey = OutputKey, OutputEncryptionKMSKeyId = OutputEncryptionKMSKeyId, KMSEncryptionContext = KMSEncryptionContext, Settings = Settings, ContentIdentificationType = ContentIdentificationType, Specialty = Specialty, Type = Type, Tags = Tags)
  output <- .transcribeservice$start_medical_transcription_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$start_medical_transcription_job <- transcribeservice_start_medical_transcription_job

#' Transcribes the audio from a media file and applies any additional
#' Request Parameters you choose to include in your request
#'
#' @description
#' Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in your request.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_start_transcription_job/](https://www.paws-r-sdk.com/docs/transcribeservice_start_transcription_job/) for full documentation.
#'
#' @param TranscriptionJobName &#91;required&#93; A unique name, chosen by you, for your transcription job. The name that
#' you specify is also used as the default name of your transcription
#' output file. If you want to specify a different name for your
#' transcription output, use the `OutputKey` parameter.
#' 
#' This name is case sensitive, cannot contain spaces, and must be unique
#' within an Amazon Web Services account. If you try to create a new job
#' with the same name as an existing job, you get a `ConflictException`
#' error.
#' @param LanguageCode The language code that represents the language spoken in the input media
#' file.
#' 
#' If you're unsure of the language spoken in your media file, consider
#' using `IdentifyLanguage` or `IdentifyMultipleLanguages` to enable
#' automatic language identification.
#' 
#' Note that you must include one of `LanguageCode`, `IdentifyLanguage`, or
#' `IdentifyMultipleLanguages` in your request. If you include more than
#' one of these parameters, your transcription job fails.
#' 
#' For a list of supported languages and their associated language codes,
#' refer to the [Supported
#' languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
#' table.
#' 
#' To transcribe speech in Modern Standard Arabic (`ar-SA`), your media
#' file must be encoded at a sample rate of 16,000 Hz or higher.
#' @param MediaSampleRateHertz The sample rate, in hertz, of the audio track in your input media file.
#' 
#' If you do not specify the media sample rate, Amazon Transcribe
#' determines it for you. If you specify the sample rate, it must match the
#' rate detected by Amazon Transcribe. If there's a mismatch between the
#' value that you specify and the value detected, your job fails. In most
#' cases, you can omit `MediaSampleRateHertz` and let Amazon Transcribe
#' determine the sample rate.
#' @param MediaFormat Specify the format of your input media file.
#' @param Media &#91;required&#93; Describes the Amazon S3 location of the media file you want to use in
#' your request.
#' @param OutputBucketName The name of the Amazon S3 bucket where you want your transcription
#' output stored. Do not include the `S3://` prefix of the specified
#' bucket.
#' 
#' If you want your output to go to a sub-folder of this bucket, specify it
#' using the `OutputKey` parameter; `OutputBucketName` only accepts the
#' name of a bucket.
#' 
#' For example, if you want your output stored in
#' `S3://DOC-EXAMPLE-BUCKET`, set `OutputBucketName` to
#' `DOC-EXAMPLE-BUCKET`. However, if you want your output stored in
#' `S3://DOC-EXAMPLE-BUCKET/test-files/`, set `OutputBucketName` to
#' `DOC-EXAMPLE-BUCKET` and `OutputKey` to `test-files/`.
#' 
#' Note that Amazon Transcribe must have permission to use the specified
#' location. You can change Amazon S3 permissions using the [Amazon Web
#' Services Management Console](https://console.aws.amazon.com/s3/home).
#' See also [Permissions Required for IAM User
#' Roles](https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
#' 
#' If you do not specify `OutputBucketName`, your transcript is placed in a
#' service-managed Amazon S3 bucket and you are provided with a URI to
#' access your transcript.
#' @param OutputKey Use in combination with `OutputBucketName` to specify the output
#' location of your transcript and, optionally, a unique name for your
#' output file. The default name for your transcription output is the same
#' as the name you specified for your transcription job
#' (`TranscriptionJobName`).
#' 
#' Here are some examples of how you can use `OutputKey`:
#' 
#' -   If you specify 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName` and
#'     'my-transcript.json' as the `OutputKey`, your transcription output
#'     path is `s3://DOC-EXAMPLE-BUCKET/my-transcript.json`.
#' 
#' -   If you specify 'my-first-transcription' as the
#'     `TranscriptionJobName`, 'DOC-EXAMPLE-BUCKET' as the
#'     `OutputBucketName`, and 'my-transcript' as the `OutputKey`, your
#'     transcription output path is
#'     `s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json`.
#' 
#' -   If you specify 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName` and
#'     'test-files/my-transcript.json' as the `OutputKey`, your
#'     transcription output path is
#'     `s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json`.
#' 
#' -   If you specify 'my-first-transcription' as the
#'     `TranscriptionJobName`, 'DOC-EXAMPLE-BUCKET' as the
#'     `OutputBucketName`, and 'test-files/my-transcript' as the
#'     `OutputKey`, your transcription output path is
#'     `s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json`.
#' 
#' If you specify the name of an Amazon S3 bucket sub-folder that doesn't
#' exist, one is created for you.
#' @param OutputEncryptionKMSKeyId The KMS key you want to use to encrypt your transcription output.
#' 
#' If using a key located in the **current** Amazon Web Services account,
#' you can specify your KMS key in one of four ways:
#' 
#' 1.  Use the KMS key ID itself. For example,
#'     `1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 2.  Use an alias for the KMS key ID. For example, `alias/ExampleAlias`.
#' 
#' 3.  Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
#'     `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 4.  Use the ARN for the KMS key alias. For example,
#'     `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
#' 
#' If using a key located in a **different** Amazon Web Services account
#' than the current Amazon Web Services account, you can specify your KMS
#' key in one of two ways:
#' 
#' 1.  Use the ARN for the KMS key ID. For example,
#'     `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' 2.  Use the ARN for the KMS key alias. For example,
#'     `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
#' 
#' If you do not specify an encryption key, your output is encrypted with
#' the default Amazon S3 key (SSE-S3).
#' 
#' If you specify a KMS key to encrypt your output, you must also specify
#' an output location using the `OutputLocation` parameter.
#' 
#' Note that the role making the request must have permission to use the
#' specified KMS key.
#' @param KMSEncryptionContext A map of plain text, non-secret key:value pairs, known as encryption
#' context pairs, that provide an added layer of security for your data.
#' For more information, see [KMS encryption
#' context](https://docs.aws.amazon.com/transcribe/latest/dg/#kms-context)
#' and [Asymmetric keys in
#' KMS](https://docs.aws.amazon.com/transcribe/latest/dg/).
#' @param Settings Specify additional optional settings in your request, including channel
#' identification, alternative transcriptions, speaker partitioning. You
#' can use that to apply custom vocabularies and vocabulary filters.
#' 
#' If you want to include a custom vocabulary or a custom vocabulary filter
#' (or both) with your request but **do not** want to use automatic
#' language identification, use `Settings` with the `VocabularyName` or
#' `VocabularyFilterName` (or both) sub-parameter.
#' 
#' If you're using automatic language identification with your request and
#' want to include a custom language model, a custom vocabulary, or a
#' custom vocabulary filter, use instead the `` parameter with the
#' `LanguageModelName`, `VocabularyName` or `VocabularyFilterName`
#' sub-parameters.
#' @param ModelSettings Specify the custom language model you want to include with your
#' transcription job. If you include `ModelSettings` in your request, you
#' must include the `LanguageModelName` sub-parameter.
#' 
#' For more information, see [Custom language
#' models](https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html).
#' @param JobExecutionSettings Makes it possible to control how your transcription job is processed.
#' Currently, the only `JobExecutionSettings` modification you can choose
#' is enabling job queueing using the `AllowDeferredExecution`
#' sub-parameter.
#' 
#' If you include `JobExecutionSettings` in your request, you must also
#' include the sub-parameters: `AllowDeferredExecution` and
#' `DataAccessRoleArn`.
#' @param ContentRedaction Makes it possible to redact or flag specified personally identifiable
#' information (PII) in your transcript. If you use `ContentRedaction`, you
#' must also include the sub-parameters: `RedactionOutput` and
#' `RedactionType`. You can optionally include `PiiEntityTypes` to choose
#' which types of PII you want to redact. If you do not include
#' `PiiEntityTypes` in your request, all PII is redacted.
#' @param IdentifyLanguage Enables automatic language identification in your transcription job
#' request. Use this parameter if your media file contains only one
#' language. If your media contains multiple languages, use
#' `IdentifyMultipleLanguages` instead.
#' 
#' If you include `IdentifyLanguage`, you can optionally include a list of
#' language codes, using `LanguageOptions`, that you think may be present
#' in your media file. Including `LanguageOptions` restricts
#' `IdentifyLanguage` to only the language options that you specify, which
#' can improve transcription accuracy.
#' 
#' If you want to apply a custom language model, a custom vocabulary, or a
#' custom vocabulary filter to your automatic language identification
#' request, include `LanguageIdSettings` with the relevant sub-parameters
#' (`VocabularyName`, `LanguageModelName`, and `VocabularyFilterName`). If
#' you include `LanguageIdSettings`, also include `LanguageOptions`.
#' 
#' Note that you must include one of `LanguageCode`, `IdentifyLanguage`, or
#' `IdentifyMultipleLanguages` in your request. If you include more than
#' one of these parameters, your transcription job fails.
#' @param IdentifyMultipleLanguages Enables automatic multi-language identification in your transcription
#' job request. Use this parameter if your media file contains more than
#' one language. If your media contains only one language, use
#' `IdentifyLanguage` instead.
#' 
#' If you include `IdentifyMultipleLanguages`, you can optionally include a
#' list of language codes, using `LanguageOptions`, that you think may be
#' present in your media file. Including `LanguageOptions` restricts
#' `IdentifyLanguage` to only the language options that you specify, which
#' can improve transcription accuracy.
#' 
#' If you want to apply a custom vocabulary or a custom vocabulary filter
#' to your automatic language identification request, include
#' `LanguageIdSettings` with the relevant sub-parameters (`VocabularyName`
#' and `VocabularyFilterName`). If you include `LanguageIdSettings`, also
#' include `LanguageOptions`.
#' 
#' Note that you must include one of `LanguageCode`, `IdentifyLanguage`, or
#' `IdentifyMultipleLanguages` in your request. If you include more than
#' one of these parameters, your transcription job fails.
#' @param LanguageOptions You can specify two or more language codes that represent the languages
#' you think may be present in your media. Including more than five is not
#' recommended. If you're unsure what languages are present, do not include
#' this parameter.
#' 
#' If you include `LanguageOptions` in your request, you must also include
#' `IdentifyLanguage`.
#' 
#' For more information, refer to [Supported
#' languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html).
#' 
#' To transcribe speech in Modern Standard Arabic (`ar-SA`), your media
#' file must be encoded at a sample rate of 16,000 Hz or higher.
#' @param Subtitles Produces subtitle files for your input media. You can specify WebVTT
#' (*.vtt) and SubRip (*.srt) formats.
#' @param Tags Adds one or more custom tags, each in the form of a key:value pair, to a
#' new transcription job at the time you start this new job.
#' 
#' To learn more about using tags with Amazon Transcribe, refer to [Tagging
#' resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
#' @param LanguageIdSettings If using automatic language identification in your request and you want
#' to apply a custom language model, a custom vocabulary, or a custom
#' vocabulary filter, include `LanguageIdSettings` with the relevant
#' sub-parameters (`VocabularyName`, `LanguageModelName`, and
#' `VocabularyFilterName`). Note that multi-language identification
#' (`IdentifyMultipleLanguages`) doesn't support custom language models.
#' 
#' `LanguageIdSettings` supports two to five language codes. Each language
#' code you include can have an associated custom language model, custom
#' vocabulary, and custom vocabulary filter. The language codes that you
#' specify must match the languages of the associated custom language
#' models, custom vocabularies, and custom vocabulary filters.
#' 
#' It's recommended that you include `LanguageOptions` when using
#' `LanguageIdSettings` to ensure that the correct language dialect is
#' identified. For example, if you specify a custom vocabulary that is in
#' `en-US` but Amazon Transcribe determines that the language spoken in
#' your media is `en-AU`, your custom vocabulary *is not* applied to your
#' transcription. If you include `LanguageOptions` and include `en-US` as
#' the only English language dialect, your custom vocabulary *is* applied
#' to your transcription.
#' 
#' If you want to include a custom language model with your request but
#' **do not** want to use automatic language identification, use instead
#' the `` parameter with the `LanguageModelName` sub-parameter. If you want
#' to include a custom vocabulary or a custom vocabulary filter (or both)
#' with your request but **do not** want to use automatic language
#' identification, use instead the `` parameter with the `VocabularyName`
#' or `VocabularyFilterName` (or both) sub-parameter.
#' @param ToxicityDetection Enables toxic speech detection in your transcript. If you include
#' `ToxicityDetection` in your request, you must also include
#' `ToxicityCategories`.
#' 
#' For information on the types of toxic speech Amazon Transcribe can
#' detect, see [Detecting toxic
#' speech](https://docs.aws.amazon.com/transcribe/latest/dg/).
#'
#' @keywords internal
#'
#' @rdname transcribeservice_start_transcription_job
transcribeservice_start_transcription_job <- function(TranscriptionJobName, LanguageCode = NULL, MediaSampleRateHertz = NULL, MediaFormat = NULL, Media, OutputBucketName = NULL, OutputKey = NULL, OutputEncryptionKMSKeyId = NULL, KMSEncryptionContext = NULL, Settings = NULL, ModelSettings = NULL, JobExecutionSettings = NULL, ContentRedaction = NULL, IdentifyLanguage = NULL, IdentifyMultipleLanguages = NULL, LanguageOptions = NULL, Subtitles = NULL, Tags = NULL, LanguageIdSettings = NULL, ToxicityDetection = NULL) {
  op <- new_operation(
    name = "StartTranscriptionJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$start_transcription_job_input(TranscriptionJobName = TranscriptionJobName, LanguageCode = LanguageCode, MediaSampleRateHertz = MediaSampleRateHertz, MediaFormat = MediaFormat, Media = Media, OutputBucketName = OutputBucketName, OutputKey = OutputKey, OutputEncryptionKMSKeyId = OutputEncryptionKMSKeyId, KMSEncryptionContext = KMSEncryptionContext, Settings = Settings, ModelSettings = ModelSettings, JobExecutionSettings = JobExecutionSettings, ContentRedaction = ContentRedaction, IdentifyLanguage = IdentifyLanguage, IdentifyMultipleLanguages = IdentifyMultipleLanguages, LanguageOptions = LanguageOptions, Subtitles = Subtitles, Tags = Tags, LanguageIdSettings = LanguageIdSettings, ToxicityDetection = ToxicityDetection)
  output <- .transcribeservice$start_transcription_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$start_transcription_job <- transcribeservice_start_transcription_job

#' Adds one or more custom tags, each in the form of a key:value pair, to
#' the specified resource
#'
#' @description
#' Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_tag_resource/](https://www.paws-r-sdk.com/docs/transcribeservice_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource you want to tag. ARNs
#' have the format
#' `arn:partition:service:region:account-id:resource-type/resource-id`.
#' 
#' For example,
#' `arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name`.
#' 
#' Valid values for `resource-type` are: `transcription-job`,
#' `medical-transcription-job`, `vocabulary`, `medical-vocabulary`,
#' `vocabulary-filter`, and `language-model`.
#' @param Tags &#91;required&#93; Adds one or more custom tags, each in the form of a key:value pair, to
#' the specified resource.
#' 
#' To learn more about using tags with Amazon Transcribe, refer to [Tagging
#' resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
#'
#' @keywords internal
#'
#' @rdname transcribeservice_tag_resource
transcribeservice_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .transcribeservice$tag_resource_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$tag_resource <- transcribeservice_tag_resource

#' Removes the specified tags from the specified Amazon Transcribe resource
#'
#' @description
#' Removes the specified tags from the specified Amazon Transcribe resource.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_untag_resource/](https://www.paws-r-sdk.com/docs/transcribeservice_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Transcribe resource you
#' want to remove tags from. ARNs have the format
#' `arn:partition:service:region:account-id:resource-type/resource-id`.
#' 
#' For example,
#' `arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name`.
#' 
#' Valid values for `resource-type` are: `transcription-job`,
#' `medical-transcription-job`, `vocabulary`, `medical-vocabulary`,
#' `vocabulary-filter`, and `language-model`.
#' @param TagKeys &#91;required&#93; Removes the specified tag keys from the specified Amazon Transcribe
#' resource.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_untag_resource
transcribeservice_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .transcribeservice$untag_resource_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$untag_resource <- transcribeservice_untag_resource

#' Updates the specified Call Analytics category with new rules
#'
#' @description
#' Updates the specified Call Analytics category with new rules. Note that the [`update_call_analytics_category`][transcribeservice_update_call_analytics_category] operation overwrites all existing rules contained in the specified category. You cannot append additional rules onto an existing category.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_update_call_analytics_category/](https://www.paws-r-sdk.com/docs/transcribeservice_update_call_analytics_category/) for full documentation.
#'
#' @param CategoryName &#91;required&#93; The name of the Call Analytics category you want to update. Category
#' names are case sensitive.
#' @param Rules &#91;required&#93; The rules used for the updated Call Analytics category. The rules you
#' provide in this field replace the ones that are currently being used in
#' the specified category.
#' @param InputType Choose whether you want to update a real-time or a post-call category.
#' The input type you specify must match the input type specified when the
#' category was created. For example, if you created a category with the
#' `POST_CALL` input type, you must use `POST_CALL` as the input type when
#' updating this category.
#'
#' @keywords internal
#'
#' @rdname transcribeservice_update_call_analytics_category
transcribeservice_update_call_analytics_category <- function(CategoryName, Rules, InputType = NULL) {
  op <- new_operation(
    name = "UpdateCallAnalyticsCategory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$update_call_analytics_category_input(CategoryName = CategoryName, Rules = Rules, InputType = InputType)
  output <- .transcribeservice$update_call_analytics_category_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$update_call_analytics_category <- transcribeservice_update_call_analytics_category

#' Updates an existing custom medical vocabulary with new values
#'
#' @description
#' Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing custom vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_update_medical_vocabulary/](https://www.paws-r-sdk.com/docs/transcribeservice_update_medical_vocabulary/) for full documentation.
#'
#' @param VocabularyName &#91;required&#93; The name of the custom medical vocabulary you want to update. Custom
#' medical vocabulary names are case sensitive.
#' @param LanguageCode &#91;required&#93; The language code that represents the language of the entries in the
#' custom vocabulary you want to update. US English (`en-US`) is the only
#' language supported with Amazon Transcribe Medical.
#' @param VocabularyFileUri &#91;required&#93; The Amazon S3 location of the text file that contains your custom
#' medical vocabulary. The URI must be located in the same Amazon Web
#' Services Region as the resource you're calling.
#' 
#' Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt`
#'
#' @keywords internal
#'
#' @rdname transcribeservice_update_medical_vocabulary
transcribeservice_update_medical_vocabulary <- function(VocabularyName, LanguageCode, VocabularyFileUri) {
  op <- new_operation(
    name = "UpdateMedicalVocabulary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$update_medical_vocabulary_input(VocabularyName = VocabularyName, LanguageCode = LanguageCode, VocabularyFileUri = VocabularyFileUri)
  output <- .transcribeservice$update_medical_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$update_medical_vocabulary <- transcribeservice_update_medical_vocabulary

#' Updates an existing custom vocabulary with new values
#'
#' @description
#' Updates an existing custom vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing custom vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_update_vocabulary/](https://www.paws-r-sdk.com/docs/transcribeservice_update_vocabulary/) for full documentation.
#'
#' @param VocabularyName &#91;required&#93; The name of the custom vocabulary you want to update. Custom vocabulary
#' names are case sensitive.
#' @param LanguageCode &#91;required&#93; The language code that represents the language of the entries in the
#' custom vocabulary you want to update. Each custom vocabulary must
#' contain terms in only one language.
#' 
#' A custom vocabulary can only be used to transcribe files in the same
#' language as the custom vocabulary. For example, if you create a custom
#' vocabulary using US English (`en-US`), you can only apply this custom
#' vocabulary to files that contain English audio.
#' 
#' For a list of supported languages and their associated language codes,
#' refer to the [Supported
#' languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
#' table.
#' @param Phrases Use this parameter if you want to update your custom vocabulary by
#' including all desired terms, as comma-separated values, within your
#' request. The other option for updating your custom vocabulary is to save
#' your entries in a text file and upload them to an Amazon S3 bucket, then
#' specify the location of your file using the `VocabularyFileUri`
#' parameter.
#' 
#' Note that if you include `Phrases` in your request, you cannot use
#' `VocabularyFileUri`; you must choose one or the other.
#' 
#' Each language has a character set that contains all allowed characters
#' for that specific language. If you use unsupported characters, your
#' custom vocabulary filter request fails. Refer to [Character Sets for
#' Custom
#' Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
#' to get the character set for your language.
#' @param VocabularyFileUri The Amazon S3 location of the text file that contains your custom
#' vocabulary. The URI must be located in the same Amazon Web Services
#' Region as the resource you're calling.
#' 
#' Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt`
#' 
#' Note that if you include `VocabularyFileUri` in your request, you cannot
#' use the `Phrases` flag; you must choose one or the other.
#' @param DataAccessRoleArn The Amazon Resource Name (ARN) of an IAM role that has permissions to
#' access the Amazon S3 bucket that contains your input files (in this
#' case, your custom vocabulary). If the role that you specify doesn’t have
#' the appropriate permissions to access the specified Amazon S3 location,
#' your request fails.
#' 
#' IAM role ARNs have the format
#' `arn:partition:iam::account:role/role-name-with-path`. For example:
#' `arn:aws:iam::111122223333:role/Admin`.
#' 
#' For more information, see [IAM
#' ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
#'
#' @keywords internal
#'
#' @rdname transcribeservice_update_vocabulary
transcribeservice_update_vocabulary <- function(VocabularyName, LanguageCode, Phrases = NULL, VocabularyFileUri = NULL, DataAccessRoleArn = NULL) {
  op <- new_operation(
    name = "UpdateVocabulary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$update_vocabulary_input(VocabularyName = VocabularyName, LanguageCode = LanguageCode, Phrases = Phrases, VocabularyFileUri = VocabularyFileUri, DataAccessRoleArn = DataAccessRoleArn)
  output <- .transcribeservice$update_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$update_vocabulary <- transcribeservice_update_vocabulary

#' Updates an existing custom vocabulary filter with a new list of words
#'
#' @description
#' Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all previous entries; you cannot append new terms onto an existing custom vocabulary filter.
#'
#' See [https://www.paws-r-sdk.com/docs/transcribeservice_update_vocabulary_filter/](https://www.paws-r-sdk.com/docs/transcribeservice_update_vocabulary_filter/) for full documentation.
#'
#' @param VocabularyFilterName &#91;required&#93; The name of the custom vocabulary filter you want to update. Custom
#' vocabulary filter names are case sensitive.
#' @param Words Use this parameter if you want to update your custom vocabulary filter
#' by including all desired terms, as comma-separated values, within your
#' request. The other option for updating your vocabulary filter is to save
#' your entries in a text file and upload them to an Amazon S3 bucket, then
#' specify the location of your file using the `VocabularyFilterFileUri`
#' parameter.
#' 
#' Note that if you include `Words` in your request, you cannot use
#' `VocabularyFilterFileUri`; you must choose one or the other.
#' 
#' Each language has a character set that contains all allowed characters
#' for that specific language. If you use unsupported characters, your
#' custom vocabulary filter request fails. Refer to [Character Sets for
#' Custom
#' Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
#' to get the character set for your language.
#' @param VocabularyFilterFileUri The Amazon S3 location of the text file that contains your custom
#' vocabulary filter terms. The URI must be located in the same Amazon Web
#' Services Region as the resource you're calling.
#' 
#' Here's an example URI path:
#' `s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt`
#' 
#' Note that if you include `VocabularyFilterFileUri` in your request, you
#' cannot use `Words`; you must choose one or the other.
#' @param DataAccessRoleArn The Amazon Resource Name (ARN) of an IAM role that has permissions to
#' access the Amazon S3 bucket that contains your input files (in this
#' case, your custom vocabulary filter). If the role that you specify
#' doesn’t have the appropriate permissions to access the specified Amazon
#' S3 location, your request fails.
#' 
#' IAM role ARNs have the format
#' `arn:partition:iam::account:role/role-name-with-path`. For example:
#' `arn:aws:iam::111122223333:role/Admin`.
#' 
#' For more information, see [IAM
#' ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
#'
#' @keywords internal
#'
#' @rdname transcribeservice_update_vocabulary_filter
transcribeservice_update_vocabulary_filter <- function(VocabularyFilterName, Words = NULL, VocabularyFilterFileUri = NULL, DataAccessRoleArn = NULL) {
  op <- new_operation(
    name = "UpdateVocabularyFilter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .transcribeservice$update_vocabulary_filter_input(VocabularyFilterName = VocabularyFilterName, Words = Words, VocabularyFilterFileUri = VocabularyFilterFileUri, DataAccessRoleArn = DataAccessRoleArn)
  output <- .transcribeservice$update_vocabulary_filter_output()
  config <- get_config()
  svc <- .transcribeservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$update_vocabulary_filter <- transcribeservice_update_vocabulary_filter
