% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_partner_app}
\alias{sagemaker_create_partner_app}
\title{Creates an Amazon SageMaker Partner AI App}
\usage{
sagemaker_create_partner_app(
  Name,
  Type,
  ExecutionRoleArn,
  MaintenanceConfig = NULL,
  Tier,
  ApplicationConfig = NULL,
  AuthType,
  EnableIamSessionBasedIdentity = NULL,
  ClientToken = NULL,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name to give the SageMaker Partner AI App.}

\item{Type}{[required] The type of SageMaker Partner AI App to create. Must be one of the
following: \code{lakera-guard}, \code{comet}, \code{deepchecks-llm-evaluation}, or
\code{fiddler}.}

\item{ExecutionRoleArn}{[required] The ARN of the IAM role that the partner application uses.}

\item{MaintenanceConfig}{Maintenance configuration settings for the SageMaker Partner AI App.}

\item{Tier}{[required] Indicates the instance type and size of the cluster attached to the
SageMaker Partner AI App.}

\item{ApplicationConfig}{Configuration settings for the SageMaker Partner AI App.}

\item{AuthType}{[required] The authorization type that users use to access the SageMaker Partner AI
App.}

\item{EnableIamSessionBasedIdentity}{When set to \code{TRUE}, the SageMaker Partner AI App sets the Amazon Web
Services IAM session name or the authenticated IAM user as the identity
of the SageMaker Partner AI App user.}

\item{ClientToken}{A unique token that guarantees that the call to this API is idempotent.}

\item{Tags}{Each tag consists of a key and an optional value. Tag keys must be
unique per resource.}
}
\description{
Creates an Amazon SageMaker Partner AI App.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_partner_app/} for full documentation.
}
\keyword{internal}
