% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_deregister_volume}
\alias{opsworks_deregister_volume}
\title{Deregisters an Amazon EBS volume}
\usage{
opsworks_deregister_volume(VolumeId)
}
\arguments{
\item{VolumeId}{[required] The AWS OpsWorks Stacks volume ID, which is the GUID that AWS OpsWorks
Stacks assigned to the instance when you registered the volume with the
stack, not the Amazon EC2 volume ID.}
}
\description{
Deregisters an Amazon EBS volume. The volume can then be registered by
another stack. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html}{Resource Management}.

\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$deregister_volume(
  VolumeId = "string"
)
}
}

\keyword{internal}
