% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_resolve_case}
\alias{support_resolve_case}
\title{Resolves a support case}
\usage{
support_resolve_case(caseId)
}
\arguments{
\item{caseId}{The AWS Support case ID requested or returned in the call. The case ID
is an alphanumeric string formatted as shown in this example:
case-\emph{12345678910-2013-c4c1d2bf33c5cf47}}
}
\description{
Resolves a support case. This operation takes a \code{caseId} and returns the
initial and final state of the case.
\itemize{
\item You must have a Business or Enterprise support plan to use the AWS
Support API.
\item If you call the AWS Support API from an account that does not have a
Business or Enterprise support plan, the
\code{SubscriptionRequiredException} error message appears. For
information about changing your support plan, see \href{https://aws.amazon.com/premiumsupport/}{AWS Support}.
}
}
\section{Request syntax}{
\preformatted{svc$resolve_case(
  caseId = "string"
)
}
}

\keyword{internal}
