% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_commands}
\alias{opsworks_describe_commands}
\title{Describes the results of specified commands}
\usage{
opsworks_describe_commands(DeploymentId, InstanceId, CommandIds)
}
\arguments{
\item{DeploymentId}{The deployment ID. If you include this parameter,
\code{\link[=opsworks_describe_commands]{describe_commands}} returns a description
of the commands associated with the specified deployment.}

\item{InstanceId}{The instance ID. If you include this parameter,
\code{\link[=opsworks_describe_commands]{describe_commands}} returns a description
of the commands associated with the specified instance.}

\item{CommandIds}{An array of command IDs. If you include this parameter,
\code{\link[=opsworks_describe_commands]{describe_commands}} returns a description
of the specified commands. Otherwise, it returns a description of every
command.}
}
\value{
A list with the following syntax:\preformatted{list(
  Commands = list(
    list(
      CommandId = "string",
      InstanceId = "string",
      DeploymentId = "string",
      CreatedAt = "string",
      AcknowledgedAt = "string",
      CompletedAt = "string",
      Status = "string",
      ExitCode = 123,
      LogUrl = "string",
      Type = "string"
    )
  )
)
}
}
\description{
Describes the results of specified commands.

This call accepts only one resource-identifying parameter.

\strong{Required Permissions}: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about
user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$describe_commands(
  DeploymentId = "string",
  InstanceId = "string",
  CommandIds = list(
    "string"
  )
)
}
}

\keyword{internal}
