% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_update_stack_instances}
\alias{cloudformation_update_stack_instances}
\title{Updates the parameter values for stack instances for the specified
accounts, within the specified regions}
\usage{
cloudformation_update_stack_instances(StackSetName, Accounts, Regions,
  ParameterOverrides, OperationPreferences, OperationId)
}
\arguments{
\item{StackSetName}{[required] The name or unique ID of the stack set associated with the stack
instances.}

\item{Accounts}{[required] The names of one or more AWS accounts for which you want to update
parameter values for stack instances. The overridden parameter values
will be applied to all stack instances in the specified accounts and
regions.}

\item{Regions}{[required] The names of one or more regions in which you want to update parameter
values for stack instances. The overridden parameter values will be
applied to all stack instances in the specified accounts and regions.}

\item{ParameterOverrides}{A list of input parameters whose values you want to update for the
specified stack instances.

Any overridden parameter values will be applied to all stack instances
in the specified accounts and regions. When specifying parameters and
their values, be aware of how AWS CloudFormation sets parameter values
during stack instance update operations:
\itemize{
\item To override the current value for a parameter, include the parameter
and specify its value.
\item To leave a parameter set to its present value, you can do one of the
following:
\itemize{
\item Do not include the parameter in the list.
\item Include the parameter and specify \code{UsePreviousValue} as \code{true}.
(You cannot specify both a value and set \code{UsePreviousValue} to
\code{true}.)
}
\item To set all overridden parameter back to the values specified in the
stack set, specify a parameter list but do not include any
parameters.
\item To leave all parameters set to their present values, do not specify
this property at all.
}

During stack set updates, any parameter values overridden for a stack
instance are not updated, but retain their overridden value.

You can only override the parameter \emph{values} that are specified in the
stack set; to add or delete a parameter itself, use \code{UpdateStackSet} to
update the stack set template. If you add a parameter to a template,
before you can override the parameter value specified in the stack set
you must first use
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html}{UpdateStackSet}
to update all stack instances with the updated template and parameter
value specified in the stack set. Once a stack instance has been updated
with the new parameter, you can then override the parameter value using
\code{UpdateStackInstances}.}

\item{OperationPreferences}{Preferences for how AWS CloudFormation performs this stack set
operation.}

\item{OperationId}{The unique identifier for this stack set operation.

The operation ID also functions as an idempotency token, to ensure that
AWS CloudFormation performs the stack set operation only once, even if
you retry the request multiple times. You might retry stack set
operation requests to ensure that AWS CloudFormation successfully
received them.

If you don't specify an operation ID, the SDK generates one
automatically.}
}
\description{
Updates the parameter values for stack instances for the specified
accounts, within the specified regions. A stack instance refers to a
stack in a specific account and region.
}
\details{
You can only update stack instances in regions and accounts where they
already exist; to create additional stack instances, use
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html}{CreateStackInstances}.

During stack set updates, any parameters overridden for a stack instance
are not updated, but retain their overridden value.

You can only update the parameter \emph{values} that are specified in the
stack set; to add or delete a parameter itself, use
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html}{UpdateStackSet}
to update the stack set template. If you add a parameter to a template,
before you can override the parameter value specified in the stack set
you must first use
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html}{UpdateStackSet}
to update all stack instances with the updated template and parameter
value specified in the stack set. Once a stack instance has been updated
with the new parameter, you can then override the parameter value using
\code{UpdateStackInstances}.
}
\section{Request syntax}{
\preformatted{svc$update_stack_instances(
  StackSetName = "string",
  Accounts = list(
    "string"
  ),
  Regions = list(
    "string"
  ),
  ParameterOverrides = list(
    list(
      ParameterKey = "string",
      ParameterValue = "string",
      UsePreviousValue = TRUE|FALSE,
      ResolvedValue = "string"
    )
  ),
  OperationPreferences = list(
    RegionOrder = list(
      "string"
    ),
    FailureToleranceCount = 123,
    FailureTolerancePercentage = 123,
    MaxConcurrentCount = 123,
    MaxConcurrentPercentage = 123
  ),
  OperationId = "string"
)
}
}

\keyword{internal}
