# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include configservice_service.R
NULL

#' Returns the current configuration items for resources that are present
#' in your AWS Config aggregator
#'
#' Returns the current configuration items for resources that are present
#' in your AWS Config aggregator. The operation also returns a list of
#' resources that are not processed in the current request. If there are no
#' unprocessed resources, the operation returns an empty
#' `unprocessedResourceIdentifiers` list.
#' 
#' -   The API does not return results for deleted resources.
#' 
#' -   The API does not return tags and relationships.
#'
#' @usage
#' configservice_batch_get_aggregate_resource_config(
#'   ConfigurationAggregatorName, ResourceIdentifiers)
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param ResourceIdentifiers &#91;required&#93; A list of aggregate ResourceIdentifiers objects.
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_aggregate_resource_config(
#'   ConfigurationAggregatorName = "string",
#'   ResourceIdentifiers = list(
#'     list(
#'       SourceAccountId = "string",
#'       SourceRegion = "string",
#'       ResourceId = "string",
#'       ResourceType = "AWS::EC2::CustomerGateway"|"AWS::EC2::EIP"|"AWS::EC2::Host"|"AWS::EC2::Instance"|"AWS::EC2::InternetGateway"|"AWS::EC2::NetworkAcl"|"AWS::EC2::NetworkInterface"|"AWS::EC2::RouteTable"|"AWS::EC2::SecurityGroup"|"AWS::EC2::Subnet"|"AWS::CloudTrail::Trail"|"AWS::EC2::Volume"|"AWS::EC2::VPC"|"AWS::EC2::VPNConnection"|"AWS::EC2::VPNGateway"|"AWS::EC2::RegisteredHAInstance"|"AWS::EC2::NatGateway"|"AWS::EC2::EgressOnlyInternetGateway"|"AWS::EC2::VPCEndpoint"|"AWS::EC2::VPCEndpointService"|"AWS::EC2::FlowLog"|"AWS::EC2::VPCPeeringConnection"|"AWS::IAM::Group"|"AWS::IAM::Policy"|"AWS::IAM::Role"|"AWS::IAM::User"|"AWS::ElasticLoadBalancingV2::LoadBalancer"|"AWS::ACM::Certificate"|"AWS::RDS::DBInstance"|"AWS::RDS::DBParameterGroup"|"AWS::RDS::DBOptionGroup"|"AWS::RDS::DBSubnetGroup"|"AWS::RDS::DBSecurityGroup"|"AWS::RDS::DBSnapshot"|"AWS::RDS::DBCluster"|"AWS::RDS::DBClusterParameterGroup"|"AWS::RDS::DBClusterSnapshot"|"AWS::RDS::EventSubscription"|"AWS::S3::Bucket"|"AWS::S3::AccountPublicAccessBlock"|"AWS::Redshift::Cluster"|"AWS::Redshift::ClusterSnapshot"|"AWS::Redshift::ClusterParameterGroup"|"AWS::Redshift::ClusterSecurityGroup"|"AWS::Redshift::ClusterSubnetGroup"|"AWS::Redshift::EventSubscription"|"AWS::SSM::ManagedInstanceInventory"|"AWS::CloudWatch::Alarm"|"AWS::CloudFormation::Stack"|"AWS::ElasticLoadBalancing::LoadBalancer"|"AWS::AutoScaling::AutoScalingGroup"|"AWS::AutoScaling::LaunchConfiguration"|"AWS::AutoScaling::ScalingPolicy"|"AWS::AutoScaling::ScheduledAction"|"AWS::DynamoDB::Table"|"AWS::CodeBuild::Project"|"AWS::WAF::RateBasedRule"|"AWS::WAF::Rule"|"AWS::WAF::RuleGroup"|"AWS::WAF::WebACL"|"AWS::WAFRegional::RateBasedRule"|"AWS::WAFRegional::Rule"|"AWS::WAFRegional::RuleGroup"|"AWS::WAFRegional::WebACL"|"AWS::CloudFront::Distribution"|"AWS::CloudFront::StreamingDistribution"|"AWS::Lambda::Alias"|"AWS::Lambda::Function"|"AWS::ElasticBeanstalk::Application"|"AWS::ElasticBeanstalk::ApplicationVersion"|"AWS::ElasticBeanstalk::Environment"|"AWS::MobileHub::Project"|"AWS::XRay::EncryptionConfig"|"AWS::SSM::AssociationCompliance"|"AWS::SSM::PatchCompliance"|"AWS::Shield::Protection"|"AWS::ShieldRegional::Protection"|"AWS::Config::ResourceCompliance"|"AWS::LicenseManager::LicenseConfiguration"|"AWS::ApiGateway::DomainName"|"AWS::ApiGateway::Method"|"AWS::ApiGateway::Stage"|"AWS::ApiGateway::RestApi"|"AWS::ApiGatewayV2::DomainName"|"AWS::ApiGatewayV2::Stage"|"AWS::ApiGatewayV2::Api"|"AWS::CodePipeline::Pipeline"|"AWS::ServiceCatalog::CloudFormationProvisionedProduct"|"AWS::ServiceCatalog::CloudFormationProduct"|"AWS::ServiceCatalog::Portfolio",
#'       ResourceName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_batch_get_aggregate_resource_config
configservice_batch_get_aggregate_resource_config <- function(ConfigurationAggregatorName, ResourceIdentifiers) {
  op <- new_operation(
    name = "BatchGetAggregateResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$batch_get_aggregate_resource_config_input(ConfigurationAggregatorName = ConfigurationAggregatorName, ResourceIdentifiers = ResourceIdentifiers)
  output <- .configservice$batch_get_aggregate_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$batch_get_aggregate_resource_config <- configservice_batch_get_aggregate_resource_config

#' Returns the current configuration for one or more requested resources
#'
#' Returns the current configuration for one or more requested resources.
#' The operation also returns a list of resources that are not processed in
#' the current request. If there are no unprocessed resources, the
#' operation returns an empty unprocessedResourceKeys list.
#' 
#' -   The API does not return results for deleted resources.
#' 
#' -   The API does not return any tags for the requested resources. This
#'     information is filtered out of the supplementaryConfiguration
#'     section of the API response.
#'
#' @usage
#' configservice_batch_get_resource_config(resourceKeys)
#'
#' @param resourceKeys &#91;required&#93; A list of resource keys to be processed with the current request. Each
#' element in the list consists of the resource type and resource ID.
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_resource_config(
#'   resourceKeys = list(
#'     list(
#'       resourceType = "AWS::EC2::CustomerGateway"|"AWS::EC2::EIP"|"AWS::EC2::Host"|"AWS::EC2::Instance"|"AWS::EC2::InternetGateway"|"AWS::EC2::NetworkAcl"|"AWS::EC2::NetworkInterface"|"AWS::EC2::RouteTable"|"AWS::EC2::SecurityGroup"|"AWS::EC2::Subnet"|"AWS::CloudTrail::Trail"|"AWS::EC2::Volume"|"AWS::EC2::VPC"|"AWS::EC2::VPNConnection"|"AWS::EC2::VPNGateway"|"AWS::EC2::RegisteredHAInstance"|"AWS::EC2::NatGateway"|"AWS::EC2::EgressOnlyInternetGateway"|"AWS::EC2::VPCEndpoint"|"AWS::EC2::VPCEndpointService"|"AWS::EC2::FlowLog"|"AWS::EC2::VPCPeeringConnection"|"AWS::IAM::Group"|"AWS::IAM::Policy"|"AWS::IAM::Role"|"AWS::IAM::User"|"AWS::ElasticLoadBalancingV2::LoadBalancer"|"AWS::ACM::Certificate"|"AWS::RDS::DBInstance"|"AWS::RDS::DBParameterGroup"|"AWS::RDS::DBOptionGroup"|"AWS::RDS::DBSubnetGroup"|"AWS::RDS::DBSecurityGroup"|"AWS::RDS::DBSnapshot"|"AWS::RDS::DBCluster"|"AWS::RDS::DBClusterParameterGroup"|"AWS::RDS::DBClusterSnapshot"|"AWS::RDS::EventSubscription"|"AWS::S3::Bucket"|"AWS::S3::AccountPublicAccessBlock"|"AWS::Redshift::Cluster"|"AWS::Redshift::ClusterSnapshot"|"AWS::Redshift::ClusterParameterGroup"|"AWS::Redshift::ClusterSecurityGroup"|"AWS::Redshift::ClusterSubnetGroup"|"AWS::Redshift::EventSubscription"|"AWS::SSM::ManagedInstanceInventory"|"AWS::CloudWatch::Alarm"|"AWS::CloudFormation::Stack"|"AWS::ElasticLoadBalancing::LoadBalancer"|"AWS::AutoScaling::AutoScalingGroup"|"AWS::AutoScaling::LaunchConfiguration"|"AWS::AutoScaling::ScalingPolicy"|"AWS::AutoScaling::ScheduledAction"|"AWS::DynamoDB::Table"|"AWS::CodeBuild::Project"|"AWS::WAF::RateBasedRule"|"AWS::WAF::Rule"|"AWS::WAF::RuleGroup"|"AWS::WAF::WebACL"|"AWS::WAFRegional::RateBasedRule"|"AWS::WAFRegional::Rule"|"AWS::WAFRegional::RuleGroup"|"AWS::WAFRegional::WebACL"|"AWS::CloudFront::Distribution"|"AWS::CloudFront::StreamingDistribution"|"AWS::Lambda::Alias"|"AWS::Lambda::Function"|"AWS::ElasticBeanstalk::Application"|"AWS::ElasticBeanstalk::ApplicationVersion"|"AWS::ElasticBeanstalk::Environment"|"AWS::MobileHub::Project"|"AWS::XRay::EncryptionConfig"|"AWS::SSM::AssociationCompliance"|"AWS::SSM::PatchCompliance"|"AWS::Shield::Protection"|"AWS::ShieldRegional::Protection"|"AWS::Config::ResourceCompliance"|"AWS::LicenseManager::LicenseConfiguration"|"AWS::ApiGateway::DomainName"|"AWS::ApiGateway::Method"|"AWS::ApiGateway::Stage"|"AWS::ApiGateway::RestApi"|"AWS::ApiGatewayV2::DomainName"|"AWS::ApiGatewayV2::Stage"|"AWS::ApiGatewayV2::Api"|"AWS::CodePipeline::Pipeline"|"AWS::ServiceCatalog::CloudFormationProvisionedProduct"|"AWS::ServiceCatalog::CloudFormationProduct"|"AWS::ServiceCatalog::Portfolio",
#'       resourceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_batch_get_resource_config
configservice_batch_get_resource_config <- function(resourceKeys) {
  op <- new_operation(
    name = "BatchGetResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$batch_get_resource_config_input(resourceKeys = resourceKeys)
  output <- .configservice$batch_get_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$batch_get_resource_config <- configservice_batch_get_resource_config

#' Deletes the authorization granted to the specified configuration
#' aggregator account in a specified region
#'
#' Deletes the authorization granted to the specified configuration
#' aggregator account in a specified region.
#'
#' @usage
#' configservice_delete_aggregation_authorization(AuthorizedAccountId,
#'   AuthorizedAwsRegion)
#'
#' @param AuthorizedAccountId &#91;required&#93; The 12-digit account ID of the account authorized to aggregate data.
#' @param AuthorizedAwsRegion &#91;required&#93; The region authorized to collect aggregated data.
#'
#' @section Request syntax:
#' ```
#' svc$delete_aggregation_authorization(
#'   AuthorizedAccountId = "string",
#'   AuthorizedAwsRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_aggregation_authorization
configservice_delete_aggregation_authorization <- function(AuthorizedAccountId, AuthorizedAwsRegion) {
  op <- new_operation(
    name = "DeleteAggregationAuthorization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_aggregation_authorization_input(AuthorizedAccountId = AuthorizedAccountId, AuthorizedAwsRegion = AuthorizedAwsRegion)
  output <- .configservice$delete_aggregation_authorization_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_aggregation_authorization <- configservice_delete_aggregation_authorization

#' Deletes the specified AWS Config rule and all of its evaluation results
#'
#' Deletes the specified AWS Config rule and all of its evaluation results.
#' 
#' AWS Config sets the state of a rule to `DELETING` until the deletion is
#' complete. You cannot update a rule while it is in this state. If you
#' make a `PutConfigRule` or `DeleteConfigRule` request for the rule, you
#' will receive a `ResourceInUseException`.
#' 
#' You can check the state of a rule by using the `DescribeConfigRules`
#' request.
#'
#' @usage
#' configservice_delete_config_rule(ConfigRuleName)
#'
#' @param ConfigRuleName &#91;required&#93; The name of the AWS Config rule that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_config_rule(
#'   ConfigRuleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_config_rule
configservice_delete_config_rule <- function(ConfigRuleName) {
  op <- new_operation(
    name = "DeleteConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_config_rule_input(ConfigRuleName = ConfigRuleName)
  output <- .configservice$delete_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_config_rule <- configservice_delete_config_rule

#' Deletes the specified configuration aggregator and the aggregated data
#' associated with the aggregator
#'
#' Deletes the specified configuration aggregator and the aggregated data
#' associated with the aggregator.
#'
#' @usage
#' configservice_delete_configuration_aggregator(
#'   ConfigurationAggregatorName)
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration_aggregator(
#'   ConfigurationAggregatorName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_configuration_aggregator
configservice_delete_configuration_aggregator <- function(ConfigurationAggregatorName) {
  op <- new_operation(
    name = "DeleteConfigurationAggregator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_configuration_aggregator_input(ConfigurationAggregatorName = ConfigurationAggregatorName)
  output <- .configservice$delete_configuration_aggregator_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_configuration_aggregator <- configservice_delete_configuration_aggregator

#' Deletes the configuration recorder
#'
#' Deletes the configuration recorder.
#' 
#' After the configuration recorder is deleted, AWS Config will not record
#' resource configuration changes until you create a new configuration
#' recorder.
#' 
#' This action does not delete the configuration information that was
#' previously recorded. You will be able to access the previously recorded
#' information by using the `GetResourceConfigHistory` action, but you will
#' not be able to access this information in the AWS Config console until
#' you create a new configuration recorder.
#'
#' @usage
#' configservice_delete_configuration_recorder(ConfigurationRecorderName)
#'
#' @param ConfigurationRecorderName &#91;required&#93; The name of the configuration recorder to be deleted. You can retrieve
#' the name of your configuration recorder by using the
#' `DescribeConfigurationRecorders` action.
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration_recorder(
#'   ConfigurationRecorderName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_configuration_recorder
configservice_delete_configuration_recorder <- function(ConfigurationRecorderName) {
  op <- new_operation(
    name = "DeleteConfigurationRecorder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_configuration_recorder_input(ConfigurationRecorderName = ConfigurationRecorderName)
  output <- .configservice$delete_configuration_recorder_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_configuration_recorder <- configservice_delete_configuration_recorder

#' Deletes the specified conformance pack and all the AWS Config rules,
#' remediation actions, and all evaluation results within that conformance
#' pack
#'
#' Deletes the specified conformance pack and all the AWS Config rules,
#' remediation actions, and all evaluation results within that conformance
#' pack.
#' 
#' AWS Config sets the conformance pack to `DELETE_IN_PROGRESS` until the
#' deletion is complete. You cannot update a conformance pack while it is
#' in this state.
#'
#' @usage
#' configservice_delete_conformance_pack(ConformancePackName)
#'
#' @param ConformancePackName &#91;required&#93; Name of the conformance pack you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_conformance_pack(
#'   ConformancePackName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_conformance_pack
configservice_delete_conformance_pack <- function(ConformancePackName) {
  op <- new_operation(
    name = "DeleteConformancePack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_conformance_pack_input(ConformancePackName = ConformancePackName)
  output <- .configservice$delete_conformance_pack_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_conformance_pack <- configservice_delete_conformance_pack

#' Deletes the delivery channel
#'
#' Deletes the delivery channel.
#' 
#' Before you can delete the delivery channel, you must stop the
#' configuration recorder by using the StopConfigurationRecorder action.
#'
#' @usage
#' configservice_delete_delivery_channel(DeliveryChannelName)
#'
#' @param DeliveryChannelName &#91;required&#93; The name of the delivery channel to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_delivery_channel(
#'   DeliveryChannelName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_delivery_channel
configservice_delete_delivery_channel <- function(DeliveryChannelName) {
  op <- new_operation(
    name = "DeleteDeliveryChannel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_delivery_channel_input(DeliveryChannelName = DeliveryChannelName)
  output <- .configservice$delete_delivery_channel_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_delivery_channel <- configservice_delete_delivery_channel

#' Deletes the evaluation results for the specified AWS Config rule
#'
#' Deletes the evaluation results for the specified AWS Config rule. You
#' can specify one AWS Config rule per request. After you delete the
#' evaluation results, you can call the StartConfigRulesEvaluation API to
#' start evaluating your AWS resources against the rule.
#'
#' @usage
#' configservice_delete_evaluation_results(ConfigRuleName)
#'
#' @param ConfigRuleName &#91;required&#93; The name of the AWS Config rule for which you want to delete the
#' evaluation results.
#'
#' @section Request syntax:
#' ```
#' svc$delete_evaluation_results(
#'   ConfigRuleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_evaluation_results
configservice_delete_evaluation_results <- function(ConfigRuleName) {
  op <- new_operation(
    name = "DeleteEvaluationResults",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_evaluation_results_input(ConfigRuleName = ConfigRuleName)
  output <- .configservice$delete_evaluation_results_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_evaluation_results <- configservice_delete_evaluation_results

#' Deletes the specified organization config rule and all of its evaluation
#' results from all member accounts in that organization
#'
#' Deletes the specified organization config rule and all of its evaluation
#' results from all member accounts in that organization. Only a master
#' account can delete an organization config rule.
#' 
#' AWS Config sets the state of a rule to DELETE\\_IN\\_PROGRESS until the
#' deletion is complete. You cannot update a rule while it is in this
#' state.
#'
#' @usage
#' configservice_delete_organization_config_rule(
#'   OrganizationConfigRuleName)
#'
#' @param OrganizationConfigRuleName &#91;required&#93; The name of organization config rule that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_organization_config_rule(
#'   OrganizationConfigRuleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_organization_config_rule
configservice_delete_organization_config_rule <- function(OrganizationConfigRuleName) {
  op <- new_operation(
    name = "DeleteOrganizationConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_organization_config_rule_input(OrganizationConfigRuleName = OrganizationConfigRuleName)
  output <- .configservice$delete_organization_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_organization_config_rule <- configservice_delete_organization_config_rule

#' Deletes the specified organization conformance pack and all of the
#' config rules and remediation actions from all member accounts in that
#' organization
#'
#' Deletes the specified organization conformance pack and all of the
#' config rules and remediation actions from all member accounts in that
#' organization. Only a master account can delete an organization
#' conformance pack.
#' 
#' AWS Config sets the state of a conformance pack to DELETE\\_IN\\_PROGRESS
#' until the deletion is complete. You cannot update a conformance pack
#' while it is in this state.
#'
#' @usage
#' configservice_delete_organization_conformance_pack(
#'   OrganizationConformancePackName)
#'
#' @param OrganizationConformancePackName &#91;required&#93; The name of organization conformance pack that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_organization_conformance_pack(
#'   OrganizationConformancePackName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_organization_conformance_pack
configservice_delete_organization_conformance_pack <- function(OrganizationConformancePackName) {
  op <- new_operation(
    name = "DeleteOrganizationConformancePack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_organization_conformance_pack_input(OrganizationConformancePackName = OrganizationConformancePackName)
  output <- .configservice$delete_organization_conformance_pack_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_organization_conformance_pack <- configservice_delete_organization_conformance_pack

#' Deletes pending authorization requests for a specified aggregator
#' account in a specified region
#'
#' Deletes pending authorization requests for a specified aggregator
#' account in a specified region.
#'
#' @usage
#' configservice_delete_pending_aggregation_request(RequesterAccountId,
#'   RequesterAwsRegion)
#'
#' @param RequesterAccountId &#91;required&#93; The 12-digit account ID of the account requesting to aggregate data.
#' @param RequesterAwsRegion &#91;required&#93; The region requesting to aggregate data.
#'
#' @section Request syntax:
#' ```
#' svc$delete_pending_aggregation_request(
#'   RequesterAccountId = "string",
#'   RequesterAwsRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_pending_aggregation_request
configservice_delete_pending_aggregation_request <- function(RequesterAccountId, RequesterAwsRegion) {
  op <- new_operation(
    name = "DeletePendingAggregationRequest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_pending_aggregation_request_input(RequesterAccountId = RequesterAccountId, RequesterAwsRegion = RequesterAwsRegion)
  output <- .configservice$delete_pending_aggregation_request_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_pending_aggregation_request <- configservice_delete_pending_aggregation_request

#' Deletes the remediation configuration
#'
#' Deletes the remediation configuration.
#'
#' @usage
#' configservice_delete_remediation_configuration(ConfigRuleName,
#'   ResourceType)
#'
#' @param ConfigRuleName &#91;required&#93; The name of the AWS Config rule for which you want to delete remediation
#' configuration.
#' @param ResourceType The type of a resource.
#'
#' @section Request syntax:
#' ```
#' svc$delete_remediation_configuration(
#'   ConfigRuleName = "string",
#'   ResourceType = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_remediation_configuration
configservice_delete_remediation_configuration <- function(ConfigRuleName, ResourceType = NULL) {
  op <- new_operation(
    name = "DeleteRemediationConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_remediation_configuration_input(ConfigRuleName = ConfigRuleName, ResourceType = ResourceType)
  output <- .configservice$delete_remediation_configuration_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_remediation_configuration <- configservice_delete_remediation_configuration

#' Deletes one or more remediation exceptions mentioned in the resource
#' keys
#'
#' Deletes one or more remediation exceptions mentioned in the resource
#' keys.
#'
#' @usage
#' configservice_delete_remediation_exceptions(ConfigRuleName,
#'   ResourceKeys)
#'
#' @param ConfigRuleName &#91;required&#93; The name of the AWS Config rule for which you want to delete remediation
#' exception configuration.
#' @param ResourceKeys &#91;required&#93; An exception list of resource exception keys to be processed with the
#' current request. AWS Config adds exception for each resource key. For
#' example, AWS Config adds 3 exceptions for 3 resource keys.
#'
#' @section Request syntax:
#' ```
#' svc$delete_remediation_exceptions(
#'   ConfigRuleName = "string",
#'   ResourceKeys = list(
#'     list(
#'       ResourceType = "string",
#'       ResourceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_remediation_exceptions
configservice_delete_remediation_exceptions <- function(ConfigRuleName, ResourceKeys) {
  op <- new_operation(
    name = "DeleteRemediationExceptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_remediation_exceptions_input(ConfigRuleName = ConfigRuleName, ResourceKeys = ResourceKeys)
  output <- .configservice$delete_remediation_exceptions_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_remediation_exceptions <- configservice_delete_remediation_exceptions

#' Records the configuration state for a custom resource that has been
#' deleted
#'
#' Records the configuration state for a custom resource that has been
#' deleted. This API records a new ConfigurationItem with a ResourceDeleted
#' status. You can retrieve the ConfigurationItems recorded for this
#' resource in your AWS Config History.
#'
#' @usage
#' configservice_delete_resource_config(ResourceType, ResourceId)
#'
#' @param ResourceType &#91;required&#93; The type of the resource.
#' @param ResourceId &#91;required&#93; Unique identifier of the resource.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resource_config(
#'   ResourceType = "string",
#'   ResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_resource_config
configservice_delete_resource_config <- function(ResourceType, ResourceId) {
  op <- new_operation(
    name = "DeleteResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_resource_config_input(ResourceType = ResourceType, ResourceId = ResourceId)
  output <- .configservice$delete_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_resource_config <- configservice_delete_resource_config

#' Deletes the retention configuration
#'
#' Deletes the retention configuration.
#'
#' @usage
#' configservice_delete_retention_configuration(RetentionConfigurationName)
#'
#' @param RetentionConfigurationName &#91;required&#93; The name of the retention configuration to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_retention_configuration(
#'   RetentionConfigurationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_delete_retention_configuration
configservice_delete_retention_configuration <- function(RetentionConfigurationName) {
  op <- new_operation(
    name = "DeleteRetentionConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_retention_configuration_input(RetentionConfigurationName = RetentionConfigurationName)
  output <- .configservice$delete_retention_configuration_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_retention_configuration <- configservice_delete_retention_configuration

#' Schedules delivery of a configuration snapshot to the Amazon S3 bucket
#' in the specified delivery channel
#'
#' Schedules delivery of a configuration snapshot to the Amazon S3 bucket
#' in the specified delivery channel. After the delivery has started, AWS
#' Config sends the following notifications using an Amazon SNS topic that
#' you have specified.
#' 
#' -   Notification of the start of the delivery.
#' 
#' -   Notification of the completion of the delivery, if the delivery was
#'     successfully completed.
#' 
#' -   Notification of delivery failure, if the delivery failed.
#'
#' @usage
#' configservice_deliver_config_snapshot(deliveryChannelName)
#'
#' @param deliveryChannelName &#91;required&#93; The name of the delivery channel through which the snapshot is
#' delivered.
#'
#' @section Request syntax:
#' ```
#' svc$deliver_config_snapshot(
#'   deliveryChannelName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_deliver_config_snapshot
configservice_deliver_config_snapshot <- function(deliveryChannelName) {
  op <- new_operation(
    name = "DeliverConfigSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$deliver_config_snapshot_input(deliveryChannelName = deliveryChannelName)
  output <- .configservice$deliver_config_snapshot_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$deliver_config_snapshot <- configservice_deliver_config_snapshot

#' Returns a list of compliant and noncompliant rules with the number of
#' resources for compliant and noncompliant rules
#'
#' Returns a list of compliant and noncompliant rules with the number of
#' resources for compliant and noncompliant rules.
#' 
#' The results can return an empty result page, but if you have a
#' `nextToken`, the results are displayed on the next page.
#'
#' @usage
#' configservice_describe_aggregate_compliance_by_config_rules(
#'   ConfigurationAggregatorName, Filters, Limit, NextToken)
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param Filters Filters the results by ConfigRuleComplianceFilters object.
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is maximum. If you specify 0, AWS Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_aggregate_compliance_by_config_rules(
#'   ConfigurationAggregatorName = "string",
#'   Filters = list(
#'     ConfigRuleName = "string",
#'     ComplianceType = "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA",
#'     AccountId = "string",
#'     AwsRegion = "string"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_aggregate_compliance_by_config_rules
configservice_describe_aggregate_compliance_by_config_rules <- function(ConfigurationAggregatorName, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAggregateComplianceByConfigRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_aggregate_compliance_by_config_rules_input(ConfigurationAggregatorName = ConfigurationAggregatorName, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_aggregate_compliance_by_config_rules_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_aggregate_compliance_by_config_rules <- configservice_describe_aggregate_compliance_by_config_rules

#' Returns a list of authorizations granted to various aggregator accounts
#' and regions
#'
#' Returns a list of authorizations granted to various aggregator accounts
#' and regions.
#'
#' @usage
#' configservice_describe_aggregation_authorizations(Limit, NextToken)
#'
#' @param Limit The maximum number of AggregationAuthorizations returned on each page.
#' The default is maximum. If you specify 0, AWS Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_aggregation_authorizations(
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_aggregation_authorizations
configservice_describe_aggregation_authorizations <- function(Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAggregationAuthorizations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_aggregation_authorizations_input(Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_aggregation_authorizations_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_aggregation_authorizations <- configservice_describe_aggregation_authorizations

#' Indicates whether the specified AWS Config rules are compliant
#'
#' Indicates whether the specified AWS Config rules are compliant. If a
#' rule is noncompliant, this action returns the number of AWS resources
#' that do not comply with the rule.
#' 
#' A rule is compliant if all of the evaluated resources comply with it. It
#' is noncompliant if any of these resources do not comply.
#' 
#' If AWS Config has no current evaluation results for the rule, it returns
#' `INSUFFICIENT_DATA`. This result might indicate one of the following
#' conditions:
#' 
#' -   AWS Config has never invoked an evaluation for the rule. To check
#'     whether it has, use the `DescribeConfigRuleEvaluationStatus` action
#'     to get the `LastSuccessfulInvocationTime` and
#'     `LastFailedInvocationTime`.
#' 
#' -   The rule\'s AWS Lambda function is failing to send evaluation
#'     results to AWS Config. Verify that the role you assigned to your
#'     configuration recorder includes the `config:PutEvaluations`
#'     permission. If the rule is a custom rule, verify that the AWS Lambda
#'     execution role includes the `config:PutEvaluations` permission.
#' 
#' -   The rule\'s AWS Lambda function has returned `NOT_APPLICABLE` for
#'     all evaluation results. This can occur if the resources were deleted
#'     or removed from the rule\'s scope.
#'
#' @usage
#' configservice_describe_compliance_by_config_rule(ConfigRuleNames,
#'   ComplianceTypes, NextToken)
#'
#' @param ConfigRuleNames Specify one or more AWS Config rule names to filter the results by rule.
#' @param ComplianceTypes Filters the results by compliance.
#' 
#' The allowed values are `COMPLIANT` and `NON_COMPLIANT`.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_compliance_by_config_rule(
#'   ConfigRuleNames = list(
#'     "string"
#'   ),
#'   ComplianceTypes = list(
#'     "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_compliance_by_config_rule
configservice_describe_compliance_by_config_rule <- function(ConfigRuleNames = NULL, ComplianceTypes = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeComplianceByConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_compliance_by_config_rule_input(ConfigRuleNames = ConfigRuleNames, ComplianceTypes = ComplianceTypes, NextToken = NextToken)
  output <- .configservice$describe_compliance_by_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_compliance_by_config_rule <- configservice_describe_compliance_by_config_rule

#' Indicates whether the specified AWS resources are compliant
#'
#' Indicates whether the specified AWS resources are compliant. If a
#' resource is noncompliant, this action returns the number of AWS Config
#' rules that the resource does not comply with.
#' 
#' A resource is compliant if it complies with all the AWS Config rules
#' that evaluate it. It is noncompliant if it does not comply with one or
#' more of these rules.
#' 
#' If AWS Config has no current evaluation results for the resource, it
#' returns `INSUFFICIENT_DATA`. This result might indicate one of the
#' following conditions about the rules that evaluate the resource:
#' 
#' -   AWS Config has never invoked an evaluation for the rule. To check
#'     whether it has, use the `DescribeConfigRuleEvaluationStatus` action
#'     to get the `LastSuccessfulInvocationTime` and
#'     `LastFailedInvocationTime`.
#' 
#' -   The rule\'s AWS Lambda function is failing to send evaluation
#'     results to AWS Config. Verify that the role that you assigned to
#'     your configuration recorder includes the `config:PutEvaluations`
#'     permission. If the rule is a custom rule, verify that the AWS Lambda
#'     execution role includes the `config:PutEvaluations` permission.
#' 
#' -   The rule\'s AWS Lambda function has returned `NOT_APPLICABLE` for
#'     all evaluation results. This can occur if the resources were deleted
#'     or removed from the rule\'s scope.
#'
#' @usage
#' configservice_describe_compliance_by_resource(ResourceType, ResourceId,
#'   ComplianceTypes, Limit, NextToken)
#'
#' @param ResourceType The types of AWS resources for which you want compliance information
#' (for example, `AWS::EC2::Instance`). For this action, you can specify
#' that the resource type is an AWS account by specifying `AWS::::Account`.
#' @param ResourceId The ID of the AWS resource for which you want compliance information.
#' You can specify only one resource ID. If you specify a resource ID, you
#' must also specify a type for `ResourceType`.
#' @param ComplianceTypes Filters the results by compliance.
#' 
#' The allowed values are `COMPLIANT`, `NON_COMPLIANT`, and
#' `INSUFFICIENT_DATA`.
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is 10. You cannot specify a number greater than 100. If you
#' specify 0, AWS Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_compliance_by_resource(
#'   ResourceType = "string",
#'   ResourceId = "string",
#'   ComplianceTypes = list(
#'     "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_compliance_by_resource
configservice_describe_compliance_by_resource <- function(ResourceType = NULL, ResourceId = NULL, ComplianceTypes = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeComplianceByResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_compliance_by_resource_input(ResourceType = ResourceType, ResourceId = ResourceId, ComplianceTypes = ComplianceTypes, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_compliance_by_resource_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_compliance_by_resource <- configservice_describe_compliance_by_resource

#' Returns status information for each of your AWS managed Config rules
#'
#' Returns status information for each of your AWS managed Config rules.
#' The status includes information such as the last time AWS Config invoked
#' the rule, the last time AWS Config failed to invoke the rule, and the
#' related error for the last failure.
#'
#' @usage
#' configservice_describe_config_rule_evaluation_status(ConfigRuleNames,
#'   NextToken, Limit)
#'
#' @param ConfigRuleNames The name of the AWS managed Config rules for which you want status
#' information. If you do not specify any names, AWS Config returns status
#' information for all AWS managed Config rules that you use.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#' @param Limit The number of rule evaluation results that you want returned.
#' 
#' This parameter is required if the rule limit for your account is more
#' than the default of 150 rules.
#' 
#' For information about requesting a rule limit increase, see [AWS Config
#' Limits](http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config)
#' in the *AWS General Reference Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$describe_config_rule_evaluation_status(
#'   ConfigRuleNames = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_config_rule_evaluation_status
configservice_describe_config_rule_evaluation_status <- function(ConfigRuleNames = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeConfigRuleEvaluationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_config_rule_evaluation_status_input(ConfigRuleNames = ConfigRuleNames, NextToken = NextToken, Limit = Limit)
  output <- .configservice$describe_config_rule_evaluation_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_config_rule_evaluation_status <- configservice_describe_config_rule_evaluation_status

#' Returns details about your AWS Config rules
#'
#' Returns details about your AWS Config rules.
#'
#' @usage
#' configservice_describe_config_rules(ConfigRuleNames, NextToken)
#'
#' @param ConfigRuleNames The names of the AWS Config rules for which you want details. If you do
#' not specify any names, AWS Config returns details for all your rules.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_config_rules(
#'   ConfigRuleNames = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_config_rules
configservice_describe_config_rules <- function(ConfigRuleNames = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeConfigRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_config_rules_input(ConfigRuleNames = ConfigRuleNames, NextToken = NextToken)
  output <- .configservice$describe_config_rules_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_config_rules <- configservice_describe_config_rules

#' Returns status information for sources within an aggregator
#'
#' Returns status information for sources within an aggregator. The status
#' includes information about the last time AWS Config verified
#' authorization between the source account and an aggregator account. In
#' case of a failure, the status contains the related error code or
#' message.
#'
#' @usage
#' configservice_describe_configuration_aggregator_sources_status(
#'   ConfigurationAggregatorName, UpdateStatus, NextToken, Limit)
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param UpdateStatus Filters the status type.
#' 
#' -   Valid value FAILED indicates errors while moving data.
#' 
#' -   Valid value SUCCEEDED indicates the data was successfully moved.
#' 
#' -   Valid value OUTDATED indicates the data is not the most recent.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#' @param Limit The maximum number of AggregatorSourceStatus returned on each page. The
#' default is maximum. If you specify 0, AWS Config uses the default.
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration_aggregator_sources_status(
#'   ConfigurationAggregatorName = "string",
#'   UpdateStatus = list(
#'     "FAILED"|"SUCCEEDED"|"OUTDATED"
#'   ),
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_configuration_aggregator_sources_status
configservice_describe_configuration_aggregator_sources_status <- function(ConfigurationAggregatorName, UpdateStatus = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationAggregatorSourcesStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_configuration_aggregator_sources_status_input(ConfigurationAggregatorName = ConfigurationAggregatorName, UpdateStatus = UpdateStatus, NextToken = NextToken, Limit = Limit)
  output <- .configservice$describe_configuration_aggregator_sources_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_configuration_aggregator_sources_status <- configservice_describe_configuration_aggregator_sources_status

#' Returns the details of one or more configuration aggregators
#'
#' Returns the details of one or more configuration aggregators. If the
#' configuration aggregator is not specified, this action returns the
#' details for all the configuration aggregators associated with the
#' account.
#'
#' @usage
#' configservice_describe_configuration_aggregators(
#'   ConfigurationAggregatorNames, NextToken, Limit)
#'
#' @param ConfigurationAggregatorNames The name of the configuration aggregators.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#' @param Limit The maximum number of configuration aggregators returned on each page.
#' The default is maximum. If you specify 0, AWS Config uses the default.
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration_aggregators(
#'   ConfigurationAggregatorNames = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_configuration_aggregators
configservice_describe_configuration_aggregators <- function(ConfigurationAggregatorNames = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationAggregators",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_configuration_aggregators_input(ConfigurationAggregatorNames = ConfigurationAggregatorNames, NextToken = NextToken, Limit = Limit)
  output <- .configservice$describe_configuration_aggregators_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_configuration_aggregators <- configservice_describe_configuration_aggregators

#' Returns the current status of the specified configuration recorder
#'
#' Returns the current status of the specified configuration recorder. If a
#' configuration recorder is not specified, this action returns the status
#' of all configuration recorders associated with the account.
#' 
#' Currently, you can specify only one configuration recorder per region in
#' your account.
#'
#' @usage
#' configservice_describe_configuration_recorder_status(
#'   ConfigurationRecorderNames)
#'
#' @param ConfigurationRecorderNames The name(s) of the configuration recorder. If the name is not specified,
#' the action returns the current status of all the configuration recorders
#' associated with the account.
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration_recorder_status(
#'   ConfigurationRecorderNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_configuration_recorder_status
configservice_describe_configuration_recorder_status <- function(ConfigurationRecorderNames = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationRecorderStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_configuration_recorder_status_input(ConfigurationRecorderNames = ConfigurationRecorderNames)
  output <- .configservice$describe_configuration_recorder_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_configuration_recorder_status <- configservice_describe_configuration_recorder_status

#' Returns the details for the specified configuration recorders
#'
#' Returns the details for the specified configuration recorders. If the
#' configuration recorder is not specified, this action returns the details
#' for all configuration recorders associated with the account.
#' 
#' Currently, you can specify only one configuration recorder per region in
#' your account.
#'
#' @usage
#' configservice_describe_configuration_recorders(
#'   ConfigurationRecorderNames)
#'
#' @param ConfigurationRecorderNames A list of configuration recorder names.
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration_recorders(
#'   ConfigurationRecorderNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_configuration_recorders
configservice_describe_configuration_recorders <- function(ConfigurationRecorderNames = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationRecorders",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_configuration_recorders_input(ConfigurationRecorderNames = ConfigurationRecorderNames)
  output <- .configservice$describe_configuration_recorders_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_configuration_recorders <- configservice_describe_configuration_recorders

#' Returns compliance details for each rule in that conformance pack
#'
#' Returns compliance details for each rule in that conformance pack.
#' 
#' You must provide exact rule names.
#'
#' @usage
#' configservice_describe_conformance_pack_compliance(ConformancePackName,
#'   Filters, Limit, NextToken)
#'
#' @param ConformancePackName &#91;required&#93; Name of the conformance pack.
#' @param Filters A `ConformancePackComplianceFilters` object.
#' @param Limit The maximum number of AWS Config rules within a conformance pack are
#' returned on each page.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_conformance_pack_compliance(
#'   ConformancePackName = "string",
#'   Filters = list(
#'     ConfigRuleNames = list(
#'       "string"
#'     ),
#'     ComplianceType = "COMPLIANT"|"NON_COMPLIANT"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_conformance_pack_compliance
configservice_describe_conformance_pack_compliance <- function(ConformancePackName, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeConformancePackCompliance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_conformance_pack_compliance_input(ConformancePackName = ConformancePackName, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_conformance_pack_compliance_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_conformance_pack_compliance <- configservice_describe_conformance_pack_compliance

#' Provides one or more conformance packs deployment status
#'
#' Provides one or more conformance packs deployment status.
#' 
#' If there are no conformance packs then you will see an empty result.
#'
#' @usage
#' configservice_describe_conformance_pack_status(ConformancePackNames,
#'   Limit, NextToken)
#'
#' @param ConformancePackNames Comma-separated list of conformance pack names.
#' @param Limit The maximum number of conformance packs status returned on each page.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_conformance_pack_status(
#'   ConformancePackNames = list(
#'     "string"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_conformance_pack_status
configservice_describe_conformance_pack_status <- function(ConformancePackNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeConformancePackStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_conformance_pack_status_input(ConformancePackNames = ConformancePackNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_conformance_pack_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_conformance_pack_status <- configservice_describe_conformance_pack_status

#' Returns a list of one or more conformance packs
#'
#' Returns a list of one or more conformance packs.
#'
#' @usage
#' configservice_describe_conformance_packs(ConformancePackNames, Limit,
#'   NextToken)
#'
#' @param ConformancePackNames Comma-separated list of conformance pack names for which you want
#' details. If you do not specify any names, AWS Config returns details for
#' all your conformance packs.
#' @param Limit The maximum number of conformance packs returned on each page.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_conformance_packs(
#'   ConformancePackNames = list(
#'     "string"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_conformance_packs
configservice_describe_conformance_packs <- function(ConformancePackNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeConformancePacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_conformance_packs_input(ConformancePackNames = ConformancePackNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_conformance_packs_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_conformance_packs <- configservice_describe_conformance_packs

#' Returns the current status of the specified delivery channel
#'
#' Returns the current status of the specified delivery channel. If a
#' delivery channel is not specified, this action returns the current
#' status of all delivery channels associated with the account.
#' 
#' Currently, you can specify only one delivery channel per region in your
#' account.
#'
#' @usage
#' configservice_describe_delivery_channel_status(DeliveryChannelNames)
#'
#' @param DeliveryChannelNames A list of delivery channel names.
#'
#' @section Request syntax:
#' ```
#' svc$describe_delivery_channel_status(
#'   DeliveryChannelNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_delivery_channel_status
configservice_describe_delivery_channel_status <- function(DeliveryChannelNames = NULL) {
  op <- new_operation(
    name = "DescribeDeliveryChannelStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_delivery_channel_status_input(DeliveryChannelNames = DeliveryChannelNames)
  output <- .configservice$describe_delivery_channel_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_delivery_channel_status <- configservice_describe_delivery_channel_status

#' Returns details about the specified delivery channel
#'
#' Returns details about the specified delivery channel. If a delivery
#' channel is not specified, this action returns the details of all
#' delivery channels associated with the account.
#' 
#' Currently, you can specify only one delivery channel per region in your
#' account.
#'
#' @usage
#' configservice_describe_delivery_channels(DeliveryChannelNames)
#'
#' @param DeliveryChannelNames A list of delivery channel names.
#'
#' @section Request syntax:
#' ```
#' svc$describe_delivery_channels(
#'   DeliveryChannelNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_delivery_channels
configservice_describe_delivery_channels <- function(DeliveryChannelNames = NULL) {
  op <- new_operation(
    name = "DescribeDeliveryChannels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_delivery_channels_input(DeliveryChannelNames = DeliveryChannelNames)
  output <- .configservice$describe_delivery_channels_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_delivery_channels <- configservice_describe_delivery_channels

#' Provides organization config rule deployment status for an organization
#'
#' Provides organization config rule deployment status for an organization.
#' 
#' The status is not considered successful until organization config rule
#' is successfully deployed in all the member accounts with an exception of
#' excluded accounts.
#' 
#' When you specify the limit and the next token, you receive a paginated
#' response. Limit and next token are not applicable if you specify
#' organization config rule names. It is only applicable, when you request
#' all the organization config rules.
#' 
#' Only a master account can call this API.
#'
#' @usage
#' configservice_describe_organization_config_rule_statuses(
#'   OrganizationConfigRuleNames, Limit, NextToken)
#'
#' @param OrganizationConfigRuleNames The names of organization config rules for which you want status
#' details. If you do not specify any names, AWS Config returns details for
#' all your organization AWS Confg rules.
#' @param Limit The maximum number of `OrganizationConfigRuleStatuses` returned on each
#' page. If you do no specify a number, AWS Config uses the default. The
#' default is 100.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_organization_config_rule_statuses(
#'   OrganizationConfigRuleNames = list(
#'     "string"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_organization_config_rule_statuses
configservice_describe_organization_config_rule_statuses <- function(OrganizationConfigRuleNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationConfigRuleStatuses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_organization_config_rule_statuses_input(OrganizationConfigRuleNames = OrganizationConfigRuleNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_organization_config_rule_statuses_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_organization_config_rule_statuses <- configservice_describe_organization_config_rule_statuses

#' Returns a list of organization config rules
#'
#' Returns a list of organization config rules.
#' 
#' When you specify the limit and the next token, you receive a paginated
#' response. Limit and next token are not applicable if you specify
#' organization config rule names. It is only applicable, when you request
#' all the organization config rules.
#' 
#' Only a master account can call this API.
#'
#' @usage
#' configservice_describe_organization_config_rules(
#'   OrganizationConfigRuleNames, Limit, NextToken)
#'
#' @param OrganizationConfigRuleNames The names of organization config rules for which you want details. If
#' you do not specify any names, AWS Config returns details for all your
#' organization config rules.
#' @param Limit The maximum number of organization config rules returned on each page.
#' If you do no specify a number, AWS Config uses the default. The default
#' is 100.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_organization_config_rules(
#'   OrganizationConfigRuleNames = list(
#'     "string"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_organization_config_rules
configservice_describe_organization_config_rules <- function(OrganizationConfigRuleNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationConfigRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_organization_config_rules_input(OrganizationConfigRuleNames = OrganizationConfigRuleNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_organization_config_rules_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_organization_config_rules <- configservice_describe_organization_config_rules

#' Provides organization conformance pack deployment status for an
#' organization
#'
#' Provides organization conformance pack deployment status for an
#' organization.
#' 
#' The status is not considered successful until organization conformance
#' pack is successfully deployed in all the member accounts with an
#' exception of excluded accounts.
#' 
#' When you specify the limit and the next token, you receive a paginated
#' response. Limit and next token are not applicable if you specify
#' organization conformance pack names. They are only applicable, when you
#' request all the organization conformance packs.
#' 
#' Only a master account can call this API.
#'
#' @usage
#' configservice_describe_organization_conformance_pack_statuses(
#'   OrganizationConformancePackNames, Limit, NextToken)
#'
#' @param OrganizationConformancePackNames The names of organization conformance packs for which you want status
#' details. If you do not specify any names, AWS Config returns details for
#' all your organization conformance packs.
#' @param Limit The maximum number of OrganizationConformancePackStatuses returned on
#' each page. If you do no specify a number, AWS Config uses the default.
#' The default is 100.
#' @param NextToken The nextToken string returned on a previous page that you use to get the
#' next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_organization_conformance_pack_statuses(
#'   OrganizationConformancePackNames = list(
#'     "string"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_organization_conformance_pack_statuses
configservice_describe_organization_conformance_pack_statuses <- function(OrganizationConformancePackNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationConformancePackStatuses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_organization_conformance_pack_statuses_input(OrganizationConformancePackNames = OrganizationConformancePackNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_organization_conformance_pack_statuses_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_organization_conformance_pack_statuses <- configservice_describe_organization_conformance_pack_statuses

#' Returns a list of organization conformance packs
#'
#' Returns a list of organization conformance packs.
#' 
#' When you specify the limit and the next token, you receive a paginated
#' response.
#' 
#' Limit and next token are not applicable if you specify organization
#' conformance packs names. They are only applicable, when you request all
#' the organization conformance packs.
#' 
#' Only a master account can call this API.
#'
#' @usage
#' configservice_describe_organization_conformance_packs(
#'   OrganizationConformancePackNames, Limit, NextToken)
#'
#' @param OrganizationConformancePackNames The name that you assign to an organization conformance pack.
#' @param Limit The maximum number of organization config packs returned on each page.
#' If you do no specify a number, AWS Config uses the default. The default
#' is 100.
#' @param NextToken The nextToken string returned on a previous page that you use to get the
#' next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_organization_conformance_packs(
#'   OrganizationConformancePackNames = list(
#'     "string"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_organization_conformance_packs
configservice_describe_organization_conformance_packs <- function(OrganizationConformancePackNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationConformancePacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_organization_conformance_packs_input(OrganizationConformancePackNames = OrganizationConformancePackNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_organization_conformance_packs_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_organization_conformance_packs <- configservice_describe_organization_conformance_packs

#' Returns a list of all pending aggregation requests
#'
#' Returns a list of all pending aggregation requests.
#'
#' @usage
#' configservice_describe_pending_aggregation_requests(Limit, NextToken)
#'
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is maximum. If you specify 0, AWS Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_pending_aggregation_requests(
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_pending_aggregation_requests
configservice_describe_pending_aggregation_requests <- function(Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePendingAggregationRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_pending_aggregation_requests_input(Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_pending_aggregation_requests_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_pending_aggregation_requests <- configservice_describe_pending_aggregation_requests

#' Returns the details of one or more remediation configurations
#'
#' Returns the details of one or more remediation configurations.
#'
#' @usage
#' configservice_describe_remediation_configurations(ConfigRuleNames)
#'
#' @param ConfigRuleNames &#91;required&#93; A list of AWS Config rule names of remediation configurations for which
#' you want details.
#'
#' @section Request syntax:
#' ```
#' svc$describe_remediation_configurations(
#'   ConfigRuleNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_remediation_configurations
configservice_describe_remediation_configurations <- function(ConfigRuleNames) {
  op <- new_operation(
    name = "DescribeRemediationConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_remediation_configurations_input(ConfigRuleNames = ConfigRuleNames)
  output <- .configservice$describe_remediation_configurations_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_remediation_configurations <- configservice_describe_remediation_configurations

#' Returns the details of one or more remediation exceptions
#'
#' Returns the details of one or more remediation exceptions. A detailed
#' view of a remediation exception for a set of resources that includes an
#' explanation of an exception and the time when the exception will be
#' deleted. When you specify the limit and the next token, you receive a
#' paginated response.
#' 
#' When you specify the limit and the next token, you receive a paginated
#' response.
#' 
#' Limit and next token are not applicable if you request resources in
#' batch. It is only applicable, when you request all resources.
#'
#' @usage
#' configservice_describe_remediation_exceptions(ConfigRuleName,
#'   ResourceKeys, Limit, NextToken)
#'
#' @param ConfigRuleName &#91;required&#93; The name of the AWS Config rule.
#' @param ResourceKeys An exception list of resource exception keys to be processed with the
#' current request. AWS Config adds exception for each resource key. For
#' example, AWS Config adds 3 exceptions for 3 resource keys.
#' @param Limit The maximum number of RemediationExceptionResourceKey returned on each
#' page. The default is 25. If you specify 0, AWS Config uses the default.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_remediation_exceptions(
#'   ConfigRuleName = "string",
#'   ResourceKeys = list(
#'     list(
#'       ResourceType = "string",
#'       ResourceId = "string"
#'     )
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_remediation_exceptions
configservice_describe_remediation_exceptions <- function(ConfigRuleName, ResourceKeys = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeRemediationExceptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_remediation_exceptions_input(ConfigRuleName = ConfigRuleName, ResourceKeys = ResourceKeys, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_remediation_exceptions_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_remediation_exceptions <- configservice_describe_remediation_exceptions

#' Provides a detailed view of a Remediation Execution for a set of
#' resources including state, timestamps for when steps for the remediation
#' execution occur, and any error messages for steps that have failed
#'
#' Provides a detailed view of a Remediation Execution for a set of
#' resources including state, timestamps for when steps for the remediation
#' execution occur, and any error messages for steps that have failed. When
#' you specify the limit and the next token, you receive a paginated
#' response.
#'
#' @usage
#' configservice_describe_remediation_execution_status(ConfigRuleName,
#'   ResourceKeys, Limit, NextToken)
#'
#' @param ConfigRuleName &#91;required&#93; A list of AWS Config rule names.
#' @param ResourceKeys A list of resource keys to be processed with the current request. Each
#' element in the list consists of the resource type and resource ID.
#' @param Limit The maximum number of RemediationExecutionStatuses returned on each
#' page. The default is maximum. If you specify 0, AWS Config uses the
#' default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_remediation_execution_status(
#'   ConfigRuleName = "string",
#'   ResourceKeys = list(
#'     list(
#'       resourceType = "AWS::EC2::CustomerGateway"|"AWS::EC2::EIP"|"AWS::EC2::Host"|"AWS::EC2::Instance"|"AWS::EC2::InternetGateway"|"AWS::EC2::NetworkAcl"|"AWS::EC2::NetworkInterface"|"AWS::EC2::RouteTable"|"AWS::EC2::SecurityGroup"|"AWS::EC2::Subnet"|"AWS::CloudTrail::Trail"|"AWS::EC2::Volume"|"AWS::EC2::VPC"|"AWS::EC2::VPNConnection"|"AWS::EC2::VPNGateway"|"AWS::EC2::RegisteredHAInstance"|"AWS::EC2::NatGateway"|"AWS::EC2::EgressOnlyInternetGateway"|"AWS::EC2::VPCEndpoint"|"AWS::EC2::VPCEndpointService"|"AWS::EC2::FlowLog"|"AWS::EC2::VPCPeeringConnection"|"AWS::IAM::Group"|"AWS::IAM::Policy"|"AWS::IAM::Role"|"AWS::IAM::User"|"AWS::ElasticLoadBalancingV2::LoadBalancer"|"AWS::ACM::Certificate"|"AWS::RDS::DBInstance"|"AWS::RDS::DBParameterGroup"|"AWS::RDS::DBOptionGroup"|"AWS::RDS::DBSubnetGroup"|"AWS::RDS::DBSecurityGroup"|"AWS::RDS::DBSnapshot"|"AWS::RDS::DBCluster"|"AWS::RDS::DBClusterParameterGroup"|"AWS::RDS::DBClusterSnapshot"|"AWS::RDS::EventSubscription"|"AWS::S3::Bucket"|"AWS::S3::AccountPublicAccessBlock"|"AWS::Redshift::Cluster"|"AWS::Redshift::ClusterSnapshot"|"AWS::Redshift::ClusterParameterGroup"|"AWS::Redshift::ClusterSecurityGroup"|"AWS::Redshift::ClusterSubnetGroup"|"AWS::Redshift::EventSubscription"|"AWS::SSM::ManagedInstanceInventory"|"AWS::CloudWatch::Alarm"|"AWS::CloudFormation::Stack"|"AWS::ElasticLoadBalancing::LoadBalancer"|"AWS::AutoScaling::AutoScalingGroup"|"AWS::AutoScaling::LaunchConfiguration"|"AWS::AutoScaling::ScalingPolicy"|"AWS::AutoScaling::ScheduledAction"|"AWS::DynamoDB::Table"|"AWS::CodeBuild::Project"|"AWS::WAF::RateBasedRule"|"AWS::WAF::Rule"|"AWS::WAF::RuleGroup"|"AWS::WAF::WebACL"|"AWS::WAFRegional::RateBasedRule"|"AWS::WAFRegional::Rule"|"AWS::WAFRegional::RuleGroup"|"AWS::WAFRegional::WebACL"|"AWS::CloudFront::Distribution"|"AWS::CloudFront::StreamingDistribution"|"AWS::Lambda::Alias"|"AWS::Lambda::Function"|"AWS::ElasticBeanstalk::Application"|"AWS::ElasticBeanstalk::ApplicationVersion"|"AWS::ElasticBeanstalk::Environment"|"AWS::MobileHub::Project"|"AWS::XRay::EncryptionConfig"|"AWS::SSM::AssociationCompliance"|"AWS::SSM::PatchCompliance"|"AWS::Shield::Protection"|"AWS::ShieldRegional::Protection"|"AWS::Config::ResourceCompliance"|"AWS::LicenseManager::LicenseConfiguration"|"AWS::ApiGateway::DomainName"|"AWS::ApiGateway::Method"|"AWS::ApiGateway::Stage"|"AWS::ApiGateway::RestApi"|"AWS::ApiGatewayV2::DomainName"|"AWS::ApiGatewayV2::Stage"|"AWS::ApiGatewayV2::Api"|"AWS::CodePipeline::Pipeline"|"AWS::ServiceCatalog::CloudFormationProvisionedProduct"|"AWS::ServiceCatalog::CloudFormationProduct"|"AWS::ServiceCatalog::Portfolio",
#'       resourceId = "string"
#'     )
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_remediation_execution_status
configservice_describe_remediation_execution_status <- function(ConfigRuleName, ResourceKeys = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeRemediationExecutionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_remediation_execution_status_input(ConfigRuleName = ConfigRuleName, ResourceKeys = ResourceKeys, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_remediation_execution_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_remediation_execution_status <- configservice_describe_remediation_execution_status

#' Returns the details of one or more retention configurations
#'
#' Returns the details of one or more retention configurations. If the
#' retention configuration name is not specified, this action returns the
#' details for all the retention configurations for that account.
#' 
#' Currently, AWS Config supports only one retention configuration per
#' region in your account.
#'
#' @usage
#' configservice_describe_retention_configurations(
#'   RetentionConfigurationNames, NextToken)
#'
#' @param RetentionConfigurationNames A list of names of retention configurations for which you want details.
#' If you do not specify a name, AWS Config returns details for all the
#' retention configurations for that account.
#' 
#' Currently, AWS Config supports only one retention configuration per
#' region in your account.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_retention_configurations(
#'   RetentionConfigurationNames = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_describe_retention_configurations
configservice_describe_retention_configurations <- function(RetentionConfigurationNames = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeRetentionConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_retention_configurations_input(RetentionConfigurationNames = RetentionConfigurationNames, NextToken = NextToken)
  output <- .configservice$describe_retention_configurations_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_retention_configurations <- configservice_describe_retention_configurations

#' Returns the evaluation results for the specified AWS Config rule for a
#' specific resource in a rule
#'
#' Returns the evaluation results for the specified AWS Config rule for a
#' specific resource in a rule. The results indicate which AWS resources
#' were evaluated by the rule, when each resource was last evaluated, and
#' whether each resource complies with the rule.
#' 
#' The results can return an empty result page. But if you have a
#' `nextToken`, the results are displayed on the next page.
#'
#' @usage
#' configservice_get_aggregate_compliance_details_by_config_rule(
#'   ConfigurationAggregatorName, ConfigRuleName, AccountId, AwsRegion,
#'   ComplianceType, Limit, NextToken)
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param ConfigRuleName &#91;required&#93; The name of the AWS Config rule for which you want compliance
#' information.
#' @param AccountId &#91;required&#93; The 12-digit account ID of the source account.
#' @param AwsRegion &#91;required&#93; The source region from where the data is aggregated.
#' @param ComplianceType The resource compliance status.
#' 
#' For the `GetAggregateComplianceDetailsByConfigRuleRequest` data type,
#' AWS Config supports only the `COMPLIANT` and `NON_COMPLIANT`. AWS Config
#' does not support the `NOT_APPLICABLE` and `INSUFFICIENT_DATA` values.
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is 50. You cannot specify a number greater than 100. If you
#' specify 0, AWS Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_aggregate_compliance_details_by_config_rule(
#'   ConfigurationAggregatorName = "string",
#'   ConfigRuleName = "string",
#'   AccountId = "string",
#'   AwsRegion = "string",
#'   ComplianceType = "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA",
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_aggregate_compliance_details_by_config_rule
configservice_get_aggregate_compliance_details_by_config_rule <- function(ConfigurationAggregatorName, ConfigRuleName, AccountId, AwsRegion, ComplianceType = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetAggregateComplianceDetailsByConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_aggregate_compliance_details_by_config_rule_input(ConfigurationAggregatorName = ConfigurationAggregatorName, ConfigRuleName = ConfigRuleName, AccountId = AccountId, AwsRegion = AwsRegion, ComplianceType = ComplianceType, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_aggregate_compliance_details_by_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_aggregate_compliance_details_by_config_rule <- configservice_get_aggregate_compliance_details_by_config_rule

#' Returns the number of compliant and noncompliant rules for one or more
#' accounts and regions in an aggregator
#'
#' Returns the number of compliant and noncompliant rules for one or more
#' accounts and regions in an aggregator.
#' 
#' The results can return an empty result page, but if you have a
#' nextToken, the results are displayed on the next page.
#'
#' @usage
#' configservice_get_aggregate_config_rule_compliance_summary(
#'   ConfigurationAggregatorName, Filters, GroupByKey, Limit, NextToken)
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param Filters Filters the results based on the ConfigRuleComplianceSummaryFilters
#' object.
#' @param GroupByKey Groups the result based on ACCOUNT\\_ID or AWS\\_REGION.
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is 1000. You cannot specify a number greater than 1000. If you
#' specify 0, AWS Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_aggregate_config_rule_compliance_summary(
#'   ConfigurationAggregatorName = "string",
#'   Filters = list(
#'     AccountId = "string",
#'     AwsRegion = "string"
#'   ),
#'   GroupByKey = "ACCOUNT_ID"|"AWS_REGION",
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_aggregate_config_rule_compliance_summary
configservice_get_aggregate_config_rule_compliance_summary <- function(ConfigurationAggregatorName, Filters = NULL, GroupByKey = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetAggregateConfigRuleComplianceSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_aggregate_config_rule_compliance_summary_input(ConfigurationAggregatorName = ConfigurationAggregatorName, Filters = Filters, GroupByKey = GroupByKey, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_aggregate_config_rule_compliance_summary_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_aggregate_config_rule_compliance_summary <- configservice_get_aggregate_config_rule_compliance_summary

#' Returns the resource counts across accounts and regions that are present
#' in your AWS Config aggregator
#'
#' Returns the resource counts across accounts and regions that are present
#' in your AWS Config aggregator. You can request the resource counts by
#' providing filters and GroupByKey.
#' 
#' For example, if the input contains accountID 12345678910 and region
#' us-east-1 in filters, the API returns the count of resources in account
#' ID 12345678910 and region us-east-1. If the input contains ACCOUNT\\_ID
#' as a GroupByKey, the API returns resource counts for all source accounts
#' that are present in your aggregator.
#'
#' @usage
#' configservice_get_aggregate_discovered_resource_counts(
#'   ConfigurationAggregatorName, Filters, GroupByKey, Limit, NextToken)
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param Filters Filters the results based on the `ResourceCountFilters` object.
#' @param GroupByKey The key to group the resource counts.
#' @param Limit The maximum number of GroupedResourceCount objects returned on each
#' page. The default is 1000. You cannot specify a number greater than
#' 1000. If you specify 0, AWS Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_aggregate_discovered_resource_counts(
#'   ConfigurationAggregatorName = "string",
#'   Filters = list(
#'     ResourceType = "AWS::EC2::CustomerGateway"|"AWS::EC2::EIP"|"AWS::EC2::Host"|"AWS::EC2::Instance"|"AWS::EC2::InternetGateway"|"AWS::EC2::NetworkAcl"|"AWS::EC2::NetworkInterface"|"AWS::EC2::RouteTable"|"AWS::EC2::SecurityGroup"|"AWS::EC2::Subnet"|"AWS::CloudTrail::Trail"|"AWS::EC2::Volume"|"AWS::EC2::VPC"|"AWS::EC2::VPNConnection"|"AWS::EC2::VPNGateway"|"AWS::EC2::RegisteredHAInstance"|"AWS::EC2::NatGateway"|"AWS::EC2::EgressOnlyInternetGateway"|"AWS::EC2::VPCEndpoint"|"AWS::EC2::VPCEndpointService"|"AWS::EC2::FlowLog"|"AWS::EC2::VPCPeeringConnection"|"AWS::IAM::Group"|"AWS::IAM::Policy"|"AWS::IAM::Role"|"AWS::IAM::User"|"AWS::ElasticLoadBalancingV2::LoadBalancer"|"AWS::ACM::Certificate"|"AWS::RDS::DBInstance"|"AWS::RDS::DBParameterGroup"|"AWS::RDS::DBOptionGroup"|"AWS::RDS::DBSubnetGroup"|"AWS::RDS::DBSecurityGroup"|"AWS::RDS::DBSnapshot"|"AWS::RDS::DBCluster"|"AWS::RDS::DBClusterParameterGroup"|"AWS::RDS::DBClusterSnapshot"|"AWS::RDS::EventSubscription"|"AWS::S3::Bucket"|"AWS::S3::AccountPublicAccessBlock"|"AWS::Redshift::Cluster"|"AWS::Redshift::ClusterSnapshot"|"AWS::Redshift::ClusterParameterGroup"|"AWS::Redshift::ClusterSecurityGroup"|"AWS::Redshift::ClusterSubnetGroup"|"AWS::Redshift::EventSubscription"|"AWS::SSM::ManagedInstanceInventory"|"AWS::CloudWatch::Alarm"|"AWS::CloudFormation::Stack"|"AWS::ElasticLoadBalancing::LoadBalancer"|"AWS::AutoScaling::AutoScalingGroup"|"AWS::AutoScaling::LaunchConfiguration"|"AWS::AutoScaling::ScalingPolicy"|"AWS::AutoScaling::ScheduledAction"|"AWS::DynamoDB::Table"|"AWS::CodeBuild::Project"|"AWS::WAF::RateBasedRule"|"AWS::WAF::Rule"|"AWS::WAF::RuleGroup"|"AWS::WAF::WebACL"|"AWS::WAFRegional::RateBasedRule"|"AWS::WAFRegional::Rule"|"AWS::WAFRegional::RuleGroup"|"AWS::WAFRegional::WebACL"|"AWS::CloudFront::Distribution"|"AWS::CloudFront::StreamingDistribution"|"AWS::Lambda::Alias"|"AWS::Lambda::Function"|"AWS::ElasticBeanstalk::Application"|"AWS::ElasticBeanstalk::ApplicationVersion"|"AWS::ElasticBeanstalk::Environment"|"AWS::MobileHub::Project"|"AWS::XRay::EncryptionConfig"|"AWS::SSM::AssociationCompliance"|"AWS::SSM::PatchCompliance"|"AWS::Shield::Protection"|"AWS::ShieldRegional::Protection"|"AWS::Config::ResourceCompliance"|"AWS::LicenseManager::LicenseConfiguration"|"AWS::ApiGateway::DomainName"|"AWS::ApiGateway::Method"|"AWS::ApiGateway::Stage"|"AWS::ApiGateway::RestApi"|"AWS::ApiGatewayV2::DomainName"|"AWS::ApiGatewayV2::Stage"|"AWS::ApiGatewayV2::Api"|"AWS::CodePipeline::Pipeline"|"AWS::ServiceCatalog::CloudFormationProvisionedProduct"|"AWS::ServiceCatalog::CloudFormationProduct"|"AWS::ServiceCatalog::Portfolio",
#'     AccountId = "string",
#'     Region = "string"
#'   ),
#'   GroupByKey = "RESOURCE_TYPE"|"ACCOUNT_ID"|"AWS_REGION",
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_aggregate_discovered_resource_counts
configservice_get_aggregate_discovered_resource_counts <- function(ConfigurationAggregatorName, Filters = NULL, GroupByKey = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetAggregateDiscoveredResourceCounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_aggregate_discovered_resource_counts_input(ConfigurationAggregatorName = ConfigurationAggregatorName, Filters = Filters, GroupByKey = GroupByKey, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_aggregate_discovered_resource_counts_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_aggregate_discovered_resource_counts <- configservice_get_aggregate_discovered_resource_counts

#' Returns configuration item that is aggregated for your specific resource
#' in a specific source account and region
#'
#' Returns configuration item that is aggregated for your specific resource
#' in a specific source account and region.
#'
#' @usage
#' configservice_get_aggregate_resource_config(ConfigurationAggregatorName,
#'   ResourceIdentifier)
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param ResourceIdentifier &#91;required&#93; An object that identifies aggregate resource.
#'
#' @section Request syntax:
#' ```
#' svc$get_aggregate_resource_config(
#'   ConfigurationAggregatorName = "string",
#'   ResourceIdentifier = list(
#'     SourceAccountId = "string",
#'     SourceRegion = "string",
#'     ResourceId = "string",
#'     ResourceType = "AWS::EC2::CustomerGateway"|"AWS::EC2::EIP"|"AWS::EC2::Host"|"AWS::EC2::Instance"|"AWS::EC2::InternetGateway"|"AWS::EC2::NetworkAcl"|"AWS::EC2::NetworkInterface"|"AWS::EC2::RouteTable"|"AWS::EC2::SecurityGroup"|"AWS::EC2::Subnet"|"AWS::CloudTrail::Trail"|"AWS::EC2::Volume"|"AWS::EC2::VPC"|"AWS::EC2::VPNConnection"|"AWS::EC2::VPNGateway"|"AWS::EC2::RegisteredHAInstance"|"AWS::EC2::NatGateway"|"AWS::EC2::EgressOnlyInternetGateway"|"AWS::EC2::VPCEndpoint"|"AWS::EC2::VPCEndpointService"|"AWS::EC2::FlowLog"|"AWS::EC2::VPCPeeringConnection"|"AWS::IAM::Group"|"AWS::IAM::Policy"|"AWS::IAM::Role"|"AWS::IAM::User"|"AWS::ElasticLoadBalancingV2::LoadBalancer"|"AWS::ACM::Certificate"|"AWS::RDS::DBInstance"|"AWS::RDS::DBParameterGroup"|"AWS::RDS::DBOptionGroup"|"AWS::RDS::DBSubnetGroup"|"AWS::RDS::DBSecurityGroup"|"AWS::RDS::DBSnapshot"|"AWS::RDS::DBCluster"|"AWS::RDS::DBClusterParameterGroup"|"AWS::RDS::DBClusterSnapshot"|"AWS::RDS::EventSubscription"|"AWS::S3::Bucket"|"AWS::S3::AccountPublicAccessBlock"|"AWS::Redshift::Cluster"|"AWS::Redshift::ClusterSnapshot"|"AWS::Redshift::ClusterParameterGroup"|"AWS::Redshift::ClusterSecurityGroup"|"AWS::Redshift::ClusterSubnetGroup"|"AWS::Redshift::EventSubscription"|"AWS::SSM::ManagedInstanceInventory"|"AWS::CloudWatch::Alarm"|"AWS::CloudFormation::Stack"|"AWS::ElasticLoadBalancing::LoadBalancer"|"AWS::AutoScaling::AutoScalingGroup"|"AWS::AutoScaling::LaunchConfiguration"|"AWS::AutoScaling::ScalingPolicy"|"AWS::AutoScaling::ScheduledAction"|"AWS::DynamoDB::Table"|"AWS::CodeBuild::Project"|"AWS::WAF::RateBasedRule"|"AWS::WAF::Rule"|"AWS::WAF::RuleGroup"|"AWS::WAF::WebACL"|"AWS::WAFRegional::RateBasedRule"|"AWS::WAFRegional::Rule"|"AWS::WAFRegional::RuleGroup"|"AWS::WAFRegional::WebACL"|"AWS::CloudFront::Distribution"|"AWS::CloudFront::StreamingDistribution"|"AWS::Lambda::Alias"|"AWS::Lambda::Function"|"AWS::ElasticBeanstalk::Application"|"AWS::ElasticBeanstalk::ApplicationVersion"|"AWS::ElasticBeanstalk::Environment"|"AWS::MobileHub::Project"|"AWS::XRay::EncryptionConfig"|"AWS::SSM::AssociationCompliance"|"AWS::SSM::PatchCompliance"|"AWS::Shield::Protection"|"AWS::ShieldRegional::Protection"|"AWS::Config::ResourceCompliance"|"AWS::LicenseManager::LicenseConfiguration"|"AWS::ApiGateway::DomainName"|"AWS::ApiGateway::Method"|"AWS::ApiGateway::Stage"|"AWS::ApiGateway::RestApi"|"AWS::ApiGatewayV2::DomainName"|"AWS::ApiGatewayV2::Stage"|"AWS::ApiGatewayV2::Api"|"AWS::CodePipeline::Pipeline"|"AWS::ServiceCatalog::CloudFormationProvisionedProduct"|"AWS::ServiceCatalog::CloudFormationProduct"|"AWS::ServiceCatalog::Portfolio",
#'     ResourceName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_aggregate_resource_config
configservice_get_aggregate_resource_config <- function(ConfigurationAggregatorName, ResourceIdentifier) {
  op <- new_operation(
    name = "GetAggregateResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_aggregate_resource_config_input(ConfigurationAggregatorName = ConfigurationAggregatorName, ResourceIdentifier = ResourceIdentifier)
  output <- .configservice$get_aggregate_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_aggregate_resource_config <- configservice_get_aggregate_resource_config

#' Returns the evaluation results for the specified AWS Config rule
#'
#' Returns the evaluation results for the specified AWS Config rule. The
#' results indicate which AWS resources were evaluated by the rule, when
#' each resource was last evaluated, and whether each resource complies
#' with the rule.
#'
#' @usage
#' configservice_get_compliance_details_by_config_rule(ConfigRuleName,
#'   ComplianceTypes, Limit, NextToken)
#'
#' @param ConfigRuleName &#91;required&#93; The name of the AWS Config rule for which you want compliance
#' information.
#' @param ComplianceTypes Filters the results by compliance.
#' 
#' The allowed values are `COMPLIANT`, `NON_COMPLIANT`, and
#' `NOT_APPLICABLE`.
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is 10. You cannot specify a number greater than 100. If you
#' specify 0, AWS Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_compliance_details_by_config_rule(
#'   ConfigRuleName = "string",
#'   ComplianceTypes = list(
#'     "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_compliance_details_by_config_rule
configservice_get_compliance_details_by_config_rule <- function(ConfigRuleName, ComplianceTypes = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetComplianceDetailsByConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_compliance_details_by_config_rule_input(ConfigRuleName = ConfigRuleName, ComplianceTypes = ComplianceTypes, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_compliance_details_by_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_compliance_details_by_config_rule <- configservice_get_compliance_details_by_config_rule

#' Returns the evaluation results for the specified AWS resource
#'
#' Returns the evaluation results for the specified AWS resource. The
#' results indicate which AWS Config rules were used to evaluate the
#' resource, when each rule was last used, and whether the resource
#' complies with each rule.
#'
#' @usage
#' configservice_get_compliance_details_by_resource(ResourceType,
#'   ResourceId, ComplianceTypes, NextToken)
#'
#' @param ResourceType &#91;required&#93; The type of the AWS resource for which you want compliance information.
#' @param ResourceId &#91;required&#93; The ID of the AWS resource for which you want compliance information.
#' @param ComplianceTypes Filters the results by compliance.
#' 
#' The allowed values are `COMPLIANT`, `NON_COMPLIANT`, and
#' `NOT_APPLICABLE`.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_compliance_details_by_resource(
#'   ResourceType = "string",
#'   ResourceId = "string",
#'   ComplianceTypes = list(
#'     "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_compliance_details_by_resource
configservice_get_compliance_details_by_resource <- function(ResourceType, ResourceId, ComplianceTypes = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetComplianceDetailsByResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_compliance_details_by_resource_input(ResourceType = ResourceType, ResourceId = ResourceId, ComplianceTypes = ComplianceTypes, NextToken = NextToken)
  output <- .configservice$get_compliance_details_by_resource_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_compliance_details_by_resource <- configservice_get_compliance_details_by_resource

#' Returns the number of AWS Config rules that are compliant and
#' noncompliant, up to a maximum of 25 for each
#'
#' Returns the number of AWS Config rules that are compliant and
#' noncompliant, up to a maximum of 25 for each.
#'
#' @usage
#' configservice_get_compliance_summary_by_config_rule()
#'

#'

#'
#' @keywords internal
#'
#' @rdname configservice_get_compliance_summary_by_config_rule
configservice_get_compliance_summary_by_config_rule <- function() {
  op <- new_operation(
    name = "GetComplianceSummaryByConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_compliance_summary_by_config_rule_input()
  output <- .configservice$get_compliance_summary_by_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_compliance_summary_by_config_rule <- configservice_get_compliance_summary_by_config_rule

#' Returns the number of resources that are compliant and the number that
#' are noncompliant
#'
#' Returns the number of resources that are compliant and the number that
#' are noncompliant. You can specify one or more resource types to get
#' these numbers for each resource type. The maximum number returned is
#' 100.
#'
#' @usage
#' configservice_get_compliance_summary_by_resource_type(ResourceTypes)
#'
#' @param ResourceTypes Specify one or more resource types to get the number of resources that
#' are compliant and the number that are noncompliant for each resource
#' type.
#' 
#' For this request, you can specify an AWS resource type such as
#' `AWS::EC2::Instance`. You can specify that the resource type is an AWS
#' account by specifying `AWS::::Account`.
#'
#' @section Request syntax:
#' ```
#' svc$get_compliance_summary_by_resource_type(
#'   ResourceTypes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_compliance_summary_by_resource_type
configservice_get_compliance_summary_by_resource_type <- function(ResourceTypes = NULL) {
  op <- new_operation(
    name = "GetComplianceSummaryByResourceType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_compliance_summary_by_resource_type_input(ResourceTypes = ResourceTypes)
  output <- .configservice$get_compliance_summary_by_resource_type_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_compliance_summary_by_resource_type <- configservice_get_compliance_summary_by_resource_type

#' Returns compliance details of a conformance pack for all AWS resources
#' that are monitered by conformance pack
#'
#' Returns compliance details of a conformance pack for all AWS resources
#' that are monitered by conformance pack.
#'
#' @usage
#' configservice_get_conformance_pack_compliance_details(
#'   ConformancePackName, Filters, Limit, NextToken)
#'
#' @param ConformancePackName &#91;required&#93; Name of the conformance pack.
#' @param Filters A `ConformancePackEvaluationFilters` object.
#' @param Limit The maximum number of evaluation results returned on each page. If you
#' do no specify a number, AWS Config uses the default. The default is 100.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_conformance_pack_compliance_details(
#'   ConformancePackName = "string",
#'   Filters = list(
#'     ConfigRuleNames = list(
#'       "string"
#'     ),
#'     ComplianceType = "COMPLIANT"|"NON_COMPLIANT",
#'     ResourceType = "string",
#'     ResourceIds = list(
#'       "string"
#'     )
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_conformance_pack_compliance_details
configservice_get_conformance_pack_compliance_details <- function(ConformancePackName, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetConformancePackComplianceDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_conformance_pack_compliance_details_input(ConformancePackName = ConformancePackName, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_conformance_pack_compliance_details_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_conformance_pack_compliance_details <- configservice_get_conformance_pack_compliance_details

#' Returns compliance details for the conformance pack based on the
#' cumulative compliance results of all the rules in that conformance pack
#'
#' Returns compliance details for the conformance pack based on the
#' cumulative compliance results of all the rules in that conformance pack.
#'
#' @usage
#' configservice_get_conformance_pack_compliance_summary(
#'   ConformancePackNames, Limit, NextToken)
#'
#' @param ConformancePackNames &#91;required&#93; Names of conformance packs.
#' @param Limit The maximum number of conformance packs returned on each page.
#' @param NextToken The nextToken string returned on a previous page that you use to get the
#' next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_conformance_pack_compliance_summary(
#'   ConformancePackNames = list(
#'     "string"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_conformance_pack_compliance_summary
configservice_get_conformance_pack_compliance_summary <- function(ConformancePackNames, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetConformancePackComplianceSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_conformance_pack_compliance_summary_input(ConformancePackNames = ConformancePackNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_conformance_pack_compliance_summary_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_conformance_pack_compliance_summary <- configservice_get_conformance_pack_compliance_summary

#' Returns the resource types, the number of each resource type, and the
#' total number of resources that AWS Config is recording in this region
#' for your AWS account
#'
#' Returns the resource types, the number of each resource type, and the
#' total number of resources that AWS Config is recording in this region
#' for your AWS account.
#' 
#' **Example**
#' 
#' 1.  AWS Config is recording three resource types in the US East (Ohio)
#'     Region for your account: 25 EC2 instances, 20 IAM users, and 15 S3
#'     buckets.
#' 
#' 2.  You make a call to the `GetDiscoveredResourceCounts` action and
#'     specify that you want all resource types.
#' 
#' 3.  AWS Config returns the following:
#' 
#'     -   The resource types (EC2 instances, IAM users, and S3 buckets).
#' 
#'     -   The number of each resource type (25, 20, and 15).
#' 
#'     -   The total number of all resources (60).
#' 
#' The response is paginated. By default, AWS Config lists 100
#' ResourceCount objects on each page. You can customize this number with
#' the `limit` parameter. The response includes a `nextToken` string. To
#' get the next page of results, run the request again and specify the
#' string for the `nextToken` parameter.
#' 
#' If you make a call to the GetDiscoveredResourceCounts action, you might
#' not immediately receive resource counts in the following situations:
#' 
#' -   You are a new AWS Config customer.
#' 
#' -   You just enabled resource recording.
#' 
#' It might take a few minutes for AWS Config to record and count your
#' resources. Wait a few minutes and then retry the
#' GetDiscoveredResourceCounts action.
#'
#' @usage
#' configservice_get_discovered_resource_counts(resourceTypes, limit,
#'   nextToken)
#'
#' @param resourceTypes The comma-separated list that specifies the resource types that you want
#' AWS Config to return (for example, `"AWS::EC2::Instance"`,
#' `"AWS::IAM::User"`).
#' 
#' If a value for `resourceTypes` is not specified, AWS Config returns all
#' resource types that AWS Config is recording in the region for your
#' account.
#' 
#' If the configuration recorder is turned off, AWS Config returns an empty
#' list of ResourceCount objects. If the configuration recorder is not
#' recording a specific resource type (for example, S3 buckets), that
#' resource type is not returned in the list of ResourceCount objects.
#' @param limit The maximum number of ResourceCount objects returned on each page. The
#' default is 100. You cannot specify a number greater than 100. If you
#' specify 0, AWS Config uses the default.
#' @param nextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_discovered_resource_counts(
#'   resourceTypes = list(
#'     "string"
#'   ),
#'   limit = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_discovered_resource_counts
configservice_get_discovered_resource_counts <- function(resourceTypes = NULL, limit = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "GetDiscoveredResourceCounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_discovered_resource_counts_input(resourceTypes = resourceTypes, limit = limit, nextToken = nextToken)
  output <- .configservice$get_discovered_resource_counts_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_discovered_resource_counts <- configservice_get_discovered_resource_counts

#' Returns detailed status for each member account within an organization
#' for a given organization config rule
#'
#' Returns detailed status for each member account within an organization
#' for a given organization config rule.
#' 
#' Only a master account can call this API.
#'
#' @usage
#' configservice_get_organization_config_rule_detailed_status(
#'   OrganizationConfigRuleName, Filters, Limit, NextToken)
#'
#' @param OrganizationConfigRuleName &#91;required&#93; The name of organization config rule for which you want status details
#' for member accounts.
#' @param Filters A `StatusDetailFilters` object.
#' @param Limit The maximum number of `OrganizationConfigRuleDetailedStatus` returned on
#' each page. If you do not specify a number, AWS Config uses the default.
#' The default is 100.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_organization_config_rule_detailed_status(
#'   OrganizationConfigRuleName = "string",
#'   Filters = list(
#'     AccountId = "string",
#'     MemberAccountRuleStatus = "CREATE_SUCCESSFUL"|"CREATE_IN_PROGRESS"|"CREATE_FAILED"|"DELETE_SUCCESSFUL"|"DELETE_FAILED"|"DELETE_IN_PROGRESS"|"UPDATE_SUCCESSFUL"|"UPDATE_IN_PROGRESS"|"UPDATE_FAILED"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_organization_config_rule_detailed_status
configservice_get_organization_config_rule_detailed_status <- function(OrganizationConfigRuleName, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetOrganizationConfigRuleDetailedStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_organization_config_rule_detailed_status_input(OrganizationConfigRuleName = OrganizationConfigRuleName, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_organization_config_rule_detailed_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_organization_config_rule_detailed_status <- configservice_get_organization_config_rule_detailed_status

#' Returns detailed status for each member account within an organization
#' for a given organization conformance pack
#'
#' Returns detailed status for each member account within an organization
#' for a given organization conformance pack.
#' 
#' Only a master account can call this API.
#'
#' @usage
#' configservice_get_organization_conformance_pack_detailed_status(
#'   OrganizationConformancePackName, Filters, Limit, NextToken)
#'
#' @param OrganizationConformancePackName &#91;required&#93; The name of organization conformance pack for which you want status
#' details for member accounts.
#' @param Filters An `OrganizationResourceDetailedStatusFilters` object.
#' @param Limit The maximum number of `OrganizationConformancePackDetailedStatuses`
#' returned on each page. If you do not specify a number, AWS Config uses
#' the default. The default is 100.
#' @param NextToken The nextToken string returned on a previous page that you use to get the
#' next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_organization_conformance_pack_detailed_status(
#'   OrganizationConformancePackName = "string",
#'   Filters = list(
#'     AccountId = "string",
#'     Status = "CREATE_SUCCESSFUL"|"CREATE_IN_PROGRESS"|"CREATE_FAILED"|"DELETE_SUCCESSFUL"|"DELETE_FAILED"|"DELETE_IN_PROGRESS"|"UPDATE_SUCCESSFUL"|"UPDATE_IN_PROGRESS"|"UPDATE_FAILED"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_organization_conformance_pack_detailed_status
configservice_get_organization_conformance_pack_detailed_status <- function(OrganizationConformancePackName, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetOrganizationConformancePackDetailedStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_organization_conformance_pack_detailed_status_input(OrganizationConformancePackName = OrganizationConformancePackName, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_organization_conformance_pack_detailed_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_organization_conformance_pack_detailed_status <- configservice_get_organization_conformance_pack_detailed_status

#' Returns a list of configuration items for the specified resource
#'
#' Returns a list of configuration items for the specified resource. The
#' list contains details about each state of the resource during the
#' specified time interval. If you specified a retention period to retain
#' your `ConfigurationItems` between a minimum of 30 days and a maximum of
#' 7 years (2557 days), AWS Config returns the `ConfigurationItems` for the
#' specified retention period.
#' 
#' The response is paginated. By default, AWS Config returns a limit of 10
#' configuration items per page. You can customize this number with the
#' `limit` parameter. The response includes a `nextToken` string. To get
#' the next page of results, run the request again and specify the string
#' for the `nextToken` parameter.
#' 
#' Each call to the API is limited to span a duration of seven days. It is
#' likely that the number of records returned is smaller than the specified
#' `limit`. In such cases, you can make another call, using the
#' `nextToken`.
#'
#' @usage
#' configservice_get_resource_config_history(resourceType, resourceId,
#'   laterTime, earlierTime, chronologicalOrder, limit, nextToken)
#'
#' @param resourceType &#91;required&#93; The resource type.
#' @param resourceId &#91;required&#93; The ID of the resource (for example., `sg-xxxxxx`).
#' @param laterTime The time stamp that indicates a later time. If not specified, current
#' time is taken.
#' @param earlierTime The time stamp that indicates an earlier time. If not specified, the
#' action returns paginated results that contain configuration items that
#' start when the first configuration item was recorded.
#' @param chronologicalOrder The chronological order for configuration items listed. By default, the
#' results are listed in reverse chronological order.
#' @param limit The maximum number of configuration items returned on each page. The
#' default is 10. You cannot specify a number greater than 100. If you
#' specify 0, AWS Config uses the default.
#' @param nextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_resource_config_history(
#'   resourceType = "AWS::EC2::CustomerGateway"|"AWS::EC2::EIP"|"AWS::EC2::Host"|"AWS::EC2::Instance"|"AWS::EC2::InternetGateway"|"AWS::EC2::NetworkAcl"|"AWS::EC2::NetworkInterface"|"AWS::EC2::RouteTable"|"AWS::EC2::SecurityGroup"|"AWS::EC2::Subnet"|"AWS::CloudTrail::Trail"|"AWS::EC2::Volume"|"AWS::EC2::VPC"|"AWS::EC2::VPNConnection"|"AWS::EC2::VPNGateway"|"AWS::EC2::RegisteredHAInstance"|"AWS::EC2::NatGateway"|"AWS::EC2::EgressOnlyInternetGateway"|"AWS::EC2::VPCEndpoint"|"AWS::EC2::VPCEndpointService"|"AWS::EC2::FlowLog"|"AWS::EC2::VPCPeeringConnection"|"AWS::IAM::Group"|"AWS::IAM::Policy"|"AWS::IAM::Role"|"AWS::IAM::User"|"AWS::ElasticLoadBalancingV2::LoadBalancer"|"AWS::ACM::Certificate"|"AWS::RDS::DBInstance"|"AWS::RDS::DBParameterGroup"|"AWS::RDS::DBOptionGroup"|"AWS::RDS::DBSubnetGroup"|"AWS::RDS::DBSecurityGroup"|"AWS::RDS::DBSnapshot"|"AWS::RDS::DBCluster"|"AWS::RDS::DBClusterParameterGroup"|"AWS::RDS::DBClusterSnapshot"|"AWS::RDS::EventSubscription"|"AWS::S3::Bucket"|"AWS::S3::AccountPublicAccessBlock"|"AWS::Redshift::Cluster"|"AWS::Redshift::ClusterSnapshot"|"AWS::Redshift::ClusterParameterGroup"|"AWS::Redshift::ClusterSecurityGroup"|"AWS::Redshift::ClusterSubnetGroup"|"AWS::Redshift::EventSubscription"|"AWS::SSM::ManagedInstanceInventory"|"AWS::CloudWatch::Alarm"|"AWS::CloudFormation::Stack"|"AWS::ElasticLoadBalancing::LoadBalancer"|"AWS::AutoScaling::AutoScalingGroup"|"AWS::AutoScaling::LaunchConfiguration"|"AWS::AutoScaling::ScalingPolicy"|"AWS::AutoScaling::ScheduledAction"|"AWS::DynamoDB::Table"|"AWS::CodeBuild::Project"|"AWS::WAF::RateBasedRule"|"AWS::WAF::Rule"|"AWS::WAF::RuleGroup"|"AWS::WAF::WebACL"|"AWS::WAFRegional::RateBasedRule"|"AWS::WAFRegional::Rule"|"AWS::WAFRegional::RuleGroup"|"AWS::WAFRegional::WebACL"|"AWS::CloudFront::Distribution"|"AWS::CloudFront::StreamingDistribution"|"AWS::Lambda::Alias"|"AWS::Lambda::Function"|"AWS::ElasticBeanstalk::Application"|"AWS::ElasticBeanstalk::ApplicationVersion"|"AWS::ElasticBeanstalk::Environment"|"AWS::MobileHub::Project"|"AWS::XRay::EncryptionConfig"|"AWS::SSM::AssociationCompliance"|"AWS::SSM::PatchCompliance"|"AWS::Shield::Protection"|"AWS::ShieldRegional::Protection"|"AWS::Config::ResourceCompliance"|"AWS::LicenseManager::LicenseConfiguration"|"AWS::ApiGateway::DomainName"|"AWS::ApiGateway::Method"|"AWS::ApiGateway::Stage"|"AWS::ApiGateway::RestApi"|"AWS::ApiGatewayV2::DomainName"|"AWS::ApiGatewayV2::Stage"|"AWS::ApiGatewayV2::Api"|"AWS::CodePipeline::Pipeline"|"AWS::ServiceCatalog::CloudFormationProvisionedProduct"|"AWS::ServiceCatalog::CloudFormationProduct"|"AWS::ServiceCatalog::Portfolio",
#'   resourceId = "string",
#'   laterTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   earlierTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   chronologicalOrder = "Reverse"|"Forward",
#'   limit = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_get_resource_config_history
configservice_get_resource_config_history <- function(resourceType, resourceId, laterTime = NULL, earlierTime = NULL, chronologicalOrder = NULL, limit = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "GetResourceConfigHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_resource_config_history_input(resourceType = resourceType, resourceId = resourceId, laterTime = laterTime, earlierTime = earlierTime, chronologicalOrder = chronologicalOrder, limit = limit, nextToken = nextToken)
  output <- .configservice$get_resource_config_history_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_resource_config_history <- configservice_get_resource_config_history

#' Accepts a resource type and returns a list of resource identifiers that
#' are aggregated for a specific resource type across accounts and regions
#'
#' Accepts a resource type and returns a list of resource identifiers that
#' are aggregated for a specific resource type across accounts and regions.
#' A resource identifier includes the resource type, ID, (if available) the
#' custom resource name, source account, and source region. You can narrow
#' the results to include only resources that have specific resource IDs,
#' or a resource name, or source account ID, or source region.
#' 
#' For example, if the input consists of accountID 12345678910 and the
#' region is us-east-1 for resource type `AWS::EC2::Instance` then the API
#' returns all the EC2 instance identifiers of accountID 12345678910 and
#' region us-east-1.
#'
#' @usage
#' configservice_list_aggregate_discovered_resources(
#'   ConfigurationAggregatorName, ResourceType, Filters, Limit, NextToken)
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param ResourceType &#91;required&#93; The type of resources that you want AWS Config to list in the response.
#' @param Filters Filters the results based on the `ResourceFilters` object.
#' @param Limit The maximum number of resource identifiers returned on each page. The
#' default is 100. You cannot specify a number greater than 100. If you
#' specify 0, AWS Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$list_aggregate_discovered_resources(
#'   ConfigurationAggregatorName = "string",
#'   ResourceType = "AWS::EC2::CustomerGateway"|"AWS::EC2::EIP"|"AWS::EC2::Host"|"AWS::EC2::Instance"|"AWS::EC2::InternetGateway"|"AWS::EC2::NetworkAcl"|"AWS::EC2::NetworkInterface"|"AWS::EC2::RouteTable"|"AWS::EC2::SecurityGroup"|"AWS::EC2::Subnet"|"AWS::CloudTrail::Trail"|"AWS::EC2::Volume"|"AWS::EC2::VPC"|"AWS::EC2::VPNConnection"|"AWS::EC2::VPNGateway"|"AWS::EC2::RegisteredHAInstance"|"AWS::EC2::NatGateway"|"AWS::EC2::EgressOnlyInternetGateway"|"AWS::EC2::VPCEndpoint"|"AWS::EC2::VPCEndpointService"|"AWS::EC2::FlowLog"|"AWS::EC2::VPCPeeringConnection"|"AWS::IAM::Group"|"AWS::IAM::Policy"|"AWS::IAM::Role"|"AWS::IAM::User"|"AWS::ElasticLoadBalancingV2::LoadBalancer"|"AWS::ACM::Certificate"|"AWS::RDS::DBInstance"|"AWS::RDS::DBParameterGroup"|"AWS::RDS::DBOptionGroup"|"AWS::RDS::DBSubnetGroup"|"AWS::RDS::DBSecurityGroup"|"AWS::RDS::DBSnapshot"|"AWS::RDS::DBCluster"|"AWS::RDS::DBClusterParameterGroup"|"AWS::RDS::DBClusterSnapshot"|"AWS::RDS::EventSubscription"|"AWS::S3::Bucket"|"AWS::S3::AccountPublicAccessBlock"|"AWS::Redshift::Cluster"|"AWS::Redshift::ClusterSnapshot"|"AWS::Redshift::ClusterParameterGroup"|"AWS::Redshift::ClusterSecurityGroup"|"AWS::Redshift::ClusterSubnetGroup"|"AWS::Redshift::EventSubscription"|"AWS::SSM::ManagedInstanceInventory"|"AWS::CloudWatch::Alarm"|"AWS::CloudFormation::Stack"|"AWS::ElasticLoadBalancing::LoadBalancer"|"AWS::AutoScaling::AutoScalingGroup"|"AWS::AutoScaling::LaunchConfiguration"|"AWS::AutoScaling::ScalingPolicy"|"AWS::AutoScaling::ScheduledAction"|"AWS::DynamoDB::Table"|"AWS::CodeBuild::Project"|"AWS::WAF::RateBasedRule"|"AWS::WAF::Rule"|"AWS::WAF::RuleGroup"|"AWS::WAF::WebACL"|"AWS::WAFRegional::RateBasedRule"|"AWS::WAFRegional::Rule"|"AWS::WAFRegional::RuleGroup"|"AWS::WAFRegional::WebACL"|"AWS::CloudFront::Distribution"|"AWS::CloudFront::StreamingDistribution"|"AWS::Lambda::Alias"|"AWS::Lambda::Function"|"AWS::ElasticBeanstalk::Application"|"AWS::ElasticBeanstalk::ApplicationVersion"|"AWS::ElasticBeanstalk::Environment"|"AWS::MobileHub::Project"|"AWS::XRay::EncryptionConfig"|"AWS::SSM::AssociationCompliance"|"AWS::SSM::PatchCompliance"|"AWS::Shield::Protection"|"AWS::ShieldRegional::Protection"|"AWS::Config::ResourceCompliance"|"AWS::LicenseManager::LicenseConfiguration"|"AWS::ApiGateway::DomainName"|"AWS::ApiGateway::Method"|"AWS::ApiGateway::Stage"|"AWS::ApiGateway::RestApi"|"AWS::ApiGatewayV2::DomainName"|"AWS::ApiGatewayV2::Stage"|"AWS::ApiGatewayV2::Api"|"AWS::CodePipeline::Pipeline"|"AWS::ServiceCatalog::CloudFormationProvisionedProduct"|"AWS::ServiceCatalog::CloudFormationProduct"|"AWS::ServiceCatalog::Portfolio",
#'   Filters = list(
#'     AccountId = "string",
#'     ResourceId = "string",
#'     ResourceName = "string",
#'     Region = "string"
#'   ),
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_list_aggregate_discovered_resources
configservice_list_aggregate_discovered_resources <- function(ConfigurationAggregatorName, ResourceType, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAggregateDiscoveredResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$list_aggregate_discovered_resources_input(ConfigurationAggregatorName = ConfigurationAggregatorName, ResourceType = ResourceType, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$list_aggregate_discovered_resources_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$list_aggregate_discovered_resources <- configservice_list_aggregate_discovered_resources

#' Accepts a resource type and returns a list of resource identifiers for
#' the resources of that type
#'
#' Accepts a resource type and returns a list of resource identifiers for
#' the resources of that type. A resource identifier includes the resource
#' type, ID, and (if available) the custom resource name. The results
#' consist of resources that AWS Config has discovered, including those
#' that AWS Config is not currently recording. You can narrow the results
#' to include only resources that have specific resource IDs or a resource
#' name.
#' 
#' You can specify either resource IDs or a resource name, but not both, in
#' the same request.
#' 
#' The response is paginated. By default, AWS Config lists 100 resource
#' identifiers on each page. You can customize this number with the `limit`
#' parameter. The response includes a `nextToken` string. To get the next
#' page of results, run the request again and specify the string for the
#' `nextToken` parameter.
#'
#' @usage
#' configservice_list_discovered_resources(resourceType, resourceIds,
#'   resourceName, limit, includeDeletedResources, nextToken)
#'
#' @param resourceType &#91;required&#93; The type of resources that you want AWS Config to list in the response.
#' @param resourceIds The IDs of only those resources that you want AWS Config to list in the
#' response. If you do not specify this parameter, AWS Config lists all
#' resources of the specified type that it has discovered.
#' @param resourceName The custom name of only those resources that you want AWS Config to list
#' in the response. If you do not specify this parameter, AWS Config lists
#' all resources of the specified type that it has discovered.
#' @param limit The maximum number of resource identifiers returned on each page. The
#' default is 100. You cannot specify a number greater than 100. If you
#' specify 0, AWS Config uses the default.
#' @param includeDeletedResources Specifies whether AWS Config includes deleted resources in the results.
#' By default, deleted resources are not included.
#' @param nextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$list_discovered_resources(
#'   resourceType = "AWS::EC2::CustomerGateway"|"AWS::EC2::EIP"|"AWS::EC2::Host"|"AWS::EC2::Instance"|"AWS::EC2::InternetGateway"|"AWS::EC2::NetworkAcl"|"AWS::EC2::NetworkInterface"|"AWS::EC2::RouteTable"|"AWS::EC2::SecurityGroup"|"AWS::EC2::Subnet"|"AWS::CloudTrail::Trail"|"AWS::EC2::Volume"|"AWS::EC2::VPC"|"AWS::EC2::VPNConnection"|"AWS::EC2::VPNGateway"|"AWS::EC2::RegisteredHAInstance"|"AWS::EC2::NatGateway"|"AWS::EC2::EgressOnlyInternetGateway"|"AWS::EC2::VPCEndpoint"|"AWS::EC2::VPCEndpointService"|"AWS::EC2::FlowLog"|"AWS::EC2::VPCPeeringConnection"|"AWS::IAM::Group"|"AWS::IAM::Policy"|"AWS::IAM::Role"|"AWS::IAM::User"|"AWS::ElasticLoadBalancingV2::LoadBalancer"|"AWS::ACM::Certificate"|"AWS::RDS::DBInstance"|"AWS::RDS::DBParameterGroup"|"AWS::RDS::DBOptionGroup"|"AWS::RDS::DBSubnetGroup"|"AWS::RDS::DBSecurityGroup"|"AWS::RDS::DBSnapshot"|"AWS::RDS::DBCluster"|"AWS::RDS::DBClusterParameterGroup"|"AWS::RDS::DBClusterSnapshot"|"AWS::RDS::EventSubscription"|"AWS::S3::Bucket"|"AWS::S3::AccountPublicAccessBlock"|"AWS::Redshift::Cluster"|"AWS::Redshift::ClusterSnapshot"|"AWS::Redshift::ClusterParameterGroup"|"AWS::Redshift::ClusterSecurityGroup"|"AWS::Redshift::ClusterSubnetGroup"|"AWS::Redshift::EventSubscription"|"AWS::SSM::ManagedInstanceInventory"|"AWS::CloudWatch::Alarm"|"AWS::CloudFormation::Stack"|"AWS::ElasticLoadBalancing::LoadBalancer"|"AWS::AutoScaling::AutoScalingGroup"|"AWS::AutoScaling::LaunchConfiguration"|"AWS::AutoScaling::ScalingPolicy"|"AWS::AutoScaling::ScheduledAction"|"AWS::DynamoDB::Table"|"AWS::CodeBuild::Project"|"AWS::WAF::RateBasedRule"|"AWS::WAF::Rule"|"AWS::WAF::RuleGroup"|"AWS::WAF::WebACL"|"AWS::WAFRegional::RateBasedRule"|"AWS::WAFRegional::Rule"|"AWS::WAFRegional::RuleGroup"|"AWS::WAFRegional::WebACL"|"AWS::CloudFront::Distribution"|"AWS::CloudFront::StreamingDistribution"|"AWS::Lambda::Alias"|"AWS::Lambda::Function"|"AWS::ElasticBeanstalk::Application"|"AWS::ElasticBeanstalk::ApplicationVersion"|"AWS::ElasticBeanstalk::Environment"|"AWS::MobileHub::Project"|"AWS::XRay::EncryptionConfig"|"AWS::SSM::AssociationCompliance"|"AWS::SSM::PatchCompliance"|"AWS::Shield::Protection"|"AWS::ShieldRegional::Protection"|"AWS::Config::ResourceCompliance"|"AWS::LicenseManager::LicenseConfiguration"|"AWS::ApiGateway::DomainName"|"AWS::ApiGateway::Method"|"AWS::ApiGateway::Stage"|"AWS::ApiGateway::RestApi"|"AWS::ApiGatewayV2::DomainName"|"AWS::ApiGatewayV2::Stage"|"AWS::ApiGatewayV2::Api"|"AWS::CodePipeline::Pipeline"|"AWS::ServiceCatalog::CloudFormationProvisionedProduct"|"AWS::ServiceCatalog::CloudFormationProduct"|"AWS::ServiceCatalog::Portfolio",
#'   resourceIds = list(
#'     "string"
#'   ),
#'   resourceName = "string",
#'   limit = 123,
#'   includeDeletedResources = TRUE|FALSE,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_list_discovered_resources
configservice_list_discovered_resources <- function(resourceType, resourceIds = NULL, resourceName = NULL, limit = NULL, includeDeletedResources = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDiscoveredResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$list_discovered_resources_input(resourceType = resourceType, resourceIds = resourceIds, resourceName = resourceName, limit = limit, includeDeletedResources = includeDeletedResources, nextToken = nextToken)
  output <- .configservice$list_discovered_resources_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$list_discovered_resources <- configservice_list_discovered_resources

#' List the tags for AWS Config resource
#'
#' List the tags for AWS Config resource.
#'
#' @usage
#' configservice_list_tags_for_resource(ResourceArn, Limit, NextToken)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags. Currently, the supported resources are `ConfigRule`,
#' `ConfigurationAggregator` and `AggregatorAuthorization`.
#' @param Limit The maximum number of tags returned on each page. The limit maximum is
#' 50. You cannot specify a number greater than 50. If you specify 0, AWS
#' Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string",
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_list_tags_for_resource
configservice_list_tags_for_resource <- function(ResourceArn, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$list_tags_for_resource_input(ResourceArn = ResourceArn, Limit = Limit, NextToken = NextToken)
  output <- .configservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$list_tags_for_resource <- configservice_list_tags_for_resource

#' Authorizes the aggregator account and region to collect data from the
#' source account and region
#'
#' Authorizes the aggregator account and region to collect data from the
#' source account and region.
#'
#' @usage
#' configservice_put_aggregation_authorization(AuthorizedAccountId,
#'   AuthorizedAwsRegion, Tags)
#'
#' @param AuthorizedAccountId &#91;required&#93; The 12-digit account ID of the account authorized to aggregate data.
#' @param AuthorizedAwsRegion &#91;required&#93; The region authorized to collect aggregated data.
#' @param Tags An array of tag object.
#'
#' @section Request syntax:
#' ```
#' svc$put_aggregation_authorization(
#'   AuthorizedAccountId = "string",
#'   AuthorizedAwsRegion = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_aggregation_authorization
configservice_put_aggregation_authorization <- function(AuthorizedAccountId, AuthorizedAwsRegion, Tags = NULL) {
  op <- new_operation(
    name = "PutAggregationAuthorization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_aggregation_authorization_input(AuthorizedAccountId = AuthorizedAccountId, AuthorizedAwsRegion = AuthorizedAwsRegion, Tags = Tags)
  output <- .configservice$put_aggregation_authorization_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_aggregation_authorization <- configservice_put_aggregation_authorization

#' Adds or updates an AWS Config rule for evaluating whether your AWS
#' resources comply with your desired configurations
#'
#' Adds or updates an AWS Config rule for evaluating whether your AWS
#' resources comply with your desired configurations.
#' 
#' You can use this action for custom AWS Config rules and AWS managed
#' Config rules. A custom AWS Config rule is a rule that you develop and
#' maintain. An AWS managed Config rule is a customizable, predefined rule
#' that AWS Config provides.
#' 
#' If you are adding a new custom AWS Config rule, you must first create
#' the AWS Lambda function that the rule invokes to evaluate your
#' resources. When you use the `PutConfigRule` action to add the rule to
#' AWS Config, you must specify the Amazon Resource Name (ARN) that AWS
#' Lambda assigns to the function. Specify the ARN for the
#' `SourceIdentifier` key. This key is part of the `Source` object, which
#' is part of the `ConfigRule` object.
#' 
#' If you are adding an AWS managed Config rule, specify the rule\'s
#' identifier for the `SourceIdentifier` key. To reference AWS managed
#' Config rule identifiers, see [About AWS Managed Config
#' Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
#' 
#' For any new rule that you add, specify the `ConfigRuleName` in the
#' `ConfigRule` object. Do not specify the `ConfigRuleArn` or the
#' `ConfigRuleId`. These values are generated by AWS Config for new rules.
#' 
#' If you are updating a rule that you added previously, you can specify
#' the rule by `ConfigRuleName`, `ConfigRuleId`, or `ConfigRuleArn` in the
#' `ConfigRule` data type that you use in this request.
#' 
#' The maximum number of rules that AWS Config supports is 150.
#' 
#' For information about requesting a rule limit increase, see [AWS Config
#' Limits](http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config)
#' in the *AWS General Reference Guide*.
#' 
#' For more information about developing and using AWS Config rules, see
#' [Evaluating AWS Resource Configurations with AWS
#' Config](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html)
#' in the *AWS Config Developer Guide*.
#'
#' @usage
#' configservice_put_config_rule(ConfigRule, Tags)
#'
#' @param ConfigRule &#91;required&#93; The rule that you want to add to your account.
#' @param Tags An array of tag object.
#'
#' @section Request syntax:
#' ```
#' svc$put_config_rule(
#'   ConfigRule = list(
#'     ConfigRuleName = "string",
#'     ConfigRuleArn = "string",
#'     ConfigRuleId = "string",
#'     Description = "string",
#'     Scope = list(
#'       ComplianceResourceTypes = list(
#'         "string"
#'       ),
#'       TagKey = "string",
#'       TagValue = "string",
#'       ComplianceResourceId = "string"
#'     ),
#'     Source = list(
#'       Owner = "CUSTOM_LAMBDA"|"AWS",
#'       SourceIdentifier = "string",
#'       SourceDetails = list(
#'         list(
#'           EventSource = "aws.config",
#'           MessageType = "ConfigurationItemChangeNotification"|"ConfigurationSnapshotDeliveryCompleted"|"ScheduledNotification"|"OversizedConfigurationItemChangeNotification",
#'           MaximumExecutionFrequency = "One_Hour"|"Three_Hours"|"Six_Hours"|"Twelve_Hours"|"TwentyFour_Hours"
#'         )
#'       )
#'     ),
#'     InputParameters = "string",
#'     MaximumExecutionFrequency = "One_Hour"|"Three_Hours"|"Six_Hours"|"Twelve_Hours"|"TwentyFour_Hours",
#'     ConfigRuleState = "ACTIVE"|"DELETING"|"DELETING_RESULTS"|"EVALUATING",
#'     CreatedBy = "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_config_rule
configservice_put_config_rule <- function(ConfigRule, Tags = NULL) {
  op <- new_operation(
    name = "PutConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_config_rule_input(ConfigRule = ConfigRule, Tags = Tags)
  output <- .configservice$put_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_config_rule <- configservice_put_config_rule

#' Creates and updates the configuration aggregator with the selected
#' source accounts and regions
#'
#' Creates and updates the configuration aggregator with the selected
#' source accounts and regions. The source account can be individual
#' account(s) or an organization.
#' 
#' AWS Config should be enabled in source accounts and regions you want to
#' aggregate.
#' 
#' If your source type is an organization, you must be signed in to the
#' master account and all features must be enabled in your organization.
#' AWS Config calls `EnableAwsServiceAccess` API to enable integration
#' between AWS Config and AWS Organizations.
#'
#' @usage
#' configservice_put_configuration_aggregator(ConfigurationAggregatorName,
#'   AccountAggregationSources, OrganizationAggregationSource, Tags)
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param AccountAggregationSources A list of AccountAggregationSource object.
#' @param OrganizationAggregationSource An OrganizationAggregationSource object.
#' @param Tags An array of tag object.
#'
#' @section Request syntax:
#' ```
#' svc$put_configuration_aggregator(
#'   ConfigurationAggregatorName = "string",
#'   AccountAggregationSources = list(
#'     list(
#'       AccountIds = list(
#'         "string"
#'       ),
#'       AllAwsRegions = TRUE|FALSE,
#'       AwsRegions = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   OrganizationAggregationSource = list(
#'     RoleArn = "string",
#'     AwsRegions = list(
#'       "string"
#'     ),
#'     AllAwsRegions = TRUE|FALSE
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_configuration_aggregator
configservice_put_configuration_aggregator <- function(ConfigurationAggregatorName, AccountAggregationSources = NULL, OrganizationAggregationSource = NULL, Tags = NULL) {
  op <- new_operation(
    name = "PutConfigurationAggregator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_configuration_aggregator_input(ConfigurationAggregatorName = ConfigurationAggregatorName, AccountAggregationSources = AccountAggregationSources, OrganizationAggregationSource = OrganizationAggregationSource, Tags = Tags)
  output <- .configservice$put_configuration_aggregator_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_configuration_aggregator <- configservice_put_configuration_aggregator

#' Creates a new configuration recorder to record the selected resource
#' configurations
#'
#' Creates a new configuration recorder to record the selected resource
#' configurations.
#' 
#' You can use this action to change the role `roleARN` or the
#' `recordingGroup` of an existing recorder. To change the role, call the
#' action on the existing configuration recorder and specify a role.
#' 
#' Currently, you can specify only one configuration recorder per region in
#' your account.
#' 
#' If `ConfigurationRecorder` does not have the **recordingGroup**
#' parameter specified, the default is to record all supported resource
#' types.
#'
#' @usage
#' configservice_put_configuration_recorder(ConfigurationRecorder)
#'
#' @param ConfigurationRecorder &#91;required&#93; The configuration recorder object that records each configuration change
#' made to the resources.
#'
#' @section Request syntax:
#' ```
#' svc$put_configuration_recorder(
#'   ConfigurationRecorder = list(
#'     name = "string",
#'     roleARN = "string",
#'     recordingGroup = list(
#'       allSupported = TRUE|FALSE,
#'       includeGlobalResourceTypes = TRUE|FALSE,
#'       resourceTypes = list(
#'         "AWS::EC2::CustomerGateway"|"AWS::EC2::EIP"|"AWS::EC2::Host"|"AWS::EC2::Instance"|"AWS::EC2::InternetGateway"|"AWS::EC2::NetworkAcl"|"AWS::EC2::NetworkInterface"|"AWS::EC2::RouteTable"|"AWS::EC2::SecurityGroup"|"AWS::EC2::Subnet"|"AWS::CloudTrail::Trail"|"AWS::EC2::Volume"|"AWS::EC2::VPC"|"AWS::EC2::VPNConnection"|"AWS::EC2::VPNGateway"|"AWS::EC2::RegisteredHAInstance"|"AWS::EC2::NatGateway"|"AWS::EC2::EgressOnlyInternetGateway"|"AWS::EC2::VPCEndpoint"|"AWS::EC2::VPCEndpointService"|"AWS::EC2::FlowLog"|"AWS::EC2::VPCPeeringConnection"|"AWS::IAM::Group"|"AWS::IAM::Policy"|"AWS::IAM::Role"|"AWS::IAM::User"|"AWS::ElasticLoadBalancingV2::LoadBalancer"|"AWS::ACM::Certificate"|"AWS::RDS::DBInstance"|"AWS::RDS::DBParameterGroup"|"AWS::RDS::DBOptionGroup"|"AWS::RDS::DBSubnetGroup"|"AWS::RDS::DBSecurityGroup"|"AWS::RDS::DBSnapshot"|"AWS::RDS::DBCluster"|"AWS::RDS::DBClusterParameterGroup"|"AWS::RDS::DBClusterSnapshot"|"AWS::RDS::EventSubscription"|"AWS::S3::Bucket"|"AWS::S3::AccountPublicAccessBlock"|"AWS::Redshift::Cluster"|"AWS::Redshift::ClusterSnapshot"|"AWS::Redshift::ClusterParameterGroup"|"AWS::Redshift::ClusterSecurityGroup"|"AWS::Redshift::ClusterSubnetGroup"|"AWS::Redshift::EventSubscription"|"AWS::SSM::ManagedInstanceInventory"|"AWS::CloudWatch::Alarm"|"AWS::CloudFormation::Stack"|"AWS::ElasticLoadBalancing::LoadBalancer"|"AWS::AutoScaling::AutoScalingGroup"|"AWS::AutoScaling::LaunchConfiguration"|"AWS::AutoScaling::ScalingPolicy"|"AWS::AutoScaling::ScheduledAction"|"AWS::DynamoDB::Table"|"AWS::CodeBuild::Project"|"AWS::WAF::RateBasedRule"|"AWS::WAF::Rule"|"AWS::WAF::RuleGroup"|"AWS::WAF::WebACL"|"AWS::WAFRegional::RateBasedRule"|"AWS::WAFRegional::Rule"|"AWS::WAFRegional::RuleGroup"|"AWS::WAFRegional::WebACL"|"AWS::CloudFront::Distribution"|"AWS::CloudFront::StreamingDistribution"|"AWS::Lambda::Alias"|"AWS::Lambda::Function"|"AWS::ElasticBeanstalk::Application"|"AWS::ElasticBeanstalk::ApplicationVersion"|"AWS::ElasticBeanstalk::Environment"|"AWS::MobileHub::Project"|"AWS::XRay::EncryptionConfig"|"AWS::SSM::AssociationCompliance"|"AWS::SSM::PatchCompliance"|"AWS::Shield::Protection"|"AWS::ShieldRegional::Protection"|"AWS::Config::ResourceCompliance"|"AWS::LicenseManager::LicenseConfiguration"|"AWS::ApiGateway::DomainName"|"AWS::ApiGateway::Method"|"AWS::ApiGateway::Stage"|"AWS::ApiGateway::RestApi"|"AWS::ApiGatewayV2::DomainName"|"AWS::ApiGatewayV2::Stage"|"AWS::ApiGatewayV2::Api"|"AWS::CodePipeline::Pipeline"|"AWS::ServiceCatalog::CloudFormationProvisionedProduct"|"AWS::ServiceCatalog::CloudFormationProduct"|"AWS::ServiceCatalog::Portfolio"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_configuration_recorder
configservice_put_configuration_recorder <- function(ConfigurationRecorder) {
  op <- new_operation(
    name = "PutConfigurationRecorder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_configuration_recorder_input(ConfigurationRecorder = ConfigurationRecorder)
  output <- .configservice$put_configuration_recorder_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_configuration_recorder <- configservice_put_configuration_recorder

#' Creates or updates a conformance pack
#'
#' Creates or updates a conformance pack. A conformance pack is a
#' collection of AWS Config rules that can be easily deployed in an account
#' and a region and across AWS Organization.
#' 
#' This API creates a service linked role `AWSServiceRoleForConfigConforms`
#' in your account. The service linked role is created only when the role
#' does not exist in your account. AWS Config verifies the existence of
#' role with `GetRole` action.
#' 
#' You must specify either the `TemplateS3Uri` or the `TemplateBody`
#' parameter, but not both. If you provide both AWS Config uses the
#' `TemplateS3Uri` parameter and ignores the `TemplateBody` parameter.
#'
#' @usage
#' configservice_put_conformance_pack(ConformancePackName, TemplateS3Uri,
#'   TemplateBody, DeliveryS3Bucket, DeliveryS3KeyPrefix,
#'   ConformancePackInputParameters)
#'
#' @param ConformancePackName &#91;required&#93; Name of the conformance pack you want to create.
#' @param TemplateS3Uri Location of file containing the template body
#' (`s3://bucketname/prefix`). The uri must point to the conformance pack
#' template (max size: 300 KB) that is located in an Amazon S3 bucket in
#' the same region as the conformance pack.
#' 
#' You must have access to read Amazon S3 bucket.
#' @param TemplateBody A string containing full conformance pack template body. Structure
#' containing the template body with a minimum length of 1 byte and a
#' maximum length of 51,200 bytes.
#' 
#' You can only use a YAML template with one resource type, that is, config
#' rule and a remediation action.
#' @param DeliveryS3Bucket &#91;required&#93; AWS Config stores intermediate files while processing conformance pack
#' template.
#' @param DeliveryS3KeyPrefix The prefix for the Amazon S3 bucket.
#' @param ConformancePackInputParameters A list of `ConformancePackInputParameter` objects.
#'
#' @section Request syntax:
#' ```
#' svc$put_conformance_pack(
#'   ConformancePackName = "string",
#'   TemplateS3Uri = "string",
#'   TemplateBody = "string",
#'   DeliveryS3Bucket = "string",
#'   DeliveryS3KeyPrefix = "string",
#'   ConformancePackInputParameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_conformance_pack
configservice_put_conformance_pack <- function(ConformancePackName, TemplateS3Uri = NULL, TemplateBody = NULL, DeliveryS3Bucket, DeliveryS3KeyPrefix = NULL, ConformancePackInputParameters = NULL) {
  op <- new_operation(
    name = "PutConformancePack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_conformance_pack_input(ConformancePackName = ConformancePackName, TemplateS3Uri = TemplateS3Uri, TemplateBody = TemplateBody, DeliveryS3Bucket = DeliveryS3Bucket, DeliveryS3KeyPrefix = DeliveryS3KeyPrefix, ConformancePackInputParameters = ConformancePackInputParameters)
  output <- .configservice$put_conformance_pack_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_conformance_pack <- configservice_put_conformance_pack

#' Creates a delivery channel object to deliver configuration information
#' to an Amazon S3 bucket and Amazon SNS topic
#'
#' Creates a delivery channel object to deliver configuration information
#' to an Amazon S3 bucket and Amazon SNS topic.
#' 
#' Before you can create a delivery channel, you must create a
#' configuration recorder.
#' 
#' You can use this action to change the Amazon S3 bucket or an Amazon SNS
#' topic of the existing delivery channel. To change the Amazon S3 bucket
#' or an Amazon SNS topic, call this action and specify the changed values
#' for the S3 bucket and the SNS topic. If you specify a different value
#' for either the S3 bucket or the SNS topic, this action will keep the
#' existing value for the parameter that is not changed.
#' 
#' You can have only one delivery channel per region in your account.
#'
#' @usage
#' configservice_put_delivery_channel(DeliveryChannel)
#'
#' @param DeliveryChannel &#91;required&#93; The configuration delivery channel object that delivers the
#' configuration information to an Amazon S3 bucket and to an Amazon SNS
#' topic.
#'
#' @section Request syntax:
#' ```
#' svc$put_delivery_channel(
#'   DeliveryChannel = list(
#'     name = "string",
#'     s3BucketName = "string",
#'     s3KeyPrefix = "string",
#'     snsTopicARN = "string",
#'     configSnapshotDeliveryProperties = list(
#'       deliveryFrequency = "One_Hour"|"Three_Hours"|"Six_Hours"|"Twelve_Hours"|"TwentyFour_Hours"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_delivery_channel
configservice_put_delivery_channel <- function(DeliveryChannel) {
  op <- new_operation(
    name = "PutDeliveryChannel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_delivery_channel_input(DeliveryChannel = DeliveryChannel)
  output <- .configservice$put_delivery_channel_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_delivery_channel <- configservice_put_delivery_channel

#' Used by an AWS Lambda function to deliver evaluation results to AWS
#' Config
#'
#' Used by an AWS Lambda function to deliver evaluation results to AWS
#' Config. This action is required in every AWS Lambda function that is
#' invoked by an AWS Config rule.
#'
#' @usage
#' configservice_put_evaluations(Evaluations, ResultToken, TestMode)
#'
#' @param Evaluations The assessments that the AWS Lambda function performs. Each evaluation
#' identifies an AWS resource and indicates whether it complies with the
#' AWS Config rule that invokes the AWS Lambda function.
#' @param ResultToken &#91;required&#93; An encrypted token that associates an evaluation with an AWS Config
#' rule. Identifies the rule and the event that triggered the evaluation.
#' @param TestMode Use this parameter to specify a test run for `PutEvaluations`. You can
#' verify whether your AWS Lambda function will deliver evaluation results
#' to AWS Config. No updates occur to your existing evaluations, and
#' evaluation results are not sent to AWS Config.
#' 
#' When `TestMode` is `true`, `PutEvaluations` doesn\'t require a valid
#' value for the `ResultToken` parameter, but the value cannot be null.
#'
#' @section Request syntax:
#' ```
#' svc$put_evaluations(
#'   Evaluations = list(
#'     list(
#'       ComplianceResourceType = "string",
#'       ComplianceResourceId = "string",
#'       ComplianceType = "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA",
#'       Annotation = "string",
#'       OrderingTimestamp = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   ResultToken = "string",
#'   TestMode = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_evaluations
configservice_put_evaluations <- function(Evaluations = NULL, ResultToken, TestMode = NULL) {
  op <- new_operation(
    name = "PutEvaluations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_evaluations_input(Evaluations = Evaluations, ResultToken = ResultToken, TestMode = TestMode)
  output <- .configservice$put_evaluations_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_evaluations <- configservice_put_evaluations

#' Adds or updates organization config rule for your entire organization
#' evaluating whether your AWS resources comply with your desired
#' configurations
#'
#' Adds or updates organization config rule for your entire organization
#' evaluating whether your AWS resources comply with your desired
#' configurations. Only a master account can create or update an
#' organization config rule.
#' 
#' This API enables organization service access through the
#' `EnableAWSServiceAccess` action and creates a service linked role
#' `AWSServiceRoleForConfigMultiAccountSetup` in the master account of your
#' organization. The service linked role is created only when the role does
#' not exist in the master account. AWS Config verifies the existence of
#' role with `GetRole` action.
#' 
#' You can use this action to create both custom AWS Config rules and AWS
#' managed Config rules. If you are adding a new custom AWS Config rule,
#' you must first create AWS Lambda function in the master account that the
#' rule invokes to evaluate your resources. When you use the
#' `PutOrganizationConfigRule` action to add the rule to AWS Config, you
#' must specify the Amazon Resource Name (ARN) that AWS Lambda assigns to
#' the function. If you are adding an AWS managed Config rule, specify the
#' rule\'s identifier for the `RuleIdentifier` key.
#' 
#' The maximum number of organization config rules that AWS Config supports
#' is 150.
#' 
#' Specify either `OrganizationCustomRuleMetadata` or
#' `OrganizationManagedRuleMetadata`.
#'
#' @usage
#' configservice_put_organization_config_rule(OrganizationConfigRuleName,
#'   OrganizationManagedRuleMetadata, OrganizationCustomRuleMetadata,
#'   ExcludedAccounts)
#'
#' @param OrganizationConfigRuleName &#91;required&#93; The name that you assign to an organization config rule.
#' @param OrganizationManagedRuleMetadata An `OrganizationManagedRuleMetadata` object.
#' @param OrganizationCustomRuleMetadata An `OrganizationCustomRuleMetadata` object.
#' @param ExcludedAccounts A comma-separated list of accounts that you want to exclude from an
#' organization config rule.
#'
#' @section Request syntax:
#' ```
#' svc$put_organization_config_rule(
#'   OrganizationConfigRuleName = "string",
#'   OrganizationManagedRuleMetadata = list(
#'     Description = "string",
#'     RuleIdentifier = "string",
#'     InputParameters = "string",
#'     MaximumExecutionFrequency = "One_Hour"|"Three_Hours"|"Six_Hours"|"Twelve_Hours"|"TwentyFour_Hours",
#'     ResourceTypesScope = list(
#'       "string"
#'     ),
#'     ResourceIdScope = "string",
#'     TagKeyScope = "string",
#'     TagValueScope = "string"
#'   ),
#'   OrganizationCustomRuleMetadata = list(
#'     Description = "string",
#'     LambdaFunctionArn = "string",
#'     OrganizationConfigRuleTriggerTypes = list(
#'       "ConfigurationItemChangeNotification"|"OversizedConfigurationItemChangeNotification"|"ScheduledNotification"
#'     ),
#'     InputParameters = "string",
#'     MaximumExecutionFrequency = "One_Hour"|"Three_Hours"|"Six_Hours"|"Twelve_Hours"|"TwentyFour_Hours",
#'     ResourceTypesScope = list(
#'       "string"
#'     ),
#'     ResourceIdScope = "string",
#'     TagKeyScope = "string",
#'     TagValueScope = "string"
#'   ),
#'   ExcludedAccounts = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_organization_config_rule
configservice_put_organization_config_rule <- function(OrganizationConfigRuleName, OrganizationManagedRuleMetadata = NULL, OrganizationCustomRuleMetadata = NULL, ExcludedAccounts = NULL) {
  op <- new_operation(
    name = "PutOrganizationConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_organization_config_rule_input(OrganizationConfigRuleName = OrganizationConfigRuleName, OrganizationManagedRuleMetadata = OrganizationManagedRuleMetadata, OrganizationCustomRuleMetadata = OrganizationCustomRuleMetadata, ExcludedAccounts = ExcludedAccounts)
  output <- .configservice$put_organization_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_organization_config_rule <- configservice_put_organization_config_rule

#' Deploys conformance packs across member accounts in an AWS Organization
#'
#' Deploys conformance packs across member accounts in an AWS Organization.
#' 
#' This API enables organization service access for
#' `config-multiaccountsetup.amazonaws.com` through the
#' `EnableAWSServiceAccess` action and creates a service linked role
#' `AWSServiceRoleForConfigMultiAccountSetup` in the master account of your
#' organization. The service linked role is created only when the role does
#' not exist in the master account. AWS Config verifies the existence of
#' role with GetRole action.
#' 
#' You must specify either the `TemplateS3Uri` or the `TemplateBody`
#' parameter, but not both. If you provide both AWS Config uses the
#' `TemplateS3Uri` parameter and ignores the `TemplateBody` parameter.
#' 
#' AWS Config sets the state of a conformance pack to CREATE\\_IN\\_PROGRESS
#' and UPDATE\\_IN\\_PROGRESS until the confomance pack is created or
#' updated. You cannot update a conformance pack while it is in this state.
#' 
#' You can create 6 conformance packs with 25 AWS Config rules in each
#' pack.
#'
#' @usage
#' configservice_put_organization_conformance_pack(
#'   OrganizationConformancePackName, TemplateS3Uri, TemplateBody,
#'   DeliveryS3Bucket, DeliveryS3KeyPrefix, ConformancePackInputParameters,
#'   ExcludedAccounts)
#'
#' @param OrganizationConformancePackName &#91;required&#93; Name of the organization conformance pack you want to create.
#' @param TemplateS3Uri Location of file containing the template body. The uri must point to the
#' conformance pack template (max size: 300 KB).
#' 
#' You must have access to read Amazon S3 bucket.
#' @param TemplateBody A string containing full conformance pack template body. Structure
#' containing the template body with a minimum length of 1 byte and a
#' maximum length of 51,200 bytes.
#' @param DeliveryS3Bucket &#91;required&#93; Location of an Amazon S3 bucket where AWS Config can deliver evaluation
#' results. AWS Config stores intermediate files while processing
#' conformance pack template.
#' 
#' The delivery bucket name should start with awsconfigconforms. For
#' example: \"Resource\": \"arn:aws:s3:::your\\_bucket\\_name/\*\". For more
#' information, see [Permissions for cross account bucket
#' access](https://docs.aws.amazon.com/config/latest/developerguide/conformance-pack-organization-apis.html).
#' @param DeliveryS3KeyPrefix The prefix for the Amazon S3 bucket.
#' @param ConformancePackInputParameters A list of `ConformancePackInputParameter` objects.
#' @param ExcludedAccounts A list of AWS accounts to be excluded from an organization conformance
#' pack while deploying a conformance pack.
#'
#' @section Request syntax:
#' ```
#' svc$put_organization_conformance_pack(
#'   OrganizationConformancePackName = "string",
#'   TemplateS3Uri = "string",
#'   TemplateBody = "string",
#'   DeliveryS3Bucket = "string",
#'   DeliveryS3KeyPrefix = "string",
#'   ConformancePackInputParameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string"
#'     )
#'   ),
#'   ExcludedAccounts = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_organization_conformance_pack
configservice_put_organization_conformance_pack <- function(OrganizationConformancePackName, TemplateS3Uri = NULL, TemplateBody = NULL, DeliveryS3Bucket, DeliveryS3KeyPrefix = NULL, ConformancePackInputParameters = NULL, ExcludedAccounts = NULL) {
  op <- new_operation(
    name = "PutOrganizationConformancePack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_organization_conformance_pack_input(OrganizationConformancePackName = OrganizationConformancePackName, TemplateS3Uri = TemplateS3Uri, TemplateBody = TemplateBody, DeliveryS3Bucket = DeliveryS3Bucket, DeliveryS3KeyPrefix = DeliveryS3KeyPrefix, ConformancePackInputParameters = ConformancePackInputParameters, ExcludedAccounts = ExcludedAccounts)
  output <- .configservice$put_organization_conformance_pack_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_organization_conformance_pack <- configservice_put_organization_conformance_pack

#' Adds or updates the remediation configuration with a specific AWS Config
#' rule with the selected target or action
#'
#' Adds or updates the remediation configuration with a specific AWS Config
#' rule with the selected target or action. The API creates the
#' `RemediationConfiguration` object for the AWS Config rule. The AWS
#' Config rule must already exist for you to add a remediation
#' configuration. The target (SSM document) must exist and have permissions
#' to use the target.
#'
#' @usage
#' configservice_put_remediation_configurations(RemediationConfigurations)
#'
#' @param RemediationConfigurations &#91;required&#93; A list of remediation configuration objects.
#'
#' @section Request syntax:
#' ```
#' svc$put_remediation_configurations(
#'   RemediationConfigurations = list(
#'     list(
#'       ConfigRuleName = "string",
#'       TargetType = "SSM_DOCUMENT",
#'       TargetId = "string",
#'       TargetVersion = "string",
#'       Parameters = list(
#'         list(
#'           ResourceValue = list(
#'             Value = "RESOURCE_ID"
#'           ),
#'           StaticValue = list(
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       ResourceType = "string",
#'       Automatic = TRUE|FALSE,
#'       ExecutionControls = list(
#'         SsmControls = list(
#'           ConcurrentExecutionRatePercentage = 123,
#'           ErrorPercentage = 123
#'         )
#'       ),
#'       MaximumAutomaticAttempts = 123,
#'       RetryAttemptSeconds = 123,
#'       Arn = "string",
#'       CreatedByService = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_remediation_configurations
configservice_put_remediation_configurations <- function(RemediationConfigurations) {
  op <- new_operation(
    name = "PutRemediationConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_remediation_configurations_input(RemediationConfigurations = RemediationConfigurations)
  output <- .configservice$put_remediation_configurations_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_remediation_configurations <- configservice_put_remediation_configurations

#' A remediation exception is when a specific resource is no longer
#' considered for auto-remediation
#'
#' A remediation exception is when a specific resource is no longer
#' considered for auto-remediation. This API adds a new exception or
#' updates an exisiting exception for a specific resource with a specific
#' AWS Config rule.
#'
#' @usage
#' configservice_put_remediation_exceptions(ConfigRuleName, ResourceKeys,
#'   Message, ExpirationTime)
#'
#' @param ConfigRuleName &#91;required&#93; The name of the AWS Config rule for which you want to create remediation
#' exception.
#' @param ResourceKeys &#91;required&#93; An exception list of resource exception keys to be processed with the
#' current request. AWS Config adds exception for each resource key. For
#' example, AWS Config adds 3 exceptions for 3 resource keys.
#' @param Message The message contains an explanation of the exception.
#' @param ExpirationTime The exception is automatically deleted after the expiration date.
#'
#' @section Request syntax:
#' ```
#' svc$put_remediation_exceptions(
#'   ConfigRuleName = "string",
#'   ResourceKeys = list(
#'     list(
#'       ResourceType = "string",
#'       ResourceId = "string"
#'     )
#'   ),
#'   Message = "string",
#'   ExpirationTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_remediation_exceptions
configservice_put_remediation_exceptions <- function(ConfigRuleName, ResourceKeys, Message = NULL, ExpirationTime = NULL) {
  op <- new_operation(
    name = "PutRemediationExceptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_remediation_exceptions_input(ConfigRuleName = ConfigRuleName, ResourceKeys = ResourceKeys, Message = Message, ExpirationTime = ExpirationTime)
  output <- .configservice$put_remediation_exceptions_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_remediation_exceptions <- configservice_put_remediation_exceptions

#' Records the configuration state for the resource provided in the request
#'
#' Records the configuration state for the resource provided in the
#' request. The configuration state of a resource is represented in AWS
#' Config as Configuration Items. Once this API records the configuration
#' item, you can retrieve the list of configuration items for the custom
#' resource type using existing AWS Config APIs.
#' 
#' The custom resource type must be registered with AWS CloudFormation.
#' This API accepts the configuration item registered with AWS
#' CloudFormation.
#' 
#' When you call this API, AWS Config only stores configuration state of
#' the resource provided in the request. This API does not change or
#' remediate the configuration of the resource.
#'
#' @usage
#' configservice_put_resource_config(ResourceType, SchemaVersionId,
#'   ResourceId, ResourceName, Configuration, Tags)
#'
#' @param ResourceType &#91;required&#93; The type of the resource. The custom resource type must be registered
#' with AWS CloudFormation.
#' 
#' You cannot use the organization names "aws", "amzn", "amazon", "alexa",
#' "custom" with custom resource types. It is the first part of the
#' ResourceType up to the first ::.
#' @param SchemaVersionId &#91;required&#93; Version of the schema registered for the ResourceType in AWS
#' CloudFormation.
#' @param ResourceId &#91;required&#93; Unique identifier of the resource.
#' @param ResourceName Name of the resource.
#' @param Configuration &#91;required&#93; The configuration object of the resource in valid JSON format. It must
#' match the schema registered with AWS CloudFormation.
#' 
#' The configuration JSON must not exceed 64 KB.
#' @param Tags Tags associated with the resource.
#'
#' @section Request syntax:
#' ```
#' svc$put_resource_config(
#'   ResourceType = "string",
#'   SchemaVersionId = "string",
#'   ResourceId = "string",
#'   ResourceName = "string",
#'   Configuration = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_resource_config
configservice_put_resource_config <- function(ResourceType, SchemaVersionId, ResourceId, ResourceName = NULL, Configuration, Tags = NULL) {
  op <- new_operation(
    name = "PutResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_resource_config_input(ResourceType = ResourceType, SchemaVersionId = SchemaVersionId, ResourceId = ResourceId, ResourceName = ResourceName, Configuration = Configuration, Tags = Tags)
  output <- .configservice$put_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_resource_config <- configservice_put_resource_config

#' Creates and updates the retention configuration with details about
#' retention period (number of days) that AWS Config stores your historical
#' information
#'
#' Creates and updates the retention configuration with details about
#' retention period (number of days) that AWS Config stores your historical
#' information. The API creates the `RetentionConfiguration` object and
#' names the object as **default**. When you have a
#' `RetentionConfiguration` object named **default**, calling the API
#' modifies the default object.
#' 
#' Currently, AWS Config supports only one retention configuration per
#' region in your account.
#'
#' @usage
#' configservice_put_retention_configuration(RetentionPeriodInDays)
#'
#' @param RetentionPeriodInDays &#91;required&#93; Number of days AWS Config stores your historical information.
#' 
#' Currently, only applicable to the configuration item history.
#'
#' @section Request syntax:
#' ```
#' svc$put_retention_configuration(
#'   RetentionPeriodInDays = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_put_retention_configuration
configservice_put_retention_configuration <- function(RetentionPeriodInDays) {
  op <- new_operation(
    name = "PutRetentionConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_retention_configuration_input(RetentionPeriodInDays = RetentionPeriodInDays)
  output <- .configservice$put_retention_configuration_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_retention_configuration <- configservice_put_retention_configuration

#' Accepts a structured query language (SQL) SELECT command, performs the
#' corresponding search, and returns resource configurations matching the
#' properties
#'
#' Accepts a structured query language (SQL) `SELECT` command, performs the
#' corresponding search, and returns resource configurations matching the
#' properties.
#' 
#' For more information about query components, see the [**Query
#' Components**](https://docs.aws.amazon.com/config/latest/developerguide/query-components.html)
#' section in the AWS Config Developer Guide.
#'
#' @usage
#' configservice_select_resource_config(Expression, Limit, NextToken)
#'
#' @param Expression &#91;required&#93; The SQL query `SELECT` command.
#' @param Limit The maximum number of query results returned on each page.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$select_resource_config(
#'   Expression = "string",
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_select_resource_config
configservice_select_resource_config <- function(Expression, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "SelectResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$select_resource_config_input(Expression = Expression, Limit = Limit, NextToken = NextToken)
  output <- .configservice$select_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$select_resource_config <- configservice_select_resource_config

#' Runs an on-demand evaluation for the specified AWS Config rules against
#' the last known configuration state of the resources
#'
#' Runs an on-demand evaluation for the specified AWS Config rules against
#' the last known configuration state of the resources. Use
#' `StartConfigRulesEvaluation` when you want to test that a rule you
#' updated is working as expected. `StartConfigRulesEvaluation` does not
#' re-record the latest configuration state for your resources. It re-runs
#' an evaluation against the last known state of your resources.
#' 
#' You can specify up to 25 AWS Config rules per request.
#' 
#' An existing `StartConfigRulesEvaluation` call for the specified rules
#' must complete before you can call the API again. If you chose to have
#' AWS Config stream to an Amazon SNS topic, you will receive a
#' `ConfigRuleEvaluationStarted` notification when the evaluation starts.
#' 
#' You don\'t need to call the `StartConfigRulesEvaluation` API to run an
#' evaluation for a new rule. When you create a rule, AWS Config evaluates
#' your resources against the rule automatically.
#' 
#' The `StartConfigRulesEvaluation` API is useful if you want to run
#' on-demand evaluations, such as the following example:
#' 
#' 1.  You have a custom rule that evaluates your IAM resources every 24
#'     hours.
#' 
#' 2.  You update your Lambda function to add additional conditions to your
#'     rule.
#' 
#' 3.  Instead of waiting for the next periodic evaluation, you call the
#'     `StartConfigRulesEvaluation` API.
#' 
#' 4.  AWS Config invokes your Lambda function and evaluates your IAM
#'     resources.
#' 
#' 5.  Your custom rule will still run periodic evaluations every 24 hours.
#'
#' @usage
#' configservice_start_config_rules_evaluation(ConfigRuleNames)
#'
#' @param ConfigRuleNames The list of names of AWS Config rules that you want to run evaluations
#' for.
#'
#' @section Request syntax:
#' ```
#' svc$start_config_rules_evaluation(
#'   ConfigRuleNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_start_config_rules_evaluation
configservice_start_config_rules_evaluation <- function(ConfigRuleNames = NULL) {
  op <- new_operation(
    name = "StartConfigRulesEvaluation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$start_config_rules_evaluation_input(ConfigRuleNames = ConfigRuleNames)
  output <- .configservice$start_config_rules_evaluation_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$start_config_rules_evaluation <- configservice_start_config_rules_evaluation

#' Starts recording configurations of the AWS resources you have selected
#' to record in your AWS account
#'
#' Starts recording configurations of the AWS resources you have selected
#' to record in your AWS account.
#' 
#' You must have created at least one delivery channel to successfully
#' start the configuration recorder.
#'
#' @usage
#' configservice_start_configuration_recorder(ConfigurationRecorderName)
#'
#' @param ConfigurationRecorderName &#91;required&#93; The name of the recorder object that records each configuration change
#' made to the resources.
#'
#' @section Request syntax:
#' ```
#' svc$start_configuration_recorder(
#'   ConfigurationRecorderName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_start_configuration_recorder
configservice_start_configuration_recorder <- function(ConfigurationRecorderName) {
  op <- new_operation(
    name = "StartConfigurationRecorder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$start_configuration_recorder_input(ConfigurationRecorderName = ConfigurationRecorderName)
  output <- .configservice$start_configuration_recorder_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$start_configuration_recorder <- configservice_start_configuration_recorder

#' Runs an on-demand remediation for the specified AWS Config rules against
#' the last known remediation configuration
#'
#' Runs an on-demand remediation for the specified AWS Config rules against
#' the last known remediation configuration. It runs an execution against
#' the current state of your resources. Remediation execution is
#' asynchronous.
#' 
#' You can specify up to 100 resource keys per request. An existing
#' StartRemediationExecution call for the specified resource keys must
#' complete before you can call the API again.
#'
#' @usage
#' configservice_start_remediation_execution(ConfigRuleName, ResourceKeys)
#'
#' @param ConfigRuleName &#91;required&#93; The list of names of AWS Config rules that you want to run remediation
#' execution for.
#' @param ResourceKeys &#91;required&#93; A list of resource keys to be processed with the current request. Each
#' element in the list consists of the resource type and resource ID.
#'
#' @section Request syntax:
#' ```
#' svc$start_remediation_execution(
#'   ConfigRuleName = "string",
#'   ResourceKeys = list(
#'     list(
#'       resourceType = "AWS::EC2::CustomerGateway"|"AWS::EC2::EIP"|"AWS::EC2::Host"|"AWS::EC2::Instance"|"AWS::EC2::InternetGateway"|"AWS::EC2::NetworkAcl"|"AWS::EC2::NetworkInterface"|"AWS::EC2::RouteTable"|"AWS::EC2::SecurityGroup"|"AWS::EC2::Subnet"|"AWS::CloudTrail::Trail"|"AWS::EC2::Volume"|"AWS::EC2::VPC"|"AWS::EC2::VPNConnection"|"AWS::EC2::VPNGateway"|"AWS::EC2::RegisteredHAInstance"|"AWS::EC2::NatGateway"|"AWS::EC2::EgressOnlyInternetGateway"|"AWS::EC2::VPCEndpoint"|"AWS::EC2::VPCEndpointService"|"AWS::EC2::FlowLog"|"AWS::EC2::VPCPeeringConnection"|"AWS::IAM::Group"|"AWS::IAM::Policy"|"AWS::IAM::Role"|"AWS::IAM::User"|"AWS::ElasticLoadBalancingV2::LoadBalancer"|"AWS::ACM::Certificate"|"AWS::RDS::DBInstance"|"AWS::RDS::DBParameterGroup"|"AWS::RDS::DBOptionGroup"|"AWS::RDS::DBSubnetGroup"|"AWS::RDS::DBSecurityGroup"|"AWS::RDS::DBSnapshot"|"AWS::RDS::DBCluster"|"AWS::RDS::DBClusterParameterGroup"|"AWS::RDS::DBClusterSnapshot"|"AWS::RDS::EventSubscription"|"AWS::S3::Bucket"|"AWS::S3::AccountPublicAccessBlock"|"AWS::Redshift::Cluster"|"AWS::Redshift::ClusterSnapshot"|"AWS::Redshift::ClusterParameterGroup"|"AWS::Redshift::ClusterSecurityGroup"|"AWS::Redshift::ClusterSubnetGroup"|"AWS::Redshift::EventSubscription"|"AWS::SSM::ManagedInstanceInventory"|"AWS::CloudWatch::Alarm"|"AWS::CloudFormation::Stack"|"AWS::ElasticLoadBalancing::LoadBalancer"|"AWS::AutoScaling::AutoScalingGroup"|"AWS::AutoScaling::LaunchConfiguration"|"AWS::AutoScaling::ScalingPolicy"|"AWS::AutoScaling::ScheduledAction"|"AWS::DynamoDB::Table"|"AWS::CodeBuild::Project"|"AWS::WAF::RateBasedRule"|"AWS::WAF::Rule"|"AWS::WAF::RuleGroup"|"AWS::WAF::WebACL"|"AWS::WAFRegional::RateBasedRule"|"AWS::WAFRegional::Rule"|"AWS::WAFRegional::RuleGroup"|"AWS::WAFRegional::WebACL"|"AWS::CloudFront::Distribution"|"AWS::CloudFront::StreamingDistribution"|"AWS::Lambda::Alias"|"AWS::Lambda::Function"|"AWS::ElasticBeanstalk::Application"|"AWS::ElasticBeanstalk::ApplicationVersion"|"AWS::ElasticBeanstalk::Environment"|"AWS::MobileHub::Project"|"AWS::XRay::EncryptionConfig"|"AWS::SSM::AssociationCompliance"|"AWS::SSM::PatchCompliance"|"AWS::Shield::Protection"|"AWS::ShieldRegional::Protection"|"AWS::Config::ResourceCompliance"|"AWS::LicenseManager::LicenseConfiguration"|"AWS::ApiGateway::DomainName"|"AWS::ApiGateway::Method"|"AWS::ApiGateway::Stage"|"AWS::ApiGateway::RestApi"|"AWS::ApiGatewayV2::DomainName"|"AWS::ApiGatewayV2::Stage"|"AWS::ApiGatewayV2::Api"|"AWS::CodePipeline::Pipeline"|"AWS::ServiceCatalog::CloudFormationProvisionedProduct"|"AWS::ServiceCatalog::CloudFormationProduct"|"AWS::ServiceCatalog::Portfolio",
#'       resourceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_start_remediation_execution
configservice_start_remediation_execution <- function(ConfigRuleName, ResourceKeys) {
  op <- new_operation(
    name = "StartRemediationExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$start_remediation_execution_input(ConfigRuleName = ConfigRuleName, ResourceKeys = ResourceKeys)
  output <- .configservice$start_remediation_execution_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$start_remediation_execution <- configservice_start_remediation_execution

#' Stops recording configurations of the AWS resources you have selected to
#' record in your AWS account
#'
#' Stops recording configurations of the AWS resources you have selected to
#' record in your AWS account.
#'
#' @usage
#' configservice_stop_configuration_recorder(ConfigurationRecorderName)
#'
#' @param ConfigurationRecorderName &#91;required&#93; The name of the recorder object that records each configuration change
#' made to the resources.
#'
#' @section Request syntax:
#' ```
#' svc$stop_configuration_recorder(
#'   ConfigurationRecorderName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_stop_configuration_recorder
configservice_stop_configuration_recorder <- function(ConfigurationRecorderName) {
  op <- new_operation(
    name = "StopConfigurationRecorder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$stop_configuration_recorder_input(ConfigurationRecorderName = ConfigurationRecorderName)
  output <- .configservice$stop_configuration_recorder_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$stop_configuration_recorder <- configservice_stop_configuration_recorder

#' Associates the specified tags to a resource with the specified
#' resourceArn
#'
#' Associates the specified tags to a resource with the specified
#' resourceArn. If existing tags on a resource are not specified in the
#' request parameters, they are not changed. When a resource is deleted,
#' the tags associated with that resource are deleted as well.
#'
#' @usage
#' configservice_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags. Currently, the supported resources are `ConfigRule`,
#' `ConfigurationAggregator` and `AggregatorAuthorization`.
#' @param Tags &#91;required&#93; An array of tag object.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_tag_resource
configservice_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .configservice$tag_resource_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$tag_resource <- configservice_tag_resource

#' Deletes specified tags from a resource
#'
#' Deletes specified tags from a resource.
#'
#' @usage
#' configservice_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags. Currently, the supported resources are `ConfigRule`,
#' `ConfigurationAggregator` and `AggregatorAuthorization`.
#' @param TagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname configservice_untag_resource
configservice_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .configservice$untag_resource_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$untag_resource <- configservice_untag_resource
